//*************************************************************
// Copyright (c) 1991-2025 Apryse Software Corp.
// All Rights Reserved.
//*************************************************************

#if !defined(LTANN_H)
#define LTANN_H

#include "lttyp.h"
#define L_LTANN_API LT_EXPORTED

#include "ltkrn.h"
#include "ltfil.h"
#include "ltdis.h"

#define L_HEADER_ENTRY
#include "ltpck.h"

#define DISTANCE(pt0, pt1) (sqrt ((L_DOUBLE)SQR((pt0)->x - (pt1)->x) + SQR((pt0)->y - (pt1)->y)))

/*
   object types
*/
typedef enum tagANNOBJECTTYPE 
{
   ANNOBJECT_CONTAINER = 0,
   ANNOBJECT_POINTER = 1,
   ANNOBJECT_AUDIO = 2,
   ANNOBJECT_BUTTON = 3,
   ANNOBJECT_ELLIPSE = 4,
   ANNOBJECT_FREEHAND = 5,
   ANNOBJECT_HILITE = 6,
   ANNOBJECT_HOTSPOT = 7,
   ANNOBJECT_LINE = 8,
   ANNOBJECT_NOTE = 9,
   ANNOBJECT_POLYGON = 10,
   ANNOBJECT_POLYLINE = 11,
   ANNOBJECT_RECT = 12,
   ANNOBJECT_REDACT = 13,
   ANNOBJECT_STAMP = 14,
   ANNOBJECT_TEXT = 15,
   ANNOBJECT_AUTOMATION = 16,
   ANNOBJECT_RULER = 17,
   ANNOBJECT_CROSSPRODUCT = 18,
   ANNOBJECT_POINT = 19,
   ANNOBJECT_PROTRACTOR = 20,
   ANNOBJECT_VIDEO = 21,
   ANNOBJECT_PUSHPIN = 22,
   ANNOBJECT_FREEHANDHOTSPOT = 23,
   ANNOBJECT_CURVE = 24,
   ANNOBJECT_CURVECLOSED = 25,
   ANNOBJECT_ENCRYPT = 26,
   ANNOBJECT_TEXTPOINTER = 27,
   ANNOBJECT_POLYRULER   = 28,
   ANNOBJECT_RTF = 29,

   ANNOBJECT_LAST,            // last automation object defined
} ANNOBJECTTYPE, *pANNOBJECTTYPE;

/*
   defined used in L_AnnSetAutoMenuItemEnable/L_AnnGetAutoMenuItemEnable
*/
#define ANNOBJECT_ALL               -1

/*
   automation text items
*/
enum {
/*
   automation menu text
*/
   ANNAUTOTEXT_MENU_UNDO,
   ANNAUTOTEXT_MENU_CUT,
   ANNAUTOTEXT_MENU_COPY,
   ANNAUTOTEXT_MENU_PASTE,
   ANNAUTOTEXT_MENU_DELETE,
   ANNAUTOTEXT_MENU_SELECTALL,
   ANNAUTOTEXT_MENU_BRINGTOFRONT,
   ANNAUTOTEXT_MENU_SENDTOBACK,
   ANNAUTOTEXT_MENU_DEFAULTPROPERTIES,
   ANNAUTOTEXT_MENU_SELECTEDPROPERTIES,
   ANNAUTOTEXT_MENU_CONTAINERPROPERTIES,
   ANNAUTOTEXT_MENU_POINTERPROPERTIES,
   ANNAUTOTEXT_MENU_AUDIOPROPERTIES,
   ANNAUTOTEXT_MENU_BUTTONPROPERTIES,
   ANNAUTOTEXT_MENU_ELLIPSEPROPERTIES,
   ANNAUTOTEXT_MENU_FREEHANDPROPERTIES,
   ANNAUTOTEXT_MENU_HILITEPROPERTIES,
   ANNAUTOTEXT_MENU_HOTSPOTPROPERTIES,
   ANNAUTOTEXT_MENU_LINEPROPERTIES,
   ANNAUTOTEXT_MENU_NOTEPROPERTIES,
   ANNAUTOTEXT_MENU_POLYGONPROPERTIES,
   ANNAUTOTEXT_MENU_POLYLINEPROPERTIES,
   ANNAUTOTEXT_MENU_RECTANGLEPROPERTIES,
   ANNAUTOTEXT_MENU_REDACTPROPERTIES,
   ANNAUTOTEXT_MENU_STAMPPROPERTIES,
   ANNAUTOTEXT_MENU_TEXTPROPERTIES,
   ANNAUTOTEXT_MENU_AUTOMATIONPROPERTIES,
   ANNAUTOTEXT_MENU_RULERPROPERTIES,
   ANNAUTOTEXT_MENU_CROSSPRODUCTPROPERTIES,
   ANNAUTOTEXT_MENU_POINTPROPERTIES,
   ANNAUTOTEXT_MENU_PROTRACTORPROPERTIES,
   ANNAUTOTEXT_MENU_VIDEOPROPERTIES,
   ANNAUTOTEXT_MENU_PUSHPINPROPERTIES,
   ANNAUTOTEXT_MENU_FREEHANDHOSPOTPROPERTIES,
   ANNAUTOTEXT_MENU_CURVEPROPERTIES,
   ANNAUTOTEXT_MENU_CURVECLOSEDPROPERTIES,
   ANNAUTOTEXT_MENU_ENCRYPTPROPERTIES,
   ANNAUTOTEXT_MENU_TEXTPOINTERPROPERTIES,
   ANNAUTOTEXT_MENU_POLYRULERPROPERTIES,
   ANNAUTOTEXT_MENU_RTFPROPERTIES,


   ANNAUTOTEXT_MENU_LINE,
   ANNAUTOTEXT_MENU_FILL,
   ANNAUTOTEXT_MENU_FOREGROUNDCOLOR,
   ANNAUTOTEXT_MENU_BACKGROUNDCOLOR,
   ANNAUTOTEXT_MENU_FONT,
   ANNAUTOTEXT_MENU_BITMAP,
   ANNAUTOTEXT_MENU_TEXT,
   ANNAUTOTEXT_MENU_FILE,
   ANNAUTOTEXT_MENU_ROP2,
   ANNAUTOTEXT_MENU_TRANSPARENT,
   ANNAUTOTEXT_MENU_LOCK,
   ANNAUTOTEXT_MENU_UNLOCK,
   ANNAUTOTEXT_MENU_LOCKALL,
   ANNAUTOTEXT_MENU_UNLOCKALL,
   ANNAUTOTEXT_MENU_HYPERLINK,
   ANNAUTOTEXT_MENU_NOTEBACKGROUNDCOLOR,
   ANNAUTOTEXT_MENU_REDACTBACKGROUNDCOLOR,
   ANNAUTOTEXT_MENU_HILITEBACKGROUNDCOLOR,
   ANNAUTOTEXT_MENU_HOTSPOTMETAFILE,
   ANNAUTOTEXT_MENU_ENCRYPTMETAFILE,
   ANNAUTOTEXT_MENU_DECRYPTMETAFILE,
   ANNAUTOTEXT_MENU_RULER,

   ANNAUTOTEXT_MENU_BUTTONFONT,
   ANNAUTOTEXT_MENU_GROUP,
   ANNAUTOTEXT_MENU_UNGROUP,
   ANNAUTOTEXT_MENU_NODES,
   ANNAUTOTEXT_MENU_PROTRACTOR,
   ANNAUTOTEXT_MENU_NAME,
   ANNAUTOTEXT_MENU_ENCRYPT,
   ANNAUTOTEXT_MENU_POINT, 

   ANNAUTOTEXT_MENU_METAFILE,
   ANNAUTOTEXT_MENU_SECONDARYMETAFILE,
   ANNAUTOTEXT_MENU_SECONDARYFILE,
   ANNAUTOTEXT_MENU_TRANSPARENTCOLOR,
   ANNAUTOTEXT_MENU_DELETENODE,
   ANNAUTOTEXT_MENU_ADDNODE,
   ANNAUTOTEXT_MENU_CAPTURE,

   ANNAUTOTEXT_MENU_FIXED,

/*
   toolbar rubber stamps menu text
*/
   ANNAUTOTEXT_MENU_STAMP_APPROVED,
   ANNAUTOTEXT_MENU_STAMP_ASSIGNED,
   ANNAUTOTEXT_MENU_STAMP_CHECKED,
   ANNAUTOTEXT_MENU_STAMP_CLATPRV,
   ANNAUTOTEXT_MENU_STAMP_COPY,
   ANNAUTOTEXT_MENU_STAMP_DRAFT,
   ANNAUTOTEXT_MENU_STAMP_EXTENDED,
   ANNAUTOTEXT_MENU_STAMP_FAX,
   ANNAUTOTEXT_MENU_STAMP_FAXED,
   ANNAUTOTEXT_MENU_STAMP_IMPORTANT,
   ANNAUTOTEXT_MENU_STAMP_INVOICE,
   ANNAUTOTEXT_MENU_STAMP_NOTICE,
   ANNAUTOTEXT_MENU_STAMP_OFFICIAL,
   ANNAUTOTEXT_MENU_STAMP_ONFILE,
   ANNAUTOTEXT_MENU_STAMP_PAID,
   ANNAUTOTEXT_MENU_STAMP_PASSED,
   ANNAUTOTEXT_MENU_STAMP_PENDING,
   ANNAUTOTEXT_MENU_STAMP_PROCESSED,
   ANNAUTOTEXT_MENU_STAMP_RECEIVED,
   ANNAUTOTEXT_MENU_STAMP_REJECTED,
   ANNAUTOTEXT_MENU_STAMP_RELEASE,
   ANNAUTOTEXT_MENU_STAMP_SENT,
   ANNAUTOTEXT_MENU_STAMP_SHIPPED,
   ANNAUTOTEXT_MENU_STAMP_TOPSECRET,
   ANNAUTOTEXT_MENU_STAMP_URGENT,
   ANNAUTOTEXT_MENU_STAMP_VOID,

/*
   automation line dialog text
*/
   ANNAUTOTEXT_LINE_CAPTION,
   ANNAUTOTEXT_LINE_WIDTH,
   ANNAUTOTEXT_LINE_STYLE,
   ANNAUTOTEXT_LINE_OK,
   ANNAUTOTEXT_LINE_CANCEL,
   ANNAUTOTEXT_LINE_APPLY,

   ANNAUTOTEXT_LINE_SOLID,
   ANNAUTOTEXT_LINE_DASH,
   ANNAUTOTEXT_LINE_DOT,
   ANNAUTOTEXT_LINE_DASHDOT,
   ANNAUTOTEXT_LINE_DASHDOTDOT,
   ANNAUTOTEXT_LINE_NULL,

/*
   automation fill dialog text
*/
   ANNAUTOTEXT_FILL_CAPTION,
   ANNAUTOTEXT_FILL_MODE,
   ANNAUTOTEXT_FILL_PATTERNS,
   ANNAUTOTEXT_FILL_POLYGON,
   ANNAUTOTEXT_FILL_OK,
   ANNAUTOTEXT_FILL_CANCEL,
   ANNAUTOTEXT_FILL_APPLY,

   ANNAUTOTEXT_FILL_TRANSPARENT,
   ANNAUTOTEXT_FILL_TRANSLUCENT,
   ANNAUTOTEXT_FILL_OPAQUE,

   ANNAUTOTEXT_FILL_SOLID,
   ANNAUTOTEXT_FILL_BACKWARDDIAGONAL,
   ANNAUTOTEXT_FILL_CROSS,
   ANNAUTOTEXT_FILL_DIAGONALCROSS,
   ANNAUTOTEXT_FILL_FORWARDDIAGONAL,
   ANNAUTOTEXT_FILL_HORIZONTAL,
   ANNAUTOTEXT_FILL_VERTICAL,

   ANNAUTOTEXT_FILL_WINDING,
   ANNAUTOTEXT_FILL_ALTERNATE,

/*
   automation text dialog text
*/
   ANNAUTOTEXT_TEXT_CAPTION,
   ANNAUTOTEXT_TEXT_IMPORT,
   ANNAUTOTEXT_TEXT_FILE_CAPTION,   // "Text File", 0, 
   ANNAUTOTEXT_TEXT_FILE_FILTER,    // "Text files (*.txt)|*.txt|All Files (*.*)|*.*|", 0,
   ANNAUTOTEXT_TEXT_INSERT_TOKEN,
   ANNAUTOTEXT_TEXT_ALIGN,
   ANNAUTOTEXT_TEXT_ALIGN_LEFT,
   ANNAUTOTEXT_TEXT_ALIGN_CENTER,
   ANNAUTOTEXT_TEXT_ALIGN_RIGHT,

   ANNAUTOTEXT_TEXT_ROTATION, 
   ANNAUTOTEXT_TEXT_ROTATE_0,  
   ANNAUTOTEXT_TEXT_ROTATE_90, 
   ANNAUTOTEXT_TEXT_ROTATE_180,
   ANNAUTOTEXT_TEXT_ROTATE_270,

   ANNAUTOTEXT_TEXT_FIXED_POINTER,
   ANNAUTOTEXT_TEXT_EXPAND_TOKENS,
   ANNAUTOTEXT_TEXT_OK,
   ANNAUTOTEXT_TEXT_CANCEL,
   ANNAUTOTEXT_TEXT_APPLY,

/*
   automation audio file dialog text
*/
   ANNAUTOTEXT_AUDIOFILE_CAPTION,
   ANNAUTOTEXT_AUDIOFILE_FILTER,

/*
   automation stamp file dialog text
*/
   ANNAUTOTEXT_STAMPFILE_CAPTION,
   ANNAUTOTEXT_STAMPFILE_FILTER,

/*
   automation hotspot file dialog text
*/
   //ANNAUTOTEXT_HOTSPOTFILE_CAPTION,
   //ANNAUTOTEXT_HOTSPOTFILE_FILTER,

/*
   automation point file dialog text
*/
   ANNAUTOTEXT_POINTFILE_CAPTION,
   ANNAUTOTEXT_POINTFILE_FILTER,

/*
   automation audio file dialog text
*/
   ANNAUTOTEXT_VIDEOFILE_CAPTION,
   ANNAUTOTEXT_VIDEOFILE_FILTER,

/*
   automation pushpin file dialog text
*/
   ANNAUTOTEXT_PUSHPINFILE_CAPTION,
   ANNAUTOTEXT_PUSHPINFILE_FILTER,
   ANNAUTOTEXT_PUSHPINSECONDARYFILE_CAPTION,
   ANNAUTOTEXT_PUSHPINSECONDARYFILE_FILTER,

/*
   automation default item text
*/
   ANNAUTOTEXT_ITEM_DEFAULTTEXT,

/*
   automation ROP2 dialog text
*/
   ANNAUTOTEXT_ROP2_CAPTION,
   ANNAUTOTEXT_ROP2_TEXT,
   ANNAUTOTEXT_ROP2_OK,
   ANNAUTOTEXT_ROP2_CANCEL,
   ANNAUTOTEXT_ROP2_APPLY,
   ANNAUTOTEXT_ROP2_COPY,
   ANNAUTOTEXT_ROP2_AND,
   ANNAUTOTEXT_ROP2_XOR,

/*
   automation Lock dialog text
*/
   ANNAUTOTEXT_LOCK_CAPTION,
   ANNAUTOTEXT_LOCK_TEXT,
   ANNAUTOTEXT_LOCK_OK,
   ANNAUTOTEXT_LOCK_CANCEL,

/*
   automation Unlock dialog text
*/
   ANNAUTOTEXT_UNLOCK_CAPTION,
   ANNAUTOTEXT_UNLOCK_TEXT,
   ANNAUTOTEXT_UNLOCK_OK,
   ANNAUTOTEXT_UNLOCK_CANCEL,

/*
   automation Ruler dialog text
*/
   ANNAUTOTEXT_RULER_CAPTION,
   ANNAUTOTEXT_RULER_UNITS,
   ANNAUTOTEXT_RULER_ABBREV,
   ANNAUTOTEXT_RULER_PRECISION,
   ANNAUTOTEXT_RULER_LENGTH,
   ANNAUTOTEXT_RULER_OK,
   ANNAUTOTEXT_RULER_CANCEL,
   ANNAUTOTEXT_RULER_APPLY,

   ANNAUTOTEXT_RULER_INCHES,
   ANNAUTOTEXT_RULER_FEET,
   ANNAUTOTEXT_RULER_YARDS,
   ANNAUTOTEXT_RULER_MICROMETERS,
   ANNAUTOTEXT_RULER_MILLIMETERS,
   ANNAUTOTEXT_RULER_CENTIMETERS,
   ANNAUTOTEXT_RULER_METERS,
   ANNAUTOTEXT_RULER_TWIPS,
   ANNAUTOTEXT_RULER_POINTS,
   ANNAUTOTEXT_RULER_PIXELS,
   ANNAUTOTEXT_RULER_SMART_METRIC,
   ANNAUTOTEXT_RULER_SMART_ENGLISH,

   ANNAUTOTEXT_RULER_SHOWLENGTH,
   ANNAUTOTEXT_RULER_SHOWGAUGE,
   ANNAUTOTEXT_RULER_SHOWTICMARKS,

/*
   automation Nodes dialog text
*/
   ANNAUTOTEXT_NODES_CAPTION,
   ANNAUTOTEXT_NODES_DISPLAYNODES,
   ANNAUTOTEXT_NODES_GAP,
   ANNAUTOTEXT_NODES_OK,
   ANNAUTOTEXT_NODES_CANCEL,
   ANNAUTOTEXT_NODES_APPLY,

/*
   automation Protractor dialog text
*/
   ANNAUTOTEXT_PROTRACTOR_CAPTION,
   ANNAUTOTEXT_PROTRACTOR_ACUTE,
   ANNAUTOTEXT_PROTRACTOR_UNITS,
   ANNAUTOTEXT_PROTRACTOR_ABBREV,
   ANNAUTOTEXT_PROTRACTOR_PRECISION,
   ANNAUTOTEXT_PROTRACTOR_ARCRADIUS,
   ANNAUTOTEXT_PROTRACTOR_OK,
   ANNAUTOTEXT_PROTRACTOR_CANCEL,
   ANNAUTOTEXT_PROTRACTOR_APPLY,

   ANNAUTOTEXT_PROTRACTOR_DEGREES,
   ANNAUTOTEXT_PROTRACTOR_RADIANS,

   /*
   automation Name dialog text
   */
   ANNAUTOTEXT_NAME_CAPTION,
   ANNAUTOTEXT_NAME_SHOW,
   ANNAUTOTEXT_NAME_LOCATION,
   ANNAUTOTEXT_NAME_OFFSET,
   ANNAUTOTEXT_NAME_OFFSET_X,
   ANNAUTOTEXT_NAME_OFFSET_Y,
   ANNAUTOTEXT_NAME_RESTRICT,
   ANNAUTOTEXT_NAME_FONT,
   ANNAUTOTEXT_NAME_SAMPLE,
   ANNAUTOTEXT_NAME_SAMPLE_TEXT,
   ANNAUTOTEXT_NAME_COLORS,
   ANNAUTOTEXT_NAME_FOREGROUNDCOLOR,
   ANNAUTOTEXT_NAME_BACKGROUNDCOLOR,
   ANNAUTOTEXT_NAME_TRANSPARENT,
   ANNAUTOTEXT_NAME_OK,
   ANNAUTOTEXT_NAME_CANCEL,
   ANNAUTOTEXT_NAME_APPLY,

/*
   automation default item text
*/
   ANNAUTOTEXT_ITEM_DEFAULTNAME,

/*
   automation Play Video dialog text
*/
   ANNAUTOTEXT_PLAYVIDEO_CAPTION,
   ANNAUTOTEXT_PLAYVIDEO_BALANCE,
   ANNAUTOTEXT_PLAYVIDEO_VOLUME,
   ANNAUTOTEXT_PLAYVIDEO_SPEED,

   ANNAUTOTEXT_PLAYVIDEO_TIP_PLAY,
   ANNAUTOTEXT_PLAYVIDEO_TIP_PAUSE,
   ANNAUTOTEXT_PLAYVIDEO_TIP_STOP,
   ANNAUTOTEXT_PLAYVIDEO_TIP_REWIND,
   ANNAUTOTEXT_PLAYVIDEO_TIP_FORWARD,
   ANNAUTOTEXT_PLAYVIDEO_TIP_PREVMARK,
   ANNAUTOTEXT_PLAYVIDEO_TIP_NEXTMARK,
   ANNAUTOTEXT_PLAYVIDEO_TIP_NEXTFRAME,
   ANNAUTOTEXT_PLAYVIDEO_TIP_PREVFRAME,
   ANNAUTOTEXT_PLAYVIDEO_TIP_STARTSEL,
   ANNAUTOTEXT_PLAYVIDEO_TIP_ENDSEL,

/*
   automation stamp metafile dialog text
*/
   ANNAUTOTEXT_STAMPMETAFILE_CAPTION,
   ANNAUTOTEXT_STAMPMETAFILE_FILTER,

/*
   automation hotspot metafile dialog text
*/
   ANNAUTOTEXT_HOTSPOTMETAFILE_CAPTION,
   ANNAUTOTEXT_HOTSPOTMETAFILE_FILTER,

/*
   automation point dialog text
*/
   ANNAUTOTEXT_POINT_CAPTION,
   ANNAUTOTEXT_POINT_USE_BITMAP,
   ANNAUTOTEXT_POINT_NO_BITMAP,
   ANNAUTOTEXT_POINT_BITMAP,
   ANNAUTOTEXT_POINT_TRANSPARENT_BITMAP,
   ANNAUTOTEXT_POINT_RADIUS,
   ANNAUTOTEXT_POINT_BORDER_COLOR,
   ANNAUTOTEXT_POINT_FILL_COLOR,
   ANNAUTOTEXT_POINT_TRANSPARENT_FILL,
   ANNAUTOTEXT_POINT_FIXED_SIZE,

/* 
automation encrypt metafile dialog text
*/
   ANNAUTOTEXT_ENCRYPTMETAFILE_CAPTION,
   ANNAUTOTEXT_ENCRYPTMETAFILE_FILTER,
   ANNAUTOTEXT_DECRYPTMETAFILE_CAPTION,
   ANNAUTOTEXT_DECRYPTMETAFILE_FILTER,

/*
   automation encrypt dialog text
*/
   ANNAUTOTEXT_ENCRYPT_CAPTION,
   ANNAUTOTEXT_ENCRYPT_KEY,
   ANNAUTOTEXT_ENCRYPT_TYPE,
   ANNAUTOTEXT_ENCRYPT_RADIO_ENCRYPTOR,
   ANNAUTOTEXT_ENCRYPT_RADIO_DECRYPTOR,
   ANNAUTOTEXT_ENCRYPT_LOCATION,
   ANNAUTOTEXT_ENCRYPT_LOCATION_LEFT,
   ANNAUTOTEXT_ENCRYPT_LOCATION_TOP,
   ANNAUTOTEXT_ENCRYPT_LOCATION_RIGHT,
   ANNAUTOTEXT_ENCRYPT_LOCATION_BOTTOM,
   ANNAUTOTEXT_ENCRYPT_OK,
   ANNAUTOTEXT_ENCRYPT_CANCEL,

/*
   automation fixed dialog text
*/
   ANNAUTOTEXT_FIXED_CAPTION,
   ANNAUTOTEXT_FIXED_DETAILED_DESCRIPTION,
   ANNAUTOTEXT_FIXED_FIXED,
   ANNAUTOTEXT_FIXED_FIXED_DESCRIPTION,
   ANNAUTOTEXT_FIXED_ADJUST,
   ANNAUTOTEXT_FIXED_ADJUST_DESCRIPTION,
   ANNAUTOTEXT_FIXED_OK,
   ANNAUTOTEXT_FIXED_CANCEL,
   ANNAUTOTEXT_FIXED_APPLY,

/*
   toolbar buttons tooltip text
*/
   ANNAUTOTEXT_TOOLTIP_SELECT,
   ANNAUTOTEXT_TOOLTIP_LINE,
   ANNAUTOTEXT_TOOLTIP_RECT,
   ANNAUTOTEXT_TOOLTIP_ELLIPSE,
   ANNAUTOTEXT_TOOLTIP_POLYLINE,
   ANNAUTOTEXT_TOOLTIP_POLYGON,
   ANNAUTOTEXT_TOOLTIP_POINTER,
   ANNAUTOTEXT_TOOLTIP_FREEHAND,
   ANNAUTOTEXT_TOOLTIP_HILITE,
   ANNAUTOTEXT_TOOLTIP_REDACT,
   ANNAUTOTEXT_TOOLTIP_TEXT,
   ANNAUTOTEXT_TOOLTIP_NOTE,
   ANNAUTOTEXT_TOOLTIP_STAMP,
   ANNAUTOTEXT_TOOLTIP_RUBBERSTAMP,
   ANNAUTOTEXT_TOOLTIP_HOTSPOT,
   ANNAUTOTEXT_TOOLTIP_FREEHANDHOTSPOT,
   ANNAUTOTEXT_TOOLTIP_AUDIO,
   ANNAUTOTEXT_TOOLTIP_BUTTON,
   ANNAUTOTEXT_TOOLTIP_RULER,
   ANNAUTOTEXT_TOOLTIP_CROSSPRODUCT,
   ANNAUTOTEXT_TOOLTIP_POINT,
   ANNAUTOTEXT_TOOLTIP_PROTRACTOR,
   ANNAUTOTEXT_TOOLTIP_VIDEO,
   ANNAUTOTEXT_TOOLTIP_PUSHPIN,
   ANNAUTOTEXT_TOOLTIP_CURVE,
   ANNAUTOTEXT_TOOLTIP_CURVECLOSED,
   ANNAUTOTEXT_TOOLTIP_ENCRYPT,
   ANNAUTOTEXT_TOOLTIP_TEXTPOINTER,
   ANNAUTOTEXT_TOOLTIP_POLYRULER,
   ANNAUTOTEXT_TOOLTIP_RTF,

/*
   automation transparent color dialog text
*/
   ANNAUTOTEXT_TRANSPARENTCOLOR_CAPTION,
   ANNAUTOTEXT_TRANSPARENTCOLOR_COLORARRAYFRAME,
   ANNAUTOTEXT_TRANSPARENTCOLOR_CURRENTCOLORFRAME,
   ANNAUTOTEXT_TRANSPARENTCOLOR_COLOR,
   ANNAUTOTEXT_TRANSPARENTCOLOR_RED,
   ANNAUTOTEXT_TRANSPARENTCOLOR_GREEN,
   ANNAUTOTEXT_TRANSPARENTCOLOR_BLUE,
   ANNAUTOTEXT_TRANSPARENTCOLOR_OK,
   ANNAUTOTEXT_TRANSPARENTCOLOR_CANCEL,

/*
   automation capture file dialog text
*/
   ANNAUTOTEXT_CAPTUREFILE_CAPTION,
   ANNAUTOTEXT_CAPTUREFILE_FILTER,

/*
   automation capture dialog text
*/
   ANNAUTOTEXT_CAPTUREWINDOW_CAPTION,
   ANNAUTOTEXT_CAPTURE_CAPTION,
   ANNAUTOTEXT_CAPTURE_CAPTURE_DEVICES,
   ANNAUTOTEXT_CAPTURE_CAPTURE_VIDEO,
   ANNAUTOTEXT_CAPTURE_CAPTURE_AUDIO,
   ANNAUTOTEXT_CAPTURE_CAPTURE_PROPERTIES,
   ANNAUTOTEXT_CAPTURE_CAPTURE_VIDEO_CAPTURE_SIZE,
   ANNAUTOTEXT_CAPTURE_CAPTURE_AUDIO_FORMAT,
   ANNAUTOTEXT_CAPTURE_COMPRESSORS,
   ANNAUTOTEXT_CAPTURE_COMPRESSORS_VIDEO,
   ANNAUTOTEXT_CAPTURE_COMPRESSORS_AUDIO,
   ANNAUTOTEXT_CAPTURE_COMPRESSORS_VIDEO_PROPERTIES,
   ANNAUTOTEXT_CAPTURE_COMPRESSORS_AUDIO_PROPERTIES,
   ANNAUTOTEXT_CAPTURE_PROCESSORS,
   ANNAUTOTEXT_CAPTURE_PROCESSORS_VIDEO,
   ANNAUTOTEXT_CAPTURE_PROCESSORS_AUDIO,
   ANNAUTOTEXT_CAPTURE_DISPLAYMODE,
   ANNAUTOTEXT_CAPTURE_DISPLAYMODE_PREVIEW,
   ANNAUTOTEXT_CAPTURE_DISPLAYMODE_AUDIO,
   ANNAUTOTEXT_CAPTURE_DISPLAYMODE_VIDEO,
   ANNAUTOTEXT_CAPTURE_DISPLAYMODE_VIDEO_FRAMES_PER_SEC,
   ANNAUTOTEXT_CAPTURE_DISPLAYMODE_SHOW_DIALOG_PREVIEW,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS_FRAMES_PER_SEC,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS_TIME_LIMIT,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS_VIDEO,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS_AUDIO,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS_START,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS_END,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS_FRAMES_CAPTURED,
   ANNAUTOTEXT_CAPTURE_CAPTURE_OPTIONS_FRAMES_DROPPED,
   ANNAUTOTEXT_CAPTURE_CAPTUREFILE,
   ANNAUTOTEXT_CAPTURE_CAPTUREFILE_BROWSE,
   ANNAUTOTEXT_CAPTURE_CAPTUREFILE_ALLOCATE_FILE,
   ANNAUTOTEXT_CAPTURE_CAPTUREFILE_UNITS,
   ANNAUTOTEXT_CAPTURE_OK,
   ANNAUTOTEXT_CAPTURE_APPLY_SETTINGS,
   ANNAUTOTEXT_CAPTURE_CANCEL,
   ANNAUTOTEXT_CAPTURE_DEFAULTNAME,
   ANNAUTOTEXT_CAPTURE_NOVIDEODRIVERS,
   ANNAUTOTEXT_CAPTURE_NOAUDIODRIVERS,
   ANNAUTOTEXT_DIALOG_FONT,
   ANNAUTOTEXT_MM_NOT_PRESENT, 
   ANNAUTOTEXT_ERROR,
   ANNAUTOTEXT_WARNING,
   ANNAUTOTEXT_MISSING_DLL,
   ANNAUTOTEXT_MISSING_FUNCTION,
   ANNAUTOTEXT_MISSING_ORDINAL,
   
   // RTF Object menus and toolbars
   ANNAUTOTEXT_RTF_DEFAULTTEXT, 
//    ANNAUTOTEXT_RTF_BACKCOLOR,
//    ANNAUTOTEXT_RTF_FORECOLOR,
   ANNAUTOTEXT_RTF_FIND_MESSAGE,
   ANNAUTOTEXT_RTF_MENU_TITLE,

   ANNAUTOTEXT_RTF_MENU_FILE,                   // "&File"
   ANNAUTOTEXT_RTF_MENU_FILE_OPEN,              // "&Open...",                    LTANN_IDM_RTF_OPEN
   ANNAUTOTEXT_RTF_MENU_FILE_SAVE_AS,           // "&Save as ...",                LTANN_IDM_RTF_SAVE
   ANNAUTOTEXT_RTF_MENU_FILE_PRINT,             // "&Print...",                   LTANN_IDM_RTF_PRINT
   ANNAUTOTEXT_RTF_MENU_FILE_EXIT,              // "E&xit",                       LTANN_IDM_RTF_EXIT
   ANNAUTOTEXT_RTF_MENU_EDIT,                   // "&Edit"
   ANNAUTOTEXT_RTF_MENU_EDIT_UNDO,              // "&Undo",                       LTANN_IDM_RTF_UNDO
   ANNAUTOTEXT_RTF_MENU_EDIT_CUT,               // "Cu&t",                        LTANN_IDM_RTF_CUT
   ANNAUTOTEXT_RTF_MENU_EDIT_COPY,              // "&Copy",                       LTANN_IDM_RTF_COPY
   ANNAUTOTEXT_RTF_MENU_EDIT_PASTE,             // "&Paste",                      LTANN_IDM_RTF_PASTE
   ANNAUTOTEXT_RTF_MENU_EDIT_DELETE,            // "&Delete",                     LTANN_IDM_RTF_DELETE
   ANNAUTOTEXT_RTF_MENU_EDIT_SELECT_ALL,        // "Select &All",                 LTANN_IDM_RTF_SELECTALL
   ANNAUTOTEXT_RTF_MENU_EDIT_FIND,              // "&Find...",                    LTANN_IDM_RTF_FIND
   ANNAUTOTEXT_RTF_MENU_EDIT_REPLACE,           // "&Replace...",                 LTANN_IDM_RTF_REPLACE
   ANNAUTOTEXT_RTF_MENU_FORMAT,                 // "F&ormat"
   ANNAUTOTEXT_RTF_MENU_FORMAT_FONT,            // "&Font...",                    LTANN_IDM_RTF_FONT
   ANNAUTOTEXT_RTF_MENU_FORMAT_BACKCOLOR,
   ANNAUTOTEXT_RTF_MENU_FORMAT_FORECOLOR, 
   ANNAUTOTEXT_RTF_MENU_FORMAT_BULLETS,         // "Bullets",                     LTANN_IDM_RTF_BULLET, CHECKED
   ANNAUTOTEXT_RTF_MENU_FORMAT_NUMBERING,       // "Numbering",                   LTANN_IDM_RTF_NUMBERING, CHECKED
   ANNAUTOTEXT_RTF_MENU_FORMAT_DECREASE_INDENT, // "&Decrease Indent",            LTANN_IDM_RTF_DECREASEINDENT
   ANNAUTOTEXT_RTF_MENU_FORMAT_INCREASE_INDENT, // "&Increase Indent",            LTANN_IDM_RTF_INCREASEINDENT
   ANNAUTOTEXT_RTF_MENU_FORMAT_LEFT,            // "&Left",                       LTANN_IDM_RTF_LEFT, CHECKED
   ANNAUTOTEXT_RTF_MENU_FORMAT_CENTER,          // "&Center",                     LTANN_IDM_RTF_CENTER, CHECKED
   ANNAUTOTEXT_RTF_MENU_FORMAT_RIGHT,           // "&Right",                      LTANN_IDM_RTF_RIGHT, CHECKED

   ANNAUTOTEXT_RTF_TOOLTIP_BOLD,                // "Bold",                        LTANN_ID_RTF_HIDE_BOLD, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_ITALIC,              // "Italic",                      LTANN_ID_RTF_HIDE_ITALIC, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_UNDERLINE,           // "Underline",                   LTANN_ID_RTF_HIDE_UNDERLINE, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_FORECOLOR,           // "Text Color",                  LTANN_ID_RTF_HIDE_FORECOLOR, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_BACKCOLOR,           // "Background Color",            LTANN_ID_RTF_HIDE_BACKCOLOR, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_BULLETS,             // "Bullets",                     LTANN_ID_RTF_HIDE_BULLET, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_NUMBERING,           // "Numbering",                   LTANN_ID_RTF_HIDE_NUMBERING, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_DECREASE_INDENT,     // "Decrease Indent",             LTANN_ID_RTF_HIDE_DECREASEINDENT
   ANNAUTOTEXT_RTF_TOOLTIP_INCREASE_INDENT,     // "Increase Indent",             LTANN_ID_RTF_HIDE_INCREASEINDENT
   ANNAUTOTEXT_RTF_TOOLTIP_LEFT,                // "Left",                        LTANN_ID_RTF_HIDE_LEFT, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_CENTER,              // "Center",                      LTANN_ID_RTF_HIDE_CENTER, CHECKED
   ANNAUTOTEXT_RTF_TOOLTIP_RIGHT,               // "Right",                       LTANN_ID_RTF_HIDE_RIGHT, CHECKED   
   ANNAUTOTEXT_RTF_TOOLTIP_CUSTOM, 

   ANNAUTOTEXT_RTF_FILTER,                      // "Rich Text Format (*.RTF)\0*.rtf\0"
   ANNAUTOTEXT_RTF_EXT,                         // "rtf"
   ANNAUTOTEXT_RTF_DLL_NOT_PRESENT,              // Riched20.dll not installed message


   // Added in middle of v14
   ANNAUTOTEXT_RULER_TICMARKLENGTH,             // Tic Mark Length
   ANNAUTOTEXT_TEXT_TOKEN_DATE_YYYY,            // Four digit year   
   ANNAUTOTEXT_TEXT_TOKEN_DATE_YY,              // Two digit year
   ANNAUTOTEXT_TEXT_TOKEN_DATE_MM,              // Two digit month
   ANNAUTOTEXT_TEXT_TOKEN_DATE_DD,              // Two digit day
   ANNAUTOTEXT_TEXT_TOKEN_DATE_MONTH_NAME,      // Month Name
   ANNAUTOTEXT_TEXT_TOKEN_DATE_DAY_OF_WEEK,     // Day of week name
   ANNAUTOTEXT_TEXT_TOKEN_TIME_HH_12,           // Current time: 12-Hour (01-12)
   ANNAUTOTEXT_TEXT_TOKEN_TIME_HH_24,           // Current time: 24-Hour (00-23)
   ANNAUTOTEXT_TEXT_TOKEN_TIME_MM,              // Current time: minutes
   ANNAUTOTEXT_TEXT_TOKEN_TIME_SS,              // Current time: seconds
   ANNAUTOTEXT_TEXT_TOKEN_TIME_MILLISECONDS,    // Current time: milliseconds
   ANNAUTOTEXT_TEXT_TOKEN_TIME_AM_PM,           // Current time: AM or PM

   // v14.5 -- 
   ANNAUTOTEXT_FILL_ALPHA_RANGE, // v14.5
   ANNAUTOTEXT_FILL_ALPHA,                // v14.5
   ANNAUTOTEXT_MENU_ROTATEPROPERTIES,
   ANNAUTOTEXT_MENU_ROTATE_SHOW,
   ANNAUTOTEXT_MENU_ROTATE_HIDE,
   ANNAUTOTEXT_MENU_ROTATE_RESET,
   ANNAUTOTEXT_MENU_ROTATE_SHOW_ALL,
   ANNAUTOTEXT_MENU_ROTATE_HIDE_ALL,
   ANNAUTOTEXT_MENU_ROTATE_RESET_ALL,

   // Calibrate Dialog
   ANNAUTOTEXT_CALIBRATE_CAPTION,
   ANNAUTOTEXT_CALIBRATE_HELP,
   ANNAUTOTEXT_CALIBRATE_DESCRIPTION,
   ANNAUTOTEXT_CALIBRATE_LENGTH,
   ANNAUTOTEXT_CALIBRATE_UNITS,
   ANNAUTOTEXT_CALIBRATE_ADVANCED,
   ANNAUTOTEXT_CALIBRATE_DPI,
   ANNAUTOTEXT_CALIBRATE_DPI_RATIO,
   ANNAUTOTEXT_CALIBRATE_DPIX,
   ANNAUTOTEXT_CALIBRATE_DPIY,
   ANNAUTOTEXT_CALIBRATE_APPLY_NEW,
   ANNAUTOTEXT_CALIBRATE_APPLY_EXISTING,
   ANNAUTOTEXT_CALIBRATE_CANCEL,
   ANNAUTOTEXT_CALIBRATE_OK,

   // This one goes in the Ruler Options dialog
   ANNAUTOTEXT_RULER_CALIBRATE, 

   // Text dialog
   ANNAUTOTEXT_TEXT_COLOR,   
   ANNAUTOTEXT_TEXT_SHOW_TEXT,   
   ANNAUTOTEXT_TEXT_SHOW_BORDER,

   // This one goes after FOREGROUNDCOLOR and BACKGROUNDCOLOR
   ANNAUTOTEXT_MENU_TEXTCOLOR,

   // This one goes after ANNAUTOTEXT_MENU_METAFILE
   ANNAUTOTEXT_MENU_SHOWSTAMPBORDER,
   ANNAUTOTEXT_CALIBRATE_REPLACE_EXISTING,
   ANNAUTOTEXT_CALIBRATE_ADDTO_EXISTING,

   ANNAUTOTEXT_MENU_SNAPTOGRID,
   ANNAUTOTEXT_MENU_OPTIONS_SNAPTOGRID,
   ANNAUTOTEXT_SNAPTOGRID_CAPTION,
   //ANNAUTOTEXT_SNAPTOGRID_DETAILED_DESCRIPTION,
   ANNAUTOTEXT_SNAPTOGRID_APPEARANCE,
   ANNAUTOTEXT_SNAPTOGRID_SHOW_GRID,
   ANNAUTOTEXT_SNAPTOGRID_COLOR,
   ANNAUTOTEXT_SNAPTOGRID_LENGTH,
   ANNAUTOTEXT_SNAPTOGRID_LINE_SPACING,
   ANNAUTOTEXT_SNAPTOGRID_LINE_STYLE,
   ANNAUTOTEXT_SNAPTOGRID_BEHAVIOR,
   ANNAUTOTEXT_SNAPTOGRID_AUTO_CHANGE_GRID_LENGTH,
   ANNAUTOTEXT_SNAPTOGRID_ENABLE_SNAP,
   ANNAUTOTEXT_SNAPTOGRID_OK,
   ANNAUTOTEXT_SNAPTOGRID_CANCEL,
   ANNAUTOTEXT_SNAPTOGRID_APPLY,

/*
   extra automation Ruler dialog text
*/
   ANNAUTOTEXT_RULER_DISPLAY,
   ANNAUTOTEXT_RULER_DOCUMENT,

   ANNAUTOTEXT_MAX,
};


// Used in  L_AnnSetAutoCursor, L_AnnGetAutoCursor

enum {
/*
automation cursor
   */
   ANNAUTOCURSOR_DEFAULT,  // default cursor--arrow
      ANNAUTOCURSOR_DRAWNEW,  // drawing a new annotation--design mode, tool other ANNTOOL_SELECT
      ANNAUTOCURSOR_HANDLE,   // Design mode, when mouse over a handle
      ANNAUTOCURSOR_HOTSPOT,  // Run mode, when cursor over 
      //    button, hotspot, freehand hotspot, audio, video, pushpin
      ANNAUTOCURSOR_MOVE,     // Design mode, when moving an annotation by dragging it with the mouse
      ANNAUTOCURSOR_SELECT,   // Design mode, when hovering over an unselected annotation
      ANNAUTOCURSOR_TEXT,     // Design mode, when entering text into a text annotation

      ANNAUTOCURSOR_WAIT,     // Displayed with wait operation -- hourglass by default
      ANNAUTOCURSOR_ROTATE_GRIPPER, // Displayed when hovering over gripper rotate handle
      ANNAUTOCURSOR_ROTATE_CENTER,  // Displayed over rotate center handle
      
      // The following are displayed when hovering over a select handle
      ANNAUTOCURSOR_SIZENS,      // ANNAUTOCURSOR_SIZENS must be FIRST
      ANNAUTOCURSOR_SIZENESW,
      ANNAUTOCURSOR_SIZEWE,
      ANNAUTOCURSOR_SIZENWSE,    // ANNAUTOCURSOR_SIZENWSE must be LAST
      
      ANNAUTOCURSOR_SELECT_OUTLINE, // Displayed when dragging a selection with the selection tool
           
      // TOOLS -- these are displayed when in design mode drawing with particular tool
      ANNAUTOCURSOR_TOOL_LINE_CURSOR,
      ANNAUTOCURSOR_TOOL_RECT_CURSOR,
      ANNAUTOCURSOR_TOOL_ELLIPSE_CURSOR,
      ANNAUTOCURSOR_TOOL_POLYLINE_CURSOR,
      ANNAUTOCURSOR_TOOL_POLYGON_CURSOR,
      ANNAUTOCURSOR_TOOL_POINTER_CURSOR,
      ANNAUTOCURSOR_TOOL_FREEHAND_CURSOR,
      ANNAUTOCURSOR_TOOL_HILITE_CURSOR,
      ANNAUTOCURSOR_TOOL_REDACT_CURSOR,
      ANNAUTOCURSOR_TOOL_TEXT_CURSOR,
      ANNAUTOCURSOR_TOOL_NOTE_CURSOR,
      ANNAUTOCURSOR_TOOL_STAMP_CURSOR,
      ANNAUTOCURSOR_TOOL_BUTTON_CURSOR,
      ANNAUTOCURSOR_TOOL_HOTSPOT_CURSOR,
      ANNAUTOCURSOR_TOOL_AUDIO_CURSOR,
      ANNAUTOCURSOR_TOOL_RULER_CURSOR,
      ANNAUTOCURSOR_TOOL_CROSSPRODUCT_CURSOR,
      ANNAUTOCURSOR_TOOL_POINT_CURSOR,
      ANNAUTOCURSOR_TOOL_PROTRACTOR_CURSOR,
      ANNAUTOCURSOR_TOOL_VIDEO_CURSOR,
      ANNAUTOCURSOR_TOOL_PUSHPIN_CURSOR,
      ANNAUTOCURSOR_TOOL_FREEHANDHOTSPOT_CURSOR,
      ANNAUTOCURSOR_TOOL_CURVE_CURSOR,
      ANNAUTOCURSOR_TOOL_CURVECLOSED_CURSOR,
      ANNAUTOCURSOR_TOOL_ENCRYPT_CURSOR,
      ANNAUTOCURSOR_TOOL_TEXTPOINTER_CURSOR,
      ANNAUTOCURSOR_TOOL_POLYRULER_CURSOR,
      ANNAUTOCURSOR_TOOL_RTF_CURSOR,

      ANNAUTOCURSOR_TOOL_RUBBERSTAMP_CURSOR,
      
      
      ANNAUTOCURSOR_MAX,      // 
};

#define ANNMENU_DISABLED   0
#define ANNMENU_ENABLED    1
#define ANNMENU_DEFAULT    2

/*
   save/clipboard formats
*/
#define ANNFMT_NATIVE   0
#define ANNFMT_WMF      1
#define ANNFMT_TIFFTAG  2     /* Save all Lead info */
#define ANNFMT_WANGTAG  3     /* Wang annotation compatibility mode */
#define ANNFMT_ENCODED  4     /* Encoded native format (better security, smaller file size) */
#define ANNFMT_XML      5     
#define ANNFMT_EMF      6

/*
   Value of the Annotation Tag
*/
#define ANNTAG_TIFF           32932  // 0x80A4
#define ANNTAG_LOCALE         32933  // 0x80A5


/*
   toolbar buttons
*/
#define ANNTOOL_SELECT           0
#define ANNTOOL_LINE             1
#define ANNTOOL_RECT             2
#define ANNTOOL_ELLIPSE          3
#define ANNTOOL_POLYLINE         4
#define ANNTOOL_POLYGON          5
#define ANNTOOL_POINTER          6
#define ANNTOOL_FREEHAND         7
#define ANNTOOL_HILITE           8
#define ANNTOOL_REDACT           9
#define ANNTOOL_TEXT             10
#define ANNTOOL_NOTE             11
#define ANNTOOL_STAMP            12
#define ANNTOOL_BUTTON           13
#define ANNTOOL_HOTSPOT          14
#define ANNTOOL_AUDIO            15
#define ANNTOOL_RULER            16
#define ANNTOOL_CROSSPRODUCT     17
#define ANNTOOL_POINT            18
#define ANNTOOL_PROTRACTOR       19
#define ANNTOOL_VIDEO            20
#define ANNTOOL_PUSHPIN          21
#define ANNTOOL_FREEHANDHOTSPOT  22
#define ANNTOOL_CURVE            23
#define ANNTOOL_CURVECLOSED      24
#define ANNTOOL_ENCRYPT          25
#define ANNTOOL_TEXTPOINTER      26
#define ANNTOOL_POLYRULER        27
#define ANNTOOL_RTF              28


#define ANNTOOL_STAMP_FIRST      29    /* define that marks the first rubber stamp */
#define ANNTOOL_STAMP_APPROVED   29
#define ANNTOOL_STAMP_ASSIGNED   30
#define ANNTOOL_STAMP_CHECKED    31
#define ANNTOOL_STAMP_CLATPRV    32
#define ANNTOOL_STAMP_COPY       33
#define ANNTOOL_STAMP_DRAFT      34
#define ANNTOOL_STAMP_EXTENDED   35
#define ANNTOOL_STAMP_FAX        36
#define ANNTOOL_STAMP_FAXED      37
#define ANNTOOL_STAMP_IMPORTANT  38
#define ANNTOOL_STAMP_INVOICE    39
#define ANNTOOL_STAMP_NOTICE     40
#define ANNTOOL_STAMP_OFFICIAL   41
#define ANNTOOL_STAMP_ONFILE     42
#define ANNTOOL_STAMP_PAID       43
#define ANNTOOL_STAMP_PASSED     44
#define ANNTOOL_STAMP_PENDING    45
#define ANNTOOL_STAMP_PROCESSED  46
#define ANNTOOL_STAMP_RECEIVED   47
#define ANNTOOL_STAMP_REJECTED   48
#define ANNTOOL_STAMP_RELEASE    49
#define ANNTOOL_STAMP_SENT       50
#define ANNTOOL_STAMP_SHIPPED    51
#define ANNTOOL_STAMP_TOPSECRET  52
#define ANNTOOL_STAMP_URGENT     53
#define ANNTOOL_STAMP_VOID       54
#define ANNTOOL_STAMP_LAST       55  /* define that marks the last rubber stamp */


#define ANNTOOL_LAST             56

#define ANNTOOL_USER             0x0100 // first user defined tool
#define ANNTOOL_USERLAST         0x0200 // last allowed user tools

#define ISVALIDTOOL(nTool) (((nTool) >= ANNTOOL_SELECT && (nTool) <= ANNTOOL_LAST) || ((nTool) >= ANNTOOL_USER && (nTool) <= ANNTOOL_USERLAST))

/*
   data structures
*/
typedef struct _ANNPOINT
{
   L_DOUBLE x;
   L_DOUBLE y;
} ANNPOINT, *pANNPOINT;

typedef struct _ANNRECT
{
   L_DOUBLE left;
   L_DOUBLE top;
   L_DOUBLE right;
   L_DOUBLE bottom;
} ANNRECT, *pANNRECT;

/*
   toolbar defines/structures
*/

#define ANNBUTTON_MULTIPLE    0x0001   // if this flag is set, then the pButtonArray defines the button

typedef struct _ANNTOOLA
{
   L_UINT         uStructSize;
   L_UINT         uTool;
   L_INT          nMenuTextID;          // used if uMenuTextID >= 0
   L_CHAR        *pMenuText;            // used if uMenuTextID == -1
} ANNTOOLA, *pANNTOOLA;

#if defined(FOR_UNICODE)
typedef struct _ANNTOOL
{
   L_UINT         uStructSize;
   L_UINT         uTool;
   L_INT          nMenuTextID;          // used if uMenuTextID >= 0
   L_TCHAR * pMenuText;            // used if uMenuTextID == -1
} ANNTOOL, *pANNTOOL;
#else
typedef ANNTOOLA ANNTOOL;
typedef pANNTOOLA pANNTOOL;
#endif // #if defined(FOR_UNICODE)

typedef struct _ANNBUTTONA
{
   L_UINT         uStructSize;
   L_UINT         uFlags;
   L_UINT         uTool;
   L_UINT         uToolCount;
   pANNTOOLA      pTools;
   pBITMAPHANDLE  pBitmapUp;
   pBITMAPHANDLE  pBitmapDown;
   L_UINT         uBitmapStructSize;    // size of the structures pointed to by pBitmapUp and pBitmapDown
   L_INT          nToolTipTextID;       // used if uToolTipTextID >= 0
   L_CHAR        *pToolTipText;         // used if uToolTipTextID == -1
} ANNBUTTONA, *pANNBUTTONA;

#if defined(FOR_UNICODE)
typedef struct _ANNBUTTON
{
   L_UINT         uStructSize;
   L_UINT         uFlags;
   L_UINT         uTool;
   L_UINT         uToolCount;
   pANNTOOL       pTools;
   pBITMAPHANDLE  pBitmapUp;
   pBITMAPHANDLE  pBitmapDown;
   L_UINT         uBitmapStructSize;    // size of the structures pointed to by pBitmapUp and pBitmapDown
   L_INT          nToolTipTextID;       // used if uToolTipTextID >= 0
   L_TCHAR * pToolTipText;         // used if uToolTipTextID == -1
} ANNBUTTON, *pANNBUTTON;
#else
typedef ANNBUTTONA ANNBUTTON;
typedef pANNBUTTONA pANNBUTTON;
#endif // #if defined(FOR_UNICODE)

typedef struct _ANNTOOLBARINFO
{
   L_UINT   uStructSize;
   L_UINT   uButtons;
   L_UINT   uRows;
   L_UINT   uColumns;
} ANNTOOLBARINFO, *pANNTOOLBARINFO;

/* 
   width and height of the toolbar bitmaps
*/
#define TOOLBARIMAGECX  (16)
#define TOOLBARIMAGECY  (15)
#define TOOLBARBUTTONCX (24)
#define TOOLBARBUTTONCY (22)


/* 
   width and height of the toolbar buttons
*/
#define TOOLBARIMAGEXP_CX (24)
#define TOOLBARIMAGEXP_CY (24)
#define TOOLBARBUTTONXP_CX (32)
#define TOOLBARBUTTONXP_CY (32)



/*
   messages
*/
#define WM_LTANNEVENT         (WM_USER + 512)
#define WM_LTANNHYPERLINK     (WM_USER + 513)   // message used internally by LEADTOOLS ActiveX
#define WM_LTANNPLAYERNOTIFY  (WM_USER + 514)   // message used internally by LEADTOOLS
#define WM_LTANNCAPTURENOTIFY (WM_USER + 515)   // message used internally by LEADTOOLS
#define WM_LTANNAUTODLGUPDATE (WM_USER + 516)   // message used internally by LEADTOOLS
#define WM_LTANNFIXED         (WM_USER + 517)   // message used internally by LEADTOOLS
#define WM_LTANNRTF           (WM_USER + 518)   // message used internally by LEADTOOLS

#define LTANNFIXEDEVENT_FIXEDINRECT 0
#define LTANNFIXEDEVENT_PUSHFIXED   1
#define LTANNFIXEDEVENT_POPFIXED    2

/*
   wParam = event id
   lParam = specific event data
*/
#define LTANNEVENT_TOOLCHECKED   0
#define LTANNEVENT_TOOLCREATE    1
#define LTANNEVENT_TOOLDESTROY   2
#define LTANNEVENT_ACTIVATE      3
#define LTANNEVENT_DEACTIVATE    4
#define LTANNEVENT_INSERT        5
#define LTANNEVENT_REMOVE        6
#define LTANNEVENT_AUTOBEGINSET  7
#define LTANNEVENT_AUTOENDSET    8
#define LTANNEVENT_AUTOCLICKED   9
#define LTANNEVENT_AUTOCHANGED   10
#define LTANNEVENT_AUTOITEMCHANGED  11
#define LTANNEVENT_AUTOSELECT    12
#define LTANNEVENT_LOCKED        13
#define LTANNEVENT_UNLOCKED      14
#define LTANNEVENT_HYPERLINK     15
#define LTANNEVENT_HYPERLINKMENU 16
#define LTANNEVENT_LBUTTONDOWN   17
#define LTANNEVENT_MOUSEMOVE     18
#define LTANNEVENT_LBUTTONUP     19
#define LTANNEVENT_MENU          20
#define LTANNEVENT_AUTOITEMCHANGING 21
#define LTANNEVENT_RESERVED1        22  // Reserved for internal use
#define LTANNEVENT_RESERVED2        23  // Reserved for internal use
#define LTANNEVENT_RESERVED3        24  // Reserved for internal use
#define LTANNEVENT_RESERVED4        25  // Reserved for internal use
#define LTANNEVENT_RESERVED5        26  // Reserved for internal use
#define LTANNEVENT_HIGHLIGHT        27
#define LTANNEVENT_AUTOACTION       28

/* 
   allowed range for user defined menus
*/
#define LTANNEVENT_MENUFIRST     0x0100
#define LTANNEVENT_MENULAST      0x01FF

#ifndef HANDLE_MSG
#define HANDLE_MSG(hwnd, message, fn)    \
    case (message): return HANDLE_##message((hwnd), (wParam), (lParam), (fn))
#endif

/* LRESULT Cls_OnLtAnnEvent(HWND hwnd, int id, LPARAM lParam); */
#define HANDLE_WM_LTANNEVENT(hwnd, wParam, lParam, fn) \
      (LRESULT)(DWORD)(fn)(hwnd, (int) wParam, lParam)
#define FORWARD_WM_LTANNEVENT(hwnd, id, lParam, fn) \
    (LRESULT)(DWORD)(fn)((hwnd), WM_LTANNEVENT, (int) (id), (LPARAM) (lParam))

#define HANDLE_MM_MCINOTIFY(hwnd, wParam, lParam, fn) \
      (LRESULT)(DWORD)(fn)(hwnd, wParam, lParam)

#define FORWARD_MM_MCINOTIFY(hwnd, id, wParam, lParam, fn) \
    (LRESULT)(DWORD)(fn)((hwnd), MM_MCINOTIFY, (int) (id), (WPARAM)wParam, (LPARAM) (lParam))



/*
   line styles
*/
#define ANNLINE_SOLID         0
#define ANNLINE_DASH          1
#define ANNLINE_DOT           2
#define ANNLINE_DASHDOT       3
#define ANNLINE_DASHDOTDOT    4
#define ANNLINE_NULL          5

/*
   fill patterns
*/
#define ANNPATTERN_SOLID         0
#define ANNPATTERN_BDIAGONAL     1
#define ANNPATTERN_CROSS         2
#define ANNPATTERN_DIAGCROSS     3
#define ANNPATTERN_FDIAGONAL     4
#define ANNPATTERN_HORIZONTAL    5
#define ANNPATTERN_VERTICAL      6

/*
   fill mode
*/
#define ANNMODE_TRANSPARENT   0
#define ANNMODE_TRANSLUCENT   1
#define ANNMODE_OPAQUE        2
#define ANNMODE_ALPHA         3

/*
   poly fill mode
*/
#define ANNPOLYFILL_WINDING   0
#define ANNPOLYFILL_ALTERNATE 1

/*
   define states
*/
#define ANNDEFINE_BEGINSET    0
#define ANNDEFINE_BEGINMOVE   1
#define ANNDEFINE_BEGINROTATE 2
#define ANNDEFINE_BEGINRESIZE 3
#define ANNDEFINE_BEGINSELECT 4
#define ANNDEFINE_APPEND      5
#define ANNDEFINE_UPDATE      6
#define ANNDEFINE_END         7
#define ANNDEFINE_BEGINMOVESELECTED    8
#define ANNDEFINE_BEGINROTATESELECTED  9
#define ANNDEFINE_BEGINRESIZESELECTED  10
#define ANNDEFINE_BEGINMOVEPOINT       11
#define ANNDEFINE_BEGINMOVENAME        12
#define ANNDEFINE_SETANCHORPOINT       13
#define ANNDEFINE_BEGINCOMBINESET      14    // reserved for internal use
#define ANNDEFINE_ENDCOMBINESET        15    // reserved for internal use
#define ANNDEFINE_UPDATECOMBINE        16    // reserved for internal use
#define ANNDEFINE_ENDCOMBINE           17    // reserved for internal use

#define ANNDEFINE_BEGINMOVEROTATECENTER 18   // reserved for internal use

#define ANNDEFINE_NOHILIGHT            0x100 // reserved for internal use


/*
   active states
*/
#define ANNACTIVE_DISABLED    0
#define ANNACTIVE_ENABLED     1

/*
   object handle
*/
#if !defined(HANNOBJECT_DEFINED)
   #define HANNOBJECT_DEFINED
   typedef HANDLE HANNOBJECT;
   typedef HANNOBJECT *pHANNOBJECT;
#endif // #if !defined(HANNOBJECT_DEFINED)

/*
   hittest results
*/
#define ANNHIT_NONE           0
#define ANNHIT_BODY           1
#define ANNHIT_HANDLE         2
#define ANNHIT_NAME           3
#define ANNHIT_USER_HANDLE    4
#define ANNHIT_ROTATE_HANDLE  5
#define ANNHIT_MULTISELECT_HANDLE 6
#define ANNHIT_MULTISELECT_ROTATE_HANDLE 7
#define ANNHIT_MULTISELECT_BODY 8

#define ROTATE_HANDLE_CENTER_ID  100
#define ROTATE_HANDLE_GRIPPER_ID 101


typedef struct tagANNHITTESTINFO
{
  L_UINT uStructSize;  //size of this structure
  L_INT  nHandleIndex;
  L_INT  nHandleID;
  L_INT  nReserved;
} *pANNHITTESTINFO, ANNHITTESTINFO;


/*
   user modes
*/
#define ANNUSER_DESIGN        0
#define ANNUSER_RUN           1

#define ANN_SNAPTOGRID_OFF  0
#define ANN_SNAPTOGRID_ON   1

/*
   flags for set functions
*/
#define ANNFLAG_SELECTED       0x0001
#define ANNFLAG_NOTCONTAINER   0x0002
#define ANNFLAG_NOTTHIS        0x0004
#define ANNFLAG_RECURSE        0x0008
#define ANNFLAG_NOINVALIDATE   0x0010
#define ANNFLAG_CHECKMENU      0x0020
#define ANNFLAG_USER           0x0040

/*
   toolbar create alignment
*/
#define ANNTOOLALIGN_LEFT     0x0000
#define ANNTOOLALIGN_RIGHT    0x0001
#define ANNTOOLALIGN_TOP      0x0000
#define ANNTOOLALIGN_BOTTOM   0x0002

/*
   ROP2 values
*/
#define ANNROP2_COPY          0
#define ANNROP2_AND           1
#define ANNROP2_XOR           2

/*
   Hyperlink types
*/
#define ANNLINK_NONE          0
#define ANNLINK_LTANNEVENT    1
#define ANNLINK_USERMSG       2
#define ANNLINK_RUN           3
#define ANNLINK_WEBPAGE       4

/*
   Distance units
*/
#define ANNUNIT_INCHES        0
#define ANNUNIT_FEET          1
#define ANNUNIT_YARDS         2
#define ANNUNIT_MICROMETERS   3
#define ANNUNIT_MILLIMETERS   4
#define ANNUNIT_CENTIMETERS   5
#define ANNUNIT_METERS        6
#define ANNUNIT_TWIPS         7
#define ANNUNIT_POINTS        8
#define ANNUNIT_PIXELS        9
#define ANNUNIT_SMART_METRIC  10
#define ANNUNIT_SMART_ENGLISH 11
#define ANNUNIT_DISPLAY       12
#define ANNUNIT_DOCUMENT      13

/*
   Angle units
*/
#define ANNANGLE_DEGREES      0
#define ANNANGLE_RADIANS      1

/* 
   Metafile types 
*/

enum
{
   ANNMETAFILE_SECONDARY = 0x7FFE,
   ANNMETAFILE_USER = 0x7FFF,    // user-defined metafiles
   ANNMETAFILE_APPROVED = 0,     // predefined metafiles
   ANNMETAFILE_ASSIGNED,
   ANNMETAFILE_CHECKED,
   ANNMETAFILE_CLATPRV,
   ANNMETAFILE_COPY,
   ANNMETAFILE_DRAFT,
   ANNMETAFILE_EXTENDED,
   ANNMETAFILE_FAX,
   ANNMETAFILE_FAXED,
   ANNMETAFILE_IMPORTANT,
   ANNMETAFILE_INVOICE,
   ANNMETAFILE_NOTICE,
   ANNMETAFILE_OFFICIAL,
   ANNMETAFILE_ONFILE,
   ANNMETAFILE_PAID,
   ANNMETAFILE_PASSED,
   ANNMETAFILE_PENDING,
   ANNMETAFILE_PROCESSED,
   ANNMETAFILE_RECEIVED,
   ANNMETAFILE_REJECTED,
   ANNMETAFILE_RELEASE,
   ANNMETAFILE_SENT,
   ANNMETAFILE_SHIPPED,
   ANNMETAFILE_TOPSECRET,
   ANNMETAFILE_URGENT,
   ANNMETAFILE_VOID,
   ANNMETAFILE_HOTSPOT,     
   ANNMETAFILE_ENCRYPTOR,
   ANNMETAFILE_DECRYPTOR,

   ANNMETAFILE_LAST,             // last predefined metafile
};


/* 
   Bitmap types 
*/

enum
{
   ANNBITMAP_POINT = 0,     // predefined bitmap
};



// L_AnnSetRenderMode flags
#define ANNRENDER_DESIGN   0  // Reserved for internal use
#define ANNRENDER_RUN      1  // Reserved for internal use
#define ANNRENDER_DEFAULT  2  // Reserved for internal use

/*
   Show flags
*/

#define ANNSHOW_LENGTH     0x0001
#define ANNSHOW_GAUGE      0x0002
#define ANNSHOW_TICMARKS   0x0004

/*
   Calibrate Flags
*/
#define ANNCALIBRATE_THIS        0x0001
#define ANNCALIBRATE_EXISTING    0x0002
#define ANNCALIBRATE_NEW         0x0004


/*
   structure passed to the mouse notifications
*/

typedef struct _ANNMOUSEPOS
{
   L_BOOL   fDoubleClick;  /* valid only for LTANNEVENT_LBUTTONDOWN */
   POINT    pt;
   L_UINT   uKeyFlags;
   L_BOOL   fUpdatePos;    /* if TRUE, the mouse cursor is updated */
} ANNMOUSEPOS, *pANNMOUSEPOS;

/*
   automation option flags
*/

#define ANNAUTO_TABBEDDIALOG      0x0001   /* display tabbed dialog boxes */
#define ANNAUTO_REVERSEEDITKEYS   0x0002   /* CTRL+ENTER exits edit box, ENTER creates new line */


typedef struct _ANNXFORM {
   L_DOUBLE r11;
   L_DOUBLE r12;
   L_DOUBLE r21;
   L_DOUBLE r22;
   L_DOUBLE tx;
   L_DOUBLE ty;
} ANNXFORM, *pANNXFORM;

/* 
   defines and structures that describe parameter for LTANNEVENT_AUTOCHANGING notification event
*/


typedef enum{
      ANNTYPE_NONE            = 0,
      ANNTYPE_COLORREF        = 1,
      ANNTYPE_UINT32          = 2,
      ANNTYPE_BOOL            = 3,
      ANNTYPE_DOUBLE          = 4,
      ANNTYPE_UINT            = 5,
      ANNTYPE_LPCSTR          = 6,
      ANNTYPE_ANNPOINT        = 7,
      ANNTYPE_BITMAP          = 8,
      ANNTYPE_HMETAFILE       = 9,
      ANNTYPE_HYPERLINK       = 10,
      ANNTYPE_RULER_UNIT      = 11,
      ANNTYPE_PROTRACTOR      = 12,
      ANNTYPE_MOVE            = 13,
      ANNTYPE_MOVE_POINT      = 14,
      ANNTYPE_RESIZE_ROTATE   = 15,
      ANNTYPE_HANNOBJECT      = 16,
      ANNTYPE_FIXED           = 17,

} ANNTYPE, *pANNTYPE;

#define SUCCESS_CHANGE     1  // change the object
#define SUCCESS_NOCHANGE   2  // do not change the object

typedef enum tagANNCHANGETYPE
{
   ANNCHANGE_TAG                       =   1,   // tag                           L_AnnSetTag                        
   ANNCHANGE_VISIBLE                   =   2,   // visible                       L_AnnSetVisible                  
   ANNCHANGE_SELECTED                  =   3,   // selected                      L_AnnSetSelected                 
   ANNCHANGE_FONT_BOLD                 =   4,   // font bold                     L_AnnSetFontBold                
   ANNCHANGE_FONT_ITALIC               =   5,   // font italic                   L_AnnSetFontItalic              
   ANNCHANGE_FONT_STRIKETHROUGH        =   6,   // font strike-through           L_AnnSetFontStrikeThrough       
   ANNCHANGE_FONT_UNDERLINE            =   7,   // font underline                L_AnnSetFontUnderline           
   ANNCHANGE_LINEWIDTH                 =   8,   // line width                    L_AnnSetLineWidth                  
   ANNCHANGE_LINESTYLE                 =   9,   // line style                    L_AnnSetLineStyle
   ANNCHANGE_FILLPATTERN               =  10,   // fill pattern                  L_AnnSetFillPattern
   ANNCHANGE_FILLMODE                  =  11,   // fill mode                     L_AnnSetFillMode
   ANNCHANGE_POLYFILLMODE              =  12,   // poly fill mode                L_AnnSetPolyFillMode
   ANNCHANGE_FONT_SIZE                 =  13,   // font size                     L_AnnSetFontSize
   ANNCHANGE_FORECOLOR                 =  14,   // foreground color              L_AnnSetForeColor
   ANNCHANGE_BACKCOLOR                 =  15,   // background color              L_AnnSetBackColor
   ANNCHANGE_TRANSPARENT_COLOR         =  16,   // transparent color             L_AnnSetTransparentColor
   ANNCHANGE_TRANSPARENT               =  17,   // transparent                   L_AnnSetTransparent
   ANNCHANGE_FONT_NAME                 =  18,   // font name                     L_AnnSetFontName
   ANNCHANGE_TEXT                      =  19,   // text                          L_AnnSetText 
   ANNCHANGE_ROP2                      =  20,   // ROP2 code                     L_AnnSetROP2
   ANNCHANGE_BITMAP                    =  21,   // Bitmap                        L_AnnSetBitmap
   ANNCHANGE_BITMAP2                   =  22,   // Secondary bitmap              L_AnnSetSecondaryBitmap
   ANNCHANGE_METAFILE                  =  23,   // Metafile                      L_AnnSetMetafile
   ANNCHANGE_METAFILE2                 =  24,   // Decrypt metafile              L_AnnSetMetafile
   //
   ANNCHANGE_NAME_FORECOLOR            =  30,   // Name foreground color         L_AnnSetNameOptions
   ANNCHANGE_NAME_BACKCOLOR            =  31,   // Name background color         L_AnnSetNameOptions
   ANNCHANGE_NAME_SHOWNAME             =  32,   // Name--show name               L_AnnSetNameOptions
   ANNCHANGE_NAME_OFFSET               =  33,   // Name offset                   L_AnnSetNameOptions
   ANNCHANGE_NAME_RESTRICT             =  34,   // Name restrict                 L_AnnSetNameOptions
   ANNCHANGE_NAME_BACKTRANSPARENT      =  35,   // Name background transparent   L_AnnSetNameOptions   
   ANNCHANGE_NAME_TEXT                 =  36,   // Name text                     L_AnnSetNameOptions
   ANNCHANGE_NAME_FONT_NAME            =  37,   // Name--font name               L_AnnSetNameOptions
   ANNCHANGE_NAME_FONT_BOLD            =  38,   // Name--font bold               L_AnnSetNameOptions
   ANNCHANGE_NAME_FONT_ITALIC          =  39,   // Name--font italic             L_AnnSetNameOptions
   ANNCHANGE_NAME_FONT_STRIKEOUT       =  40,   // Name--font strikethrough      L_AnnSetNameOptions
   ANNCHANGE_NAME_FONT_UNDERLINE       =  41,   // Name--font underline          L_AnnSetNameOptions
   ANNCHANGE_NAME_FONT_SIZE            =  42,   // Name--font size               L_AnnSetNameOptions
   //
   ANNCHANGE_POINT_USE_BITMAP          =  50,   // Point--use bitmap             L_AnnSetPointOptions
   ANNCHANGE_POINT_RADIUS              =  51,   // Point--radius in pixels       L_AnnSetPointOptions
   ANNCHANGE_POINT_BORDER_COLOR        =  52,   // Point--border color           L_AnnSetPointOptions
   ANNCHANGE_POINT_FILL_COLOR          =  53,   // Point--fill color             L_AnnSetPointOptions
   ANNCHANGE_POINT_TRANSPARENT_FILL    =  54,   // Point--transparent fill       L_AnnSetPointOptions
   ANNCHANGE_POINT_FIXED_SIZE          =  55,   // Point--fixed size             L_AnnSetPointOptions
   //
   ANNCHANGE_SHOW_DEFAULT_HANDLES      =  60,   // Show default handles          L_AnnSetNodes
   ANNCHANGE_GAP_DEFAULT_HANDLES       =  61,   // Handle gap                    L_AnnSetNodes
   ANNCHANGE_HYPERLINK                 =  62,   // Hyperlink options             L_AnnSetHyperlink

   // Ruler changes
   ANNCHANGE_GAUGELENGTH               =  70,   // Gauge length                  L_AnnSetGaugeLength
   ANNCHANGE_TICMARKLENGTH             =  71,   // TicMark Length                L_AnnSetTicMarkLength
   ANNCHANGE_BITMAP_DPI_X              =  72,   // Bitmap DPI -- horizontal      L_AnnSetBitmapDpiX
   ANNCHANGE_BITMAP_DPI_Y              =  73,   // Bitmap DPI -- vertical        L_AnnSetBitmapDpiY
   ANNCHANGE_RULER_UNIT                =  74,   // Ruler unit, abbreviation, precision  L_AnnSetUnit
   ANNCHANGE_RULER_SHOW_FLAGS          =  75,   // Ruler show flags              L_AnnSetShowFlags
   ANNCHANGE_PROTRACTOR                =  76,   // Protractor options            L_AnnSetProtractorOptions

   ANNCHANGE_ENCRYPTOR_TYPE            =  80,   // Encryptor type                L_AnnSetEncryptOptions
   ANNCHANGE_ENCRYPTOR_KEY             =  81,   // Encryptor key                 L_AnnSetEncryptOptions
   ANNCHANGE_ENCRYPTOR_NEVER_ENCRYPTED =  82,   // Indicates if never encrypted  L_AnnSetEncryptOptions
   ANNCHANGE_ENCRYPTOR_BITMAP          =  83,   // Bitmap to be encrypted        L_AnnSetEncryptOptions
   ANNCHANGE_ENCRYPTOR_SAVE_ENCRYPTOR_KEY=  84,   // Save Encryptor Key            L_AnnSetEncryptOptions
   ANNCHANGE_DECRYPTOR_SAVE_DECRYPTOR_KEY=  85,   // Save Decryptor Key            L_AnnSetEncryptOptions
   ///
   ANNCHANGE_MOVE                      =  90,   // Object is moving              
   ANNCHANGE_MOVE_POINT                =  91,   // Point on object is moving
   ANNCHANGE_RESIZE                    =  92,   // Object resized
   ANNCHANGE_ROTATE                    =  93,   // Object rotated
   ANNCHANGE_RESIZE_ROTATE             =  94,   // Object is being resized and rotated
   //
   ANNCHANGE_UNDO                      = 100,   // Annotation undo               L_AnnUndo
   ANNCHANGE_CUT                       = 101,   // Annotation cut to clipboard   L_AnnCutToClipboard
   ANNCHANGE_PASTE                     = 102,   // Annotation paste              L_AnnCopyFromClipboard
   ANNCHANGE_DELETE                    = 103,   // Object being deleted          L_AnnDestroy
   ANNCHANGE_SELECT_ALL                = 104,   // All objects being selected
   ANNCHANGE_BRING_TO_FRONT            = 105,   // Menu: Bring To Front --Bring selected object to front of Z-order
   ANNCHANGE_BRING_TO_BACK             = 106,   // Menu: Bring To Back -- Bring selected object to back of Z-Order
   ANNCHANGE_LOCK                      = 107,   // Lock one object               L_AnnLock
   ANNCHANGE_UNLOCK                    = 108,   // Unlock one object             L_AnnUnlock
   ANNCHANGE_LOCK_SELECTED             = 109,   // Menu: Lock selected objects
   ANNCHANGE_UNLOCK_SELECTED           = 110,   // Menu: Unlock selected objects
   ANNCHANGE_INSERT                    = 111,   // Insert object into container  L_AnnInsert
   ANNCHANGE_NOTE_BACKCOLOR            = 112,   // Menu: Default Properties->Note Background Color
   ANNCHANGE_HILITE_BACKCOLOR          = 113,   // Menu: Default Properties->Hilite Background Color
   ANNCHANGE_REDACT_BACKCOLOR          = 114,   // Menu: Default Properties->Redact Background Color
   ANNCHANGE_ENCRYPT_METAFILE          = 115,   // Menu: Default Properties->Encrypt Metafile
   ANNCHANGE_DECRYPT_METAFILE          = 116,   // Menu: Default Properties->Decrypt Metafile
   ANNCHANGE_HOTSPOT_METAFILE          = 117,   // Menu: Default Properties->Hotspot Metafile

   ANNCHANGE_TEXT_ALIGN                = 118,   // L_AnnSetTextAlign
   ANNCHANGE_TEXT_ROTATE               = 119,   // L_AnnSetTextRotate
   ANNCHANGE_TEXPOINTER_FIXED          = 120,   // L_AnnSetTextPointerFixed
   ANNCHANGE_TEXT_EXPANDTOKENS         = 121,   // L_AnnSetTextExpandTokens
   ANNCHANGE_FIXED                     = 122,   // L_AnnSetFixed
   ANNCHANGE_MOVE_SELECTED             = 123,   // Fired when moving 1 or more selected objects
   ANNCHANGE_RESIZE_SELECTED           = 124,   // Fired when resizing 1 or more selected objects
   ANNCHANGE_ROTATE_SELECTED           = 125,   // Fired when rotating 1 or more selected objects
   ANNCHANGE_CONTAINER_RECURSE         = 126,   // Fired when applying a change recursively to a container (i.e. change forecolor)

   ANNCHANGE_LAST,


} ANNCHANGETYPE, *pANNCHANGETYPE;

typedef struct tagANNFIXED
{
   L_UINT uStructSize;
   L_BOOL bFixed;
   L_BOOL bAdjust;
} ANNFIXED, *pANNFIXED;

typedef struct tagANNRULERUNITA
{
   L_UINT uStructSize;
   L_UINT uUnit;           // unit of measure 
   L_CHAR *pAbbrev; // Address of the character string containing the unit abbreviation string 
   L_UINT uPrecision;  
} ANNRULERUNITA, *pANNRULERUNITA;

#if defined(FOR_UNICODE)
typedef struct tagANNRULERUNIT
{
   L_UINT uStructSize;
   L_UINT uUnit;           // unit of measure 
   L_TCHAR *pAbbrev; // Address of the character string containing the unit abbreviation string 
   L_UINT uPrecision;  
} ANNRULERUNIT, *pANNRULERUNIT;
#else
typedef ANNRULERUNITA ANNRULERUNIT;
typedef pANNRULERUNITA pANNRULERUNIT;
#endif // #if defined(FOR_UNICODE)

typedef struct tagANNHYPERLINKA
{
   L_UINT      uStructSize;
   L_UINT      uLinkMsg;
   L_SIZE_T    uLinkParam;
   L_CHAR    *pLinkText;
   L_UINT      uLinkType;
} ANNHYPERLINKA, *pANNHYPERLINKA;

#if defined(FOR_UNICODE)
typedef struct tagANNHYPERLINK
{
   L_UINT      uStructSize;
   L_UINT      uLinkMsg;
   L_SIZE_T    uLinkParam;
   L_TCHAR    *pLinkText;
   L_UINT      uLinkType;
} ANNHYPERLINK, *pANNHYPERLINK;
#else
typedef ANNHYPERLINKA ANNHYPERLINK;
typedef pANNHYPERLINKA pANNHYPERLINK;
#endif // #if defined(FOR_UNICODE)

typedef struct tagANNPROTRACTORA
{
   L_UINT      uStructSize;
   L_BOOL      bAcute;
   L_UINT      uAngleUnit;
   L_UINT      uAnglePrecision;
   L_DOUBLE    dArcRadius;
   L_CHAR    *pszAbbrev;
} ANNPROTRACTORA, *pANNPROTRACTORA;

#if defined(FOR_UNICODE)
typedef struct tagANNPROTRACTOR
{
   L_UINT      uStructSize;
   L_BOOL      bAcute;
   L_UINT      uAngleUnit;
   L_UINT      uAnglePrecision;
   L_DOUBLE    dArcRadius;
   L_TCHAR    *pszAbbrev;
} ANNPROTRACTOR, *pANNPROTRACTOR;
#else
typedef ANNPROTRACTORA ANNPROTRACTOR;
typedef pANNPROTRACTORA pANNPROTRACTOR;
#endif // #if defined(FOR_UNICODE)

#define STATE_BEGIN  (1)
#define STATE_UPDATE (2)
#define STATE_END    (3)
typedef struct tagANNMOVE
{
   L_UINT      uStructSize;
   L_INT       nState;
   POINT       pt;
} ANNMOVE, *pANNMOVE;

typedef struct tagANNMOVEPOINT
{
   L_UINT      uStructSize;
   L_INT       nState;
   POINT       pt;
   L_UINT      uIndex;
   ANNPOINT    apt;
} ANNMOVEPOINT, *pANNMOVEPOINT;

typedef struct tagANNRESIZEROTATE
{
   L_UINT      uStructSize;
   L_INT       nState;
   pANNXFORM   pAnnXForm;
   L_DOUBLE    dAngle;
} ANNRESIZEROTATE, *pANNRESIZEROTATE;

#define ANNCHANGE_FLAG_UNDO              (0x001)
#define ANNCHANGE_FLAG_CUT               (0x002)
#define ANNCHANGE_FLAG_PASTE             (0x008)
#define ANNCHANGE_FLAG_SELECT_ALL        (0x010)
#define ANNCHANGE_FLAG_LOCK_SELECTED     (0x020)
#define ANNCHANGE_FLAG_UNLOCK_SELECTED   (0x040)
#define ANNCHANGE_FLAG_MOVE_SELECTED     (0x080)
#define ANNCHANGE_FLAG_RESIZE_SELECTED   (0x100)
#define ANNCHANGE_FLAG_ROTATE_SELECTED   (0x200)
#define ANNCHANGE_FLAG_CONTAINER_RECURSE (0x400)
//#define ANNCHANGE_FLAG_INSERT     

typedef struct tagANNCHANGEPARAMA
{
   L_UINT         uStructSize;            // size of this structure
   HANNOBJECT     hObject;          // object being changed.
   ANNCHANGETYPE  uChange;          // the type of change being performed
   L_INT          nChange;          // set to SUCCESS_CHANGE to allow the modification, set to SUCCESS_NO_CHANGE cancel the change
   L_UINT         uUnionType;       // field in the union that contains the value
   L_BOOL         bAfter;           // FALSE--fired before the change
                                    // TRUE --fired after the change
   L_UINT         uFlags;           // Indicate if change is part of Undo, Cut, Copy, Paste, Create, Delete
   union 
   {
      L_DOUBLE          dDouble;           // valid if the object is being rotated
      COLORREF          crColor;
      L_BOOL            bBool;
      L_UINT32          uUint32;
      L_UINT            uUint;
      L_CHAR *          pszString;
      ANNPOINT          apt;
      pBITMAPHANDLE     pBitmapHandle;
      HMETAFILE         hMetafile;
      HANNOBJECT        hObject;
      ANNHYPERLINKA     AnnHyperlink;
      ANNRULERUNITA     AnnRulerUnit;
      ANNPROTRACTORA    AnnProtractor;
      ANNMOVE           AnnMove;
      ANNMOVEPOINT      AnnMovePoint;
      ANNRESIZEROTATE   AnnResizeRotate;
      ANNFIXED          AnnFixed;
   }u;
} ANNCHANGEPARAMA, *pANNCHANGEPARAMA;

#if defined(FOR_UNICODE)
typedef struct tagANNCHANGEPARAM
{
   L_UINT         uStructSize;            // size of this structure
   HANNOBJECT     hObject;          // object being changed.
   ANNCHANGETYPE  uChange;          // the type of change being performed
   L_INT          nChange;          // set to SUCCESS_CHANGE to allow the modification, set to SUCCESS_NO_CHANGE cancel the change
   L_UINT         uUnionType;       // field in the union that contains the value
   L_BOOL         bAfter;           // FALSE--fired before the change
                                    // TRUE --fired after the change
   L_UINT         uFlags;           // Indicate if change is part of Undo, Cut, Copy, Paste, Create, Delete
   union 
   {
      L_DOUBLE          dDouble;           // valid if the object is being rotated
      COLORREF          crColor;
      L_BOOL            bBool;
      L_UINT32          uUint32;
      L_UINT            uUint;
      L_TCHAR *    pszString;
      ANNPOINT          apt;
      pBITMAPHANDLE     pBitmapHandle;
      HMETAFILE         hMetafile;
      HANNOBJECT        hObject;
      ANNHYPERLINK      AnnHyperlink;
      ANNRULERUNIT      AnnRulerUnit;
      ANNPROTRACTOR     AnnProtractor;
      ANNMOVE           AnnMove;
      ANNMOVEPOINT      AnnMovePoint;
      ANNRESIZEROTATE   AnnResizeRotate;
      ANNFIXED          AnnFixed;
   }u;
   
} ANNCHANGEPARAM, *pANNCHANGEPARAM;
#else
typedef ANNCHANGEPARAMA ANNCHANGEPARAM;
typedef pANNCHANGEPARAMA pANNCHANGEPARAM;
#endif // #if defined(FOR_UNICODE)

typedef struct tagANNHILIGHT
{
   L_UINT      uStructSize;         // size of this structure
   HANNOBJECT  hObject;             // object being hilighted
   L_BOOL      bRemoveHilight;      // TRUE if removing previous hilight
   L_UINT      uCount;              // number of points
   LPPOINT     ppts;                // pointer to array of points
   HWND        hWnd;                // window handle to send message
   L_INT       nReserved;           // Reserved for future use
} ANNHILIGHT, *pANNHILIGHT;


typedef struct tagANNFILEINFO
{
   L_UINT      uStructSize;         // size of this structure
   L_SSIZE_T   nOffset;
   L_INT32     nVersion;
   L_UINT      uFormat;          //ANNFMT_NATIVE,ANNFMT_WMF	,ANNFMT_ENCODED   
   L_INT32     nTotalPages;
   L_INT32     nReserved;
} ANNFILEINFO, *pANNFILEINFO;

typedef struct tagANNFONTA
{
   L_UINT      uStructSize;         // size of this structure
   L_CHAR      szFontName[LF_FACESIZE];
   L_BOOL      bFontBold;
   L_BOOL      bFontItalic;
   L_BOOL      bFontStrikeOut;
   L_BOOL      bFontUnderline;
   L_DOUBLE    dFontSize;
   DWORD       dwReserved;
} ANNFONTA, *pANNFONTA;

#if defined(FOR_UNICODE)
typedef struct tagANNFONT
{
   L_UINT      uStructSize;         // size of this structure
   L_TCHAR     szFontName[LF_FACESIZE];
   L_BOOL      bFontBold;
   L_BOOL      bFontItalic;
   L_BOOL      bFontStrikeOut;
   L_BOOL      bFontUnderline;
   L_DOUBLE    dFontSize;
   DWORD       dwReserved;
} ANNFONT, *pANNFONT;
#else
typedef ANNFONTA ANNFONT;
typedef pANNFONTA pANNFONT;
#endif // #if defined(FOR_UNICODE)

typedef struct tagANNNAMEOPTIONSA
{
   L_UINT      uStructSize;         // size of this structure
   L_UINT      uFlags;
   L_BOOL      bShowName;             // TRUE if you want to show the annotation name
   L_CHAR     *pszName;              // the annotation name
   L_SIZE_T    uNameLen;
   ANNPOINT    ptNameOffset;          // Offset of name
   L_BOOL      bNameRestrict;         // TRUE--restrict name to container,  FALSE--Name can go outside container
   COLORREF    crNameFore;
   COLORREF    crNameBack;
   ANNFONTA    NameFont;
   L_BOOL      bNameBackTransparent;
   L_INT32     nReserved;
} ANNNAMEOPTIONSA, *pANNNAMEOPTIONSA;

#if defined(FOR_UNICODE)
typedef struct tagANNNAMEOPTIONS
{
   L_UINT      uStructSize;         // size of this structure
   L_UINT      uFlags;
   L_BOOL      bShowName;             // TRUE if you want to show the annotation name
   L_TCHAR     *pszName;              // the annotation name
   L_SIZE_T    uNameLen;
   ANNPOINT    ptNameOffset;          // Offset of name
   L_BOOL      bNameRestrict;         // TRUE--restrict name to container,  FALSE--Name can go outside container
   COLORREF    crNameFore;
   COLORREF    crNameBack;
   ANNFONT     NameFont;
   L_BOOL      bNameBackTransparent;
   L_INT32     nReserved;
} ANNNAMEOPTIONS, *pANNNAMEOPTIONS;
#else
typedef ANNNAMEOPTIONSA ANNNAMEOPTIONS;
typedef pANNNAMEOPTIONSA pANNNAMEOPTIONS;
#endif // #if defined(FOR_UNICODE)


#define ANNNAME_SHOW_NAME                 0x0001
#define ANNNAME_NAME                      0x0002
#define ANNNAME_NAME_LENGTH               0x0004
#define ANNNAME_OFFSET                    0x0008
#define ANNNAME_RESTRICT                  0x0010
#define ANNNAME_FORECOLOR                 0x0020
#define ANNNAME_BACKCOLOR                 0x0040
#define ANNNAME_BACK_TRANSPARENT          0x0080
#define ANNNAME_FONT_BOLD                 0x0100
#define ANNNAME_FONT_ITALIC               0x0200
#define ANNNAME_FONT_STRIKEOUT            0x0400
#define ANNNAME_FONT_UNDERLINE            0x0800
#define ANNNAME_FONT_NAME                 0x1000
#define ANNNAME_FONT_SIZE                 0x2000             

#define ANNNAME_FONT_INFO                 (ANNNAME_FONT_BOLD | ANNNAME_FONT_ITALIC |  ANNNAME_FONT_STRIKEOUT | ANNNAME_FONT_UNDERLINE | ANNNAME_FONT_SIZE | ANNNAME_FONT_NAME)           
#define ANNNAME_ALL                       (ANNNAME_SHOW_NAME | ANNNAME_NAME | ANNNAME_NAME_LENGTH | ANNNAME_OFFSET | ANNNAME_RESTRICT | ANNNAME_FORECOLOR | ANNNAME_BACKCOLOR | ANNNAME_BACK_TRANSPARENT | ANNNAME_FONT_INFO)



typedef struct tagANNTEXTOPTIONS
{
   L_UINT      uStructSize;         // size of this structure
   L_UINT      uFlags;
   L_BOOL      bShowText;             // TRUE if you want to show the annotation name
   L_BOOL      bShowBorder;             // TRUE if you want to show the annotation name
   COLORREF    crText;
   L_INT32     nReserved;
} ANNTEXTOPTIONS, *pANNTEXTOPTIONS;

#define ANNTEXT_SHOW_TEXT              0x001
#define ANNTEXT_SHOW_BORDER            0x002
#define ANNTEXT_TEXTCOLOR              0x004
#define ANNTEXT_TEXTBACKCOLOR          0x008
#define ANNTEXT_RTF                    0x010
#define ANNTEXT_ALL                    (ANNTEXT_SHOW_TEXT | ANNTEXT_SHOW_BORDER | ANNTEXT_TEXTCOLOR)


typedef struct tagANNPOINTEROPTIONS
{
   L_UINT      uStructSize;         // size of this structure
   L_UINT      uFlags;
   L_INT       nPointerHeadM;             
   L_INT       nPointerHeadB;             
   L_INT32     nReserved;
} ANNPOINTEROPTIONS, *pANNPOINTEROPTIONS;

#define ANNPOINTER_HEAD                0x001
#define ANNPOINTER_ALL                 0x001

#define ANNENCRYPT_TYPE                0x001
#define ANNENCRYPT_KEY                 0x002
#define ANNENCRYPT_RESERVED1           0x004
#define ANNENCRYPT_NEVER_ENCRYPTED     0x008
#define ANNENCRYPT_ENCRYPT_BITMAP      0x010
#define ANNENCRYPT_SAVE_ENCRYPTOR_KEY  0x020 // Get or set the bSaveEncryptorKey field
#define ANNENCRYPT_SAVE_DECRYPTOR_KEY  0x040 // Get or set the bSaveDecryptorKey field
#define ANNENCRYPT_CLEAR_ENCRYPTOR_KEY 0x080 // Get or set the bClearEncryptorKey field
#define ANNENCRYPT_CLEAR_DECRYPTOR_KEY 0x100 // Get or set the bClearDecryptorKey field
#define ANNENCRYPT_VIEWPERSPECTIVE     0x200 // Reserved for internal use
#define ANNENCRYPT_ALL                 0x3FF // Get or set all fields
typedef struct tagANNENCRYPTOPTIONS
{
   L_UINT      uStructSize;         // size of this structure
   L_UINT      uFlags;                 //Identifies which fields to set/get
   L_BOOL      bEncryptor;
   L_UINT32    uKey;
   L_BOOL      bNeverEncrypted;        // TRUE if a decryptor that has never been encrypted
   pBITMAPHANDLE pEncryptBitmap;       // 
   L_BOOL      bSaveEncryptorKey;      // Save the key when L_AnnSave
   L_BOOL      bSaveDecryptorKey;
   L_BOOL      bClearEncryptorKey;     // After L_AnnEncryptApply, clear encryptor key 
   L_BOOL      bClearDecryptorKey;     // After L_AnnEncryptApply, clear decryptor key 
   L_UINT      uBitmapStructSize;      // size of the pEncryptBitmap structure
   L_INT32     nReserved;
} ANNENCRYPTOPTIONS, *pANNENCRYPTOPTIONS;


// L_AnnEncryptApply flags
#define ANNENCRYPTAPPLY_ENCRYPTOR 0x001
#define ANNENCRYPTAPPLY_DECRYPTOR 0x002
#define ANNENCRYPTAPPLY_BOTH      (ANNENCRYPTAPPLY_ENCRYPTOR | ANNENCRYPTAPPLY_DECRYPTOR)


typedef struct tagANNPOINTOPTIONS
{
   L_UINT         uStructSize;
   L_UINT         uFlags;                 //Identifies which fields to set/get
   L_BOOL         bPointUseBitmap;
   pBITMAPHANDLE  pPointBitmap;
   L_UINT         uBitmapStructSize;
   L_BOOL         bPointBitmapTransparent;
   COLORREF       crPointBitmapTransparentColor;
   L_INT32        nPointRadius;
   COLORREF       crPointBorderColor;
   L_BOOL         bPointTransparentFill;
   COLORREF       crPointFillColor;
   L_BOOL         bPointFixedSize;
   L_INT32        nReserved;
} ANNPOINTOPTIONS, *pANNPOINTOPTIONS;

typedef struct tagANNSNAPTOGRIDOPTIONS
{
   L_UINT      uStructSize;         // size of this structure
   L_UINT      uFlags;
   COLORREF    crGridColor;
   L_UINT      uGridLength;
   L_UINT      uLineSpacing;
   L_UINT      uLineStyle;
   L_BOOL      bEnableSnap;
   L_BOOL      bShowGrid;
   L_BOOL      bAutoChangeGridLength;
   L_INT32     nReserved;
} ANNSNAPTOGRIDOPTIONS, *pANNSNAPTOGRIDOPTIONS;

#define ANNSNAPTOGRID_GRID_COLOR                   0x001
#define ANNSNAPTOGRID_GRID_LENGTH                  0x002
#define ANNSNAPTOGRID_LINE_SPACING                 0x004
#define ANNSNAPTOGRID_LINE_STYLE                   0x008
#define ANNSNAPTOGRID_ENABLE_SNAP                  0x010                 
#define ANNSNAPTOGRID_SHOW_GRID                    0x020              
#define ANNSNAPTOGRID_AUTO_CHANGE_GRID_LENGTH      0x040     
#define ANNSNAPTOGRID_ALL                          (ANNSNAPTOGRID_GRID_COLOR | ANNSNAPTOGRID_GRID_LENGTH | ANNSNAPTOGRID_LINE_SPACING | ANNSNAPTOGRID_LINE_STYLE | ANNSNAPTOGRID_ENABLE_SNAP | ANNSNAPTOGRID_SHOW_GRID | ANNSNAPTOGRID_AUTO_CHANGE_GRID_LENGTH)

#define ANNHANDLE_ID                      0x0001
#define ANNHANDLE_LOCATION                0x0002   
#define ANNHANDLE_CONTAINER_COORDINATES   0x0004   
#define ANNHANDLE_VISIBLE                 0x0008 
#define ANNHANDLE_PEN_COLOR               0x0010
#define ANNHANDLE_FILL_COLOR              0x0020
#define ANNHANDLE_SHAPE                   0x0040    

#define ANNHANDLE_ALL                     0x007f             
                      
      

#define ANNHANDLE_SHAPE_SQUARE            0x001
#define ANNHANDLE_SHAPE_CIRCLE            0x002
#define ANNHANDLE_SHAPE_CROSS             0x004
#define ANNHANDLE_SHAPE_SQUARE_CROSS      0x005
#define ANNHANDLE_SHAPE_CIRCLE_CROSS      0x006

// Structure used to add/delete a user handle
typedef struct tagANNHANDLE
{
   L_UINT         uStructSize;
   L_INT          nID;
   ANNPOINT       aptContainer;            // Center of handle--container coordinates
   POINT          ptClient;            // Center of handle--client coordinates
   L_BOOL         bVisible;
   COLORREF       crPen;
   COLORREF       crFill;
   L_INT          nShape;
   HCURSOR        hCursor;
   L_UINT         uFlags;              // Support transparency
} ANNHANDLE, *pANNHANDLE;


// Constants for L_AnnAdjustPoint
#define ANNADJUST_HORIZONTAL           (1)
#define ANNADJUST_VERTICAL             (2)
#define ANNADJUST_45_DEGREES_FAVOR_X   (3)
#define ANNADJUST_45_DEGREES_FAVOR_Y   (4)
#define ANNADJUST_RESERVED_1           (5)


#define    ANNPOINT_USE_BITMAP                  0x001
#define    ANNPOINT_BITMAP                      0x002
#define    ANNPOINT_BITMAP_TRANSPARENT          0x004
#define    ANNPOINT_BITMAP_TRANSPARENT_COLOR    0x008

#define    ANNPOINT_RADIUS                      0x010
#define    ANNPOINT_BORDER_COLOR                0x020
#define    ANNPOINT_FILL_COLOR                  0x040
#define    ANNPOINT_TRANSPARENT_FILL            0x080
#define    ANNPOINT_FIXED_SIZE                  0x100
#define    ANNPOINT_ALL                         0x1ff

// Constants for L_AnnSetTextAlign, L_AnnGetTextAlign
typedef enum 
{
   TEXTALIGN_LEFT    = 1,
   TEXTALIGN_CENTER  = 2,
   TEXTALIGN_RIGHT   = 3,
} TEXTALIGN, *pTEXTALIGN;


// Constants for L_AnnSetTextRotate, L_AnnGetTextRotate
typedef enum
{
   TEXTROTATE_0      = 0,
   TEXTROTATE_90     = 90,
   TEXTROTATE_180    = 180,
   TEXTROTATE_270    = 270,
} TEXTROTATE, *pTEXTROTATE;


#define ANNHANDLETYPE_DEFAULT_HANDLE            (ANNHIT_HANDLE)
#define ANNHANDLETYPE_USER_HANDLE               (ANNHIT_USER_HANDLE)
#define ANNHANDLETYPE_ROTATE_HANDLE             (ANNHIT_ROTATE_HANDLE)
#define ANNHANDLETYPE_MULTISELECT_HANDLE        (ANNHIT_MULTISELECT_HANDLE)
#define ANNHANDLETYPE_MULTISELECT_ROTATE_HANDLE (ANNHIT_MULTISELECT_ROTATE_HANDLE)


#define ANNROTATE_SHOW_ROTATE_HANDLES     0x0001
#define ANNROTATE_RESET_ROTATE_HANDLES    0x0002
#define ANNROTATE_ALL                     (ANNROTATE_SHOW_ROTATE_HANDLES | ANNROTATE_RESET_ROTATE_HANDLES)


typedef struct tagANNROTATEOPTIONS
{
   L_UINT   uStructSize;         // sizeof this structure
   L_UINT   uFlags;
   L_BOOL   bShowRotateHandles;  // TRUE (displays rotate handles)  FALSE(hides rotate handles)
   L_INT32  nReserved;        // Must be 0
} ANNROTATEOPTIONS, *pANNROTATEOPTIONS;


// Structure used for information about a handle
typedef struct tagANNHANDLEINFO
{
   L_UINT   uStructSize;
   L_INT    nType;               // user define
   L_INT    nID;
   L_INT    nIndex;
   ANNPOINT ptLocationContainer;
   POINT    ptLocationClient;
   L_BOOL   bVisible;
   COLORREF crPen;
   COLORREF crFill;
   L_INT    nShape;
   HCURSOR  hCursor;
   L_INT    nTotalHandles;
   L_INT    nReserved;
} ANNHANDLEINFO, *pANNHANDLEINFO;

typedef enum{
      ANNTOKEN_NONE              = 0,
      ANNTOKEN_SEPARATOR         = 1,
      ANNTOKEN_TEXT              = 2,
      ANNTOKEN_DATE_YYYY         = 3,
      ANNTOKEN_DATE_YY           = 4,
      ANNTOKEN_DATE_MM           = 5,
      ANNTOKEN_DATE_DD           = 6,
      ANNTOKEN_DATE_MONTH_NAME   = 7,
      ANNTOKEN_DATE_DAY_OF_WEEK  = 8,
      ANNTOKEN_TIME_HH_12        = 9,
      ANNTOKEN_TIME_HH_24        = 10,
      ANNTOKEN_TIME_MM           = 11,
      ANNTOKEN_TIME_SS           = 12,
      ANNTOKEN_TIME_MILLISECONDS = 13,
      ANNTOKEN_AM_PM             = 14,
} ANNTEXTTOKENTYPE, *pANNTEXTTOKENTYPE;


// Structure used in
//    L_AnnInsertTextTableToken()
//    L_AnnEnumTextTableTokens()
typedef struct tagANNTEXTTOKENA
{
   L_UINT  uStructSize;             // sizeof this structure
   L_CHAR cToken;                  // character representing the token
   L_CHAR *pszDesc;                // description of the token
   L_CHAR *pszTokenString;         // definition of the token
   ANNTEXTTOKENTYPE nTokenType;     // constant defining the type of token
   L_INT nReserved;                 // reserved for future use
} ANNTEXTTOKENA, *pANNTEXTTOKENA;

#if defined(FOR_UNICODE)
typedef struct tagANNTEXTTOKEN
{
   L_UINT  uStructSize;             // sizeof this structure
   L_TCHAR cToken;                  // character representing the token
   L_TCHAR *pszDesc;                // description of the token
   L_TCHAR *pszTokenString;         // definition of the token
   ANNTEXTTOKENTYPE nTokenType;     // constant defining the type of token
   L_INT nReserved;                 // reserved for future use
} ANNTEXTTOKEN, *pANNTEXTTOKEN;
#else
typedef ANNTEXTTOKENA ANNTEXTTOKEN;
typedef pANNTEXTTOKENA pANNTEXTTOKEN;
#endif // #if defined(FOR_UNICODE)



// Structure used in 
//    L_AnnGetDistance
typedef struct tagANNSMARTDISTANCE
{
   L_UINT   uStructSize;
   L_DOUBLE dDistance;
   L_UINT   uRulerUnit;
   L_UINT   uSmartUnit;
} ANNSMARTDISTANCE, *pANNSMARTDISTANCE;


/*
   callback typedefs
*/
typedef L_INT (pEXT_CALLBACK ANNENUMCALLBACK) (HANNOBJECT hObject, L_VOID *pUserData);
typedef L_INT (pEXT_CALLBACK ANNENUMHANDLECALLBACK) (HANNOBJECT hObject, pANNHANDLEINFO pHandleInfo, L_VOID *pUserData); 


typedef L_INT (pEXT_CALLBACK ANNENUMTEXTTOKENTABLECALLBACKA) (L_INT nTextTokenCount, L_INT nIndex, pANNTEXTTOKENA pTextToken, L_VOID *pUserData); 

#if defined(FOR_UNICODE)
typedef L_INT (pEXT_CALLBACK ANNENUMTEXTTOKENTABLECALLBACK) (L_INT nTextTokenCount, L_INT nIndex, pANNTEXTTOKEN pTextToken, L_VOID *pUserData); 
#else
typedef ANNENUMTEXTTOKENTABLECALLBACKA ANNENUMTEXTTOKENTABLECALLBACK;
#endif // #if defined(FOR_UNICODE)


// Constants for:
//    L_AnnSetTextRTF
//    L_AnnGetTextRTF

#define RTFFORMAT_TEXT			0x0001
#define RTFFORMAT_RTF			0x0002


#define ANNCONVERT_TO_CONTAINER (1)
#define ANNCONVERT_TO_CLIENT    (2)


// v14.5 options
#define OPTIONS_NEW_STAMP_METAFILES    0x0001
#define OPTIONS_NEW_TOOLBAR            0x0002
#define OPTIONS_NEW_ALPHA              0x0004
#define OPTIONS_NEW_ROTATE             0x0008
#define OPTIONS_NEW_SIDE_HANDLES       0x0010
#define OPTIONS_NEW_MULTI_SELECT       0x0020
#define OPTIONS_NEW_CURSORS            0x0040
#define OPTIONS_NEW_ESC_CANCEL         0x0080
#define OPTIONS_NEW_CALIBRATE_RULER    0x0100
#define OPTIONS_NEW_DOT_DASH_LINES     0x0200
#define OPTIONS_NEW_TEXT_OPTIONS       0x0400

#define OPTIONS_NEW_MULTILINE_DRAW     0x1000

#define OPTIONS_NEW_SNAPTOGRID         0x0800
#define OPTIONS_NEW_ALL                0x1fff

/*
   function prototypes
*/

#if !defined(FOR_MANAGED) || defined(FOR_MANAGED_KERNEL_ANNOTATIONS)

L_LTANN_API L_INT EXT_FUNCTION L_AnnBringToFront (HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnClipboardReady(L_BOOL *pfReady);

L_LTANN_API L_INT EXT_FUNCTION L_AnnCopy(HANNOBJECT hSource,
                             pHANNOBJECT phDest);

L_LTANN_API L_INT EXT_FUNCTION L_AnnCopyFromClipboard(HWND hWnd,
                                          pHANNOBJECT phContainer);

L_LTANN_API L_INT EXT_FUNCTION L_AnnCopyToClipboard(HANNOBJECT hObject,
                                        L_UINT uFormat,
                                        L_BOOL fSelected,
                                        L_BOOL fEmpty,
                                        L_BOOL fCheckMenu);

L_LTANN_API L_INT EXT_FUNCTION L_AnnCutToClipboard(HANNOBJECT hObject,
                                       L_UINT uFormat,
                                       L_BOOL fSelected,
                                       L_BOOL fEmpty,
                                       L_BOOL fCheckMenu);


L_LTANN_API L_INT EXT_FUNCTION L_AnnCreate (L_UINT uObjectType,
                                pHANNOBJECT phObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnCreateContainer (HWND hWnd,
                                         pANNRECT pRect,
                                         L_BOOL fVisible,
                                         pHANNOBJECT phObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnCreateItem (HANNOBJECT hContainer,
                                    L_UINT uObjectType,
                                    L_BOOL fVisible,
                                    pHANNOBJECT phObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnDefine (HANNOBJECT hObject,
                                LPPOINT pPoint,
                                L_UINT uState);

L_LTANN_API L_INT EXT_FUNCTION L_AnnDeletePageOffset(L_HFILE fd, L_SSIZE_T nOffset, L_INT32 nPage);

L_LTANN_API L_INT EXT_FUNCTION L_AnnDeletePageMemory (HGLOBAL hMem, L_SIZE_T *puMemSize, L_INT32 nPage);

L_LTANN_API L_INT EXT_FUNCTION L_AnnDestroy (HANNOBJECT hObject,
                                 L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnDraw (HDC hDC,
                              LPRECT prcInvalid,
                              HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnFileInfoOffset (L_HFILE fd, 
                                        pANNFILEINFO pAnnFileInfo,
                                        L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnFileInfoMemory (L_UCHAR *pMem, 
                                        L_SIZE_T uMemSize, 
                                        pANNFILEINFO pAnnFileInfo,
                                        L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnFlip(HANNOBJECT hObject,
                             pANNPOINT pCenter,
                             L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetActiveState (HANNOBJECT hObject,
                                        L_UINT *puState);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoContainer (HANNOBJECT hObject,
                                          pHANNOBJECT phContainer);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoDrawEnable (HANNOBJECT hObject,
                                           L_BOOL *pfEnable);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoMenuEnable (HANNOBJECT hObject,
                                           L_BOOL *pfEnable);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoTextLen (HANNOBJECT hObject,
                                        L_UINT uItem,
                                        L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetBackColor (HANNOBJECT hObject,
                                      COLORREF *pcrBack);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetBitmap (HANNOBJECT hObject,
                                   pBITMAPHANDLE pBitmap,
                                   L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetBitmapDpiX(HANNOBJECT hObject,
                                      L_DOUBLE *pdDpiX);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetBitmapDpiY(HANNOBJECT hObject,
                                      L_DOUBLE *pdDpiY);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetBoundingRect (HANNOBJECT hObject, 
                                         LPRECT pRect, 
                                         LPRECT pRectName);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetContainer (HANNOBJECT hObject,
                                       pHANNOBJECT phContainer);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetDistance(HANNOBJECT hObject,
                                    L_DOUBLE *pdDistance,
                                    L_DOUBLE *pdDistance2);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetDpiX (HANNOBJECT hObject,
                                 L_DOUBLE *pdDpiX);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetDpiY (HANNOBJECT hObject,
                                 L_DOUBLE *pdDpiY);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFillPattern (HANNOBJECT hObject,
                                        L_UINT *puFillPattern);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFontBold (HANNOBJECT hObject,
                                     L_BOOL *pfFontBold);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFontItalic (HANNOBJECT hObject,
                                       L_BOOL *pfFontItalic);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFontNameLen (HANNOBJECT hObject,
                                        L_UINT *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFontSize (HANNOBJECT hObject,
                                     L_DOUBLE *pdFontSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFontStrikeThrough (HANNOBJECT hObject,
                                              L_BOOL *pfFontStrikeThrough);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFontUnderline (HANNOBJECT hObject,
                                          L_BOOL *pfFontUnderline);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetForeColor (HANNOBJECT hObject,
                                      COLORREF *pcrFore);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetGaugeLength(HANNOBJECT hObject,
                                       L_DOUBLE *pdLength);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTicMarkLength(HANNOBJECT hObject,
                                         L_DOUBLE *pdLength);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetHyperlinkLen (HANNOBJECT hObject,
                                         L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetHyperlinkMenuEnable(HANNOBJECT hObject,
                                               L_BOOL *pfEnable);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetLineStyle (HANNOBJECT hObject,
                                      L_UINT *puLineStyle);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetLineWidth (HANNOBJECT hObject,
                                      L_DOUBLE *pdLineWidth);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetLocked (HANNOBJECT hObject, 
                                   L_BOOL *pfLocked);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetOffsetX (HANNOBJECT hObject,
                                    L_DOUBLE *pdOffsetX);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetOffsetY (HANNOBJECT hObject,
                                    L_DOUBLE *pdOffsetY);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetPointCount (HANNOBJECT hObject,
                                       L_UINT *puCount);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetPoints (HANNOBJECT hObject,
                                   pANNPOINT pPoints);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetPolyFillMode (HANNOBJECT hObject,
                                         L_UINT *puPolyFillMode);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetRect (HANNOBJECT hObject, 
                                 pANNRECT pRect, 
                                 pANNRECT pRectName);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetROP2 (HANNOBJECT hObject,
                                 L_UINT *puRop2);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetScalarX (HANNOBJECT hObject,
                                    L_DOUBLE *pdScalarX);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetScalarY (HANNOBJECT hObject,
                                    L_DOUBLE *pdScalarY);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetSelectCount (HANNOBJECT hObject,
                                        L_UINT *puCount);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetSelected (HANNOBJECT hObject,
                                     L_BOOL *pfSelected);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetSelectItems(HANNOBJECT hObject, 
                                       pHANNOBJECT pItems);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetSelectRect(HANNOBJECT hObject,
                                      LPRECT pRect);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTag (HANNOBJECT hObject,
                                L_UINT32 *puTag);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextLen (HANNOBJECT hObject,
                                    L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextAlign(HANNOBJECT hObject, L_UINT *puTextAlign);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextRotate(HANNOBJECT hObject, L_UINT *puTextRotate);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextPointerFixed(HANNOBJECT hObject, L_BOOL *pbPointerFixed);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextExpandTokens(HANNOBJECT hObject, L_BOOL bTextExpandTokens, L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextExpandTokens(HANNOBJECT hObject, L_BOOL *pbTextExpandTokens);


L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTool (HANNOBJECT hObject,
                                 L_UINT *puTool);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetToolBarButtonVisible(HWND hwndToolBar,
                                                L_UINT uButton,
                                                L_BOOL *pfVisible);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetToolBarChecked (HWND hwndToolBar,
                                           L_UINT *puChecked);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTransparent (HANNOBJECT hObject,
                                        L_BOOL *pbTransparent);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetType (HANNOBJECT hObject,
                                 L_UINT *puObjectType);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTopContainer (HANNOBJECT hObject,
                                         pHANNOBJECT phContainer);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetUnitLen(HANNOBJECT hObject,
                                   L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetUserMode (HANNOBJECT hObject,
                                     L_UINT *puMode);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetVisible (HANNOBJECT hObject,
                                    L_BOOL *pfVisible);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetWnd (HANNOBJECT hObject,
                                HWND *phWnd);


L_LTANN_API L_INT EXT_FUNCTION L_AnnInsert (HANNOBJECT hContainer,
                                HANNOBJECT hObject,
                                L_BOOL fStripContainer);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetItem (HANNOBJECT hContainer,
                                 pHANNOBJECT phItem);

L_LTANN_API L_INT EXT_FUNCTION L_AnnLoadOffset (L_HFILE fd,
                                    L_SSIZE_T nOffset,
                                    L_SIZE_T nLength,
                                    pHANNOBJECT phObject,
                                    pLOADFILEOPTION pLoadOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnLoadMemory (L_UCHAR *pMem,
                                    L_SIZE_T uMemSize,
                                    pHANNOBJECT phObject,
                                    pLOADFILEOPTION pLoadOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnMove(HANNOBJECT hObject,
                             L_DOUBLE dDx,
                             L_DOUBLE dDy,
                             L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnPrint(HDC hDC,
                              LPRECT prcBounds,
                              HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnRealize(pBITMAPHANDLE pBitmap,
                                LPRECT prcBounds,
                                HANNOBJECT hObject,
                                L_BOOL fRedactOnly);

L_LTANN_API L_INT EXT_FUNCTION L_AnnResize(HANNOBJECT hObject,
                               L_DOUBLE dFactorX,
                               L_DOUBLE dFactorY,
                               pANNPOINT pCenter,
                               L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnReverse(HANNOBJECT hObject,
                                pANNPOINT pCenter,
                                L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnRemove (HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnRotate(HANNOBJECT hObject,
                               L_DOUBLE dAngle,
                               pANNPOINT pCenter,
                               L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSaveTag(HANNOBJECT hObject,
                                L_UINT uFormat,
                                L_BOOL fSelected);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSelectPoint(HANNOBJECT hObject,
                                    LPPOINT pPoint);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSelectRect(HANNOBJECT hObject,
                                   LPRECT pRect);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSendToBack (HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetActiveState (HANNOBJECT hObject,
                                        L_UINT uState);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoContainer (HANNOBJECT hObject,
                                          HANNOBJECT hContainer);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoDrawEnable (HANNOBJECT hObject,
                                           L_BOOL fEnable);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoMenuEnable (HANNOBJECT hObject,
                                           L_BOOL fEnable);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetBackColor (HANNOBJECT hObject,
                                      COLORREF crBack,
                                      L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetBitmap (HANNOBJECT hObject,
                                   pBITMAPHANDLE pBitmap,
                                   L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetBitmapDpiX(HANNOBJECT hObject,
                                      L_DOUBLE  dDpiX,
                                      L_UINT    uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetBitmapDpiY(HANNOBJECT hObject,
                                      L_DOUBLE  dDpiY,
                                      L_UINT    uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetDpiX(HANNOBJECT hObject,
                                L_DOUBLE dDpiX,
                                L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetDpiY(HANNOBJECT hObject,
                                L_DOUBLE dDpiY,
                                L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFillPattern (HANNOBJECT hObject,
                                        L_UINT uFillPattern,
                                        L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFontBold (HANNOBJECT hObject,
                                     L_BOOL fFontBold,
                                     L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFontItalic (HANNOBJECT hObject,
                                       L_BOOL fFontItalic,
                                       L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFontSize (HANNOBJECT hObject,
                                     L_DOUBLE dFontSize,
                                     L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFontStrikeThrough (HANNOBJECT hObject,
                                              L_BOOL fFontStrikeThrough,
                                              L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFontUnderline (HANNOBJECT hObject,
                                          L_BOOL fFontUnderline,
                                          L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetForeColor (HANNOBJECT hObject,
                                      COLORREF crFore,
                                      L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetGaugeLength(HANNOBJECT hObject,
                                       L_DOUBLE dLength,
                                       L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTicMarkLength(HANNOBJECT hObject,
                                         L_DOUBLE dLength,
                                         L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetHyperlinkMenuEnable(HANNOBJECT hObject,
                                               L_BOOL fEnable,
                                               L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetLineStyle (HANNOBJECT hObject,
                                      L_UINT uLineStyle,
                                      L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetLineWidth (HANNOBJECT hObject,
                                      L_DOUBLE dLineWidth,
                                      L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetOffsetX(HANNOBJECT hObject,
                                   L_DOUBLE dOffsetX,
                                   L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetOffsetY(HANNOBJECT hObject,
                                   L_DOUBLE dOffsetY,
                                   L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetPoints (HANNOBJECT hObject,
                                   pANNPOINT pPoints,
                                   L_UINT uCount);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetPolyFillMode (HANNOBJECT hObject,
                                         L_UINT uPolyFillMode,
                                         L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetROP2 (HANNOBJECT hObject,
                                 L_UINT uROP2,
                                 L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetRect (HANNOBJECT hObject,
                                 pANNRECT pRect);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetSelected (HANNOBJECT hObject,
                                     L_BOOL fSelected,
                                     L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetScalarX(HANNOBJECT hObject,
                                   L_DOUBLE dScalarX,
                                   L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetScalarY(HANNOBJECT hObject,
                                   L_DOUBLE dScalarY,
                                   L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTag (HANNOBJECT hObject,
                                L_UINT32 uTag,
                                L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextAlign(HANNOBJECT hObject, L_UINT uTextAlign, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextRotate(HANNOBJECT hObject, L_UINT uTextRotate, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextPointerFixed(HANNOBJECT hObject, L_BOOL bPointerFixed, L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTool (HANNOBJECT hObject,
                                 L_UINT uTool);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetToolBarButtonVisible(HWND hwndToolBar,
                                  L_UINT uButton,
                                  L_BOOL fVisible);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetToolBarChecked(HWND hwndToolBar,
                                  L_UINT uChecked);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTransparent (HANNOBJECT hObject,
                                      L_BOOL bTransparent,
                                      L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetUndoDepth (HANNOBJECT hObject,
                                      L_UINT uLevels);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetUserMode (HANNOBJECT hObject,
                                      L_UINT uMode);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetWnd (HANNOBJECT hObject,
                                 HWND hWnd);
L_LTANN_API L_INT EXT_FUNCTION L_AnnShowLockedIcon (HANNOBJECT hObject,
                                     L_BOOL bShow,
                                     L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnUndo (HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnUnrealize(pBITMAPHANDLE pBitmap, 
                                LPRECT prcBounds, 
                                HANNOBJECT hObject, 
                                L_BOOL fSelected);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetNodes(HANNOBJECT hObject, 
                                 L_BOOL bShowNodes, 
                                 L_UINT uGapNodes, 
                                 L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetNodes(HANNOBJECT hObject, 
                                 L_BOOL *pbShowNodes, 
                                 L_UINT *puGapNodes);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetShowFlags (HANNOBJECT hObject,
                                       L_UINT uShowFlags,
                                       L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetShowFlags (HANNOBJECT hObject,
                                       L_UINT *puShowFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAngle(HANNOBJECT hObject,
                                 L_DOUBLE *pdAngle);

/* newest functions */

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetMetafile (HANNOBJECT hObject, 
                                     HMETAFILE hMetafile, 
                                     L_UINT uType, 
                                     L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetMetafile (HANNOBJECT hObject, 
                                     HMETAFILE *phMetafile);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetSecondaryMetafile (HANNOBJECT hObject, 
                                              HMETAFILE *phMetafile);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetPredefinedMetafile(L_UINT uType, 
                                              HMETAFILE hMetafile);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetPredefinedMetafile(L_UINT uType, 
                                              HMETAFILE *phMetafile,
                                              L_BOOL *pbEnhanced);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetSecondaryBitmap (HANNOBJECT hObject, 
                                            pBITMAPHANDLE pBitmap, 
                                            L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetSecondaryBitmap (HANNOBJECT hObject, 
                                            pBITMAPHANDLE pBitmap,
                                            L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoMenuItemEnable(HANNOBJECT hObject, 
                                              L_INT nObjectType, 
                                              L_UINT uItem, 
                                              L_UINT *puEnable);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoMenuState(HANNOBJECT hObject, 
                                         L_INT nObjectType, 
                                         L_UCHAR *pEnable, 
                                         L_UCHAR *pEnableFlags, 
                                         L_UINT uBits, 
                                         L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoMenuState(HANNOBJECT hObject, 
                                         L_INT nObjectType, 
                                         L_UCHAR *pEnable, 
                                         L_UCHAR *pEnableFlags, 
                                         L_UINT uBits);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetToolBarInfo(HWND hwndToolBar,
                                       pANNTOOLBARINFO pInfo,
                                       L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetToolBarColumns(HWND hwndToolBar,
                                          L_UINT uColumns);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetToolBarRows(HWND hwndToolBar,
                                          L_UINT uRows);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoDefaults(HANNOBJECT hAutomation, 
                                        HANNOBJECT hObject, 
                                        L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTransparentColor (HANNOBJECT hObject, 
                                             COLORREF crTransparent, 
                                             L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTransparentColor (HANNOBJECT hObject, 
                                             COLORREF *pcrTransparent);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetUndoDepth (HANNOBJECT hObject,
                                      L_UINT *puUsedLevels,
                                      L_UINT *puMaxLevels);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoOptions (HANNOBJECT hObject,
                                        L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoOptions (HANNOBJECT hObject,
                                        L_UINT *puFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetObjectFromTag (HANNOBJECT hContainer,
                                          L_UINT uFlags,
                                          L_UINT32 uTag,
                                          pHANNOBJECT phTagObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetRgnHandle(HANNOBJECT hObject,
                                    pRGNXFORM pXForm,
                                    HRGN *phRgn);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetArea(HANNOBJECT hObject, 
                                L_SIZE_T *puCount);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoDialogFontSize(HANNOBJECT hObject,
                                        L_INT   nFontSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoDialogFontSize(HANNOBJECT hObject,
                                        L_INT * pnFontSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetGrouping(HANNOBJECT hObject,
                                    L_BOOL bAutoGroup,
                                    L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetGrouping(HANNOBJECT hObject,
                                    L_BOOL * pbAutoGroup);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoBackColor(HANNOBJECT hObject,
                                         L_UINT uObjectType,
                                         COLORREF crBack);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoBackColor(HANNOBJECT hObject,
                                         L_UINT uObjectType,
                                         COLORREF *pcrBack);

L_LTANN_API L_INT EXT_FUNCTION L_AnnAddUndoNode(HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoUndoEnable(HANNOBJECT hObject,
                                          L_BOOL      bEnable);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoUndoEnable(HANNOBJECT hObject,
                                          L_BOOL *pbEnable);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetToolBarParent(HWND hwndToolBar, HWND hwndParent); // for internal use

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetEncryptOptions (HANNOBJECT hObject, 
                                           pANNENCRYPTOPTIONS pEncryptOptions,
                                           L_UINT uFlags);


L_LTANN_API L_INT EXT_FUNCTION L_AnnGetEncryptOptions(HANNOBJECT hObject,
                                          pANNENCRYPTOPTIONS pEncryptOptions);

/*
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetEncryptBitmap(HANNOBJECT    hObject, 
                                         pBITMAPHANDLE pEncryptBitmap,
                                         L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetEncryptBitmap (HANNOBJECT hObject,
                                          pBITMAPHANDLE *ppEncryptBitmap);
*/

L_LTANN_API L_INT EXT_FUNCTION L_AnnEncryptApply(HANNOBJECT    hObject, 
                                     L_UINT uEncryptFlags, 
                                     L_UINT        uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetPredefinedBitmap(L_UINT uType, 
                                            pBITMAPHANDLE pBitmap);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetPredefinedBitmap(L_UINT uType, 
                                            pBITMAPHANDLE pBitmap,
                                            L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetPointOptions(HANNOBJECT hObject,
                                        pANNPOINTOPTIONS pPointOptions,
                                        L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetPointOptions (HANNOBJECT    hObject, 
                                         pANNPOINTOPTIONS pPointOptions, 
                                         L_UINT        uFlags);

// Annotation handle (node) functions
L_LTANN_API L_INT EXT_FUNCTION L_AnnAddUserHandle(HANNOBJECT hObject,
                                      pANNHANDLE pAnnHandle);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetUserHandle(HANNOBJECT hObject,
                                      L_INT32 uIndex,
                                      pANNHANDLE pAnnHandle);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetUserHandles(HANNOBJECT hObject,
                                       pANNHANDLE pAnnHandle,
                                       L_UINT    *pCount);

L_LTANN_API L_INT EXT_FUNCTION L_AnnChangeUserHandle(HANNOBJECT hObject,
                                         L_INT32 nIndex,
                                         pANNHANDLE pAnnHandle);



L_LTANN_API L_INT EXT_FUNCTION L_AnnDeleteUserHandle(HANNOBJECT hObject,
                                         L_INT32 nIndex);

L_LTANN_API L_INT EXT_FUNCTION L_AnnEnumerateHandles(HANNOBJECT hObject, 
                                         ANNENUMHANDLECALLBACK pfnCallback, 
                                         L_VOID *pUserData);


// Misc functions




L_LTANN_API L_INT EXT_FUNCTION L_AnnDumpObject(HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnHitTest(HANNOBJECT hObject,
                                   LPPOINT pPoint,
                                   L_UINT *puResult,
                                   pHANNOBJECT phObjectHit,
                                   pANNHITTESTINFO pHitTestInfo,
                                   L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetRotateAngle(HANNOBJECT hObject, L_DOUBLE *pdAngle);

L_LTANN_API L_INT EXT_FUNCTION L_AnnAdjustPoint(pANNPOINT pptAnchor, pANNPOINT pptMove, L_DOUBLE dAngle, L_INT nType);



L_LTANN_API L_INT EXT_FUNCTION L_AnnConvert(HANNOBJECT hContainer, LPPOINT pPoints, pANNPOINT pAnnPoints, L_INT nCount, L_INT nConvert);

L_LTANN_API L_INT EXT_FUNCTION L_AnnRestrictCursor(HANNOBJECT hContainer, LPRECT lpRect, LPPOINT pPoint, LPRECT prcOldClip, L_BOOL bRestrictClient);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetRestrictToContainer(HANNOBJECT hObject, L_BOOL bRestrict, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetRestrictToContainer(HANNOBJECT hObject, L_BOOL * pbRestrict);

L_LTANN_API L_INT EXT_FUNCTION L_AnnDefine2(HANNOBJECT hObject, pANNPOINT apt, L_UINT uState);


// Text Token Table Functions
//L_LTANN_API L_INT EXT_FUNCTION L_AnnInsertTextTokenTable(HANNOBJECT hAutomation, pANNTEXTTOKEN pTextToken);
//L_LTANN_API L_INT EXT_FUNCTION L_AnnEnumerateTextTokenTable(HANNOBJECT hAutomation, ANNENUMTEXTTOKENTABLECALLBACK pfnCallback,L_VOID *pUserData)////;
//L_LTANN_API L_INT EXT_FUNCTION L_AnnDeleteTextTokenTable(HANNOBJECT hAutomation, L_TCHAR cToken);
L_LTANN_API L_INT EXT_FUNCTION L_AnnClearTextTokenTable(HANNOBJECT hAutomation);

// Fixed Annotation Functions

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFixed(HANNOBJECT hObject, L_BOOL *pbFixed);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFixed(HANNOBJECT hObject, L_BOOL bFixed, L_BOOL bAdjust, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnPushFixedState(HANNOBJECT hObject, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnPopFixedState(HANNOBJECT hObject, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnIsFixedInRect(HANNOBJECT hObject,
                                    LPRECT prc, 
                                    L_BOOL *pbFixedInRect,
                                    L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetDistance2(HANNOBJECT          hObject,
                                     L_UINT             *puCount,
                                     pANNSMARTDISTANCE   pDistance,
                                     pANNSMARTDISTANCE   pTotalDistance,
                                     L_UINT              uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoCursor(HANNOBJECT hAutomation, L_UINT uItem, HCURSOR hCursor);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoCursor(HANNOBJECT hAutomation, L_UINT uItem, HCURSOR *phCursor);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetUserData(HANNOBJECT hObject, L_UCHAR *pUserData, L_UINT uUserDataSize, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetUserData(HANNOBJECT hObject, L_UCHAR *pUserData, L_UINT *puUserDataSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoHilightPen(HANNOBJECT hAutomation, COLORREF crHilight);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetOptions(HANNOBJECT hAutomation, L_UINT uOptions);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetOptions(L_UINT *puOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFillMode(HANNOBJECT hObject,
                                     L_UINT *puFillMode,
                                     L_INT *pnAlpha);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFillMode(HANNOBJECT hObject,
                                     L_UINT uFillMode,
                                     L_INT  nAlpha,
                                     L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetRotateOptions(HANNOBJECT hObject, pANNROTATEOPTIONS pRotateOptions, L_UINT uStructSize);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetRotateOptions(HANNOBJECT hObject, pANNROTATEOPTIONS pRotateOptions, L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnCalibrateRuler(HANNOBJECT hObject, L_DOUBLE dCalibrateLength, L_UINT uCalibrateUnit, L_DOUBLE dDpiRatioXtoY);
L_LTANN_API L_INT EXT_FUNCTION L_AnnCalibrateRulerSuccessive(HANNOBJECT hObject, L_DOUBLE dCalibrateLength, L_UINT uCalibrateUnit);
L_LTANN_API L_INT EXT_FUNCTION L_AnnCalibrateRuler2(HANNOBJECT hObject, L_DOUBLE dCalibrateLength, L_UINT uCalibrateUnit, L_DOUBLE dDpiRatioXtoY, L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnTextEdit(HANNOBJECT hObject);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextOptions (HANNOBJECT hObject, pANNTEXTOPTIONS pTextOptions, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextOptions(HANNOBJECT hObject, pANNTEXTOPTIONS pTextOptions, L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoSnapCursor(HANNOBJECT hAutomation, L_BOOL *pbSnap);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoSnapCursor(HANNOBJECT hAutomation, L_BOOL bSnap);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextFixedSize(HANNOBJECT hObject, L_BOOL bTextFixedSize, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextFixedSize(HANNOBJECT hObject, L_BOOL *pbTextFixedSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextScaleWithDpi(HANNOBJECT hObject, L_BOOL bTextScaleWithDpi);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextScaleWithDpi(HANNOBJECT hObject, L_BOOL *pbTextScaleWithDpi);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetLineFixedWidth(HANNOBJECT hObject, L_BOOL *pbLineFixedWidth);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetLineFixedWidth(HANNOBJECT hObject, L_BOOL bLineFixedWidth, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetPointerOptions(HANNOBJECT hObject, pANNPOINTEROPTIONS pOptions, L_UINT uStructSize);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetPointerOptions(HANNOBJECT hObject, pANNPOINTEROPTIONS pOptions, L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetRenderMode (HANNOBJECT hObject, L_UINT32 uRenderMode, L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetShowStampBorder(HANNOBJECT hObject, L_BOOL *pbShowStampBorder);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetShowStampBorder(HANNOBJECT hObject, L_BOOL bShowStampBorder, L_UINT uFlags);


//**************************************
L_LTANN_API L_INT EXT_FUNCTION L_AnnDeletePageA(L_CHAR *pFile, L_INT32 nPage);

L_LTANN_API L_INT EXT_FUNCTION L_AnnEnumerateA(HANNOBJECT hObject,
                                   ANNENUMCALLBACK pfnCallback,
                                   L_VOID *pUserData,
                                   L_UINT uFlags,
                                   L_CHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnFileInfoA(L_CHAR *pszFile, 
                                  pANNFILEINFO pAnnFileInfo,
                                  L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoTextA(HANNOBJECT hObject,
                                     L_UINT uItem,
                                     L_CHAR *pText,
                                     L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFontNameA(HANNOBJECT hObject,
                                     L_CHAR *pFontName,
                                     L_UINT *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetHyperlinkA(HANNOBJECT hObject,
                                      L_UINT *puType,
                                      L_UINT *puMsg,
                                      WPARAM *pwParam,
                                      L_CHAR *pLink,
                                      L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextA(HANNOBJECT hObject,
                                 L_CHAR *pText,
                                 L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetUnitA(HANNOBJECT hObject,
                                L_UINT    *puUnit,
                                L_CHAR   *pUnitAbbrev,
                                L_SIZE_T  *puUnitAbbrevLen,
                                L_UINT    *puRulerPrecision
                                );

L_LTANN_API L_INT EXT_FUNCTION L_AnnLoadA(L_CHAR *pFile,
                              pHANNOBJECT phObject,
                              pLOADFILEOPTION pLoadOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnLockA(HANNOBJECT hObject, 
                              L_CHAR * pLockKey, 
                              L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSaveA(L_CHAR *pFile,
                              HANNOBJECT hObject,
                              L_UINT uFormat,
                              L_BOOL fSelected,
                              pSAVEFILEOPTIONA pSaveOptionsA);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSaveOffsetA(L_HFILE fd,
                                    L_SSIZE_T nOffset,
                                    L_SIZE_T *puSizeWritten,
                                    HANNOBJECT hObject,
                                    L_UINT uFormat,
                                    L_BOOL fSelected,
                                    pSAVEFILEOPTIONA pSaveOptionsA);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSaveMemoryA(HANNOBJECT hObject,
                                    L_UINT uFormat,
                                    L_BOOL fSelected,
                                    HGLOBAL *phMem,
                                    L_SIZE_T *puMemSize,
                                    pSAVEFILEOPTIONA pSaveOptionsA);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoTextA(HANNOBJECT hObject,
                                     L_UINT uItem,
                                     L_CHAR *pText);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFontNameA(HANNOBJECT hObject,
                                     L_CHAR *pFontName,
                                     L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetHyperlinkA(HANNOBJECT hObject,
                                      L_UINT uType,
                                      L_UINT uMsg,
                                      WPARAM wParam,
                                      L_CHAR *pLink,
                                      L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextA(HANNOBJECT hObject,
                                 L_CHAR *pText,
                                 L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetUnitA(HANNOBJECT hObject,
                                L_UINT uUnit,
                                L_CHAR * pUnitAbbrev,
                                L_UINT uPrecision,
                                L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetVisibleA(HANNOBJECT hObject,
                                     L_BOOL fVisible,
                                     L_UINT uFlags,
                                     L_CHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnUnlockA(HANNOBJECT hObject, 
                              L_CHAR * pUnlockKey, 
                              L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetProtractorOptionsA(HANNOBJECT hObject, 
                                             L_BOOL  bAcute,
                                             L_UINT  uUnit,
                                             L_CHAR *pszAbbrev,
                                             L_UINT  uPrecision,
                                             L_DOUBLE dArcRadius,
                                             L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetProtractorOptionsA(HANNOBJECT hObject,
                                             L_BOOL  *pbAcute,
                                             L_UINT  *puUnit,
                                             L_SIZE_T *puAbbrevLen,
                                             L_CHAR *pszAbbrev,
                                             L_UINT  *puPrecision,
                                             L_DOUBLE *pdArcRadius);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoMenuItemEnableA(HANNOBJECT hObject, 
                                              L_INT nObjectType, 
                                              L_UINT uItem, 
                                              L_UINT uEnable, 
                                              L_UINT uFlags,
                                              L_CHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetUserA(HANNOBJECT hObject, 
                                L_CHAR *pOldUser, 
                                L_CHAR *pNewUser, 
                                L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGroupA(HANNOBJECT hObject, 
                               L_UINT uFlags, 
                               L_CHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnUngroupA(HANNOBJECT hObject, 
                               L_UINT uFlags, 
                               L_CHAR *pUserList);

//// TextTokenTable
L_LTANN_API L_INT EXT_FUNCTION L_AnnInsertTextTokenTableA(HANNOBJECT hAutomation, pANNTEXTTOKENA pTextToken);
L_LTANN_API L_INT EXT_FUNCTION L_AnnEnumerateTextTokenTableA(HANNOBJECT hAutomation, ANNENUMTEXTTOKENTABLECALLBACKA pfnCallback,L_VOID *pUserData);
L_LTANN_API L_INT EXT_FUNCTION L_AnnDeleteTextTokenTableA(HANNOBJECT hAutomation, L_CHAR cToken);

//L_LTANN_API L_INT EXT_FUNCTION L_AnnSetNoScrollA(HANNOBJECT hObject, L_BOOL bNoScroll, L_UINT uFlags, L_CHAR *pUserList);

//L_LTANN_API L_INT EXT_FUNCTION L_AnnSetNoZoomA(HANNOBJECT hObject, L_BOOL bNoZoom, L_UINT uFlags, L_CHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextRTFA(HANNOBJECT hObject, L_UINT uFormat, L_CHAR *pText, L_UINT uFlags);
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextRTFA(HANNOBJECT hObject, L_UINT uFormat, L_CHAR *pText, L_SIZE_T  *puLen);
L_LTANN_API L_CHAR * EXT_FUNCTION L_AnnSetlocaleA(L_INT nCategory, const L_CHAR *lpszLocale);


// AnnToolbar Functions
L_LTANN_API L_INT EXT_FUNCTION L_AnnCreateToolBarA(HWND hwndParent,
                                      LPPOINT pPoint,
                                      L_UINT uAlign,
                                      L_BOOL fVisible,
                                      HWND *phWnd,
                                      L_UINT uButtons,
                                      pANNBUTTONA pButtons);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetToolBarButtonsA(HWND hwndToolBar,
                                          pANNBUTTONA pButtons,
                                          L_UINT uButtons);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetToolBarButtonsA(HWND hwndToolBar,
                                          pANNBUTTONA pButtons,
                                          L_UINT uStructSize,
                                          L_UINT *puButtons);

L_LTANN_API L_INT EXT_FUNCTION L_AnnFreeToolBarButtonsA(pANNBUTTONA pButtons,
                                           L_UINT uButtons);

//
//// Name Options
L_LTANN_API L_INT EXT_FUNCTION L_AnnGetNameOptionsA(HANNOBJECT hObject, pANNNAMEOPTIONSA pNameOptions, L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetNameOptionsA(HANNOBJECT    hObject, 
                                       pANNNAMEOPTIONSA pNameOptions, 
                                       L_UINT        uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetSnapToGrid (HANNOBJECT hAutomation, L_UINT *puSnapToGridMode, pANNSNAPTOGRIDOPTIONS pOptions);
L_LTANN_API L_INT EXT_FUNCTION L_AnnSetSnapToGrid (HANNOBJECT hAutomation, L_UINT uSnapToGridMode, pANNSNAPTOGRIDOPTIONS pOptions);

#if defined(FOR_UNICODE)
L_LTANN_API L_INT EXT_FUNCTION L_AnnDeletePage(L_TCHAR *pFile, L_INT32 nPage);

L_LTANN_API L_INT EXT_FUNCTION L_AnnEnumerate (HANNOBJECT hObject,
                                   ANNENUMCALLBACK pfnCallback,
                                   L_VOID *pUserData,
                                   L_UINT uFlags,
                                   L_TCHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnFileInfo (L_TCHAR *pszFile, 
                                  pANNFILEINFO pAnnFileInfo,
                                  L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetAutoText (HANNOBJECT hObject,
                                     L_UINT uItem,
                                     L_TCHAR *pText,
                                     L_SIZE_T *puLen);


L_LTANN_API L_INT EXT_FUNCTION L_AnnGetFontName (HANNOBJECT hObject,
                                     L_TCHAR *pFontName,
                                     L_UINT *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetHyperlink (HANNOBJECT hObject,
                                      L_UINT *puType,
                                      L_UINT *puMsg,
                                      WPARAM *pwParam,
                                      L_TCHAR *pLink,
                                      L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetText (HANNOBJECT hObject,
                                 L_TCHAR *pText,
                                 L_SIZE_T *puLen);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetUnit(HANNOBJECT hObject,
                                L_UINT    *puUnit,
                                L_TCHAR   *pUnitAbbrev,
                                L_SIZE_T  *puUnitAbbrevLen,
                                L_UINT    *puRulerPrecision
                                );

L_LTANN_API L_INT EXT_FUNCTION L_AnnLoad (L_TCHAR *pFile,
                              pHANNOBJECT phObject,
                              pLOADFILEOPTION pLoadOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnLock (HANNOBJECT hObject, 
                              L_TCHAR * pLockKey, 
                              L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSave (L_TCHAR *pFile,
                              HANNOBJECT hObject,
                              L_UINT uFormat,
                              L_BOOL fSelected,
                              pSAVEFILEOPTION pSaveOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSaveOffset (L_HFILE fd,
                                    L_SSIZE_T nOffset,
                                    L_SIZE_T *puSizeWritten,
                                    HANNOBJECT hObject,
                                    L_UINT uFormat,
                                    L_BOOL fSelected,
                                    pSAVEFILEOPTION pSaveOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSaveMemory (HANNOBJECT hObject,
                                    L_UINT uFormat,
                                    L_BOOL fSelected,
                                    HGLOBAL *phMem,
                                    L_SIZE_T *puMemSize,
                                    pSAVEFILEOPTION pSaveOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoText (HANNOBJECT hObject,
                                     L_UINT uItem,
                                     L_TCHAR *pText);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetFontName (HANNOBJECT hObject,
                                     L_TCHAR *pFontName,
                                     L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetHyperlink (HANNOBJECT hObject,
                                      L_UINT uType,
                                      L_UINT uMsg,
                                      WPARAM wParam,
                                      L_TCHAR *pLink,
                                      L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetText (HANNOBJECT hObject,
                                 L_TCHAR *pText,
                                 L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetUnit(HANNOBJECT hObject,
                                L_UINT uUnit,
                                L_TCHAR * pUnitAbbrev,
                                L_UINT uPrecision,
                                L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetVisible (HANNOBJECT hObject,
                                     L_BOOL fVisible,
                                     L_UINT uFlags,
                                     L_TCHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnUnlock (HANNOBJECT hObject, 
                              L_TCHAR * pUnlockKey, 
                              L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetProtractorOptions(HANNOBJECT hObject, 
                                             L_BOOL  bAcute,
                                             L_UINT  uUnit,
                                             L_TCHAR *pszAbbrev,
                                             L_UINT  uPrecision,
                                             L_DOUBLE dArcRadius,
                                             L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetProtractorOptions(HANNOBJECT hObject,
                                             L_BOOL  *pbAcute,
                                             L_UINT  *puUnit,
                                             L_SIZE_T *puAbbrevLen,
                                             L_TCHAR *pszAbbrev,
                                             L_UINT  *puPrecision,
                                             L_DOUBLE *pdArcRadius);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetAutoMenuItemEnable(HANNOBJECT hObject, 
                                              L_INT nObjectType, 
                                              L_UINT uItem, 
                                              L_UINT uEnable, 
                                              L_UINT uFlags,
                                              L_TCHAR *pUserList);


L_LTANN_API L_INT EXT_FUNCTION L_AnnSetUser(HANNOBJECT hObject, 
                                L_TCHAR *pOldUser, 
                                L_TCHAR *pNewUser, 
                                L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGroup (HANNOBJECT hObject, 
                               L_UINT uFlags, 
                               L_TCHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnUngroup (HANNOBJECT hObject, 
                               L_UINT uFlags, 
                               L_TCHAR *pUserList);

L_LTANN_API L_INT EXT_FUNCTION L_AnnDeleteTextTokenTable(HANNOBJECT hAutomation, L_TCHAR cToken);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetTextRTF(HANNOBJECT hObject, L_UINT uFormat, L_TCHAR *pText, L_UINT uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetTextRTF(HANNOBJECT hObject, L_UINT uFormat, L_TCHAR *pText, L_SIZE_T  *puLen);

L_LTANN_API L_TCHAR * EXT_FUNCTION L_AnnSetlocale(L_INT nCategory, const L_TCHAR *lpszLocale);

L_LTANN_API L_INT EXT_FUNCTION L_AnnCreateToolBar(HWND hwndParent,
                                      LPPOINT pPoint,
                                      L_UINT uAlign,
                                      L_BOOL fVisible,
                                      HWND *phWnd,
                                      L_UINT uButtons,
                                      pANNBUTTON pButtons);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetToolBarButtons(HWND hwndToolBar,
                                          pANNBUTTON pButtons,
                                          L_UINT uStructSize,
                                          L_UINT *puButtons);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetToolBarButtons(HWND hwndToolBar,
                                          pANNBUTTON pButtons,
                                          L_UINT uButtons);

L_LTANN_API L_INT EXT_FUNCTION L_AnnFreeToolBarButtons(pANNBUTTON pButtons,
                                           L_UINT uButtons);

L_LTANN_API L_INT EXT_FUNCTION L_AnnGetNameOptions(HANNOBJECT hObject, pANNNAMEOPTIONS pNameOptions, L_UINT uStructSize);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSetNameOptions(HANNOBJECT    hObject, 
                                       pANNNAMEOPTIONS pNameOptions, 
                                       L_UINT        uFlags);

L_LTANN_API L_INT EXT_FUNCTION L_AnnInsertTextTokenTable(HANNOBJECT hAutomation, pANNTEXTTOKEN pTextToken);
L_LTANN_API L_INT EXT_FUNCTION L_AnnEnumerateTextTokenTable(HANNOBJECT hAutomation, ANNENUMTEXTTOKENTABLECALLBACK pfnCallback,L_VOID *pUserData);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSaveMulti(L_TCHAR *pFile,
                               HANNOBJECT *phObjects,
                               L_INT nCount,
                               L_UINT uFormat,
                               L_BOOL fSelected,
                               pSAVEFILEOPTION pSaveOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnSaveMultiOffset (L_HFILE fd,
                               L_SSIZE_T nOffset,
                               L_SIZE_T *puSizeWritten,
                               HANNOBJECT *phObjects,
                               L_INT      nCount,
                               L_UINT uFormat,
                               L_BOOL fSelected,
                               pSAVEFILEOPTION pSaveOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnLoadMultiOffset (L_HFILE fd,
                               L_SSIZE_T nOffset,
                               L_SIZE_T nLength,
                               pHANNOBJECT phObjects,
                               L_INT      nCount,
                               L_INT      *pnItemsRead,
                               pLOADFILEOPTION pLoadOptions);

L_LTANN_API L_INT EXT_FUNCTION L_AnnLoadMulti(L_TCHAR *pFile,
                               pHANNOBJECT phObjects,
                               L_INT      nCount,
                               L_INT      *pnItemsRead,
                               pLOADFILEOPTION pLoadOptions);

#else
#define L_AnnDeletePage L_AnnDeletePageA
#define L_AnnEnumerate L_AnnEnumerateA
#define L_AnnFileInfo L_AnnFileInfoA
#define L_AnnGetAutoText L_AnnGetAutoTextA
#define L_AnnGetFontName L_AnnGetFontNameA
#define L_AnnGetHyperlink L_AnnGetHyperlinkA
#define L_AnnGetText L_AnnGetTextA
#define L_AnnGetUnit L_AnnGetUnitA
#define L_AnnLoad L_AnnLoadA
#define L_AnnLock L_AnnLockA
#define L_AnnSave L_AnnSaveA
#define L_AnnSaveOffset L_AnnSaveOffsetA
#define L_AnnSaveMemory L_AnnSaveMemoryA
#define L_AnnSetAutoText L_AnnSetAutoTextA
#define L_AnnSetFontName L_AnnSetFontNameA
#define L_AnnSetHyperlink L_AnnSetHyperlinkA
#define L_AnnSetText L_AnnSetTextA
#define L_AnnSetUnit L_AnnSetUnitA
#define L_AnnSetVisible L_AnnSetVisibleA
#define L_AnnUnlock L_AnnUnlockA
#define L_AnnSetProtractorOptions L_AnnSetProtractorOptionsA
#define L_AnnGetProtractorOptions L_AnnGetProtractorOptionsA
#define L_AnnSetAutoMenuItemEnable L_AnnSetAutoMenuItemEnableA
#define L_AnnSetUser L_AnnSetUserA
#define L_AnnGroup L_AnnGroupA
#define L_AnnUngroup L_AnnUngroupA

#define L_AnnInsertTextTokenTable L_AnnInsertTextTokenTableA
#define L_AnnEnumerateTextTokenTable L_AnnEnumerateTextTokenTableA
#define L_AnnDeleteTextTokenTable L_AnnDeleteTextTokenTableA
#define L_AnnSetTextRTF L_AnnSetTextRTFA
// #define L_AnnDumpSmartDistance L_AnnDumpSmartDistanceA
#define L_AnnGetTextRTF L_AnnGetTextRTFA
#define L_AnnSetlocale L_AnnSetlocaleA

#define L_AnnCreateToolBar L_AnnCreateToolBarA
#define L_AnnGetToolBarButtons L_AnnGetToolBarButtonsA
#define L_AnnSetToolBarButtons L_AnnSetToolBarButtonsA
#define L_AnnFreeToolBarButtons L_AnnFreeToolBarButtonsA

#define L_AnnGetNameOptions L_AnnGetNameOptionsA
#define L_AnnSetNameOptions L_AnnSetNameOptionsA
#endif

#endif // #if !defined(FOR_MANAGED) || defined(FOR_MANAGED_KERNEL_ANNOTATIONS)

#undef L_HEADER_ENTRY
#include "ltpck.h"

#endif // #if !defined(LTANN_H)

