// *************************************************************
// Copyright (c) 1991-2025 Apryse Software Corp.
// All Rights Reserved.
// *************************************************************
//
//  LTErrorCode.h
//  Leadtools
//

#import <Leadtools/LTLeadtools.h>


// ************************************************************************
// *** NOTE: Be sure to get these values directly from /API/Include/lterr.h
// ************************************************************************
typedef NS_ENUM(NSInteger, LTErrorCode) {
    LTErrorCodeSuccess                                 = 1,
    LTErrorCodeFailure                                 = 0,
    LTErrorCodeSuccessDelete                           = 3,
    LTErrorCodeSuccessRetry                            = 4,
    LTErrorCodeSuccessPartialFailure                   = 8,
    
    LTErrorCodeKernelExpired                           = -1591,
    LTErrorCodeInvalidParameter                        = -13,
    LTErrorCodeInvalidStructSize                       = -789,
    LTErrorCodeBitsPerPixel                            = -27,
    LTErrorCodeInvalidRange                            = -11,
    LTErrorCodeIncorrectWidthAdjusted                  = -1753,
    LTErrorCodeNoImage                                 = -2,
    LTErrorCodeNullPointer                             = -814,
    LTErrorCodeNotInitialized                          = -30,
    LTErrorCodeSignedDataNotSupported                  = -1360,
    LTErrorCodeBufferTooSmall                          = -290,
    LTErrorCodeException                               = -149,
    LTErrorCodeNothingToDo                             = -351,
    LTErrorCodeImageEmpty                              = -144,
    LTErrorCodeInternal                                = -74,
    LTErrorCodeQFactor                                 = -21,
    LTErrorCodeInvalidHandle                           = -261,
    LTErrorCodeBadPointer                              = -60,
    LTErrorCodeGray32Unsupported                       = -1364,
    LTErrorCodeInvalidLutLength                        = -1486,
    LTErrorCodeInvalidDib                              = -1491,
    LTErrorCodeBitmapFormatUnsupported                 = -1541,
    LTErrorCodeInvalidYuvFormat                        = -1782,
    LTErrorCodeInvalidYuvSize                          = -1783,
    LTErrorCodeInvalidUnicodeString                    = -1851,
    LTErrorCodeInvalidFileHandle                       = -1852,
    LTErrorCodeTempFileDiskDisabled                    = -1853,
    LTErrorCodeInvalidIndex                            = -1860,
    LTErrorCodeGdiError                                = -1861,
    LTErrorCodeBitmapTooBig                            = -1906,

    LTErrorCodeSuccessAbort                            = 2,
    LTErrorCodeUserAbort                               = -100,
    LTErrorCodeNormalAbort                             = -29,
    
    LTErrorCodeNoMemory                                = -1,
    LTErrorCodeMemoryTooLow                            = -3,
       LTErrorCodeMemoryLimit                          = -1905,

    LTErrorCodeFeatureNotSupported                     = -16,
    LTErrorCodeFeatureNotSupportedOnThisPlatform       = -1858,
    LTErrorCodeDocumentNotEnabled                      = -143,
    LTErrorCodeMedicalNotEnabled                       = -314,
    LTErrorCodeProNotEnabled                           = -930,
    LTErrorCodeLzwLocked                               = -146,
    LTErrorCodeJbigNotEnabled                          = -315,
    LTErrorCodeJbig2Locked                             = -1362,
    LTErrorCodeJ2kLocked                               = -542,
    LTErrorCodePdfNotEnabled                           = -408,
    LTErrorCodeCmwLocked                               = -354,
    LTErrorCodeAbcLocked                               = -1361,
    LTErrorCodeMedicalNetNotEnabled                    = -318,
    LTErrorCodeNitfLocked                              = -1363,
    LTErrorCodeDicomNotEnabled                         = -803,
    LTErrorCodeJpipLocked                              = -1477,
    LTErrorCodeFormsLocked                             = -1478,
    LTErrorCodeDocumentWritersNotEnabled               = -1493,
    LTErrorCodeMediaWriterNotEnabled                   = -1494,
    LTErrorCodeDocumentWritersPdfNotEnabled            = -1495,
    LTErrorCodeLeadPrinterNotEnabled                   = -1535,
    LTErrorCodeLeadPrinterServerNotEnabled             = -1536,
    LTErrorCodeLeadPrinterNetworkNotEnabled            = -1628,
    LTErrorCodeAppStoreNotEnabled                      = -1750,
    LTErrorCodeBasicNotEnabled                         = -1751,
    LTErrorCodeNoServerLicense                         = -1752,
    LTErrorCodeMediaStreamingNotEnabled                = -1775,
    LTErrorCodeSvgNotEnabled                           = -1873,
    LTErrorCodeAnnotationsNotEnabled                   = -1874,
    LTErrorCodeDocumentEditingNotEnabled               = -1897,
    
    LTErrorCodeNoLicense                               = -1790,
    LTErrorCodeInvalidLicense                          = -1754,
    LTErrorCodeInvalidServerLicense                    = -1755,
    LTErrorCodeUserNotRegisteredForServerLicense       = -1756,
    LTErrorCodeAppNotRegisteredForServerLicense        = -1757,
    LTErrorCodeConnectionToLicenseServerFailed         = -1758,
    LTErrorCodeServerLicenseNotActivated               = -1759,
    LTErrorCodeInvalidLicenseVersion                   = -1785,
    
    LTErrorCodeFileNotFound                            = -10,
    LTErrorCodeFileOpen                                = -14,
    LTErrorCodeFileWrite                               = -5,
    LTErrorCodeFileGone                                = -6,
    LTErrorCodeFileRead                                = -7,
    LTErrorCodeFileSeek                                = -4,
    LTErrorCodeDiskIsFull                              = -295,
    LTErrorCodeFileReadOnly                            = -805,
    LTErrorCodeFileWriteOnly                           = -1854,
    LTErrorCodeFileFormat                              = -9,
    LTErrorCodeInvalidFileName                         = -8,
    LTErrorCodeFileCreate                              = -1490,
    LTErrorCodeMaxOpenFiles                            = -1786,
    LTErrorCodeFileAccessDenined                       = -1846,
    LTErrorCodeFileDelete                              = -1847,
    LTErrorCodeFolderCreate                            = -1849,
    LTErrorCodeFileNameAlreadyRegistered               = -1850,
    LTErrorCodeTooManyTempFiles                        = -1894,
    
    LTErrorCodeCodecIgnored                            = -1841,
    LTErrorCodeDxfCodecMissing                         = -309,
    LTErrorCodeJbigCodecMissing                        = -319,
    LTErrorCodeWmfCodecMissing                         = -349,
    LTErrorCodeCmwCodecMissing                         = -355,
    LTErrorCodeCmpCodecMissing                         = -356,
    LTErrorCodeFaxCodecMissing                         = -357,
    LTErrorCodePdfCodecMissing                         = -358,
    LTErrorCodeTifCodecMissing                         = -359,
    LTErrorCodeDcrCodecMissing                         = -819,
    LTErrorCodeKdcCodecMissing                         = -820,
    LTErrorCodeDcsCodecMissing                         = -821,
    LTErrorCodeAbcCodecMissing                         = -822,
    LTErrorCodeAbiCodecMissing                         = -823,
    LTErrorCodeJb2CodecMissing                         = -824,
    LTErrorCodeJ2kCodecMissing                         = -541,
    LTErrorCodePngCodecMissing                         = -825,
    LTErrorCodeColorConversionFrameworkMissing         = -807,
    LTErrorCodeVectorKernelMissing                     = -353,
    LTErrorCodeSegmentationFrameworkMissing            = -818,
    LTErrorCodeImageProcessingFrameworkMissing         = -1480,
    LTErrorCodeCodecsFrameworkMissing                  = -1483,
    LTErrorCodeDicomFrameworkMissing                   = -1485,
    LTErrorCodeDocumentWriterMissing                   = -1788,
    LTErrorCodeDrawingFrameworkMissing                 = -1784,
    LTErrorCodeDrawingMPFrameworkMissing               = -1826,
    LTErrorCodeSpecialEffectsFrameworkMissing          = -1791,
    LTErrorCodeMrcFrameworkMissing                     = -1793,
    LTErrorCodePdfCompressorFrameworkMissing           = -1794,
    LTErrorCodeCreditCardFrameworkMissing              = -1795,
    LTErrorCodePdfFrameworkMissing                     = -1796,
    LTErrorCodeBmpCodecMissing                         = -1496,
    LTErrorCodeRawCodecMissing                         = -1497,
    LTErrorCodeClrCodecMissing                         = -900,
    LTErrorCodeRtfCodecMissing                         = -1537,
    LTErrorCodePdfUtilitiesMissing                     = -1540,
    LTErrorCodeCgmCodecMissing                         = -1543,
    LTErrorCodeClpCodecMissing                         = -1544,
    LTErrorCodeCrwCodecMissing                         = -1545,
    LTErrorCodeDrwCodecMissing                         = -1547,
    LTErrorCodeDwfCodecMissing                         = -1548,
    LTErrorCodeDwgCodecMissing                         = -1549,
    LTErrorCodeEpsCodecMissing                         = -1550,
    LTErrorCodeFitCodecMissing                         = -1551,
    LTErrorCodeFlcCodecMissing                         = -1552,
    LTErrorCodeGifCodecMissing                         = -1553,
    LTErrorCodeHdpCodecMissing                         = -1554,
    LTErrorCodeIffCodecMissing                         = -1555,
    LTErrorCodeJp2CodecMissing                         = -1556,
    LTErrorCodeJpmCodecMissing                         = -1557,
    LTErrorCodeCinCodecMissing                         = -1558,
    LTErrorCodeLmbCodecMissing                         = -1559,
    LTErrorCodeMifCodecMissing                         = -1560,
    LTErrorCodeMngCodecMissing                         = -1561,
    LTErrorCodeMspCodecMissing                         = -1562,
    LTErrorCodeNtfCodecMissing                         = -1563,
    LTErrorCodePcdCodecMissing                         = -1564,
    LTErrorCodePcxCodecMissing                         = -1565,
    LTErrorCodePsdCodecMissing                         = -1566,
    LTErrorCodePspCodecMissing                         = -1567,
    LTErrorCodeRasCodecMissing                         = -1568,
    LTErrorCodeSffCodecMissing                         = -1569,
    LTErrorCodeSgiCodecMissing                         = -1570,
    LTErrorCodeSgmCodecMissing                         = -1571,
    LTErrorCodeShpCodecMissing                         = -1572,
    LTErrorCodeSnpCodecMissing                         = -1574,
    LTErrorCodeSvgCodecMissing                         = -1575,
    LTErrorCodeTdbCodecMissing                         = -1576,
    LTErrorCodeTgaCodecMissing                         = -1577,
    LTErrorCodeVecCodecMissing                         = -1578,
    LTErrorCodeVpgCodecMissing                         = -1579,
    LTErrorCodeWfxCodecMissing                         = -1580,
    LTErrorCodeWmzCodecMissing                         = -1581,
    LTErrorCodeWpgCodecMissing                         = -1582,
    LTErrorCodeXpsCodecMissing                         = -1583,
    LTErrorCodeXwdCodecMissing                         = -1584,
    LTErrorCodeItgCodecMissing                         = -1585,
    LTErrorCodeVffCodecMissing                         = -1586,
    LTErrorCodeJxrCodecMissing                         = -1587,
    LTErrorCodeJlsCodecMissing                         = -1588,
    LTErrorCodeDcfCodecMissing                         = -1589,
    LTErrorCodeHtmCodecMissing                         = -1595,
    LTErrorCodeMobCodecMissing                         = -1596,
    LTErrorCodePubCodecMissing                         = -1597,
    LTErrorCodeIngCodecMissing                         = -1598,
    LTErrorCodePstCodecMissing                         = -1773,
    LTErrorCodeXmpCodecMissing                         = -1776,
    LTErrorCodeX9fCodecMissing                         = -1777,
    LTErrorCodeThreeJSCodecMissing                     = -1789,
    LTErrorCodeStlCodecMissing                         = -1835,
    LTErrorCodeTxtCodecMissing                         = -1792,
    LTErrorCodeCmxCodecMissing                         = -1797,
    LTErrorCodeDgnCodecMissing                         = -1798,
    LTErrorCodeE00CodecMissing                         = -1799,
    LTErrorCodeGbrCodecMissing                         = -1827,
    LTErrorCodeNapCodecMissing                         = -1828,
    LTErrorCodePclCodecMissing                         = -1829,
    LTErrorCodePctCodecMissing                         = -1830,
    LTErrorCodeAfpCodecMissing                         = -1831,
    LTErrorCodeCalCodecMissing                         = -1832,
    LTErrorCodeIcaCodecMissing                         = -1833,
    LTErrorCodeLmaCodecMissing                         = -1834,
    LTErrorCodePtkCodecMissing                         = -1808,
    LTErrorCodeDocCodecMissing                         = -1809,
    LTErrorCodeDoxCodecMissing                         = -1810,
    LTErrorCodePptCodecMissing                         = -1811,
    LTErrorCodePpxCodecMissing                         = -1812,
    LTErrorCodeXlsCodecMissing                         = -1813,
    LTErrorCodeXlxCodecMissing                         = -1814,
    LTErrorCodePnmCodecMissing                         = -1815,
    LTErrorCodeWmpCodecMissing                         = -1816,
    LTErrorCodeCutCodecMissing                         = -1817,
    LTErrorCodeImgCodecMissing                         = -1818,
    LTErrorCodeMacCodecMissing                         = -1819,
    LTErrorCodeSmpCodecMissing                         = -1820,
    LTErrorCodeXpmCodecMissing                         = -1821,
    LTErrorCodeAnzCodecMissing                         = -1822,
    LTErrorCodeSctCodecMissing                         = -1823,
    LTErrorCodeTfxCodecMissing                         = -1824,
    LTErrorCodeAniCodecMissing                         = -1825,
    LTErrorCodeEcwCodecMissing                         = -1842,
    LTErrorCodeFpxCodecMissing                         = -1843,
    LTErrorCodeLibreOfficeMissing                      = -1946,
    LTErrorCodeOdfCodecMissing                         = -1944,
    LTErrorCodeOdfEngineMissing                        = -1945,
    LTErrorCodeAwdCodecMissing                         = -1844,
    LTErrorCodeXbmCodecMissing                         = -1845,
    LTErrorCodeBarcode1dWriteMissing                   = -1836,
    LTErrorCodeBarcodePdfWriteMissing                  = -1837,
    LTErrorCodeBarcodeDatamatrixWriteMissing           = -1838,
    LTErrorCodeBarcodeQrWriteMissing                   = -1839,
    LTErrorCodeBarcode2dWriteMissing                   = -1840,
    LTErrorCodeWebKitEngineMissing                     = -1857,
    LTErrorCodeOpenSSLDllMissing                       = -1864,
    LTErrorCodeIcrMissing                              = -1875,
    LTErrorCodeMLMissing                               = -1878,
    LTErrorCodeHeicCodecMissing                        = -1883,
    
    LTErrorCodeNoOverlay                               = -815,
    LTErrorCodeOverlayIndex                            = -816,
    
    LTErrorCodeAllPagesOutRange                        = -1896,
    LTErrorCodeWindowSize                              = -28,
    LTErrorCodeInvalidCodecName                        = -1353,
    LTErrorCodePageNotFound                            = -310,
    LTErrorCodeDeleteLastPage                          = -311,
    LTErrorCodeImageType                               = -12,
    LTErrorCodeBadDecodeState                          = -77,
    LTErrorCodeLayerMissing                            = -800,
    LTErrorCodeOutputType                              = -23,
    LTErrorCodeVersionNumber                           = -78,
    LTErrorCodeChannelMissing                          = -1492,
    LTErrorCodeFileSizeTooBig                          = -1778,
    LTErrorCodeFormatMismatch                          = -1779,
    LTErrorCodeFileInfoUpdated                         = -1780,
    LTErrorCodeInvalidPageNumbers                      = -1787,
    LTErrorCodeNoPages                                 = -1848,
    LTErrorCodeFileCorrupted                           = -1859,
    LTErrorCodeFileOperationFailed                     = -1863,
    LTErrorCodeAttachmentNotFound                      = -1869,
    LTErrorCodeNoAttachments                           = -1870,
    LTErrorCodeEncrypted                               = -1876,
    LTErrorCodeRedirectToFilter                        = -1877,
    LTErrorCodeNoExifMetadata                          = -1893,
    
    LTErrorCodeJp2Failure                              = -530,
    LTErrorCodeJp2Signature                            = -531,
    LTErrorCodeJp2Unsupported                          = -532,
    LTErrorCodeJ2kFailure                              = -533,
    LTErrorCodeJ2kNoSoc                                = -534,
    LTErrorCodeJ2kNoSot                                = -535,
    LTErrorCodeJ2kInformationSet                       = -536,
    LTErrorCodeJ2kLowTargetSize                        = -537,
    LTErrorCodeJ2kDecompositionLevel                   = -538,
    LTErrorCodeJ2kMarkerValue                          = -539,
    LTErrorCodeJ2kUnsupported                          = -540,
    LTErrorCodeJ2kBoxNotAvailable                      = -1501,
    
    LTErrorCodeNoStamp                                 = -65,
    LTErrorCodeInvalidStampSize                        = -141,
    LTErrorCodeBadStamp                                = -142,
    
    LTErrorCodeBadMarker                               = -801,
    LTErrorCodeBadResyncMarker                         = -806,
    LTErrorCodeMarkerSizeTooBig                        = -808,
    LTErrorCodeMarkerMissing                           = -809,
    LTErrorCodeMarkerIndex                             = -811,
    
    LTErrorCodeAudioMissing                            = -802,
    LTErrorCodeExtensionsMissing                       = -810,
    
    LTErrorCodeNoChange                                = -145,
    LTErrorCodeImageSize                               = -910,
    LTErrorCodeNoMessage                               = -911,
    LTErrorCodeInvalidPassword                         = -912,
    LTErrorCodeNotEnoughImages                         = -92,
    
    LTErrorCodeUnknownCompression                      = -15,
    LTErrorCodeCompactAborted                          = -917,
    LTErrorCodeBadTag                                  = -140,
    LTErrorCodeTagMissing                              = -404,
    LTErrorCodeTagValueTooBig                          = -1781,
    
    LTErrorCodeCUBusy                                  = -31,
    LTErrorCodeInvalidTableType                        = -32,
    LTErrorCodeInvalidBuffer                           = -34,
    LTErrorCodeMissingTileData                         = -35,
    LTErrorCodeInvalidQValue                           = -36,
    LTErrorCodeInvalidData                             = -37,
    LTErrorCodeInvalidCompressedType                   = -38,
    LTErrorCodeInvalidComponentNumber                  = -39,
    LTErrorCodeInvalidPixelType                        = -40,
    LTErrorCodeInvalidPixelSampling                    = -41,
    LTErrorCodeInvalidImageDimensions                  = -44,
    LTErrorCodeInvalidTileDimension                    = -45,
    LTErrorCodeInvalidPixBufferDimensions              = -46,
    LTErrorCodeSegmentOverflow                         = -47,
    LTErrorCodeInvalidSubsampling                      = -48,
    LTErrorCodeInvalidQVisTable                        = -49,
    LTErrorCodeInvalidDCCodeTable                      = -50,
    LTErrorCodeInvalidACCodeTable                      = -51,
    LTErrorCodeInsufficientData                        = -52,
    LTErrorCodeMissingFunctionPointer                  = -53,
    LTErrorCodeTooManyDCCodeTables                     = -54,
    LTErrorCodeTooManyACCodeTables                     = -55,
    LTErrorCodeInvalidSubImage                         = -56,
    LTErrorCodeInvalidAbortion                         = -57,
    LTErrorCodeCUNoSupport                             = -58,
    LTErrorCodeCUFailure                               = -59,
    LTErrorCodeCompressedDataFailure                   = -62,
    
    LTErrorCodeInvalidColorspace                       = -918,
    LTErrorCodeInvalidFormat                           = -785,
    LTErrorCodeUnsupportedMethod                       = -786,
    LTErrorCodeOpeningProfile                          = -787,
    LTErrorCodeInvalidColorProfile                     = -788,
    LTErrorCodeUVNotMultiples                          = -791,
    LTErrorCodeNoNonplanarVerticalSubsamplingSupported = -792,
    LTErrorCodePlanarAlignmentNotSupported             = -793,
    LTErrorCodeUnsupportedConversion                   = -794,
    LTErrorCodeTruncateHeight                          = -795,
    LTErrorCodeTruncateWidth                           = -796,
    LTErrorCodeTruncateWidthAndHeight                  = -797,
    LTErrorColorConversionDllInvalid                   = -1870,
    
    LTErrorCodeICCUnknownTag                           = -1150,
    LTErrorCodeICCUnknownType                          = -1151,
    LTErrorCodeICCUnknownTagAndType                    = -1152,
    LTErrorCodeInvalidICCProfile                       = -1153,
    LTErrorCodeICCImageNotSupported                    = -1154,
    LTErrorCodeNoProfile                               = -812,
    LTErrorCodeCorruptProfile                          = -817,
    LTErrorCodeDecodingProfile                         = -813,
    
    LTErrorCodePdfFileEncrypted                        = -721,
    LTErrorCodePdfInvalidPassword                      = -722,
    LTErrorCodePdfFaxNotEnabled                        = -723,
    LTErrorCodePdfJpegNotEnabled                       = -724,
    LTErrorCodePdfInvDocStructuringComments            = -725,
    LTErrorCodePdfFontsDirectoryNotFound               = -726,
    LTErrorCodePdfCannotEditFile                       = -727,
    LTErrorCodePdfBadContent                           = -728,
    LTErrorCodePdfBadInitializationFiles               = -729,
    LTErrorCodePdfBadInterpageLinks                    = -1599,
    
    LTErrorCodePreProcessBadState                      = -1503,
    LTErrorCodePreProcessInit                          = -1504,
    LTErrorCodePreProcessCantScaleEdgeSteps            = -1505,
    LTErrorCodePreProcessWrongWord                     = -1506,
    LTErrorCodePreProcessCantFindPointBand             = -1507,
    LTErrorCodePreProcessUnmatchedBlockRight           = -1508,
    LTErrorCodePreProcessUnmatchedBlockLeft            = -1509,
    LTErrorCodePreProcessUnmatchedBlockRightRemaining  = -1510,
    LTErrorCodePreProcessCodesIllegalsum               = -1511,
    LTErrorCodePreProcessIllegalSampleSize             = -1512,
    LTErrorCodePreProcessIllegalCircularSpec           = -1513,
    LTErrorCodePreProcessIllegalEssentialSpec          = -1514,
    LTErrorCodePreProcessIllegalMinMaxSpec             = -1515,
    LTErrorCodePreProcessIllegalSampleCount            = -1516,
    LTErrorCodePreProcessIllegalMeadnSpec              = -1517,
    LTErrorCodePreProcessIllegalVarianceSpec           = -1518,
    LTErrorCodePreProcessIllegalDistribution           = -1519,
    LTErrorCodePreProcessIllegalSignificanceSpec       = -1520,
    LTErrorCodePreProcessIllegalStyleSpec              = -1521,
    LTErrorCodePreProcessIllegalFloat                  = -1522,
    LTErrorCodePreProcessIllegalNumSets                = -1523,
    LTErrorCodePreProcessIllegalShortName              = -1524,
    LTErrorCodePreProcessIllegalFeatureParam           = -1525,
    LTErrorCodePreProcessIllegalNumFeatures            = -1526,
    LTErrorCodePreProcessHeapFull                      = -1527,
    LTErrorCodePreProcessIllegalAmbiguitySpecification = -1528,
    LTErrorCodePreProcessInvalidUnicodeCharset         = -1529,
    LTErrorCodePreProcessBadOkMode                     = -1530,
    LTErrorCodePreProcessBadRejectMode                 = -1531,
    LTErrorCodePreProcessReadingTemplateFile           = -1532,
    LTErrorCodePreProcessReadingEdgesFile              = -1533,
    LTErrorCodePreProcessCantOpenChoiceFile            = -1534,
    
    LTErrorCodeMedicalViewerActionNotAdded             = -1538,
    LTErrorCodeMedicalViewerActionAlreadyAdded         = -1539,
    
    LTErrorCodeSvgFileSizeRead                         = -770,
    LTErrorCodeSvgRootNotFound                         = -771,
    LTErrorCodeSvgInvalidElement                       = -773,
    LTErrorCodeSvgDuplicatedAttribute                  = -774,
    LTErrorCodeSvgInvalidAttribute                     = -775,
    LTErrorCodeSvgInvalidAttributeValue                = -776,
    LTErrorCodeSvgBadCssProperty                       = -777,
    LTErrorCodeSvgMissingRequiredAttribute             = -778,
    LTErrorCodeSvgDuplicatedID                         = -779,
    LTErrorCodeSvgInvalidCoordinatesNumber             = -780,
    LTErrorCodeSvgInvalidStringComma                   = -781,
    LTErrorCodeSvgAttributeNotFound                    = -782,
    LTErrorCodeSvgFileNotFlat                          = -783,
    
    LTErrorCodeOcrNotEnabled                           = -1760,
    LTErrorCodeOcrPdfNotEnabled                        = -1761,
    LTErrorCodeOcrOmrNotEnabled                        = -1762,
    LTErrorCodeOcrEngineNotStarted                     = -1763,
    LTErrorCodeOcrLanguageNotSupported                 = -1764,
    LTErrorCodeOcrComponentMissing                     = -1765,
    LTErrorCodeOcrInvalidSettingName                   = -1766,
    LTErrorCodeOcrInvalidSettingType                   = -1767,
    LTErrorCodeOcrInvalidSettingValue                  = -1768,
    LTErrorCodeOcrInvalidZoneType                      = -1769,
    LTErrorCodeOcrInitialization                       = -1770,
    LTErrorCodeOcrError                                = -1771,
    LTErrorCodeOcrSpellcheckerNotFound                 = -1772,
    LTErrorCodeOcrMultipleAsianLanguagesNotAllowed     = -1774,
    LTErrorCodeOcrZoneOutsideBitmap                    = -1867,

    LTErrorCodeDocWrtInvalidAltoXmlIndentation         = -1866,

    LTErrorCodeHeifGettingItemData                     = -1879,
    LTErrorCodeHeifTilesDifferentSize                  = -1880,
    LTErrorCodeHeifInvalidGridData                     = -1881,
    LTErrorCodeHeifInvalidCompressionParams            = -1882,
    LTErrorCodeHeifInvalidBoxSize                      = -1884,
    LTErrorCodeHeifComponentsHaveDifferentBitDepths    = -1885,
    LTErrorCodeHeifInvalidExifMetadata                 = -1886,
    LTErrorCodeHeifUnsupportedImageType                = -1887,
    LTErrorCodeHeifReferencesMissing                   = -1888,
    LTErrorCodeHeifEncoderFailure                      = -1889,
    LTErrorCodeHeifUnsupportedChromaFormat             = -1890,
    LTErrorCodeHeifDecoderFailure                      = -1891,
    LTErrorCodeHeifCompressedDataHasNoFrame            = -1892
};
    
NS_ASSUME_NONNULL_BEGIN
    
LEADTOOLS_EXPORT NSErrorDomain const LTErrorDomain;
LEADTOOLS_EXPORT NSExceptionName const LeadtoolsException;

LEADTOOLS_EXPORT NSError *LTErrorWithCode(LTErrorCode code) NS_SWIFT_UNAVAILABLE("use NSError.init(leadtoolsError:) instead");
LEADTOOLS_EXPORT NSException *LTExceptionWithCode(LTErrorCode code) NS_SWIFT_UNAVAILABLE("use NSException.init(leadtoolsError:) instead");

@interface NSError (LTErrorCode)

- (instancetype)initWithLeadtoolsError:(LTErrorCode)code;
+ (NSError *)errorWithLeadtoolsError:(LTErrorCode)code OBJC_SWIFT_UNAVAILABLE("use object initializers instead");

@end

@interface NSException (LTErrorCode)

- (instancetype)initWithLeadtoolsError:(LTErrorCode)code;
+ (NSException *)exceptionWithLeadtoolsError:(LTErrorCode)code OBJC_SWIFT_UNAVAILABLE("use object initializers instead");

@end
    
NS_ASSUME_NONNULL_END
