/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.common;

public class PDFNetException
extends Exception {
    protected String cond_expr;
    protected String file_name;
    protected long line_number;
    protected String function;
    protected String message;
    protected long error_code;
    public static final long e_error_general = 0L;
    public static final long e_error_network = 1L;
    public static final long e_error_credentials = 2L;
    public static final long e_error_num = 3L;

    private PDFNetException(String string) {
        String[] stringArray = string.split("%%%");
        if (stringArray.length == 5) {
            this.cond_expr = stringArray[0];
            this.line_number = Long.parseLong(stringArray[1]);
            this.file_name = stringArray[2];
            this.function = stringArray[3];
            this.message = stringArray[4];
        } else if (stringArray.length == 6) {
            this.cond_expr = stringArray[0];
            this.line_number = Long.parseLong(stringArray[1]);
            this.file_name = stringArray[2];
            this.function = stringArray[3];
            this.message = stringArray[4];
            this.error_code = Long.parseLong(stringArray[5]);
        } else {
            this.message = string;
            this.line_number = 0L;
        }
    }

    public PDFNetException(String string, long l, String string2, String string3, String string4) {
        this.cond_expr = string;
        this.line_number = l;
        this.file_name = string2;
        this.function = string3;
        this.message = string4;
        this.error_code = 0L;
    }

    public PDFNetException(String string, long l, String string2, String string3, String string4, long l2) {
        this.cond_expr = string;
        this.line_number = l;
        this.file_name = string2;
        this.function = string3;
        this.message = string4;
        this.error_code = l2;
    }

    public String getCondExpr() {
        return this.cond_expr;
    }

    public String getFileName() {
        return this.file_name;
    }

    public int getLineNumber() {
        return (int)this.line_number;
    }

    public String getFunction() {
        return this.function;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public long getErrorCode() {
        return this.error_code;
    }

    @Override
    public String toString() {
        if (this.line_number != 0L) {
            return "Exception: \n\t Message: " + this.getMessage() + "\n\t Conditional expression: " + this.getCondExpr() + "\n\t Filename   : " + this.getFileName() + "\n\t Function   : " + this.getFunction() + "\n\t Linenumber : " + this.getLineNumber() + "\n\t Error code : " + this.getErrorCode() + "\n";
        }
        return super.toString();
    }
}

