/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.crypto;

import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.ObjectIdentifier;
import com.pdftron.crypto.X501AttributeTypeAndValue;
import com.pdftron.helpers.ReachabilityHelper;

public class X501DistinguishedName
implements AutoCloseable {
    private long mImpl;

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            X501DistinguishedName.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public X501DistinguishedName(long l) {
        this.mImpl = l;
    }

    public boolean hasAttribute(ObjectIdentifier objectIdentifier) throws PDFNetException {
        boolean bl = X501DistinguishedName.HasAttribute(this.mImpl, objectIdentifier.__GetHandle());
        ReachabilityHelper.ensureReachable(objectIdentifier);
        return bl;
    }

    public String[] getStringValuesForAttribute(ObjectIdentifier objectIdentifier) throws PDFNetException {
        String[] stringArray = X501DistinguishedName.GetStringValuesForAttribute(this.mImpl, objectIdentifier.__GetHandle());
        ReachabilityHelper.ensureReachable(objectIdentifier);
        return stringArray;
    }

    public X501AttributeTypeAndValue[] getAllAttributesAndValues() throws PDFNetException {
        long[] lArray = X501DistinguishedName.GetAllAttributesAndValues(this.mImpl);
        X501AttributeTypeAndValue[] x501AttributeTypeAndValueArray = new X501AttributeTypeAndValue[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            x501AttributeTypeAndValueArray[i] = new X501AttributeTypeAndValue(lArray[i]);
        }
        return x501AttributeTypeAndValueArray;
    }

    public long __GetHandle() {
        return this.mImpl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native boolean HasAttribute(long var0, long var2);

    static native String[] GetStringValuesForAttribute(long var0, long var2);

    static native long[] GetAllAttributesAndValues(long var0);
}

