/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.Matrix2D;
import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.CharIterator;
import com.pdftron.pdf.ColorSpace;
import com.pdftron.pdf.GState;
import com.pdftron.pdf.PathData;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.Shading;
import com.pdftron.pdf.struct.SElement;
import com.pdftron.sdf.Obj;

public class Element {
    public static final int e_null = 0;
    public static final int e_path = 1;
    public static final int e_text_begin = 2;
    public static final int e_text = 3;
    public static final int e_text_new_line = 4;
    public static final int e_text_end = 5;
    public static final int e_image = 6;
    public static final int e_inline_image = 7;
    public static final int e_shading = 8;
    public static final int e_form = 9;
    public static final int e_group_begin = 10;
    public static final int e_group_end = 11;
    public static final int e_marked_content_begin = 12;
    public static final int e_marked_content_end = 13;
    public static final int e_marked_content_point = 14;
    long impl;
    private Object ref;
    private Object doc_ref;

    public int getType() throws PDFNetException {
        return Element.GetType(this.impl);
    }

    public GState getGState() throws PDFNetException {
        return new GState(Element.GetGState(this.impl), this.ref, this.doc_ref);
    }

    public Matrix2D getCTM() throws PDFNetException {
        return Matrix2D.__Create(Element.GetCTM(this.impl));
    }

    public Rect getBBox() throws PDFNetException {
        long l = Element.GetBBox(this.impl);
        if (l == 0L) {
            return null;
        }
        return new Rect(l);
    }

    public SElement getParentStructElement() throws PDFNetException {
        return SElement.__Create(Element.GetParentStructElement(this.impl), this);
    }

    public int getStructMCID() throws PDFNetException {
        return Element.GetStructMCID(this.impl);
    }

    public boolean isOCVisible() throws PDFNetException {
        return Element.IsOCVisible(this.impl);
    }

    public boolean isClippingPath() throws PDFNetException {
        return Element.IsClippingPath(this.impl);
    }

    public PathData getPathData() throws PDFNetException {
        double[] dArray = Element.GetPathPoints(this.impl);
        byte[] byArray = Element.GetPathTypes(this.impl);
        return new PathData(true, byArray, dArray);
    }

    public boolean isStroked() throws PDFNetException {
        return Element.IsStroked(this.impl);
    }

    public boolean isFilled() throws PDFNetException {
        return Element.IsFilled(this.impl);
    }

    public boolean isWindingFill() throws PDFNetException {
        return Element.IsWindingFill(this.impl);
    }

    public boolean isClipWindingFill() throws PDFNetException {
        return Element.IsClipWindingFill(this.impl);
    }

    public void setPathClip(boolean bl) throws PDFNetException {
        Element.SetPathClip(this.impl, bl);
    }

    public void setPathData(PathData pathData) throws PDFNetException {
        Element.SetPathPoints(this.impl, pathData.getPoints());
        Element.SetPathTypes(this.impl, pathData.getOperators());
    }

    public void setPathStroke(boolean bl) throws PDFNetException {
        Element.SetPathStroke(this.impl, bl);
    }

    public void setPathFill(boolean bl) throws PDFNetException {
        Element.SetPathFill(this.impl, bl);
    }

    public void setWindingFill(boolean bl) throws PDFNetException {
        Element.SetWindingFill(this.impl, bl);
    }

    public void setClipWindingFill(boolean bl) throws PDFNetException {
        Element.SetClipWindingFill(this.impl, bl);
    }

    public Obj getXObject() throws PDFNetException {
        return Obj.__Create(Element.GetXObject(this.impl), this.doc_ref);
    }

    public Filter getImageData() throws PDFNetException {
        return Filter.__Create(Element.GetImageData(this.impl), null);
    }

    public int getImageDataSize() throws PDFNetException {
        return Element.GetImageDataSize(this.impl);
    }

    public ColorSpace getImageColorSpace() throws PDFNetException {
        return ColorSpace.__Create(Element.GetImageColorSpace(this.impl), this.doc_ref);
    }

    public int getImageWidth() throws PDFNetException {
        return Element.GetImageWidth(this.impl);
    }

    public int getImageHeight() throws PDFNetException {
        return Element.GetImageHeight(this.impl);
    }

    public Obj getDecodeArray() throws PDFNetException {
        return Obj.__Create(Element.GetDecodeArray(this.impl), this.doc_ref);
    }

    public int getBitsPerComponent() throws PDFNetException {
        return Element.GetBitsPerComponent(this.impl);
    }

    public int getComponentNum() throws PDFNetException {
        return Element.GetComponentNum(this.impl);
    }

    public boolean isImageMask() throws PDFNetException {
        return Element.IsImageMask(this.impl);
    }

    public boolean isImageInterpolate() throws PDFNetException {
        return Element.IsImageInterpolate(this.impl);
    }

    public Obj getMask() throws PDFNetException {
        return Obj.__Create(Element.GetMask(this.impl), this.doc_ref);
    }

    public int getImageRenderingIntent() throws PDFNetException {
        return Element.GetImageRenderingIntent(this.impl);
    }

    public String getTextString() throws PDFNetException {
        return Element.GetTextString(this.impl);
    }

    public byte[] getTextData() throws PDFNetException {
        return Element.GetTextData(this.impl);
    }

    public Matrix2D getTextMatrix() throws PDFNetException {
        return Matrix2D.__Create(Element.GetTextMatrix(this.impl));
    }

    public CharIterator getCharIterator() throws PDFNetException {
        return new CharIterator(Element.GetCharIterator(this.impl), this.ref);
    }

    public double getTextLength() throws PDFNetException {
        return Element.GetTextLength(this.impl);
    }

    public double getPosAdjustment() throws PDFNetException {
        return Element.GetPosAdjustment(this.impl);
    }

    public double[] getNewTextLineOffset() throws PDFNetException {
        double[] dArray = Element.GetNewTextLineOffset(this.impl);
        return dArray;
    }

    public boolean hasTextMatrix() throws PDFNetException {
        return Element.HasTextMatrix(this.impl);
    }

    public void setTextData(byte[] byArray) throws PDFNetException {
        Element.SetTextData(this.impl, byArray);
    }

    public void setTextMatrix(Matrix2D matrix2D) throws PDFNetException {
        Element.SetTextMatrix(this.impl, matrix2D.__GetHandle());
        ReachabilityHelper.ensureReachable(matrix2D);
    }

    public void setTextMatrix(double d, double d2, double d3, double d4, double d5, double d6) throws PDFNetException {
        Element.SetTextMatrix(this.impl, d, d2, d3, d4, d5, d6);
    }

    public void setPosAdjustment(double d) throws PDFNetException {
        Element.SetPosAdjustment(this.impl, d);
    }

    public void updateTextMetrics() throws PDFNetException {
        Element.UpdateTextMetrics(this.impl);
    }

    public void setNewTextLineOffset(double d, double d2) throws PDFNetException {
        Element.SetNewTextLineOffset(this.impl, d, d2);
    }

    public Shading getShading() throws PDFNetException {
        return Shading.__Create(Element.GetShading(this.impl), this.doc_ref);
    }

    public Obj getMCPropertyDict() throws PDFNetException {
        return Obj.__Create(Element.GetMCPropertyDict(this.impl), this.doc_ref);
    }

    public Obj getMCTag() throws PDFNetException {
        return Obj.__Create(Element.GetMCTag(this.impl), this.doc_ref);
    }

    Element(long l, Object object, Object object2) {
        this.impl = l;
        this.ref = object;
        this.doc_ref = object2;
    }

    static native int GetType(long var0);

    static native long GetGState(long var0);

    static native long GetCTM(long var0);

    static native long GetBBox(long var0);

    static native long GetParentStructElement(long var0);

    static native int GetStructMCID(long var0);

    static native boolean IsOCVisible(long var0);

    static native boolean IsClippingPath(long var0);

    static native boolean IsStroked(long var0);

    static native boolean IsFilled(long var0);

    static native boolean IsWindingFill(long var0);

    static native boolean IsClipWindingFill(long var0);

    static native byte[] GetPathTypes(long var0);

    static native double[] GetPathPoints(long var0);

    static native void SetPathClip(long var0, boolean var2);

    static native void SetPathStroke(long var0, boolean var2);

    static native void SetPathFill(long var0, boolean var2);

    static native void SetWindingFill(long var0, boolean var2);

    static native void SetClipWindingFill(long var0, boolean var2);

    static native void SetPathPoints(long var0, double[] var2);

    static native void SetPathTypes(long var0, byte[] var2);

    static native long GetXObject(long var0);

    static native long GetImageData(long var0);

    static native int GetImageDataSize(long var0);

    static native long GetImageColorSpace(long var0);

    static native int GetImageWidth(long var0);

    static native int GetImageHeight(long var0);

    static native long GetDecodeArray(long var0);

    static native int GetBitsPerComponent(long var0);

    static native int GetComponentNum(long var0);

    static native boolean IsImageMask(long var0);

    static native boolean IsImageInterpolate(long var0);

    static native long GetMask(long var0);

    static native int GetImageRenderingIntent(long var0);

    static native String GetTextString(long var0);

    static native byte[] GetTextData(long var0);

    static native long GetTextMatrix(long var0);

    static native long GetCharIterator(long var0);

    static native double GetTextLength(long var0);

    static native double GetPosAdjustment(long var0);

    static native double[] GetNewTextLineOffset(long var0);

    static native boolean HasTextMatrix(long var0);

    static native void SetTextData(long var0, byte[] var2);

    static native void SetTextMatrix(long var0, long var2);

    static native void SetTextMatrix(long var0, double var2, double var4, double var6, double var8, double var10, double var12);

    static native void SetPosAdjustment(long var0, double var2);

    static native void UpdateTextMetrics(long var0);

    static native void SetNewTextLineOffset(long var0, double var2, double var4);

    static native long GetShading(long var0);

    static native long GetMCPropertyDict(long var0);

    static native long GetMCTag(long var0);
}

