/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.PDFDoc;
import com.pdftron.pdf.TextRange;

public class Highlights
implements AutoCloseable {
    long impl;
    Object ctx_ref = null;

    public Highlights() {
        this.impl = Highlights.HighlightsCreate();
    }

    public void destroy() {
        if (this.impl != 0L) {
            Highlights.Delete(this.impl);
            this.impl = 0L;
            this.ctx_ref = null;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void load(String string) {
        Highlights.Load(this.impl, string);
    }

    public void save(String string) {
        Highlights.Save(this.impl, string);
    }

    public String saveToString() {
        return Highlights.SaveToString(this.impl);
    }

    public void add(Highlights highlights) {
        Highlights.Add(this.impl, highlights.impl);
        ReachabilityHelper.ensureReachable(highlights);
    }

    public void clear() {
        Highlights.Clear(this.impl);
    }

    public void begin(PDFDoc pDFDoc) {
        Highlights.Begin(this.impl, pDFDoc.__GetHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    public boolean hasNext() {
        return Highlights.HasNext(this.impl);
    }

    public void next() {
        Highlights.Next(this.impl);
    }

    public int getCurrentPageNumber() {
        return Highlights.GetCurrentPageNumber(this.impl);
    }

    public double[] getCurrentQuads() {
        return Highlights.GetCurrentQuads(this.impl);
    }

    public TextRange getCurrentTextRange() {
        return new TextRange(Highlights.GetCurrentTextRange(this.impl), this.ctx_ref);
    }

    public Highlights(long l) {
        this.impl = l;
    }

    @Override
    public void close() {
        this.destroy();
    }

    static native long HighlightsCreate();

    static native void Delete(long var0);

    static native void Load(long var0, String var2);

    static native void Save(long var0, String var2);

    static native String SaveToString(long var0);

    static native void Add(long var0, long var2);

    static native void Clear(long var0);

    static native void Begin(long var0, long var2);

    static native boolean HasNext(long var0);

    static native void Next(long var0);

    static native int GetCurrentPageNumber(long var0);

    static native double[] GetCurrentQuads(long var0);

    static native long GetCurrentTextRange(long var0);
}

