/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.ConnectionErrorProc;
import com.pdftron.pdf.JarResourceExtractor;
import com.pdftron.pdf.NativeLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PDFNet {
    public static final int e_status_err = 0;
    public static final int e_status_ok = 1;
    public static final int e_status_network_err = 2;
    public static final int e_status_bad_Credentials = 3;
    public static final int e_status_service_down = 4;
    public static final int e_status_invalid_operation = 5;
    public static final int e_lcms = 0;
    public static final int e_icm = 1;
    public static final int e_no_cms = 2;
    public static final int e_z_default_compression = -1;
    public static final int e_z_no_compression = 0;
    public static final int e_z_best_speed = 1;
    public static final int e_z_best_compression = 9;
    public static final int e_Identity = 0;
    public static final int e_Japan1 = 1;
    public static final int e_Japan2 = 2;
    public static final int e_GB1 = 3;
    public static final int e_CNS1 = 4;
    public static final int e_Korea1 = 5;
    public static final int e_LogLevel_Off = -1;
    public static final int e_LogLevel_Fatal = 5;
    public static final int e_LogLevel_Error = 4;
    public static final int e_LogLevel_Warning = 3;
    public static final int e_LogLevel_Info = 2;
    public static final int e_LogLevel_Trace = 1;
    public static final int e_LogLevel_Debug = 0;
    public static final int e_ConnectionErrorHandlingMode_continue = 0;
    public static final int e_ConnectionErrorHandlingMode_continue_unless_switching_to_demo = 1;
    public static final int e_ConnectionErrorHandlingMode_stop = 2;

    public static void initialize() {
        PDFNet.initialize(null);
    }

    public static native void initialize(String var0);

    public static native void enableJavaScript(boolean var0);

    public static native boolean isJavaScriptEnabled();

    public static native void terminate();

    public static native boolean setResourcesPath(String var0);

    public static native String getResourcesPath() throws PDFNetException;

    public static native void addResourceSearchPath(String var0);

    public static native void setColorManagement(int var0) throws PDFNetException;

    public static native void setDefaultDeviceCMYKProfile(String var0) throws PDFNetException;

    public static native void setDefaultDeviceRGBProfile(String var0) throws PDFNetException;

    public static native void setDefaultDiskCachingEnabled(boolean var0) throws PDFNetException;

    public static native void setDefaultFlateCompressionLevel(int var0) throws PDFNetException;

    public static native void setViewerCache(int var0, boolean var1);

    public static native boolean addFontSubst(String var0, String var1) throws PDFNetException;

    public static native boolean addFontSubst(int var0, String var1) throws PDFNetException;

    public static native void setTempPath(String var0) throws PDFNetException;

    public static native void setPersistentCachePath(String var0) throws PDFNetException;

    public static native double getVersion() throws PDFNetException;

    public static native void setLogLevel(int var0) throws PDFNetException;

    public static native String getSystemFontList() throws PDFNetException;

    public static native void addPDFTronCustomHandler(int var0) throws PDFNetException;

    public static native void setWriteAPIUsageLocally(boolean var0) throws PDFNetException;

    public static native String getVersionString() throws PDFNetException;

    public static native void setConnectionErrorHandlingMode(int var0) throws PDFNetException;

    public static void setConnectionErrorProc(ConnectionErrorProc connectionErrorProc, Object object) throws PDFNetException {
        PDFNet.SetConnectionErrorProc(connectionErrorProc, object);
    }

    static native void SetConnectionErrorProc(ConnectionErrorProc var0, Object var1);

    static {
        Path path;
        boolean bl = NativeLoader.loadPDFNetCFromJar();
        if (!bl) {
            System.loadLibrary("PDFNetC");
        }
        if ((path = JarResourceExtractor.extractJarResourcesByClassName("com.pdftron.data_extraction.Marker")) != null) {
            Path path2;
            Path path3;
            Path path4 = path.resolve(Paths.get("lib", new String[0]));
            if (Files.exists(path4, new LinkOption[0])) {
                PDFNet.setResourcesPath(path4.toString());
            }
            if (Files.exists(path3 = path4.resolve("TabularData"), new LinkOption[0])) {
                PDFNet.setResourcesPath(path3.toString());
            }
            if (Files.exists(path2 = path4.resolve("AIPageObjectExtractor"), new LinkOption[0])) {
                PDFNet.setResourcesPath(path2.toString());
            }
        }
    }
}

