/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.Matrix2D;
import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.Separation;
import com.pdftron.pdf.ocg.Context;

public class PDFRasterizer
implements AutoCloseable {
    public static final int e_postprocess_none = 0;
    public static final int e_postprocess_invert = 1;
    public static final int e_postprocess_gradient_map = 2;
    public static final int e_postprocess_night_mode = 3;
    long impl = PDFRasterizer.PDFRasterizerCreate();
    long impl_cancel = PDFRasterizer.PDFRasterizerCreateCancelFlag();
    Object ctx_ref = null;

    public void destroy() throws PDFNetException {
        if (this.impl != 0L || this.impl_cancel != 0L) {
            PDFRasterizer.Destroy(this.impl, this.impl_cancel);
            this.impl = 0L;
            this.impl_cancel = 0L;
        }
    }

    public void setAntiAliasing(boolean bl) throws PDFNetException {
        PDFRasterizer.SetAntiAliasing(this.impl, bl);
    }

    public void setCancel(boolean bl) throws PDFNetException {
        PDFRasterizer.SetCancel(this.impl_cancel, bl);
    }

    public void setPathHinting(boolean bl) throws PDFNetException {
        PDFRasterizer.SetPathHinting(this.impl, bl);
    }

    public void setDrawAnnotations(boolean bl) throws PDFNetException {
        PDFRasterizer.SetDrawAnnotations(this.impl, bl);
    }

    public void setHighlightFields(boolean bl) {
        PDFRasterizer.SetHighlightFields(this.impl, bl);
    }

    public void setThinLineAdjustment(boolean bl, boolean bl2) {
        PDFRasterizer.SetThinLineAdjustment(this.impl, bl, bl2);
    }

    public void setImageSmoothing() throws PDFNetException {
        PDFRasterizer.SetImageSmoothing(this.impl, true, false);
    }

    public void setImageSmoothing(boolean bl) throws PDFNetException {
        PDFRasterizer.SetImageSmoothing(this.impl, bl, false);
    }

    public void setImageSmoothing(boolean bl, boolean bl2) throws PDFNetException {
        PDFRasterizer.SetImageSmoothing(this.impl, bl, bl2);
    }

    public void setCaching() throws PDFNetException {
        PDFRasterizer.SetCaching(this.impl, true);
    }

    public void setCaching(boolean bl) throws PDFNetException {
        PDFRasterizer.SetCaching(this.impl, bl);
    }

    public void setGamma(double d) throws PDFNetException {
        PDFRasterizer.SetGamma(this.impl, d);
    }

    public void setOCGContext(Context context) throws PDFNetException {
        this.ctx_ref = context;
        if (context == null) {
            PDFRasterizer.SetOCGContext(this.impl, 0L);
        } else {
            PDFRasterizer.SetOCGContext(this.impl, context.__GetHandle());
            ReachabilityHelper.ensureReachable(context);
        }
    }

    public void setPrintMode(boolean bl) throws PDFNetException {
        PDFRasterizer.SetPrintMode(this.impl, bl);
    }

    public void setOverprint(int n) throws PDFNetException {
        PDFRasterizer.SetOverprint(this.impl, n);
    }

    public void setColorPostProcessMode(int n) {
        PDFRasterizer.SetColorPostProcessMode(this.impl, n);
    }

    public void setColorPostProcessColors(int n, int n2) throws PDFNetException {
        PDFRasterizer.SetColorPostProcessColors(this.impl, n, n2);
    }

    public void setColorPostProcessMapFile(Filter filter) throws PDFNetException {
        PDFRasterizer.SetColorPostProcessMapFile(this.impl, filter.__GetHandle());
        ReachabilityHelper.ensureReachable(filter);
    }

    public int getColorPostProcessMode() {
        return PDFRasterizer.GetColorPostProcessMode(this.impl);
    }

    public void rasterize(Page page, int[] nArray, int n, int n2, boolean bl, Matrix2D matrix2D, Rect rect) throws PDFNetException {
        PDFRasterizer.RasterizeToIntBuffer(this.impl, page.impl, nArray, n, n2, bl, matrix2D.__GetHandle(), rect == null ? 0L : rect.impl, 0L, this.impl_cancel);
        ReachabilityHelper.ensureReachable(page);
        ReachabilityHelper.ensureReachable(matrix2D);
        ReachabilityHelper.ensureReachable(rect);
    }

    public byte[] rasterize(Page page, int n, int n2, int n3, int n4, boolean bl, Matrix2D matrix2D, Rect rect) throws PDFNetException {
        byte[] byArray = new byte[n * n2 * n4];
        PDFRasterizer.Rasterize(this.impl, page.impl, byArray, n, n2, n3, n4, bl, matrix2D.__GetHandle(), rect == null ? 0L : rect.impl);
        ReachabilityHelper.ensureReachable(page);
        ReachabilityHelper.ensureReachable(matrix2D);
        ReachabilityHelper.ensureReachable(rect);
        return byArray;
    }

    public Separation[] rasterizeSeparations(Page page, int n, int n2, Matrix2D matrix2D, Rect rect, boolean bl) throws PDFNetException {
        this.setCancel(bl);
        Separation[] separationArray = PDFRasterizer.RasterizeSeparations(this.impl, page.impl, n, n2, matrix2D.__GetHandle(), rect == null ? 0L : rect.impl, this.impl_cancel);
        ReachabilityHelper.ensureReachable(page);
        ReachabilityHelper.ensureReachable(matrix2D);
        ReachabilityHelper.ensureReachable(rect);
        return separationArray;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long PDFRasterizerCreate();

    static native long PDFRasterizerCreateCancelFlag();

    static native void Destroy(long var0, long var2);

    static native void SetDrawAnnotations(long var0, boolean var2);

    static native void SetHighlightFields(long var0, boolean var2);

    static native void SetAntiAliasing(long var0, boolean var2);

    static native void SetPathHinting(long var0, boolean var2);

    static native void SetThinLineAdjustment(long var0, boolean var2, boolean var3);

    static native void SetImageSmoothing(long var0, boolean var2, boolean var3);

    static native void SetCaching(long var0, boolean var2);

    static native void SetGamma(long var0, double var2);

    static native void SetOCGContext(long var0, long var2);

    static native void SetPrintMode(long var0, boolean var2);

    static native void SetOverprint(long var0, int var2);

    static native void SetDefaultPageColor(long var0, byte var2, byte var3, byte var4);

    static native void SetCancel(long var0, boolean var2);

    static native void SetColorPostProcessMode(long var0, int var2);

    static native void SetColorPostProcessColors(long var0, int var2, int var3);

    static native void SetColorPostProcessMapFile(long var0, long var2);

    static native int GetColorPostProcessMode(long var0);

    static native void Rasterize(long var0, long var2, byte[] var4, int var5, int var6, int var7, int var8, boolean var9, long var10, long var12);

    static native void RasterizeWithCancel(long var0, long var2, byte[] var4, int var5, int var6, int var7, int var8, boolean var9, long var10, long var12, long var14);

    static native void RasterizeToIntBuffer(long var0, long var2, int[] var4, int var5, int var6, boolean var7, long var8, long var10, long var12, long var14);

    static native Separation[] RasterizeSeparations(long var0, long var2, int var4, int var5, long var6, long var8, long var10);
}

