/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.Matrix2D;
import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Annot;
import com.pdftron.pdf.ColorPt;
import com.pdftron.pdf.CurrentPageProc;
import com.pdftron.pdf.ErrorReportProc;
import com.pdftron.pdf.ExternalAnnotManager;
import com.pdftron.pdf.Field;
import com.pdftron.pdf.FindTextProc;
import com.pdftron.pdf.Highlights;
import com.pdftron.pdf.PDFDoc;
import com.pdftron.pdf.PDFViewScrollPane;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.RequestRenderInWorkerThreadProc;
import com.pdftron.pdf.ThumbAsyncHandler;
import com.pdftron.pdf.ViewCallback;
import com.pdftron.pdf.ViewChangeCollection;
import com.pdftron.pdf.__DelayDelete;
import com.pdftron.pdf.__Delete;
import com.pdftron.pdf.ocg.Context;
import com.pdftron.sdf.SDFDoc;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.MemoryImageSource;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class PDFViewCtrl
extends JComponent
implements __Delete,
Scrollable,
AutoCloseable {
    BufferedImage display;
    MemoryImageSource source;
    int tool_mode = 2;
    int click_x = 0;
    int click_y = 0;
    int pos_x = 0;
    int pos_y = 0;
    boolean selected = false;
    int h = 0;
    int v = 0;
    PDFViewScrollPane scrollpane;
    public static final int e_AnnotMgr_UserOnly = 0;
    public static final int e_AnnotMgr_Admin_undoOthers = 1;
    public static final int e_AnnotMgr_Admin_undoOwn = 2;
    Dimension visible_size = new Dimension();
    int[] data;
    long impl;
    long render_data;
    long error_proc;
    long curr_page_proc;
    long findtext_proc;
    long thumb_async_proc;
    long request_render_worker_proc;
    int width;
    int height;
    int stride;
    public static final int e_fit_page = 0;
    public static final int e_fit_width = 1;
    public static final int e_fit_height = 2;
    public static final int e_zoom = 3;
    public static final int e_single_page = 1;
    public static final int e_single_continuous = 2;
    public static final int e_facing = 3;
    public static final int e_facing_continuous = 4;
    public static final int e_facing_cover = 5;
    public static final int e_facing_continuous_cover = 6;
    public static final int e_postprocess_none = 0;
    public static final int e_postprocess_invert = 1;
    public static final int e_custom = 0;
    public static final int e_pan = 1;
    public static final int e_text_rect_select = 2;
    public static final int e_text_struct_select = 3;
    private Thread t;
    private PDFDoc ref;
    private static int maxUnitIncrement = 10;
    private Dimension pref_size = new Dimension(0, 0);

    public PDFViewCtrl() {
        this(600);
    }

    public int getH() {
        return this.h;
    }

    public int getV() {
        return this.v;
    }

    public void setH(int n) {
        this.h = n;
    }

    public void setV(int n) {
        this.v = n;
    }

    public PDFViewScrollPane getViewPane() {
        this.scrollpane.refresh();
        return this.scrollpane;
    }

    public void setToolMode(int n) {
        this.tool_mode = n;
    }

    public PDFViewCtrl(int n) {
        long[] lArray = this.PDFViewCtrlCreate(new ViewCallback());
        this.impl = lArray[0];
        this.render_data = lArray[1];
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                PDFViewCtrl.this.pos_x = mouseEvent.getX();
                PDFViewCtrl.this.pos_y = mouseEvent.getY();
                switch (PDFViewCtrl.this.tool_mode) {
                    case 1: {
                        PDFViewCtrl.this.scrollTo(Math.max(0, PDFViewCtrl.this.click_x - (mouseEvent.getX() + PDFViewCtrl.this.getH())), Math.max(0, PDFViewCtrl.this.click_y - (mouseEvent.getY() + PDFViewCtrl.this.getV())));
                        break;
                    }
                    case 2: {
                        PDFViewCtrl.this.clearSelection();
                        PDFViewCtrl.this.selectByRect(PDFViewCtrl.this.click_x + PDFViewCtrl.this.getX(), PDFViewCtrl.this.click_y + PDFViewCtrl.this.getY(), PDFViewCtrl.this.pos_x + PDFViewCtrl.this.getX(), PDFViewCtrl.this.pos_y + PDFViewCtrl.this.getY());
                        PDFViewCtrl.this.repaint();
                        break;
                    }
                    case 3: {
                        PDFViewCtrl.this.clearSelection();
                        PDFViewCtrl.this.selectByStruct(PDFViewCtrl.this.click_x + PDFViewCtrl.this.getX(), PDFViewCtrl.this.click_y + PDFViewCtrl.this.getY(), PDFViewCtrl.this.pos_x + PDFViewCtrl.this.getX(), PDFViewCtrl.this.pos_y + PDFViewCtrl.this.getY());
                        PDFViewCtrl.this.repaint();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PDFViewCtrl.this.pos_x = mouseEvent.getX();
                PDFViewCtrl.this.pos_y = mouseEvent.getY();
                PDFViewCtrl.this.selected = false;
                switch (PDFViewCtrl.this.tool_mode) {
                    case 1: {
                        PDFViewCtrl.this.setH((int)PDFViewCtrl.this.getHScrollPos() * -1);
                        PDFViewCtrl.this.setV((int)PDFViewCtrl.this.getVScrollPos() * -1);
                        break;
                    }
                    case 2: {
                        PDFViewCtrl.this.clearSelection();
                        PDFViewCtrl.this.selectByRect(PDFViewCtrl.this.click_x + PDFViewCtrl.this.getX(), PDFViewCtrl.this.click_y + PDFViewCtrl.this.getY(), PDFViewCtrl.this.pos_x + PDFViewCtrl.this.getX(), PDFViewCtrl.this.pos_y + PDFViewCtrl.this.getY());
                        PDFViewCtrl.this.repaint();
                        break;
                    }
                    case 3: {
                        PDFViewCtrl.this.clearSelection();
                        PDFViewCtrl.this.selectByStruct(PDFViewCtrl.this.click_x + PDFViewCtrl.this.getX(), PDFViewCtrl.this.click_y + PDFViewCtrl.this.getY(), PDFViewCtrl.this.pos_x + PDFViewCtrl.this.getX(), PDFViewCtrl.this.pos_y + PDFViewCtrl.this.getY());
                        PDFViewCtrl.this.repaint();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PDFViewCtrl.this.clearSelection();
                PDFViewCtrl.this.repaint();
                PDFViewCtrl.this.setH((int)PDFViewCtrl.this.getHScrollPos() * -1);
                PDFViewCtrl.this.setV((int)PDFViewCtrl.this.getVScrollPos() * -1);
                PDFViewCtrl.this.click_x = mouseEvent.getX();
                PDFViewCtrl.this.click_y = mouseEvent.getY();
                PDFViewCtrl.this.pos_x = mouseEvent.getX();
                PDFViewCtrl.this.pos_y = mouseEvent.getY();
                PDFViewCtrl.this.selected = true;
            }
        });
        this.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                PDFViewCtrl.this.onScroll(0, mouseWheelEvent.getUnitsToScroll() * PDFViewCtrl.this.getScrollableUnitIncrement(PDFViewCtrl.this.getVisibleRect(), 1, 1));
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 40) {
                    PDFViewCtrl.this.onScroll(0, PDFViewCtrl.this.getScrollableUnitIncrement(PDFViewCtrl.this.getVisibleRect(), 1, 1));
                } else if (n == 38) {
                    PDFViewCtrl.this.onScroll(0, -1 * PDFViewCtrl.this.getScrollableUnitIncrement(PDFViewCtrl.this.getVisibleRect(), 1, 1));
                } else if (n == 37) {
                    PDFViewCtrl.this.onScroll(-1 * PDFViewCtrl.this.getScrollableUnitIncrement(PDFViewCtrl.this.getVisibleRect(), 0, 1), 0);
                } else if (n == 39) {
                    PDFViewCtrl.this.onScroll(PDFViewCtrl.this.getScrollableUnitIncrement(PDFViewCtrl.this.getVisibleRect(), 0, 1), 0);
                } else if (n == 33) {
                    PDFViewCtrl.this.onScroll(0, -1 * (PDFViewCtrl.this.getVisibleRect().height - PDFViewCtrl.this.getScrollableUnitIncrement(PDFViewCtrl.this.getVisibleRect(), 1, 1)));
                } else if (n == 34) {
                    PDFViewCtrl.this.onScroll(0, PDFViewCtrl.this.getVisibleRect().height - PDFViewCtrl.this.getScrollableUnitIncrement(PDFViewCtrl.this.getVisibleRect(), 1, 1));
                }
            }
        });
        this.width = n;
        this.height = 1;
        this.stride = this.width * 4;
        this.error_proc = 0L;
        this.curr_page_proc = 0L;
        this.findtext_proc = 0L;
        this.thumb_async_proc = 0L;
        this.request_render_worker_proc = 0L;
        this.display = new BufferedImage(this.width, this.height, 2);
        this.data = ((DataBufferInt)this.display.getRaster().getDataBuffer()).getData();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                PDFViewCtrl.this.setDefaultPageColor(Color.WHITE);
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                Rectangle rectangle = PDFViewCtrl.this.getVisibleRect();
                if (rectangle.width > 0 && rectangle.height > 0) {
                    PDFViewCtrl.this.width = rectangle.width;
                    PDFViewCtrl.this.height = rectangle.height;
                    PDFViewCtrl.this.stride = PDFViewCtrl.this.width * 4;
                }
                PDFViewCtrl.OnSize(PDFViewCtrl.this.impl, PDFViewCtrl.this.width, PDFViewCtrl.this.height, PDFViewCtrl.this.stride, true);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.setDoubleBuffered(true);
        this.scrollpane = new PDFViewScrollPane(this);
    }

    public void refreshAndUpdate(ViewChangeCollection viewChangeCollection) throws PDFNetException {
        PDFViewCtrl.RefreshAndUpdate(this.impl, viewChangeCollection.impl);
        ReachabilityHelper.ensureReachable(viewChangeCollection);
    }

    public void setDoc(PDFDoc pDFDoc) {
        PDFViewCtrl.SetDoc(this.impl, pDFDoc.__GetHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        this.height = 1;
        this.ref = pDFDoc;
        this.resize();
        this.scrollpane.refresh();
    }

    public void enableUndoRedo() throws PDFNetException {
        PDFViewCtrl.EnableUndoRedo(this.impl);
    }

    public String undo() throws PDFNetException {
        return PDFViewCtrl.Undo(this.impl);
    }

    public String redo() throws PDFNetException {
        return PDFViewCtrl.Redo(this.impl);
    }

    public boolean hasChangesSinceSnapshot() throws PDFNetException {
        return PDFViewCtrl.HasChangesSinceSnapshot(this.impl);
    }

    public void takeSnapshot(String string) throws PDFNetException {
        PDFViewCtrl.TakeSnapshot(this.impl, string);
    }

    public String getNextUndoInfo() throws PDFNetException {
        return PDFViewCtrl.GetNextUndoInfo(this.impl);
    }

    public String getNextRedoInfo() throws PDFNetException {
        return PDFViewCtrl.GetNextRedoInfo(this.impl);
    }

    public boolean canUndo() throws PDFNetException {
        return PDFViewCtrl.CanUndo(this.impl);
    }

    public boolean canRedo() throws PDFNetException {
        return PDFViewCtrl.CanRedo(this.impl);
    }

    public void revertChangesSinceSnapshot() throws PDFNetException {
        PDFViewCtrl.RevertChangesSinceSnapshot(this.impl);
    }

    public void revertAllChanges() throws PDFNetException {
        PDFViewCtrl.RevertAllChanges(this.impl);
    }

    public ExternalAnnotManager getExternalAnnotManager(String string) throws PDFNetException {
        return new ExternalAnnotManager(PDFViewCtrl.GetExternalAnnotManager(this.impl, string, 2));
    }

    public ExternalAnnotManager getExternalAnnotManager(String string, int n) throws PDFNetException {
        return new ExternalAnnotManager(PDFViewCtrl.GetExternalAnnotManager(this.impl, string, n));
    }

    private void resize() {
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.width = rectangle.width;
            this.height = rectangle.height;
            this.stride = this.width * 4;
        }
        PDFViewCtrl.OnSize(this.impl, this.width, this.height, this.stride, true);
        this.display = new BufferedImage(this.width, this.height, 2);
        this.data = ((DataBufferInt)this.display.getRaster().getDataBuffer()).getData();
        this.setPreferredSize();
        this.revalidate();
        this.scrollTo();
        if (this.scrollpane != null) {
            this.scrollpane.refresh();
        }
    }

    private void setPreferredSize() {
        this.setPreferredSize(this.getInt(PDFViewCtrl.GetCanvasWidth(this.impl)), this.getInt(PDFViewCtrl.GetCanvasHeight(this.impl)));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = this.getVisibleRect();
        if (!rectangle.getSize().equals(this.visible_size)) {
            this.visible_size.setSize(rectangle.width, rectangle.height);
            this.resize();
        } else {
            PDFViewCtrl.GetBuffer(this.impl, this.data);
            this.display.setRGB(0, 0, this.width, this.height, this.data, 0, this.width);
            graphics.drawImage(this.display, 0, 0, this.width, this.height, this);
            if (this.selected && this.tool_mode == 2) {
                graphics.setXORMode(Color.YELLOW);
                if (graphics instanceof Graphics2D) {
                    ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f));
                }
                graphics.drawRect(Math.min(this.click_x, this.pos_x), Math.min(this.click_y, this.pos_y), Math.abs(this.pos_x - this.click_x), Math.abs(this.pos_y - this.click_y));
            }
        }
    }

    @Override
    public int getWidth() {
        int n = this.getInt(PDFViewCtrl.GetCanvasWidth(this.impl));
        return Math.max(n, this.width);
    }

    @Override
    public int getHeight() {
        int n = this.getInt(PDFViewCtrl.GetCanvasHeight(this.impl));
        return Math.max(n, this.height);
    }

    @Override
    public Dimension getSize(Dimension dimension) {
        dimension.setSize(this.width, this.getHeight());
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.impl != 0L) {
            Object v;
            HashMap hashMap = __DelayDelete.destroy_map;
            synchronized (hashMap) {
                v = __DelayDelete.destroy_map.get(this.t);
            }
            if (v != null) {
                hashMap = v;
                synchronized (hashMap) {
                    ((LinkedList)v).add(this);
                }
            }
        }
        if (this.render_data != 0L) {
            PDFViewCtrl.DestroyRenderData(this.render_data, this.error_proc, this.curr_page_proc, this.findtext_proc, this.thumb_async_proc, this.request_render_worker_proc, 0L);
            this.render_data = 0L;
            this.error_proc = 0L;
            this.curr_page_proc = 0L;
            this.findtext_proc = 0L;
            this.thumb_async_proc = 0L;
            this.request_render_worker_proc = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearList() throws PDFNetException {
        Object v;
        this.t = Thread.currentThread();
        Cloneable cloneable = __DelayDelete.destroy_map;
        synchronized (cloneable) {
            v = __DelayDelete.destroy_map.get(this.t);
        }
        if (v != null) {
            cloneable = v;
            synchronized (cloneable) {
                LinkedList linkedList = (LinkedList)v;
                while (!linkedList.isEmpty()) {
                    ((__Delete)linkedList.removeFirst()).destroy();
                }
            }
        }
        cloneable = new LinkedList();
        HashMap hashMap = __DelayDelete.destroy_map;
        synchronized (hashMap) {
            __DelayDelete.destroy_map.put(this.t, cloneable);
        }
    }

    @Override
    public void destroy() {
        if (this.impl != 0L) {
            PDFViewCtrl.Destroy(this.impl);
            this.impl = 0L;
        }
        if (this.render_data != 0L) {
            PDFViewCtrl.DestroyRenderData(this.render_data, this.error_proc, this.curr_page_proc, this.findtext_proc, this.thumb_async_proc, this.request_render_worker_proc, 0L);
            this.render_data = 0L;
            this.error_proc = 0L;
            this.curr_page_proc = 0L;
            this.findtext_proc = 0L;
            this.thumb_async_proc = 0L;
            this.request_render_worker_proc = 0L;
        }
    }

    public PDFDoc getDoc() {
        return this.ref;
    }

    public void docLock(boolean bl) {
        PDFViewCtrl.DocLock(this.impl, bl);
    }

    public void docUnlock() {
        PDFViewCtrl.DocUnlock(this.impl);
    }

    public boolean docTryLock(int n) {
        return PDFViewCtrl.DocTryLock(this.impl, n);
    }

    public void docLockRead() {
        PDFViewCtrl.DocLockRead(this.impl);
    }

    public void docUnlockRead() {
        PDFViewCtrl.DocUnlockRead(this.impl);
    }

    public boolean docTryLockRead(int n) {
        return PDFViewCtrl.DocTryLockRead(this.impl, n);
    }

    public void setPageViewMode(int n) {
        PDFViewCtrl.SetPageViewMode(this.impl, n);
        this.setPreferredSize();
        this.revalidate();
        this.scrollTo();
        this.scrollpane.refresh();
    }

    public void setPageViewMode(PageViewMode pageViewMode) {
        this.setPageViewMode(pageViewMode.getValue());
    }

    public int getPageViewMode() {
        return PDFViewCtrl.GetPageViewMode(this.impl);
    }

    public void setPagePresentationMode(int n) {
        PDFViewCtrl.SetPagePresentationMode(this.impl, n);
        this.setPreferredSize();
        this.revalidate();
        this.scrollTo();
        this.scrollpane.refresh();
    }

    public void setPagePresentationMode(PagePresentationMode pagePresentationMode) {
        this.setPagePresentationMode(pagePresentationMode.getValue());
    }

    public int getPagePresentationMode() {
        return PDFViewCtrl.GetPagePresentationMode(this.impl);
    }

    public void setColorPostProcessMode(int n) {
        PDFViewCtrl.SetColorPostProcessMode(this.impl, n);
    }

    public void setColorPostProcessMode(ColorPostprocessMode colorPostprocessMode) {
        this.setColorPostProcessMode(colorPostprocessMode.getValue());
    }

    public int getColorPostProcessMode() {
        return PDFViewCtrl.GetColorPostProcessMode(this.impl);
    }

    public int getCurrentPage() {
        return PDFViewCtrl.GetCurrentPage(this.impl);
    }

    public int getPageCount() {
        return PDFViewCtrl.GetPagesCount(this.impl);
    }

    void scrollTo() {
        this.scrollTo(Math.max(this.getInt(PDFViewCtrl.GetHScrollPos(this.impl)), 0), Math.max(this.getInt(PDFViewCtrl.GetVScrollPos(this.impl)), 0));
    }

    void scrollTo(int n, int n2) {
        this.scrollRectToVisible(new Rectangle(n, n2, this.width, this.height));
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        PDFViewCtrl.SetHScrollPos(this.impl, rectangle.getX());
        PDFViewCtrl.SetVScrollPos(this.impl, rectangle.getY());
        if (this.scrollpane == null) {
            this.repaint();
        } else if (Math.abs((double)this.scrollpane.hbar.getValue() - this.getHScrollPos()) < (double)this.getScrollableUnitIncrement(this.getVisibleRect(), 0, 1) && Math.abs((double)this.scrollpane.vbar.getValue() - this.getVScrollPos()) < (double)this.getScrollableUnitIncrement(this.getVisibleRect(), 1, 1)) {
            this.repaint();
        } else {
            this.scrollpane.updateScrollbarValue();
        }
    }

    protected void movePanel(int n, int n2) {
    }

    public boolean gotoFirstPage() {
        return PDFViewCtrl.GotoFirstPage(this.impl);
    }

    public boolean gotoLastPage() {
        return PDFViewCtrl.GotoLastPage(this.impl);
    }

    public boolean gotoNextPage() {
        return PDFViewCtrl.GotoNextPage(this.impl);
    }

    public boolean gotoPreviousPage() {
        return PDFViewCtrl.GotoPreviousPage(this.impl);
    }

    public boolean setCurrentPage(int n) {
        return PDFViewCtrl.SetCurrentPage(this.impl, n);
    }

    public boolean showRect(int n, Rect rect) {
        boolean bl = PDFViewCtrl.ShowRect(this.impl, n, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
        return bl;
    }

    public double getZoom() {
        return PDFViewCtrl.GetZoom(this.impl);
    }

    public boolean setZoom(double d) {
        boolean bl = PDFViewCtrl.SetZoom(this.impl, d, true);
        this.setPreferredSize();
        this.revalidate();
        this.scrollTo();
        if (this.scrollpane != null) {
            this.scrollpane.refresh();
        }
        return bl;
    }

    public boolean setZoom(int n, int n2, double d) {
        boolean bl = PDFViewCtrl.SetZoom(this.impl, n, n2, d, true);
        this.setPreferredSize();
        this.revalidate();
        this.scrollTo();
        return bl;
    }

    public boolean smartZoom(int n, int n2) {
        boolean bl = PDFViewCtrl.SmartZoom(this.impl, n, n2);
        this.setPreferredSize();
        this.revalidate();
        this.scrollTo();
        this.scrollpane.refresh();
        return bl;
    }

    public void rotateClockwise() {
        PDFViewCtrl.RotateClockwise(this.impl);
        this.setPreferredSize();
        this.revalidate();
        this.scrollTo();
        this.scrollpane.refresh();
    }

    public void rotateCounterClockwise() {
        PDFViewCtrl.RotateCounterClockwise(this.impl);
        this.setPreferredSize();
        this.revalidate();
        this.scrollTo();
        this.scrollpane.refresh();
    }

    public int getPageNumberFromScreenPt(double d, double d2) {
        return PDFViewCtrl.GetPageNumberFromScreenPt(this.impl, d, d2);
    }

    public Point2D.Double convScreenPtToCanvasPt(double d, double d2) {
        double[] dArray = PDFViewCtrl.ConvScreenPtToCanvasPt(this.impl, d, d2);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convCanvasPtToScreenPt(double d, double d2) {
        double[] dArray = PDFViewCtrl.ConvCanvasPtToScreenPt(this.impl, d, d2);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convCanvasPtToPagePt(double d, double d2) {
        double[] dArray = PDFViewCtrl.ConvCanvasPtToPagePt(this.impl, d, d2, -1);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convCanvasPtToPagePt(double d, double d2, int n) {
        double[] dArray = PDFViewCtrl.ConvCanvasPtToPagePt(this.impl, d, d2, n);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convPagePtToCanvasPt(double d, double d2) {
        double[] dArray = PDFViewCtrl.ConvPagePtToCanvasPt(this.impl, d, d2, -1);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convPagePtToCanvasPt(double d, double d2, int n) {
        double[] dArray = PDFViewCtrl.ConvPagePtToCanvasPt(this.impl, d, d2, n);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convScreenPtToPagePt(double d, double d2) {
        double[] dArray = PDFViewCtrl.ConvScreenPtToPagePt(this.impl, d, d2, -1);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convScreenPtToPagePt(double d, double d2, int n) {
        double[] dArray = PDFViewCtrl.ConvScreenPtToPagePt(this.impl, d, d2, n);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convPagePtToScreenPt(double d, double d2) {
        double[] dArray = PDFViewCtrl.ConvPagePtToScreenPt(this.impl, d, d2, -1);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double convPagePtToScreenPt(double d, double d2, int n) {
        double[] dArray = PDFViewCtrl.ConvPagePtToScreenPt(this.impl, d, d2, n);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public Point2D.Double snapToNearestInDoc(double d, double d2) {
        double[] dArray = PDFViewCtrl.SnapToNearestInDoc(this.impl, d, d2);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public void setSnappingMode(int n) {
        PDFViewCtrl.SetSnappingMode(this.impl, n);
    }

    public Matrix2D getDeviceTransform() {
        return Matrix2D.__Create(PDFViewCtrl.GetDeviceTransform(this.impl, -1));
    }

    public Matrix2D getDeviceTransform(int n) {
        return Matrix2D.__Create(PDFViewCtrl.GetDeviceTransform(this.impl, n));
    }

    public void setErrorReportProc(ErrorReportProc errorReportProc, Object object) {
        this.error_proc = PDFViewCtrl.SetErrorReportProc(this.impl, new ThreadedErrorReportProc(errorReportProc), object);
    }

    public void setRequestRenderInWorkerThreadProc(RequestRenderInWorkerThreadProc requestRenderInWorkerThreadProc, Object object) {
        this.request_render_worker_proc = PDFViewCtrl.SetRequestRenderInWorkerThreadProc(this.impl, new ThreadedRequestRenderInWorkerThreadProc(requestRenderInWorkerThreadProc), object);
    }

    public void cancelAllThumbRequests() {
        PDFViewCtrl.CancelAllThumbRequests(this.impl);
    }

    public void setCurrentPageProc(CurrentPageProc currentPageProc, Object object) {
        this.curr_page_proc = PDFViewCtrl.SetCurrentPageProc(this.impl, new ThreadedCurrentPageProc(currentPageProc), object);
    }

    public double getCanvasWidth() {
        return PDFViewCtrl.GetCanvasWidth(this.impl);
    }

    public double getCanvasHeight() {
        return PDFViewCtrl.GetCanvasHeight(this.impl);
    }

    public double getHScrollPos() {
        return PDFViewCtrl.GetHScrollPos(this.impl);
    }

    public double getVScrollPos() {
        return PDFViewCtrl.GetVScrollPos(this.impl);
    }

    public void onScroll(int n, int n2) {
        PDFViewCtrl.OnScroll(this.impl, n, n2, true);
        this.scrollTo();
    }

    public void setHScrollPos(double d) {
        PDFViewCtrl.SetHScrollPos(this.impl, d);
        this.repaint();
    }

    public void setVScrollPos(double d) {
        PDFViewCtrl.SetVScrollPos(this.impl, d);
        this.repaint();
    }

    public boolean isFinishedRendering() {
        return PDFViewCtrl.IsFinishedRendering(this.impl, false);
    }

    public void cancelRenderingAsync() {
        PDFViewCtrl.CancelRenderingAsync(this.impl);
    }

    public void cancelRendering() {
        PDFViewCtrl.CancelRendering(this.impl);
    }

    public void updatePageLayout() {
        PDFViewCtrl.UpdatePageLayout(this.impl);
    }

    public void update() {
        PDFViewCtrl.Update(this.impl, false);
    }

    public void update(Rect rect) {
        PDFViewCtrl.Update(this.impl, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
    }

    public void update(Annot annot, int n) {
        PDFViewCtrl.Update(this.impl, annot.impl, n);
        ReachabilityHelper.ensureReachable(annot);
    }

    public void update(Field field) {
        PDFViewCtrl.UpdateField(this.impl, field.impl);
        ReachabilityHelper.ensureReachable(field);
    }

    public int getBufferWidth() {
        return PDFViewCtrl.GetBufferWidth(this.impl);
    }

    public int getBufferHeight() {
        return PDFViewCtrl.GetBufferHeight(this.impl);
    }

    public int getBufferStride() {
        return PDFViewCtrl.GetBufferStride(this.impl);
    }

    public void invalidateRect() {
        PDFViewCtrl.InvalidateRect(this.impl, 0L);
    }

    public void invalidateRect(Rect rect) {
        PDFViewCtrl.InvalidateRect(this.impl, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
    }

    public void hideAnnotation(Annot annot) {
        PDFViewCtrl.HideAnnotation(this.impl, annot.impl);
        ReachabilityHelper.ensureReachable(annot);
    }

    public void showAnnotation(Annot annot) {
        PDFViewCtrl.ShowAnnotation(this.impl, annot.impl);
        ReachabilityHelper.ensureReachable(annot);
    }

    public void setDrawAnnotations(boolean bl) {
        PDFViewCtrl.SetDrawAnnotations(this.impl, bl);
    }

    public void setHighlightFields(boolean bl) {
        PDFViewCtrl.SetHighlightFields(this.impl, bl);
    }

    public void setFieldHighlightColor(ColorPt colorPt) {
        PDFViewCtrl.SetFieldHighlightColor(this.impl, colorPt.__GetHandle());
        ReachabilityHelper.ensureReachable(colorPt);
    }

    public void setSignatureHighlightColor(ColorPt colorPt) {
        PDFViewCtrl.SetSignatureHighlightColor(this.impl, colorPt.__GetHandle());
        ReachabilityHelper.ensureReachable(colorPt);
    }

    public void setRequiredFieldBorderColor(ColorPt colorPt) {
        PDFViewCtrl.SetRequiredFieldBorderColor(this.impl, colorPt.__GetHandle());
        ReachabilityHelper.ensureReachable(colorPt);
    }

    public void setAntiAliasing(boolean bl) {
        PDFViewCtrl.SetAntiAliasing(this.impl, bl);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setPathHinting(boolean bl) {
        PDFViewCtrl.SetPathHinting(this.impl, bl);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setThinLineAdjustment(boolean bl, boolean bl2) {
        PDFViewCtrl.SetThinLineAdjustment(this.impl, bl, bl2);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setImageSmoothing() {
        PDFViewCtrl.SetImageSmoothing(this.impl, true);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setImageSmoothing(boolean bl) {
        PDFViewCtrl.SetImageSmoothing(this.impl, bl);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setCaching(boolean bl) {
        PDFViewCtrl.SetCaching(this.impl, bl);
    }

    public void setUrlExtraction(boolean bl) {
        PDFViewCtrl.SetUrlExtraction(this.impl, bl);
    }

    public LinkInfo getLinkAt(int n, int n2) {
        return PDFViewCtrl.GetLinkAt(this.impl, n, n2);
    }

    public void setRasterizer(boolean bl) {
        PDFViewCtrl.SetRasterizerType(this.impl, bl ? 0 : 1);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setGamma(double d) {
        PDFViewCtrl.SetGamma(this.impl, d);
    }

    public void setOverprint(int n) throws PDFNetException {
        PDFViewCtrl.SetOverprint(this.impl, n);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setOCGContext(Context context) throws PDFNetException {
        if (context == null) {
            PDFViewCtrl.SetOCGContext(this.impl, 0L);
        } else {
            PDFViewCtrl.SetOCGContext(this.impl, context.__GetHandle());
            ReachabilityHelper.ensureReachable(context);
        }
    }

    public Context getOCGContext() throws PDFNetException {
        return Context.__Create(PDFViewCtrl.GetOCGContext(this.impl), this);
    }

    public int getToolMode() {
        return PDFViewCtrl.GetToolMode(this.impl);
    }

    public boolean selectByRect(double d, double d2, double d3, double d4) {
        return PDFViewCtrl.SelectByRect(this.impl, d, d2, d3, d4);
    }

    public boolean selectByStruct(double d, double d2, double d3, double d4) {
        return PDFViewCtrl.SelectByStruct(this.impl, d, d2, d3, d4);
    }

    public boolean selectByHighlights(Highlights highlights) {
        boolean bl = PDFViewCtrl.SelectByHighlights(this.impl, highlights.impl);
        ReachabilityHelper.ensureReachable(highlights);
        return bl;
    }

    public boolean selectBySelection(Selection selection) {
        boolean bl = PDFViewCtrl.SelectBySelection(this.impl, selection.impl);
        ReachabilityHelper.ensureReachable(selection);
        return bl;
    }

    public void selectAll() {
        PDFViewCtrl.SelectAll(this.impl);
    }

    public void findTextAsync(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        PDFViewCtrl.FindTextAsync(this.impl, string, bl, bl2, bl3, bl4);
    }

    public void setFindTextHandler(FindTextProc findTextProc, Object object) {
        PDFViewCtrl.DestroyFindTextData(this.findtext_proc);
        this.findtext_proc = PDFViewCtrl.SetFindTextHandler(this.impl, new ThreadedFindTextProc(findTextProc, this), object);
    }

    public boolean hasSelection() {
        return PDFViewCtrl.HasSelection(this.impl);
    }

    public void clearSelection() {
        PDFViewCtrl.ClearSelection(this.impl);
    }

    public Selection getSelection(int n) {
        return new Selection(PDFViewCtrl.GetSelection(this.impl, n), this);
    }

    public int GetSelectionBeginPage() {
        return PDFViewCtrl.GetSelectionBeginPage(this.impl);
    }

    public int GetSelectionEndPage() {
        return PDFViewCtrl.GetSelectionEndPage(this.impl);
    }

    public boolean HasSelectionOnPage(int n) {
        return PDFViewCtrl.HasSelectionOnPage(this.impl, n);
    }

    public void setPageBorderVisibility(boolean bl) {
        PDFViewCtrl.SetPageBorderVisibility(this.impl, bl);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setPageTransparencyGrid(boolean bl) {
        PDFViewCtrl.SetPageTransparencyGrid(this.impl, bl);
        if (this.width > 0 && this.height > 0) {
            this.resize();
        }
    }

    public void setDefaultPageColor(byte by, byte by2, byte by3) {
        this.setDefaultPageColor(new Color(by, by2, by3));
    }

    public void setDefaultPageColor(Color color) {
        PDFViewCtrl.SetDefaultPageColor(this.impl, (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        if (this.getParent() instanceof JViewport) {
            ((JViewport)this.getParent()).getParent().setBackground(color);
            this.getParent().setBackground(color);
        }
    }

    public void setBackgroundColor(byte by, byte by2, byte by3) {
        PDFViewCtrl.SetBackgroundColor(this.impl, by, by2, by3, (byte)-1);
    }

    @Override
    public void setBackground(Color color) {
        this.setBackgroundColor((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
    }

    public void setHorizontalAlign(int n) {
        PDFViewCtrl.SetHorizontalAlign(this.impl, n);
    }

    public void setVerticalAlign(int n) {
        PDFViewCtrl.SetVerticalAlign(this.impl, n);
    }

    public void setPageSpacing(int n, int n2, int n3, int n4) {
        PDFViewCtrl.SetPageSpacing(this.impl, n, n2, n3, n4);
    }

    public void setDevicePixelDensity(double d, double d2) {
        PDFViewCtrl.SetDevicePixelDensity(this.impl, d, d2);
    }

    public Rect getScreenRectForAnnot(Annot annot, int n) {
        Rect rect = new Rect(PDFViewCtrl.GetScreenRectForAnnot(this.impl, annot.impl, n));
        ReachabilityHelper.ensureReachable(annot);
        return rect;
    }

    public Annot getAnnotationAt(int n, int n2) {
        return this.getAnnotationAt(n, n2, 15.0, 7.0);
    }

    public Annot getAnnotationAt(int n, int n2, double d, double d2) {
        return new Annot(PDFViewCtrl.GetAnnotationAt(this.impl, n, n2, d, d2), this);
    }

    public Annot[] getAnnotationListAt(int n, int n2, int n3, int n4) {
        long[] lArray = PDFViewCtrl.GetAnnotationListAt(this.impl, n, n2, n3, n4);
        Annot[] annotArray = new Annot[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            annotArray[i] = new Annot(lArray[i], this);
        }
        return annotArray;
    }

    public Annot[] getAnnotationsOnPage(int n) {
        long[] lArray = PDFViewCtrl.GetAnnotationsOnPage(this.impl, n);
        Annot[] annotArray = new Annot[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            annotArray[i] = new Annot(lArray[i], this);
        }
        return annotArray;
    }

    public void setProgressiveRendering(boolean bl) {
        PDFViewCtrl.SetProgressiveRendering(this.render_data, bl);
    }

    public int getRotation() throws PDFNetException {
        return PDFViewCtrl.GetRotation(this.impl);
    }

    public void setupThumbnails(boolean bl, boolean bl2, boolean bl3, int n, long l, double d) {
        PDFViewCtrl.SetupThumbnails(this.impl, bl, bl2, bl3, n, l, d);
    }

    public void getThumbAsync(int n, ThumbAsyncHandler thumbAsyncHandler, Object object) {
        PDFViewCtrl.GetThumbAsync(this.impl, n, thumbAsyncHandler, object);
    }

    public static void setViewerCache(SDFDoc sDFDoc, int n, boolean bl) throws PDFNetException {
        PDFViewCtrl.SetViewerCache(sDFDoc.__GetHandle(), n, bl);
        ReachabilityHelper.ensureReachable(sDFDoc);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.pref_size.setSize(Math.max(this.pref_size.width, this.getInt(PDFViewCtrl.GetCanvasWidth(this.impl))), Math.max(this.pref_size.height, this.getInt(PDFViewCtrl.GetCanvasHeight(this.impl))));
        super.setPreferredSize(this.pref_size);
        if (this.getParent() instanceof JViewport) {
            ((JViewport)this.getParent()).setViewSize(this.pref_size);
        }
    }

    public void setPreferredSize(int n, int n2) {
        this.pref_size.setSize(this.width, this.height);
        super.setPreferredSize(this.pref_size);
        if (this.getParent() instanceof JViewport) {
            ((JViewport)this.getParent()).setViewSize(this.pref_size);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.pref_size.setSize(this.getInt(PDFViewCtrl.GetCanvasWidth(this.impl)), this.getInt(PDFViewCtrl.GetCanvasHeight(this.impl)));
        return this.pref_size;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.pref_size;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        n3 = n == 0 ? rectangle.x : rectangle.y;
        if (n2 < 0) {
            int n4 = n3 - n3 / maxUnitIncrement * maxUnitIncrement;
            return n4 == 0 ? maxUnitIncrement : n4;
        }
        return (n3 / maxUnitIncrement + 1) * maxUnitIncrement - n3;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width - maxUnitIncrement;
        }
        return rectangle.height - maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width || this.getPageViewMode() != 3;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() >= this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private int getInt(double d) {
        return (int)Math.round(d);
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    native long[] PDFViewCtrlCreate(ViewCallback var1);

    static native void RefreshAndUpdate(long var0, long var2);

    static native long[] PDFViewCtrlCreate2(Object var0, ViewCallback var1);

    static native void Destroy(long var0);

    static native void DestroyRenderData(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    static native void DestroyFindTextData(long var0);

    static native void DocLock(long var0, boolean var2);

    static native void DocUnlock(long var0);

    static native boolean DocTryLock(long var0, int var2);

    static native void DocLockRead(long var0);

    static native void DocUnlockRead(long var0);

    static native boolean DocTryLockRead(long var0, int var2);

    static native void SetPageViewMode(long var0, int var2);

    static native int GetPageViewMode(long var0);

    static native void SetPagePresentationMode(long var0, int var2);

    static native int GetPagePresentationMode(long var0);

    static native void SetColorPostProcessMode(long var0, int var2);

    static native int GetColorPostProcessMode(long var0);

    static native int GetCurrentPage(long var0);

    static native int GetPagesCount(long var0);

    static native boolean GotoFirstPage(long var0);

    static native boolean GotoLastPage(long var0);

    static native boolean GotoNextPage(long var0);

    static native boolean GotoPreviousPage(long var0);

    static native boolean SetCurrentPage(long var0, int var2);

    static native boolean ShowRect(long var0, int var2, long var3);

    static native double GetZoom(long var0);

    static native boolean SetZoom(long var0, double var2, boolean var4);

    static native boolean SetZoom(long var0, int var2, int var3, double var4, boolean var6);

    static native boolean SmartZoom(long var0, int var2, int var3);

    static native void RotateClockwise(long var0);

    static native void RotateCounterClockwise(long var0);

    static native int GetPageNumberFromScreenPt(long var0, double var2, double var4);

    static native double[] ConvScreenPtToCanvasPt(long var0, double var2, double var4);

    static native double[] ConvCanvasPtToScreenPt(long var0, double var2, double var4);

    static native double[] ConvCanvasPtToPagePt(long var0, double var2, double var4, int var6);

    static native double[] ConvPagePtToCanvasPt(long var0, double var2, double var4, int var6);

    static native double[] ConvScreenPtToPagePt(long var0, double var2, double var4, int var6);

    static native double[] ConvPagePtToScreenPt(long var0, double var2, double var4, int var6);

    static native double[] SnapToNearestInDoc(long var0, double var2, double var4);

    static native void SetSnappingMode(long var0, int var2);

    static native long GetDeviceTransform(long var0, int var2);

    static native long SetErrorReportProc(long var0, ErrorReportProc var2, Object var3);

    static native long SetCurrentPageProc(long var0, CurrentPageProc var2, Object var3);

    static native double GetCanvasWidth(long var0);

    static native double GetCanvasHeight(long var0);

    static native double GetHScrollPos(long var0);

    static native double GetVScrollPos(long var0);

    static native void SetDevicePixelDensity(long var0, double var2, double var4);

    static native long GetScreenRectForAnnot(long var0, long var2, int var4);

    static native long GetAnnotationAt(long var0, int var2, int var3, double var4, double var6);

    static native long[] GetAnnotationListAt(long var0, int var2, int var3, int var4, int var5);

    static native long[] GetAnnotationsOnPage(long var0, int var2);

    static native void OnScroll(long var0, int var2, int var3, boolean var4);

    static native void SetHScrollPos(long var0, double var2);

    static native void SetVScrollPos(long var0, double var2);

    static native boolean IsFinishedRendering(long var0, boolean var2);

    static native void CancelRenderingAsync(long var0);

    static native void CancelRendering(long var0);

    static native void UpdatePageLayout(long var0);

    static native void Update(long var0, boolean var2);

    static native void Update(long var0, long var2);

    static native void Update(long var0, long var2, int var4);

    static native void UpdateField(long var0, long var2);

    static native int GetBufferWidth(long var0);

    static native int GetBufferHeight(long var0);

    static native int GetBufferStride(long var0);

    static native void InvalidateRect(long var0, long var2);

    static native void HideAnnotation(long var0, long var2);

    static native void ShowAnnotation(long var0, long var2);

    static native void SetDrawAnnotations(long var0, boolean var2);

    static native void SetHighlightFields(long var0, boolean var2);

    static native void SetFieldHighlightColor(long var0, long var2);

    static native void SetSignatureHighlightColor(long var0, long var2);

    static native void SetRequiredFieldBorderColor(long var0, long var2);

    static native void SetAntiAliasing(long var0, boolean var2);

    static native void SetPathHinting(long var0, boolean var2);

    static native void SetThinLineAdjustment(long var0, boolean var2, boolean var3);

    static native void SetImageSmoothing(long var0, boolean var2);

    static native void SetCaching(long var0, boolean var2);

    static native void SetUrlExtraction(long var0, boolean var2);

    static native LinkInfo GetLinkAt(long var0, int var2, int var3);

    static native void SetGamma(long var0, double var2);

    static native void SetOverprint(long var0, int var2);

    static native void SetOCGContext(long var0, long var2);

    static native long GetOCGContext(long var0);

    static native void SetRasterizerType(long var0, int var2);

    static native int GetToolMode(long var0);

    static native boolean SelectByRect(long var0, double var2, double var4, double var6, double var8);

    static native boolean SelectByStruct(long var0, double var2, double var4, double var6, double var8);

    static native boolean SelectByHighlights(long var0, long var2);

    static native boolean SelectBySelection(long var0, long var2);

    static native void SelectAll(long var0);

    static native void FindTextAsync(long var0, String var2, boolean var3, boolean var4, boolean var5, boolean var6);

    static native long SetFindTextHandler(long var0, ThreadedFindTextProc var2, Object var3);

    static native boolean HasSelection(long var0);

    static native void ClearSelection(long var0);

    static native long GetSelection(long var0, int var2);

    static native int GetSelectionBeginPage(long var0);

    static native int GetSelectionEndPage(long var0);

    static native boolean HasSelectionOnPage(long var0, int var2);

    static native void SetPageBorderVisibility(long var0, boolean var2);

    static native void SetPageTransparencyGrid(long var0, boolean var2);

    static native void SetDefaultPageColor(long var0, byte var2, byte var3, byte var4);

    static native void SetBackgroundColor(long var0, byte var2, byte var3, byte var4, byte var5);

    static native void SetHorizontalAlign(long var0, int var2);

    static native void SetVerticalAlign(long var0, int var2);

    static native void SetPageSpacing(long var0, int var2, int var3, int var4, int var5);

    static native void SetProgressiveRendering(long var0, boolean var2);

    static native int GetRotation(long var0);

    static native void SetViewerCache(long var0, int var2, boolean var3);

    static native void UpdateData(long var0, int[] var2, int var3, int var4);

    static native void GetBuffer(long var0, int[] var2);

    static native void OnSize(long var0, int var2, int var3, int var4, boolean var5);

    static native void SetDoc(long var0, long var2);

    static native int SelectionGetPageNum(long var0);

    static native double[] SelectionGetQuads(long var0);

    static native String SelectionGetAsUnicode(long var0);

    static native String SelectionGetAsHtml(long var0);

    static native long SetRequestRenderInWorkerThreadProc(long var0, ThreadedRequestRenderInWorkerThreadProc var2, Object var3);

    static native void CancelAllThumbRequests(long var0);

    static native void GetThumbAsync(long var0, long var2, ThumbAsyncHandler var4, Object var5);

    static native void SetupThumbnails(long var0, boolean var2, boolean var3, boolean var4, int var5, long var6, double var8);

    static native long GetExternalAnnotManager(long var0, String var2, int var3);

    private static native void EnableUndoRedo(long var0);

    private static native String Undo(long var0);

    private static native String Redo(long var0);

    private static native boolean HasChangesSinceSnapshot(long var0);

    private static native void TakeSnapshot(long var0, String var2);

    private static native String GetNextUndoInfo(long var0);

    private static native String GetNextRedoInfo(long var0);

    private static native boolean CanUndo(long var0);

    private static native boolean CanRedo(long var0);

    private static native void RevertChangesSinceSnapshot(long var0);

    private static native void RevertAllChanges(long var0);

    public class Selection
    implements AutoCloseable {
        long impl;
        Object ref;

        public int getPageNum() {
            return PDFViewCtrl.SelectionGetPageNum(this.impl);
        }

        public double[] getQuads() {
            return PDFViewCtrl.SelectionGetQuads(this.impl);
        }

        public String getAsUnicode() {
            return PDFViewCtrl.SelectionGetAsUnicode(this.impl);
        }

        public String getAsHtml() {
            return PDFViewCtrl.SelectionGetAsHtml(this.impl);
        }

        Selection(long l, Object object) {
            this.impl = l;
            this.ref = object;
        }

        @Override
        public void close() throws PDFNetException {
            PDFViewCtrl.this.destroy();
        }
    }

    public static class LinkInfo {
        private String mUrl = "";
        private double mX1 = 0.0;
        private double mX2 = 0.0;
        private double mY1 = 0.0;
        private double mY2 = 0.0;

        private LinkInfo() {
        }

        public double getX1() {
            return this.mX1;
        }

        public double getX2() {
            return this.mX2;
        }

        public double getY1() {
            return this.mY1;
        }

        public double getY2() {
            return this.mY2;
        }

        public String getURL() {
            return this.mUrl;
        }
    }

    class ThreadedFindTextProc
    implements FindTextProc {
        FindTextProc p;
        PDFViewCtrl control;

        ThreadedFindTextProc(FindTextProc findTextProc, PDFViewCtrl pDFViewCtrl2) {
            this.p = findTextProc;
            this.control = pDFViewCtrl2;
        }

        @Override
        public void handleFindText(final boolean bl, final Selection selection, final Object object) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadedFindTextProc.this.p.handleFindText(bl, selection, object);
                }
            };
            Timer timer = new Timer(0, actionListener);
            timer.setRepeats(false);
            timer.start();
        }

        public void nativeHandleFindText(boolean bl, long l, Object object) {
            Selection selection = new Selection(l, this.control);
            this.handleFindText(bl, selection, object);
        }
    }

    class ThreadedCurrentPageProc
    implements CurrentPageProc {
        CurrentPageProc p;

        ThreadedCurrentPageProc(CurrentPageProc currentPageProc) {
            this.p = currentPageProc;
        }

        @Override
        public void reportCurrentPage(final int n, final int n2, final Object object) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PDFViewCtrl.this.scrollpane.updateScrollbarValue();
                    ThreadedCurrentPageProc.this.p.reportCurrentPage(n, n2, object);
                }
            };
            Timer timer = new Timer(0, actionListener);
            timer.setRepeats(false);
            timer.start();
        }
    }

    class ThreadedRequestRenderInWorkerThreadProc
    implements RequestRenderInWorkerThreadProc {
        RequestRenderInWorkerThreadProc p;

        ThreadedRequestRenderInWorkerThreadProc(RequestRenderInWorkerThreadProc requestRenderInWorkerThreadProc) {
            this.p = requestRenderInWorkerThreadProc;
        }

        @Override
        public void onRequestRenderInWorkerThreadProc(final Object object) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadedRequestRenderInWorkerThreadProc.this.p.onRequestRenderInWorkerThreadProc(object);
                }
            };
            Timer timer = new Timer(0, actionListener);
            timer.setRepeats(false);
            timer.start();
        }
    }

    class ThreadedThumbAsyncProc
    implements ThumbAsyncHandler {
        ThumbAsyncHandler p;

        ThreadedThumbAsyncProc(ThumbAsyncHandler thumbAsyncHandler) {
            this.p = thumbAsyncHandler;
        }

        @Override
        public void thumbAsyncHandlerProc(final int n, final boolean bl, final Object object, final int n2, final int n3, final Object object2) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadedThumbAsyncProc.this.p.thumbAsyncHandlerProc(n, bl, object, n2, n3, object2);
                }
            };
            Timer timer = new Timer(0, actionListener);
            timer.setRepeats(false);
            timer.start();
        }
    }

    class ThreadedErrorReportProc
    implements ErrorReportProc {
        ErrorReportProc p;
        String temp_msg = null;

        ThreadedErrorReportProc(ErrorReportProc errorReportProc) {
            this.p = errorReportProc;
        }

        @Override
        public void reportError(final String string, final Object object) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!string.equals(ThreadedErrorReportProc.this.temp_msg)) {
                        ThreadedErrorReportProc.this.temp_msg = string;
                        ThreadedErrorReportProc.this.p.reportError(string, object);
                    }
                }
            };
            Timer timer = new Timer(0, actionListener);
            timer.setRepeats(false);
            timer.start();
        }
    }

    public static enum ColorPostprocessMode {
        NONE(0),
        INVERT(1);

        private final int mode;

        private ColorPostprocessMode(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }

    public static enum PagePresentationMode {
        SINGLE_PAGE(1),
        SINGLE_CONTINUOUS(2),
        FACING(3),
        FACING_CONTINUOUS(4),
        FACING_COVER(5),
        FACING_CONTINUOUS_COVER(6);

        private final int mode;

        private PagePresentationMode(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }

    public static enum PageViewMode {
        FIT_PAGE(0),
        FIT_WIDTH(1),
        FIT_HEIGHT(2),
        ZOOM(3);

        private final int mode;

        private PageViewMode(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }
}

