/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf.annots;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Annot;
import com.pdftron.pdf.Point;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.annots.Markup;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;

public class Ink
extends Markup {
    public Ink(Obj obj) {
        super(obj);
    }

    public Ink() {
    }

    Ink(long l, Object object) {
        super(l, object);
    }

    public Ink(Annot annot) throws PDFNetException {
        super(annot.getSDFObj());
    }

    public static Ink create(Doc doc, Rect rect) throws PDFNetException {
        Ink ink = new Ink(Ink.Create(doc.__GetHandle(), rect.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(rect);
        return ink;
    }

    public int getPathCount() throws PDFNetException {
        return Ink.GetPathCount(this.__GetHandle());
    }

    public int getPointCount(int n) throws PDFNetException {
        return Ink.GetPointCount(this.__GetHandle(), n);
    }

    public Point GetPoint(int n, int n2) throws PDFNetException {
        return new Point(Ink.GetPointx(this.__GetHandle(), n, n2), Ink.GetPointy(this.__GetHandle(), n, n2));
    }

    public void setPoint(int n, int n2, Point point) throws PDFNetException {
        Ink.SetPoint(this.__GetHandle(), n, n2, point.x, point.y);
    }

    public boolean erase(Point point, Point point2, double d) throws PDFNetException {
        return Ink.Erase(this.__GetHandle(), point.x, point.y, point2.x, point2.y, d);
    }

    public boolean erasePaths(Point point, Point point2, double d) throws PDFNetException {
        return Ink.ErasePaths(this.__GetHandle(), point.x, point.y, point2.x, point2.y, d);
    }

    public static boolean erasePoints(Obj obj, Rect rect, Point point, Point point2, double d) throws PDFNetException {
        boolean bl = Ink.ErasePoints(obj.__GetHandle(), rect.__GetHandle(), point.x, point.y, point2.x, point2.y, d);
        ReachabilityHelper.ensureReachable(obj);
        ReachabilityHelper.ensureReachable(rect);
        return bl;
    }

    public boolean getSmoothing() throws PDFNetException {
        return Ink.GetSmoothing(this.__GetHandle());
    }

    public void setSmoothing(boolean bl) throws PDFNetException {
        Ink.SetSmoothing(this.__GetHandle(), bl);
    }

    public int getBlendMode() throws PDFNetException {
        return Ink.GetBlendMode(this.__GetHandle());
    }

    public void setBlendMode(BlendMode blendMode) throws PDFNetException {
        Ink.SetBlendMode(this.__GetHandle(), blendMode.getValue());
    }

    public static double[] getBezierControlPoints(double[] dArray) throws PDFNetException {
        return Ink.GetBezierControlPoints(dArray);
    }

    public boolean getHighlightIntent() throws PDFNetException {
        return Ink.GetHighlightIntent(this.__GetHandle());
    }

    public void setHighlightIntent(boolean bl) throws PDFNetException {
        Ink.SetHighlightIntent(this.__GetHandle(), bl);
    }

    static native long Create(long var0, long var2);

    static native int GetPathCount(long var0);

    static native int GetPointCount(long var0, int var2);

    static native double GetPointx(long var0, int var2, int var3);

    static native double GetPointy(long var0, int var2, int var3);

    static native void SetPoint(long var0, int var2, int var3, double var4, double var6);

    static native boolean Erase(long var0, double var2, double var4, double var6, double var8, double var10);

    static native boolean ErasePaths(long var0, double var2, double var4, double var6, double var8, double var10);

    static native boolean ErasePoints(long var0, long var2, double var4, double var6, double var8, double var10, double var12);

    static native boolean GetSmoothing(long var0);

    static native void SetSmoothing(long var0, boolean var2);

    static native int GetBlendMode(long var0);

    static native void SetBlendMode(long var0, int var2);

    static native double[] GetBezierControlPoints(double[] var0);

    static native boolean GetHighlightIntent(long var0);

    static native void SetHighlightIntent(long var0, boolean var2);

    public static enum BlendMode {
        COMPATIBLE(0),
        NORMAL(1),
        MULTIPLY(2),
        SCREEN(3),
        DIFFERENCE(4),
        DARKEN(5),
        LIGHTEN(6),
        COLOR_DODGE(7),
        COLOR_BURN(8),
        EXCLUSION(9),
        HARD_LIGHT(10),
        OVERLAY(11),
        SOFT_LIGHT(12),
        LUMINOSITY(13),
        HUE(14),
        SATURATION(15),
        COLOR(16);

        private final int mode;

        private BlendMode(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }
}

