//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFReflow
#define PDFTRON_H_CPPPDFReflow
#include <C/PDF/TRN_Reflow.h>

#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace PDF { 


/**
 * The class Reflow.
 * Reflow annotations between PDF and HTML
 *
 * DocumentConversion instances are created through methods belonging to
 * the Convert class. See Convert.CreateReflow for an example.
 */
class Reflow
{
public:
		Reflow();
	Reflow(const Reflow& other);
	Reflow(TRN_Reflow impl);
	Reflow& operator= (const Reflow& other);
	~Reflow();
	
	void Destroy();

	//methods:
	
	/**
	 * Converts PDF to HTML.
	 * 
	 * @return returns HTML as a string.
	 */
	UString GetHtml();
	
	/**
	 * Gets PDF annotation(s) as JSON.
	 * 
	 * @param in_id -- an annotation ID, or an empty string.
	 * @return returns JSON string.
	 */
	UString GetAnnot(UString in_id);
	
	/**
	 * Updates PDF annotation.
	 * 
	 * @param in_json -- update instructions (JSON).
	 * @return returns JSON string.
	 */
	UString SetAnnot(UString in_json);
	
	/**
	 * Determines whether to include images in the output HTML. Default is false.
	 * 
	 * @param include -- if true images will be included in the output HTML.
	 */
	void SetIncludeImages(bool include);
	
	/**
	 * Determines whether to write text markup tags into the output HTML. Default is false.
	 * 
	 * @param include -- if true text markup tags will be included in the output HTML..
	 */
	void SetHTMLOutputTextMarkup(bool include);
	
	/**
	 * Sets the error message in the output HTML when the page doesn't contain reflowable text. Use it for localization purposes. Default: "This page doesn't contain reflowable text".
	 * 
	 * @param content -- the localized message.
	 */
	void SetMessageWhenNoReflowContent(UString content);
	
	/**
	 * Sets the error message in the output HTML when reflow conversion fails. Use it for localization purposes. Default: "Could not reflow this page".
	 * 
	 * @param content -- the localized message.
	 */
	void SetMessageWhenReflowFailed(UString content);
	
	/**
	 * Determines whether to hide background images. Default is false.
	 * 
	 * @param hide_background_images -- if true, background images will not be included in the output HTML.
	 */
	void SetHideBackgroundImages(bool hide_background_images);
	
	/**
	 * Determines whether to hide images that are covered by text. Default is false.
	 * 
	 * @param hide_images_under_text -- if true, images that are covered by text will not be included in the output HTML.
	 */
	void SetHideImagesUnderText(bool hide_images_under_text);
	
	/**
	 * Determines whether to hide images that are covered by invisible text (typically produced by OCR). Default is true.
	 *
	 * This options works only if SetHideImagesUnderText() is set to false. If SetHideImagesUnderText() is set to true,
	 * then images that are covered by any text, whether visible or not, will not be included in the output HTML.
	 * 
	 * If SetHideImagesUnderInvisibleText() is set to true while SetHideImagesUnderText() is set to false, then images
	 * that are covered by invisible text will not be included in the output HTML. This can be useful when processing
	 * scanned documents that are processed by OCR.
	 * 
	 * @param hide_images_under_invisible_text -- if true, images that are covered by invisible text will not be included in the output HTML.
	 */
	void SetHideImagesUnderInvisibleText(bool hide_images_under_invisible_text);
	
	/**
	 * Determines whether to not reflow text that appears over images. Default is false.
	 * 
	 * @param do_not_reflow_text_over_images -- if true, text that appears over images will not be included in the output HTML.
	 */
	void SetDoNotReflowTextOverImages(bool do_not_reflow_text_over_images);
	
	/**
	 * Overrides the font to use for reflowed content. If this property is empty, the default PDF font will be used. Default is no override.
	 * 
	 * @param font_family -- the font-family value that goes to the CSS in the output HTML.
	 */
	void SetFontOverrideName(UString font_family);
	
	/**
	 * Appends custom CSS styles to the output HTML. Default is no custom styles.
	 * 
	 * @param styles -- the CSS code without any <style> tags to be inserted in the output HTML.
	 */
	void SetCustomStyles(UString styles);
	
	/**
	 * Determines whether to include bounding box information (of the original PDF) in the output HTML. Default is false.
	 *
	 * The bounding box information will be stored using the attribute called "data-bbox" (value is written as "x1,y1,x2,y2", in PDF coordinates).
	 * 
	 * Note: This option is only available when pre-recognized zoning information is set through SetRecognizedZones().
	 * 
	 * @param include -- if true bounding box information will be included in the output HTML.
	 */
	void SetIncludeBBoxForRecognizedZones(bool include);

#ifndef SWIGHIDDEN
	TRN_Reflow m_impl;
#endif

private:

#ifndef SWIGHIDDEN
	mutable bool m_owner; 
#endif
};

#include <Impl/Reflow.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFReflow
