// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFSVGConvertOptions
#define PDFTRON_H_CPPPDFSVGConvertOptions

#include <PDF/OptionsBase.h>

namespace pdftron{ namespace PDF{ 

class SVGConvertOptions
{
public:
	SVGConvertOptions();
	~SVGConvertOptions();

	
	/**
	* Gets the value ConvertLinks from the options object
	* Instructs the conversion process to generate interactive Link annotations from links in the SVG input file.
	* @return a bool, the current value for ConvertLinks.
	*/
	bool GetConvertLinks();

	/**
	* Sets the value for ConvertLinks in the options object
	* Instructs the conversion process to generate interactive Link annotations from links in the SVG input file.
	* @param value: the new value for ConvertLinks
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetConvertLinks(bool value);

	
	/**
	* Gets the value DefaultFontFamily from the options object
	* Name of the font family which is used if a font for some text in the graphics file is either not specified or not available. Default: Arial Unicode MS if available, otherwise Helvetica.
	* @return a UString, the current value for DefaultFontFamily.
	*/
	UString GetDefaultFontFamily();

	/**
	* Sets the value for DefaultFontFamily in the options object
	* Name of the font family which is used if a font for some text in the graphics file is either not specified or not available. Default: Arial Unicode MS if available, otherwise Helvetica.
	* @param value: the new value for DefaultFontFamily
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetDefaultFontFamily(const UString& value);

	
	/**
	* Gets the value FallbackFontFamily from the options object
	* Name of the font family which is used to create a fallback font for each font, in addition to the fallback fonts which may have been specified in the graphics file. Default: empty.
	* @return a UString, the current value for FallbackFontFamily.
	*/
	UString GetFallbackFontFamily();

	/**
	* Sets the value for FallbackFontFamily in the options object
	* Name of the font family which is used to create a fallback font for each font, in addition to the fallback fonts which may have been specified in the graphics file. Default: empty.
	* @param value: the new value for FallbackFontFamily
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetFallbackFontFamily(const UString& value);

	
	/**
	* Gets the value FallbackHeight from the options object
	* Affects only SVG graphics without absolute size; ignored if ForcedHeight is supplied. Height >= 0 of the SVG graphics for the fitting process. If the value is zero the bounding box is calculated. Default: values in the SVG graphics if present, otherwise 0.
	* @return a double, the current value for FallbackHeight.
	*/
	double GetFallbackHeight();

	/**
	* Sets the value for FallbackHeight in the options object
	* Affects only SVG graphics without absolute size; ignored if ForcedHeight is supplied. Height >= 0 of the SVG graphics for the fitting process. If the value is zero the bounding box is calculated. Default: values in the SVG graphics if present, otherwise 0.
	* @param value: the new value for FallbackHeight
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetFallbackHeight(double value);

	
	/**
	* Gets the value FallbackWidth from the options object
	* Affects only SVG graphics without absolute size; ignored if ForcedWidth is supplied. Width >= 0 of the SVG graphics for the fitting process. If the value is zero the bounding box is calculated. Default: values in the SVG graphics if present, otherwise 0.
	* @return a double, the current value for FallbackWidth.
	*/
	double GetFallbackWidth();

	/**
	* Sets the value for FallbackWidth in the options object
	* Affects only SVG graphics without absolute size; ignored if ForcedWidth is supplied. Width >= 0 of the SVG graphics for the fitting process. If the value is zero the bounding box is calculated. Default: values in the SVG graphics if present, otherwise 0.
	* @param value: the new value for FallbackWidth
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetFallbackWidth(double value);

	
	/**
	* Gets the value ForceSRGB from the options object
	* If true, all non-sRGB color specifications are ignored and the sRGB fallback color is used instead. This option does not affect referenced images. Default: false.
	* @return a bool, the current value for ForceSRGB.
	*/
	bool GetForceSRGB();

	/**
	* Sets the value for ForceSRGB in the options object
	* If true, all non-sRGB color specifications are ignored and the sRGB fallback color is used instead. This option does not affect referenced images. Default: false.
	* @param value: the new value for ForceSRGB
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetForceSRGB(bool value);

	
	/**
	* Gets the value ForcedHeight from the options object
	* The height of the SVG graphics is ignored and the specified value is applied instead if a value >= 1 is supplied. Default: height attribute of the graphics.
	* @return a double, the current value for ForcedHeight.
	*/
	double GetForcedHeight();

	/**
	* Sets the value for ForcedHeight in the options object
	* The height of the SVG graphics is ignored and the specified value is applied instead if a value >= 1 is supplied. Default: height attribute of the graphics.
	* @param value: the new value for ForcedHeight
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetForcedHeight(double value);

	
	/**
	* Gets the value ForcedWidth from the options object
	* The width of the SVG graphics is ignored and the specified value is applied instead if a value >= 1 is supplied. Default: width attribute of the graphics.
	* @return a double, the current value for ForcedWidth.
	*/
	double GetForcedWidth();

	/**
	* Sets the value for ForcedWidth in the options object
	* The width of the SVG graphics is ignored and the specified value is applied instead if a value >= 1 is supplied. Default: width attribute of the graphics.
	* @param value: the new value for ForcedWidth
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetForcedWidth(double value);

	
	/**
	* Gets the value HonorIccProfile from the options object
	* If true, honor all ICC profiles in icc-color specifications or implicitly in sRGB colors; otherwise all explicit ICC colors and implicit sRGB colors are interpreted as device-gray/device-rgb/device-cmyk colors. Default: true.
	* @return a bool, the current value for HonorIccProfile.
	*/
	bool GetHonorIccProfile();

	/**
	* Sets the value for HonorIccProfile in the options object
	* If true, honor all ICC profiles in icc-color specifications or implicitly in sRGB colors; otherwise all explicit ICC colors and implicit sRGB colors are interpreted as device-gray/device-rgb/device-cmyk colors. Default: true.
	* @param value: the new value for HonorIccProfile
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetHonorIccProfile(bool value);

	
	/**
	* Gets the value Inline from the options object
	* If true, create output inline in the content stream; otherwise a separate Form XObject is created. The inline method suffers from disadvantages related to transparency handling. On the other hand, this option is required if active links in the graphics should be converted (option ConvertLinks). Default: true.
	* @return a bool, the current value for Inline.
	*/
	bool GetInline();

	/**
	* Sets the value for Inline in the options object
	* If true, create output inline in the content stream; otherwise a separate Form XObject is created. The inline method suffers from disadvantages related to transparency handling. On the other hand, this option is required if active links in the graphics should be converted (option ConvertLinks). Default: true.
	* @param value: the new value for Inline
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetInline(bool value);

	
	/**
	* Gets the value Lang from the options object
	* Natural language for the graphics file as a BCP 47 language tag consisting of a two- or three-character language code according to ISO 639-1/2 which can be used e.g. in an SVG switch element. Default: the language identifier found in the LANG environment variable.
	* @return a UString, the current value for Lang.
	*/
	UString GetLang();

	/**
	* Sets the value for Lang in the options object
	* Natural language for the graphics file as a BCP 47 language tag consisting of a two- or three-character language code according to ISO 639-1/2 which can be used e.g. in an SVG switch element. Default: the language identifier found in the LANG environment variable.
	* @param value: the new value for Lang
	* @return this object, for call chaining
	*/
	SVGConvertOptions& SetLang(const UString& value);

	
	// @cond PRIVATE_DOC
	#ifndef SWIGHIDDEN
	const SDF::Obj& GetInternalObj() const;
	SDF::Obj& GetInternalObj();

private:
	
	SDF::ObjSet m_obj_set;
	SDF::Obj m_dict;
	#endif
	// @endcond
};

}
}

#include "../Impl/SVGConvertOptions.inl"
#endif // PDFTRON_H_CPPPDFSVGConvertOptions
