//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2023 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
#include <PDF/PDFNet.h>
#include <PDF/PDFDoc.h>
#include <PDF/PageSet.h>
#include <Filters/MappedFile.h>
#include <Filters/FilterReader.h>
#include <Filters/FilterWriter.h>
#include <PDF/ElementWriter.h>
#include <PDF/ElementReader.h>
#include <PDF/FindReplace.h>
#include <PDF/FindReplaceOptions.h>

#include <iostream>
#include <fstream>
#include "../../LicenseKey/CPP/LicenseKey.h"

using namespace std;
using namespace pdftron;
using namespace SDF;
using namespace PDF;
using namespace Filters;

int main(int argc, char *argv[])
{
	int ret = 0;
	PDFNet::Initialize(LicenseKey);

	// Relative path to the folder containing test files.
	string input_path =  "../../TestFiles/";
	string output_path = "../../TestFiles/Output/";

	// The following sample illustrates how to find and replace text in a document
	try  
	{
		// Open a PDF document to edit
		PDFDoc doc(input_path + "find-replace-test.pdf");
		FindReplaceOptions options = FindReplaceOptions();

		// Set some find/replace options
		options.SetWholeWords(true);
		options.SetMatchCase(true);
		options.SetMatchMode(FindReplaceOptions::e_exact);
		options.SetReflowMode(FindReplaceOptions::e_para);
		options.SetAlignment(FindReplaceOptions::e_left);

		// Perform a Find/Replace finding "the" with "THE INCREDIBLE"
		FindReplace::FindReplaceText(doc, "the", "THE INCREDIBLE", options);

		// Save the edited PDF
		doc.Save(output_path + "find-replace-test-replaced.pdf", SDFDoc::e_linearized);
	}
	catch(Common::Exception& e)
	{
		cout << e << endl;
		ret = 1;
	}
	catch(...)
	{
		cout << "Unknown Exception" << endl;
		ret = 1;
	}

	PDFNet::Terminate();
	return ret;
}