//
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
//

using System;
using System.IO;
using pdftron;
using pdftron.Common;
using pdftron.Filters;
using pdftron.SDF;
using pdftron.PDF;
using pdftron.FDF;

// The following sample illustrates how to extract xlf from a PDF document for translation.
// It then applies a pre-prepared translated xlf file to the PDF to produce a translated PDF. 
namespace TransPDFTestCS
{
	class Class1
	{
		private static pdftron.PDFNetLoader pdfNetLoader = pdftron.PDFNetLoader.Instance();
		static Class1() {}
		
		[STAThread]
		static void Main(string[] args)
		{
			PDFNet.Initialize(PDFTronLicense.Key);

			// Relative path to the folder containing test files.
			string input_path =  "../../TestFiles/";
			string output_path = "../../TestFiles/Output/";

			try  
			{
				// Read a PDF document from a stream or pass-in a memory buffer...
				FileStream istm = new FileStream(input_path + "find-replace-test.pdf", FileMode.Open, FileAccess.Read);
				
				using (PDFDoc doc = new PDFDoc(istm))
				{
					TransPDFOptions options = new TransPDFOptions();
					
					// Set the source language in the options
					options.SetSourceLanguage("en");

					// Set the number of pages to process in each batch
					options.SetBatchSize(20);

					// Optionally, subset the pages to process
					// This PDF only has a single page, but you can specify a subset of pages like this
					// options.SetPages("-2,5-6,9,11-");

					// Extract the xlf to file and field the PDF for translation
					TransPDF.ExtractXLIFF(doc, output_path + "find-replace-test.xlf", options);

					// Save the fielded PDF
					doc.Save(output_path + "find-replace-test-fielded.pdf", SDFDoc.SaveOptions.e_linearized);

					// The extracted xlf can be translated in a system of your choice.
					// In this sample a pre-prepared translated file is used - find-replace-test_(en_to_fr).xlf

					// Perform the translation using the pre-prepared translated xliff
					TransPDF.ApplyXLIFF(doc, input_path + "find-replace-test_(en_to_fr).xlf", options);

					// Save the translated PDF
					doc.Save(output_path + "find-replace-test-fr.pdf", SDFDoc.SaveOptions.e_linearized);
					doc.Close();
				}
			}
			catch (PDFNetException e)
			{
				Console.WriteLine(e.Message);
			}
			PDFNet.Terminate();
		}
	}
}
