/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.crypto;

import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.DigestAlgorithm;
import com.pdftron.crypto.X501DistinguishedName;
import com.pdftron.crypto.X509Extension;

public class X509Certificate
implements AutoCloseable {
    private long mImpl;

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            X509Certificate.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public X509Certificate(long l) {
        this.mImpl = l;
    }

    public X509Certificate(String string) throws PDFNetException {
        this.mImpl = X509Certificate.CreateFromFile(string);
    }

    public X509Certificate(byte[] byArray) throws PDFNetException {
        this.mImpl = X509Certificate.CreateFromBuffer(byArray);
    }

    public X501DistinguishedName getIssuerField() throws PDFNetException {
        return new X501DistinguishedName(X509Certificate.GetIssuerField(this.mImpl));
    }

    public X501DistinguishedName getSubjectField() throws PDFNetException {
        return new X501DistinguishedName(X509Certificate.GetSubjectField(this.mImpl));
    }

    public long getNotBeforeEpochTime() throws PDFNetException {
        return X509Certificate.GetNotBeforeEpochTime(this.mImpl);
    }

    public long getNotAfterEpochTime() throws PDFNetException {
        return X509Certificate.GetNotAfterEpochTime(this.mImpl);
    }

    public int getRawX509VersionNumber() throws PDFNetException {
        return X509Certificate.GetRawX509VersionNumber(this.mImpl);
    }

    public String toString() {
        return X509Certificate.ToString(this.mImpl);
    }

    public String getFingerprint(DigestAlgorithm digestAlgorithm) throws PDFNetException {
        return X509Certificate.GetFingerprint(this.mImpl, digestAlgorithm.value);
    }

    public String getFingerprint() throws PDFNetException {
        return this.getFingerprint(DigestAlgorithm.e_sha256);
    }

    public byte[] getSerialNumber() throws PDFNetException {
        return X509Certificate.GetSerialNumber(this.mImpl);
    }

    public X509Extension[] getExtensions() throws PDFNetException {
        long[] lArray = X509Certificate.GetExtensions(this.mImpl);
        X509Extension[] x509ExtensionArray = new X509Extension[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            x509ExtensionArray[i] = new X509Extension(lArray[i]);
        }
        return x509ExtensionArray;
    }

    public byte[] getData() throws PDFNetException {
        return X509Certificate.GetData(this.mImpl);
    }

    public long __GetHandle() {
        return this.mImpl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long CreateFromFile(String var0);

    static native long CreateFromBuffer(byte[] var0);

    static native long GetIssuerField(long var0);

    static native long GetSubjectField(long var0);

    static native long GetNotBeforeEpochTime(long var0);

    static native long GetNotAfterEpochTime(long var0);

    static native int GetRawX509VersionNumber(long var0);

    static native String ToString(long var0);

    static native String GetFingerprint(long var0, int var2);

    static native byte[] GetSerialNumber(long var0);

    static native long[] GetExtensions(long var0);

    static native byte[] GetData(long var0);
}

