/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.helpers;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;

public class BitmapHelper {
    public static void drawInRect(BufferedImage bufferedImage, Graphics graphics, int n, int n2) {
        double d = Math.min((double)n / (double)bufferedImage.getWidth(), (double)n2 / (double)bufferedImage.getHeight());
        int n3 = (int)(((double)n - d * (double)bufferedImage.getWidth()) / 2.0 + 0.5);
        int n4 = (int)(((double)n2 - d * (double)bufferedImage.getHeight()) / 2.0 + 0.5);
        graphics.drawImage(bufferedImage, n3, n4, (int)((double)n3 + d * (double)bufferedImage.getWidth() + 0.5), (int)((double)n4 + d * (double)bufferedImage.getHeight() + 0.5), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
    }

    public static int getHeight(Image image) {
        return image.getHeight(null);
    }

    public static int getWidth(Image image) {
        return image.getWidth(null);
    }

    public static void createArrayFromBitmap(Image image, int[] nArray, int n, int n2) throws InterruptedException {
        if (nArray.length == n * n2) {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            pixelGrabber.grabPixels();
        }
    }

    public static Image getBitmap(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray[nArray.length - 2];
        int n2 = nArray[nArray.length - 1];
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        WritableRaster writableRaster = (WritableRaster)bufferedImage.getData();
        writableRaster.setPixels(0, 0, n, n2, nArray);
        return bufferedImage;
    }

    public static Color getColor(int[] nArray) {
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public static class CustomBitmap {
        public BufferedImage bitmap;
        public int[] bitmapArray;

        public CustomBitmap(int n, int n2) {
            this(n, n2, null);
        }

        public CustomBitmap(int n, int n2, BufferedImage bufferedImage) {
            this.bitmap = bufferedImage == null || bufferedImage.getHeight() != n2 || bufferedImage.getWidth() != n ? new BufferedImage(n, n2, 2) : bufferedImage;
            this.bitmapArray = ((DataBufferInt)this.bitmap.getRaster().getDataBuffer()).getData();
        }

        public void create() {
        }
    }
}

