/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Element;
import com.pdftron.pdf.ElementReader;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.__DelayDelete;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;

public class ElementWriter
extends __DelayDelete
implements AutoCloseable {
    public static final int e_underlay = 0;
    public static final int e_overlay = 1;
    public static final int e_replacement = 2;
    long impl = ElementWriter.ElementWriterCreate();
    Object ref = null;

    @Override
    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            ElementWriter.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    public void begin(Page page) throws PDFNetException {
        ElementWriter.Begin(this.impl, page.impl, 1, true, true, 0L);
        this.ref = page.ref;
    }

    public void begin(Page page, int n) throws PDFNetException {
        ElementWriter.Begin(this.impl, page.impl, n, true, true, 0L);
        this.ref = page.ref;
    }

    public void begin(Page page, int n, boolean bl) throws PDFNetException {
        ElementWriter.Begin(this.impl, page.impl, n, bl, true, 0L);
        this.ref = page.ref;
    }

    public void begin(Page page, int n, boolean bl, boolean bl2) throws PDFNetException {
        ElementWriter.Begin(this.impl, page.impl, n, bl, bl2, 0L);
        this.ref = page.ref;
    }

    public void begin(Page page, int n, boolean bl, boolean bl2, Obj obj) throws PDFNetException {
        ElementWriter.Begin(this.impl, page.impl, n, bl, bl2, obj.__GetHandle());
        this.ref = page.ref;
        ReachabilityHelper.ensureReachable(obj);
    }

    public void begin(Obj obj) throws PDFNetException {
        ElementWriter.BeginObj(this.impl, obj.__GetHandle(), true, 0L);
        this.ref = obj;
    }

    public void begin(Obj obj, boolean bl) throws PDFNetException {
        ElementWriter.BeginObj(this.impl, obj.__GetHandle(), bl, 0L);
        this.ref = obj;
    }

    public void begin(Obj obj, boolean bl, Obj obj2) throws PDFNetException {
        ElementWriter.BeginObj(this.impl, obj.__GetHandle(), bl, obj2.__GetHandle());
        this.ref = obj;
        ReachabilityHelper.ensureReachable(obj2);
    }

    public void begin(Doc doc) throws PDFNetException {
        ElementWriter.Begin(this.impl, doc.__GetHandle(), true);
        this.ref = doc;
    }

    public void begin(Doc doc, boolean bl) throws PDFNetException {
        ElementWriter.Begin(this.impl, doc.__GetHandle(), bl);
        this.ref = doc;
    }

    public Obj end() throws PDFNetException {
        return Obj.__Create(ElementWriter.End(this.impl), this.ref);
    }

    public void writeElement(Element element) throws PDFNetException {
        ElementWriter.WriteElement(this.impl, element.impl);
        ReachabilityHelper.ensureReachable(element);
    }

    public void writePlacedElement(Element element) throws PDFNetException {
        ElementWriter.WritePlacedElement(this.impl, element.impl);
        ReachabilityHelper.ensureReachable(element);
    }

    public void flush() throws PDFNetException {
        ElementWriter.Flush(this.impl);
    }

    public void writeBuffer(byte[] byArray) throws PDFNetException {
        ElementWriter.WriteBuffer(this.impl, byArray);
    }

    public void writeString(String string) throws PDFNetException {
        ElementWriter.WriteString(this.impl, string);
    }

    public void writeGStateChanges(Element element) throws PDFNetException {
        ElementWriter.WriteGStateChanges(this.impl, element.impl);
        ReachabilityHelper.ensureReachable(element);
    }

    public void setDefaultGState(ElementReader elementReader) throws PDFNetException {
        ElementWriter.SetDefaultGState(this.impl, elementReader.impl);
        ReachabilityHelper.ensureReachable(elementReader);
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long ElementWriterCreate();

    static native void Destroy(long var0);

    static native void Begin(long var0, long var2, int var4, boolean var5, boolean var6, long var7);

    static native void Begin(long var0, long var2, boolean var4);

    static native void BeginObj(long var0, long var2, boolean var4, long var5);

    static native long End(long var0);

    static native void WriteElement(long var0, long var2);

    static native void WritePlacedElement(long var0, long var2);

    static native void Flush(long var0);

    static native void WriteBuffer(long var0, byte[] var2);

    static native void WriteString(long var0, String var2);

    static native void WriteGStateChanges(long var0, long var2);

    static native void SetDefaultGState(long var0, long var2);
}

