/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.filters.FilterReader;
import com.pdftron.filters.FilterWriter;
import com.pdftron.helpers.BitmapHelper;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.ColorSpace;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;

public class Image {
    public static final int e_none = 0;
    public static final int e_jpeg = 1;
    public static final int e_jp2 = 2;
    public static final int e_flate = 3;
    public static final int e_g3 = 4;
    public static final int e_g4 = 5;
    public static final int e_ascii_hex = 6;
    long impl;
    Object ref;

    public static Image create(Doc doc, String string) throws PDFNetException {
        return new Image(Image.Create(doc.__GetHandle(), string, 0L), doc);
    }

    public static Image create(Doc doc, String string, Obj obj) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), string, obj.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image create(Doc doc, byte[] byArray, int n, int n2, int n3, ColorSpace colorSpace) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), byArray, n, n2, n3, colorSpace.impl, 0L), doc);
        ReachabilityHelper.ensureReachable(colorSpace);
        return image;
    }

    public static Image create(Doc doc, byte[] byArray, int n, int n2, int n3, ColorSpace colorSpace, Obj obj) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), byArray, n, n2, n3, colorSpace.impl, obj.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(colorSpace);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image create(Doc doc, byte[] byArray) throws PDFNetException {
        return new Image(Image.Create(doc.__GetHandle(), byArray, 0L), doc);
    }

    public static Image create(Doc doc, byte[] byArray, Obj obj) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), byArray, obj.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image create(Doc doc, Filter filter) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), filter.__GetHandle(), 0L), doc);
        filter.__SetRefHandle(image);
        return image;
    }

    public static Image create(Doc doc, Filter filter, Obj obj) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), filter.__GetHandle(), obj.__GetHandle()), doc);
        filter.__SetRefHandle(image);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image create(Doc doc, FilterReader filterReader, int n, int n2, int n3, ColorSpace colorSpace) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), filterReader.__GetHandle(), n, n2, n3, colorSpace.impl, 0L), doc);
        ReachabilityHelper.ensureReachable(colorSpace);
        ReachabilityHelper.ensureReachable(filterReader);
        return image;
    }

    public static Image create(Doc doc, FilterReader filterReader, int n, int n2, int n3, ColorSpace colorSpace, Obj obj) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), filterReader.__GetHandle(), n, n2, n3, colorSpace.impl, obj.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(colorSpace);
        ReachabilityHelper.ensureReachable(filterReader);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image createImageMask(Doc doc, byte[] byArray, int n, int n2) throws PDFNetException {
        return new Image(Image.CreateImageMask(doc.__GetHandle(), byArray, n, n2, 0L), doc);
    }

    public static Image createImageMask(Doc doc, byte[] byArray, int n, int n2, Obj obj) throws PDFNetException {
        Image image = new Image(Image.CreateImageMask(doc.__GetHandle(), byArray, n, n2, obj.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image createImageMask(Doc doc, FilterReader filterReader, int n, int n2) throws PDFNetException {
        Image image = new Image(Image.CreateImageMask(doc.__GetHandle(), filterReader.__GetHandle(), n, n2, 0L), doc);
        ReachabilityHelper.ensureReachable(filterReader);
        return image;
    }

    public static Image createImageMask(Doc doc, FilterReader filterReader, int n, int n2, Obj obj) throws PDFNetException {
        Image image = new Image(Image.CreateImageMask(doc.__GetHandle(), filterReader.__GetHandle(), n, n2, obj.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(filterReader);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image createSoftMask(Doc doc, byte[] byArray, int n, int n2, int n3) throws PDFNetException {
        return new Image(Image.CreateSoftMask(doc.__GetHandle(), byArray, n, n2, n3, 0L), doc);
    }

    public static Image createSoftMask(Doc doc, byte[] byArray, int n, int n2, int n3, Obj obj) throws PDFNetException {
        Image image = new Image(Image.CreateSoftMask(doc.__GetHandle(), byArray, n, n2, n3, obj.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image createSoftMask(Doc doc, FilterReader filterReader, int n, int n2, int n3) throws PDFNetException {
        Image image = new Image(Image.CreateSoftMask(doc.__GetHandle(), filterReader.__GetHandle(), n, n2, n3, 0L), doc);
        ReachabilityHelper.ensureReachable(filterReader);
        return image;
    }

    public static Image createSoftMask(Doc doc, FilterReader filterReader, int n, int n2, int n3, Obj obj) throws PDFNetException {
        Image image = new Image(Image.CreateSoftMask(doc.__GetHandle(), filterReader.__GetHandle(), n, n2, n3, obj.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(filterReader);
        ReachabilityHelper.ensureReachable(obj);
        return image;
    }

    public static Image create(Doc doc, byte[] byArray, int n, int n2, int n3, ColorSpace colorSpace, int n4) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), byArray, n, n2, n3, colorSpace.impl, n4), doc);
        ReachabilityHelper.ensureReachable(colorSpace);
        return image;
    }

    public static Image create(Doc doc, FilterReader filterReader, int n, int n2, int n3, ColorSpace colorSpace, int n4) throws PDFNetException {
        Image image = new Image(Image.Create(doc.__GetHandle(), filterReader.__GetHandle(), n, n2, n3, colorSpace.impl, n4), doc);
        ReachabilityHelper.ensureReachable(colorSpace);
        ReachabilityHelper.ensureReachable(filterReader);
        return image;
    }

    public static Image create(Doc doc, java.awt.Image image) throws PDFNetException, InterruptedException {
        int n = BitmapHelper.getHeight(image);
        int n2 = BitmapHelper.getWidth(image);
        if (n2 * n <= 0) {
            return null;
        }
        int[] nArray = new int[n2 * n];
        BitmapHelper.createArrayFromBitmap(image, nArray, n2, n);
        return new Image(Image.Create(doc.__GetHandle(), nArray, n2, n), doc);
    }

    public java.awt.Image getBitmap() throws PDFNetException {
        int[] nArray = Image.GetRawImageData(this.impl);
        return BitmapHelper.getBitmap(nArray);
    }

    public Image(Obj obj) {
        this.impl = obj.__GetHandle();
        this.ref = obj.__GetRefHandle();
    }

    public Obj getSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    public boolean isValid() throws PDFNetException {
        return Image.IsValid(this.impl);
    }

    public Filter getImageData() throws PDFNetException {
        return Filter.__Create(Image.GetImageData(this.impl), null);
    }

    public int getImageDataSize() throws PDFNetException {
        return Image.GetImageDataSize(this.impl);
    }

    public ColorSpace getImageColorSpace() throws PDFNetException {
        return ColorSpace.__Create(Image.GetImageColorSpace(this.impl), this.ref);
    }

    public int getImageWidth() throws PDFNetException {
        return Image.GetImageWidth(this.impl);
    }

    public int getImageHeight() throws PDFNetException {
        return Image.GetImageHeight(this.impl);
    }

    public Obj getDecodeArray() throws PDFNetException {
        return Obj.__Create(Image.GetDecodeArray(this.impl), this.ref);
    }

    public int getBitsPerComponent() throws PDFNetException {
        return Image.GetBitsPerComponent(this.impl);
    }

    public int getComponentNum() throws PDFNetException {
        return Image.GetComponentNum(this.impl);
    }

    public boolean isImageMask() throws PDFNetException {
        return Image.IsImageMask(this.impl);
    }

    public boolean isImageInterpolate() throws PDFNetException {
        return Image.IsImageInterpolate(this.impl);
    }

    public Obj getMask() throws PDFNetException {
        return Obj.__Create(Image.GetMask(this.impl), this.ref);
    }

    public void setMask(Image image) throws PDFNetException {
        Image.SetMask(this.impl, image.impl);
        ReachabilityHelper.ensureReachable(image);
    }

    public void setMask(Obj obj) throws PDFNetException {
        Image.SetMaskObj(this.impl, obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
    }

    public Obj getSoftMask() throws PDFNetException {
        return Obj.__Create(Image.GetSoftMask(this.impl), this.ref);
    }

    public void setSoftMask(Image image) throws PDFNetException {
        Image.SetSoftMask(this.impl, image.impl);
        ReachabilityHelper.ensureReachable(image);
    }

    public int getImageRenderingIntent() throws PDFNetException {
        return Image.GetImageRenderingIntent(this.impl);
    }

    public int export(String string) throws PDFNetException {
        return Image.Export(this.impl, string);
    }

    public int export(FilterWriter filterWriter) throws PDFNetException {
        int n = Image.Export(this.impl, filterWriter.__GetHandle());
        ReachabilityHelper.ensureReachable(filterWriter);
        return n;
    }

    public void exportAsTiff(String string) throws PDFNetException {
        Image.ExportAsTiff(this.impl, string);
    }

    public void exportAsTiff(FilterWriter filterWriter) throws PDFNetException {
        Image.ExportAsTiff(this.impl, filterWriter.__GetHandle());
        ReachabilityHelper.ensureReachable(filterWriter);
    }

    public void exportAsPng(String string) throws PDFNetException {
        Image.ExportAsPng(this.impl, string);
    }

    public void exportAsPng(FilterWriter filterWriter) throws PDFNetException {
        Image.ExportAsPng(this.impl, filterWriter.__GetHandle());
        ReachabilityHelper.ensureReachable(filterWriter);
    }

    public long __GetHandle() {
        return this.impl;
    }

    Image(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    static native long Create(long var0, String var2, long var3);

    static native long Create(long var0, byte[] var2, int var3, int var4, int var5, long var6, long var8);

    static native long Create(long var0, long var2, int var4, int var5, int var6, long var7, long var9);

    static native long Create(long var0, byte[] var2, long var3);

    static native long Create(long var0, long var2, long var4);

    static native long CreateImageMask(long var0, byte[] var2, int var3, int var4, long var5);

    static native long CreateImageMask(long var0, long var2, int var4, int var5, long var6);

    static native long CreateSoftMask(long var0, byte[] var2, int var3, int var4, int var5, long var6);

    static native long CreateSoftMask(long var0, long var2, int var4, int var5, int var6, long var7);

    static native long Create(long var0, byte[] var2, int var3, int var4, int var5, long var6, int var8);

    static native long Create(long var0, long var2, int var4, int var5, int var6, long var7, int var9);

    static native long Create(long var0, int[] var2, int var3, int var4);

    static native boolean IsValid(long var0);

    static native long GetImageData(long var0);

    static native int GetImageDataSize(long var0);

    static native long GetImageColorSpace(long var0);

    static native int GetImageWidth(long var0);

    static native int GetImageHeight(long var0);

    static native long GetDecodeArray(long var0);

    static native int GetBitsPerComponent(long var0);

    static native int GetComponentNum(long var0);

    static native boolean IsImageMask(long var0);

    static native boolean IsImageInterpolate(long var0);

    static native long GetMask(long var0);

    static native void SetMask(long var0, long var2);

    static native void SetMaskObj(long var0, long var2);

    static native long GetSoftMask(long var0);

    static native void SetSoftMask(long var0, long var2);

    static native int GetImageRenderingIntent(long var0);

    static native int Export(long var0, String var2);

    static native int Export(long var0, long var2);

    static native void ExportAsTiff(long var0, String var2);

    static native void ExportAsTiff(long var0, long var2);

    static native void ExportAsPng(long var0, String var2);

    static native void ExportAsPng(long var0, long var2);

    static native byte[] GetBitmap(long var0);

    static native int[] GetRawImageData(long var0);

    public static class Compat {
        public static int[] GetRawImageData(long l) {
            return Image.GetRawImageData(l);
        }
    }
}

