/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.TimestampingResult;
import com.pdftron.pdf.VerificationOptions;

public class TimestampingConfiguration
implements AutoCloseable {
    private long mImpl;

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            TimestampingConfiguration.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public TimestampingConfiguration(long l) {
        this.mImpl = l;
    }

    public TimestampingConfiguration(String string) throws PDFNetException {
        this.mImpl = TimestampingConfiguration.Create(string);
    }

    public void setTimestampAuthorityServerURL(String string) throws PDFNetException {
        TimestampingConfiguration.SetTimestampAuthorityServerURL(this.mImpl, string);
    }

    public void setTimestampAuthorityServerUsername(String string) throws PDFNetException {
        TimestampingConfiguration.SetTimestampAuthorityServerUsername(this.mImpl, string);
    }

    public void setTimestampAuthorityServerPassword(String string) throws PDFNetException {
        TimestampingConfiguration.SetTimestampAuthorityServerPassword(this.mImpl, string);
    }

    public void setUseNonce(boolean bl) throws PDFNetException {
        TimestampingConfiguration.SetUseNonce(this.mImpl, bl);
    }

    public TimestampingResult testConfiguration(VerificationOptions verificationOptions) throws PDFNetException {
        TimestampingResult timestampingResult = new TimestampingResult(TimestampingConfiguration.TestConfiguration(this.mImpl, verificationOptions.__GetHandle()));
        ReachabilityHelper.ensureReachable(verificationOptions);
        return timestampingResult;
    }

    public long __GetHandle() {
        return this.mImpl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long Create(String var0);

    static native void SetTimestampAuthorityServerURL(long var0, String var2);

    static native void SetTimestampAuthorityServerUsername(long var0, String var2);

    static native void SetTimestampAuthorityServerPassword(long var0, String var2);

    static native void SetUseNonce(long var0, boolean var2);

    static native long TestConfiguration(long var0, long var2);
}

