/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf.ocg;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.ocg.Config;
import com.pdftron.pdf.ocg.Group;

public class Context {
    public static final int e_VisibleOC = 0;
    public static final int e_AllOC = 1;
    public static final int e_NoOC = 2;
    long impl;
    Object ref;
    boolean owner = true;

    public Context(Context context) throws PDFNetException {
        this.impl = Context.ContextCreateCtx(context.impl);
        this.ref = context.ref;
        this.owner = true;
    }

    public Context(Config config) throws PDFNetException {
        this.impl = Context.ContextCreateCfg(config.impl);
        this.ref = config.ref;
        this.owner = true;
    }

    protected void finalize() throws Throwable {
        if (this.owner) {
            Context.Destroy(this.impl);
        }
        this.impl = 0L;
        this.ref = null;
    }

    public boolean getState(Group group) throws PDFNetException {
        boolean bl = Context.GetState(this.impl, group.impl);
        ReachabilityHelper.ensureReachable(group);
        return bl;
    }

    public void setState(Group group, boolean bl) throws PDFNetException {
        Context.SetState(this.impl, group.impl, bl);
        ReachabilityHelper.ensureReachable(group);
    }

    public void resetStates(boolean bl) throws PDFNetException {
        Context.ResetStates(this.impl, bl);
    }

    public void setNonOCDrawing(boolean bl) throws PDFNetException {
        Context.SetNonOCDrawing(this.impl, bl);
    }

    boolean getNonOCDrawing() throws PDFNetException {
        return Context.GetNonOCDrawing(this.impl);
    }

    public void setOCDrawMode(int n) throws PDFNetException {
        Context.SetOCDrawMode(this.impl, n);
    }

    public int getOCMode() throws PDFNetException {
        return Context.GetOCMode(this.impl);
    }

    public long __GetHandle() {
        return this.impl;
    }

    Context(long l, Object object) {
        this.impl = l;
        this.ref = object;
        this.owner = false;
    }

    public static Context __Create(long l, Object object) {
        if (l == 0L) {
            return null;
        }
        return new Context(l, object);
    }

    static native long ContextCreateCtx(long var0);

    static native long ContextCreateCfg(long var0);

    static native void Destroy(long var0);

    static native boolean GetState(long var0, long var2);

    static native void SetState(long var0, long var2, boolean var4);

    static native void ResetStates(long var0, boolean var2);

    static native void SetNonOCDrawing(long var0, boolean var2);

    static native boolean GetNonOCDrawing(long var0);

    static native void SetOCDrawMode(long var0, int var2);

    static native int GetOCMode(long var0);
}

