//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------

#include <PDF/PDFNet.h>
#include <PDF/PDFDoc.h>
#include <PDF/PageSet.h>
#include <Filters/MappedFile.h>
#include <Filters/FilterReader.h>
#include <Filters/FilterWriter.h>
#include <PDF/ElementWriter.h>
#include <PDF/ElementReader.h>
#include <PDF/TransPDF.h>
#include <PDF/TransPDFOptions.h>

#include <iostream>
#include <fstream>
#include "../../LicenseKey/CPP/LicenseKey.h"

using namespace std;
using namespace pdftron;
using namespace SDF;
using namespace PDF;
using namespace Filters;

int main(int argc, char *argv[])
{
	int ret = 0;
	PDFNet::Initialize(LicenseKey);

	// Relative path to the folder containing test files.
	string input_path =  "../../TestFiles/";
	string output_path = "../../TestFiles/Output/";

	// The following sample illustrates how to extract xlf from a PDF document for translation.
	// It then applies a pre-prepared translated xlf file to the PDF to produce a translated PDF.
	try  
	{
		// Open a PDF to translate.
		PDFDoc doc(input_path + "find-replace-test.pdf");
		TransPDFOptions options = TransPDFOptions();

		// Set the source language in the options
		options.SetSourceLanguage("en");

		// Set the number of pages to process in each batch
		options.SetBatchSize(20);

		// Optionally, subset the pages to process
		// This PDF only has a single page, but you can specify a subset of pages like this
		// options.SetPages("-2,5-6,9,11-");

		// Extract the xlf to file and field the PDF for translation
		TransPDF::ExtractXLIFF(doc, output_path + "find-replace-test.xlf", options);

		// Save the fielded PDF
		doc.Save(output_path + "find-replace-test-fielded.pdf", SDFDoc::e_linearized);

		// The extracted xlf can be translated in a system of your choice.
		// In this sample a pre-prepared translated file is used - find-replace-test_(en_to_fr).xlf
		// Perform the translation using the pre-prepared translated xliff
		TransPDF::ApplyXLIFF(doc, input_path + "find-replace-test_(en_to_fr).xlf", options);

		// Save the translated PDF
		doc.Save(output_path + "find-replace-test-fr.pdf", SDFDoc::e_linearized);
		doc.Close();
	}
	catch(Common::Exception& e)
	{
		cout << e << endl;
		ret = 1;
	}
	catch(...)
	{
		cout << "Unknown Exception" << endl;
		ret = 1;
	}

	PDFNet::Terminate();
	return ret;
}
