/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.ColorPt;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.RectCollection;
import com.pdftron.sdf.Obj;
import com.pdftron.sdf.ObjSet;

public class OptionsBase {
    protected ObjSet mObjSet = new ObjSet();
    protected Obj mDict;

    public OptionsBase() throws PDFNetException {
        this.mDict = this.mObjSet.createDict();
    }

    public OptionsBase(String string) throws PDFNetException {
        this.mDict = this.mObjSet.createFromJson(string);
    }

    long getObjHandle() throws PDFNetException {
        return this.mDict.__GetHandle();
    }

    Obj getArray(String string) throws PDFNetException {
        Obj obj = this.mDict.findObj(string);
        if (obj == null) {
            obj = this.mDict.putArray(string);
        }
        return obj;
    }

    static ColorPt colorPtFromNumber(double d) throws PDFNetException {
        long l = (long)d;
        return new ColorPt((double)(l >> 16 & 0xFFL) / 255.0, (double)(l >> 8 & 0xFFL) / 255.0, (double)(l >> 0 & 0xFFL) / 255.0, (double)(l >> 24 & 0xFFL) / 255.0);
    }

    static double colorPtToNumber(ColorPt colorPt) throws PDFNetException {
        int n = 3;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 255L;
        if (n == 1) {
            l2 = l = (long)(255.0 * colorPt.get(0));
            l3 = l;
        } else if (n == 3 || n == 4) {
            l = (long)(255.0 * colorPt.get(0));
            l2 = (long)(255.0 * colorPt.get(1));
            l3 = (long)(255.0 * colorPt.get(2));
        }
        if (n == 4) {
            l4 = (long)(255.0 * colorPt.get(3));
        }
        long l5 = (0xFFL & l4) << 24 | (0xFFL & l) << 16 | (0xFFL & l2) << 8 | (0xFFL & l3) << 0;
        return l5;
    }

    protected void putNumber(String string, double d) throws PDFNetException {
        this.mDict.putNumber(string, d);
    }

    protected void putBool(String string, Boolean bl) throws PDFNetException {
        this.mDict.putBool(string, bl);
    }

    protected void putText(String string, String string2) throws PDFNetException {
        this.mDict.putText(string, string2);
    }

    protected void putRect(String string, Rect rect) throws PDFNetException {
        this.mDict.putRect(string, rect.getX1(), rect.getY1(), rect.getX2(), rect.getY2());
    }

    protected void pushBackNumber(String string, double d) throws PDFNetException {
        Obj obj = this.getArray(string);
        obj.pushBackNumber(d);
    }

    protected void pushBackBool(String string, Boolean bl) throws PDFNetException {
        Obj obj = this.getArray(string);
        obj.pushBackBool(bl);
    }

    protected void pushBackText(String string, String string2) throws PDFNetException {
        Obj obj = this.getArray(string);
        obj.pushBackText(string2);
    }

    protected void pushBackRect(String string, Rect rect) throws PDFNetException {
        Obj obj = this.getArray(string);
        obj.pushBackRect(rect.getX1(), rect.getY1(), rect.getX2(), rect.getY2());
    }

    protected void insertRectCollection(String string, RectCollection rectCollection, int n) throws PDFNetException {
        Obj obj = this.getArray(string);
        while (obj.size() <= (long)n) {
            obj.pushBackArray();
        }
        Obj obj2 = obj.getAt(n);
        for (int i = 0; i < rectCollection.getNumRects(); ++i) {
            Rect rect = rectCollection.getRectAt(i);
            obj2.pushBackRect(rect.getX1(), rect.getY1(), rect.getX2(), rect.getY2());
        }
    }

    protected static Rect rectFromArray(Obj obj) throws PDFNetException {
        return new Rect(obj.getAt(0).getNumber(), obj.getAt(1).getNumber(), obj.getAt(2).getNumber(), obj.getAt(3).getNumber());
    }
}

