/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.AnalyticsHandlerCallback;
import com.pdftron.pdf.AssertHandlerCallback;
import com.pdftron.pdf.PDFDoc;

public class PDFNetInternalTools {
    public static final int e_debugger = 0;
    public static final int e_disk = 1;
    public static final int e_callback = 2;
    public static final int e_console = 3;
    public static final int e_trace = 0;
    public static final int e_debug = 1;
    public static final int e_info = 2;
    public static final int e_warning = 3;
    public static final int e_error = 4;
    public static final int e_fatal = 5;
    public static final int e_disabled = 6;
    private static AnalyticsHandlerCallback mAnalyticsHandler = null;
    private static AssertHandlerCallback mAssertHandler = null;

    private PDFNetInternalTools() {
    }

    public static boolean isLogSystemAvailable() throws PDFNetException {
        return PDFNetInternalTools.IsLogSystemAvailable();
    }

    public static boolean configureLogFromJsonString(String string) throws PDFNetException {
        return PDFNetInternalTools.ConfigureLogFromJsonString(string);
    }

    public static String getDefaultConfigFile() throws PDFNetException {
        return PDFNetInternalTools.GetDefaultConfigFile();
    }

    public static String runUniversalConversionTests(String string) throws PDFNetException {
        return PDFNetInternalTools.RunUniversalConversionTests(string);
    }

    public static void logMessage(int n, String string, String string2, int n2) throws PDFNetException {
        PDFNetInternalTools.LogMessage(n, string, string2, n2);
    }

    public static void logStreamMessage(int n, String string, String string2, String string3, int n2) throws PDFNetException {
        PDFNetInternalTools.LogStreamMessage(n, string, string2, string3, n2);
    }

    public static boolean setLogLocation(String string, String string2) throws PDFNetException {
        return PDFNetInternalTools.SetLogLocation(string, string2);
    }

    public static boolean setLogFileName(String string) throws PDFNetException {
        return PDFNetInternalTools.SetLogFileName(string);
    }

    public static void setThresholdForLogStream(String string, int n) throws PDFNetException {
        PDFNetInternalTools.SetThresholdForLogStream(string, n);
    }

    public static void setDefaultLogThreshold(int n) throws PDFNetException {
        PDFNetInternalTools.SetDefaultLogThreshold(n);
    }

    public static void setCutoffLogThreshold(int n) throws PDFNetException {
        PDFNetInternalTools.SetCutoffLogThreshold(n);
    }

    public static boolean enableLogBackend(int n) throws PDFNetException {
        return PDFNetInternalTools.EnableLogBackend(n);
    }

    public static void disableLogBackend(int n) throws PDFNetException {
        PDFNetInternalTools.DisableLogBackend(n);
    }

    public static void setAnalyticsHandler(AnalyticsHandlerCallback analyticsHandlerCallback) throws PDFNetException {
        mAnalyticsHandler = analyticsHandlerCallback;
        PDFNetInternalTools.SetAnalyticsHandler(mAnalyticsHandler);
    }

    public static void setAssertHandler(AssertHandlerCallback assertHandlerCallback) throws PDFNetException {
        mAssertHandler = assertHandlerCallback;
        PDFNetInternalTools.SetAssertHandler(mAssertHandler);
    }

    public static String getPDFViewTileSummary() throws PDFNetException {
        return PDFNetInternalTools.GetPDFViewTileSummary();
    }

    public static boolean checkDocIntegrity(PDFDoc pDFDoc) throws PDFNetException {
        boolean bl = PDFNetInternalTools.CheckDocIntegrity(pDFDoc.__GetHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        return bl;
    }

    static native boolean IsLogSystemAvailable();

    static native boolean ConfigureLogFromJsonString(String var0);

    static native String GetDefaultConfigFile();

    static native String RunUniversalConversionTests(String var0);

    static native void LogMessage(int var0, String var1, String var2, int var3);

    static native void LogStreamMessage(int var0, String var1, String var2, String var3, int var4);

    static native boolean SetLogLocation(String var0, String var1);

    static native boolean SetLogFileName(String var0);

    static native void SetThresholdForLogStream(String var0, int var1);

    static native void SetDefaultLogThreshold(int var0);

    static native void SetCutoffLogThreshold(int var0);

    static native boolean EnableLogBackend(int var0);

    static native void DisableLogBackend(int var0);

    static native String GetPDFViewTileSummary();

    static native void SetAnalyticsHandler(AnalyticsHandlerCallback var0);

    static native void SetAssertHandler(AssertHandlerCallback var0);

    static native boolean CheckDocIntegrity(long var0);
}

