/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.ColorPt;
import com.pdftron.pdf.Font;
import com.pdftron.pdf.Image;
import com.pdftron.pdf.PDFDoc;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.PageSet;

public class Stamper
implements AutoCloseable {
    public static final int e_relative_scale = 1;
    public static final int e_absolute_size = 2;
    public static final int e_font_size = 3;
    public static final int e_horizontal_left = -1;
    public static final int e_horizontal_center = 0;
    public static final int e_horizontal_right = 1;
    public static final int e_vertical_bottom = -1;
    public static final int e_vertical_center = 0;
    public static final int e_vertical_top = 1;
    public static final int e_align_left = -1;
    public static final int e_align_center = 0;
    public static final int e_align_right = 1;
    long impl;

    public Stamper(int n, double d, double d2) {
        this.impl = Stamper.StamperCreate(n, d, d2);
    }

    public void destroy() {
        if (this.impl != 0L) {
            Stamper.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    public void stampImage(PDFDoc pDFDoc, Image image, PageSet pageSet) {
        Stamper.StampImage(this.impl, pDFDoc.__GetHandle(), image.impl, pageSet.impl);
        ReachabilityHelper.ensureReachable(image);
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(pageSet);
    }

    public void stampPage(PDFDoc pDFDoc, Page page, PageSet pageSet) {
        Stamper.StampPage(this.impl, pDFDoc.__GetHandle(), page.impl, pageSet.impl);
        ReachabilityHelper.ensureReachable(page);
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(pageSet);
    }

    public void stampText(PDFDoc pDFDoc, String string, PageSet pageSet) {
        Stamper.StampText(this.impl, pDFDoc.__GetHandle(), string, pageSet.impl);
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(pageSet);
    }

    public void setFont(Font font) {
        Stamper.SetFont(this.impl, font.impl);
        ReachabilityHelper.ensureReachable(font);
    }

    public void setFontColor(ColorPt colorPt) {
        Stamper.SetFontColor(this.impl, colorPt.impl);
        ReachabilityHelper.ensureReachable(colorPt);
    }

    public void setOpacity(double d) {
        Stamper.SetOpacity(this.impl, d);
    }

    public void setRotation(double d) {
        Stamper.SetRotation(this.impl, d);
    }

    public void setAsBackground(boolean bl) {
        Stamper.SetAsBackground(this.impl, bl);
    }

    public void setAsAnnotation(boolean bl) {
        Stamper.SetAsAnnotation(this.impl, bl);
    }

    public void showsOnScreen(boolean bl) {
        Stamper.ShowsOnScreen(this.impl, bl);
    }

    public void showsOnPrint(boolean bl) {
        Stamper.ShowsOnPrint(this.impl, bl);
    }

    public void setPosition(double d, double d2) {
        Stamper.SetPosition(this.impl, d, d2);
    }

    public void setPosition(double d, double d2, boolean bl) {
        Stamper.SetPosition(this.impl, d, d2, bl);
    }

    public void setAlignment(int n, int n2) {
        Stamper.SetAlignment(this.impl, n, n2);
    }

    public void setTextAlignment(int n) {
        Stamper.SetTextAlignment(this.impl, n);
    }

    public void setSize(int n, double d, double d2) {
        Stamper.SetSize(this.impl, n, d, d2);
    }

    public static void deleteStamps(PDFDoc pDFDoc, PageSet pageSet) {
        Stamper.DeleteStamps(pDFDoc.__GetHandle(), pageSet.impl);
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(pageSet);
    }

    public static boolean hasStamps(PDFDoc pDFDoc, PageSet pageSet) {
        boolean bl = Stamper.HasStamps(pDFDoc.__GetHandle(), pageSet.impl);
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(pageSet);
        return bl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long StamperCreate(int var0, double var1, double var3);

    static native void Destroy(long var0);

    static native void StampImage(long var0, long var2, long var4, long var6);

    static native void StampPage(long var0, long var2, long var4, long var6);

    static native void StampText(long var0, long var2, String var4, long var5);

    static native void SetFont(long var0, long var2);

    static native void SetFontColor(long var0, long var2);

    static native void SetOpacity(long var0, double var2);

    static native void SetRotation(long var0, double var2);

    static native void SetAsBackground(long var0, boolean var2);

    static native void SetAsAnnotation(long var0, boolean var2);

    static native void ShowsOnScreen(long var0, boolean var2);

    static native void ShowsOnPrint(long var0, boolean var2);

    static native void SetPosition(long var0, double var2, double var4);

    static native void SetPosition(long var0, double var2, double var4, boolean var6);

    static native void SetAlignment(long var0, int var2, int var3);

    static native void SetTextAlignment(long var0, int var2);

    static native void SetSize(long var0, int var2, double var3, double var5);

    static native void DeleteStamps(long var0, long var2);

    static native boolean HasStamps(long var0, long var2);
}

