/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf.annots;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Action;
import com.pdftron.pdf.Annot;
import com.pdftron.pdf.Point;
import com.pdftron.pdf.QuadPoint;
import com.pdftron.pdf.Rect;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;

public class Link
extends Annot {
    public static final int e_none = 0;
    public static final int e_invert = 1;
    public static final int e_outline = 2;
    public static final int e_push = 3;

    public Link(Obj obj) {
        super(obj);
    }

    public Link() {
    }

    public Link(long l, Object object) {
        super(l, object);
    }

    public Link(Annot annot) throws PDFNetException {
        super(annot.getSDFObj());
    }

    public static Link create(Doc doc, Rect rect) throws PDFNetException {
        Link link = new Link(Link.Create(doc.__GetHandle(), rect.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(rect);
        return link;
    }

    public static Link create(Doc doc, Rect rect, Action action) throws PDFNetException {
        Link link = new Link(Link.Create(doc.__GetHandle(), rect.__GetHandle(), action.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(rect);
        ReachabilityHelper.ensureReachable(action);
        return link;
    }

    public void removeAction() throws PDFNetException {
        Link.RemoveAction(this.__GetHandle());
    }

    public Action getAction() throws PDFNetException {
        return Action.__Create(Link.GetAction(this.__GetHandle()), this.__GetRefHandle());
    }

    public void setAction(Action action) throws PDFNetException {
        Link.SetAction(this.__GetHandle(), action.__GetHandle());
    }

    public int getHighlightingMode() throws PDFNetException {
        return Link.GetHighlightingMode(this.__GetHandle());
    }

    public void setHighlightingMode(int n) throws PDFNetException {
        Link.SetHighlightingMode(this.__GetHandle(), n);
    }

    public int getQuadPointCount() throws PDFNetException {
        return Link.GetQuadPointCount(this.__GetHandle());
    }

    public QuadPoint getQuadPoint(int n) throws PDFNetException {
        Point point = new Point(Link.GetQuadPointp1x(this.__GetHandle(), n), Link.GetQuadPointp1y(this.__GetHandle(), n));
        Point point2 = new Point(Link.GetQuadPointp2x(this.__GetHandle(), n), Link.GetQuadPointp2y(this.__GetHandle(), n));
        Point point3 = new Point(Link.GetQuadPointp3x(this.__GetHandle(), n), Link.GetQuadPointp3y(this.__GetHandle(), n));
        Point point4 = new Point(Link.GetQuadPointp4x(this.__GetHandle(), n), Link.GetQuadPointp4y(this.__GetHandle(), n));
        return new QuadPoint(point, point2, point3, point4);
    }

    public void setQuadPoint(int n, QuadPoint quadPoint) throws PDFNetException {
        Link.SetQuadPoint(this.__GetHandle(), n, quadPoint.p1.x, quadPoint.p1.y, quadPoint.p2.x, quadPoint.p2.y, quadPoint.p3.x, quadPoint.p3.y, quadPoint.p4.x, quadPoint.p4.y);
    }

    static native long Create(long var0, long var2);

    static native long Create(long var0, long var2, long var4);

    static native void RemoveAction(long var0);

    static native long GetAction(long var0);

    static native void SetAction(long var0, long var2);

    static native int GetHighlightingMode(long var0);

    static native void SetHighlightingMode(long var0, int var2);

    static native int GetQuadPointCount(long var0);

    static native double GetQuadPointp1x(long var0, int var2);

    static native double GetQuadPointp1y(long var0, int var2);

    static native double GetQuadPointp2x(long var0, int var2);

    static native double GetQuadPointp2y(long var0, int var2);

    static native double GetQuadPointp3x(long var0, int var2);

    static native double GetQuadPointp3y(long var0, int var2);

    static native double GetQuadPointp4x(long var0, int var2);

    static native double GetQuadPointp4y(long var0, int var2);

    static native void SetQuadPoint(long var0, int var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);
}

