/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.sdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.filters.FilterReader;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;
import com.pdftron.sdf.ProgressMonitor;
import com.pdftron.sdf.SecurityHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SDFDoc
extends Doc
implements AutoCloseable {
    public static final int e_incremental = 1;
    public static final int e_remove_unused = 2;
    public static final int e_hex_strings = 4;
    public static final int e_omit_xref = 8;
    public static final int e_linearized = 16;
    public static final int e_compatibility = 32;
    Object ref;

    public SDFDoc() throws PDFNetException {
        this.impl = SDFDoc.SDFDocCreate();
        this.ref = null;
    }

    public SDFDoc(String string) throws PDFNetException {
        this.impl = SDFDoc.SDFDocCreate(string);
        this.ref = null;
    }

    public SDFDoc(Filter filter) throws PDFNetException {
        filter.__SetRefHandle(this);
        this.impl = SDFDoc.SDFDocCreate(filter.__GetHandle());
        this.ref = null;
    }

    public SDFDoc(byte[] byArray) throws PDFNetException {
        this.impl = SDFDoc.SDFDocCreate(byArray);
    }

    public SDFDoc(InputStream inputStream) throws PDFNetException, IOException {
        this(inputStream, 0x100000);
    }

    public SDFDoc(InputStream inputStream, int n) throws PDFNetException, IOException {
        long l = 0L;
        try {
            int n2;
            l = SDFDoc.MemStreamCreateMemFilt(inputStream.available());
            byte[] byArray = new byte[n];
            while ((n2 = inputStream.read(byArray)) != -1) {
                SDFDoc.MemStreamWriteData(l, byArray, n2);
            }
            this.impl = SDFDoc.MemStreamCreateDoc(l);
        }
        catch (PDFNetException pDFNetException) {
            Filter filter = Filter.__Create(l, null);
            filter.destroy();
            throw pDFNetException;
        }
        catch (IOException iOException) {
            Filter filter = Filter.__Create(l, null);
            filter.destroy();
            throw iOException;
        }
    }

    @Override
    public void close() throws PDFNetException {
        if (this.impl != 0L && this.ref == null) {
            SDFDoc.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isEncrypted() throws PDFNetException {
        return SDFDoc.IsEncrypted(this.impl);
    }

    public boolean initSecurityHandler() throws PDFNetException {
        return SDFDoc.InitSecurityHandler(this.impl, null);
    }

    public boolean initSecurityHandler(Object object) throws PDFNetException {
        return SDFDoc.InitSecurityHandler(this.impl, object);
    }

    public boolean initStdSecurityHandler(String string) throws PDFNetException {
        return SDFDoc.InitStdSecurityHandler(this.impl, string);
    }

    public boolean initStdSecurityHandler(byte[] byArray) throws PDFNetException {
        return SDFDoc.InitStdSecurityHandlerBuffer(this.impl, byArray);
    }

    public boolean isModified() throws PDFNetException {
        return SDFDoc.IsModified(this.impl);
    }

    public boolean hasRepairedXRef() throws PDFNetException {
        return SDFDoc.HasRepairedXRef(this.impl);
    }

    public void enableDiskCaching(boolean bl) {
        SDFDoc.EnableDiskCaching(this.impl, bl);
    }

    public boolean isFullSaveRequired() throws PDFNetException {
        return SDFDoc.IsFullSaveRequired(this.impl);
    }

    public boolean canSaveToPath(String string, long l) throws PDFNetException {
        return SDFDoc.CanSaveToPath(this.impl, string, l);
    }

    public boolean canSaveToPath(String string, SaveMode saveMode) throws PDFNetException {
        return SDFDoc.CanSaveToPath(this.impl, string, saveMode.getValue());
    }

    public Obj getTrailer() throws PDFNetException {
        return Obj.__Create(SDFDoc.GetTrailer(this.impl), this);
    }

    public Obj getObj(long l) throws PDFNetException {
        return Obj.__Create(SDFDoc.GetObj(this.impl, l), this);
    }

    public Obj importObj(Obj obj, boolean bl) throws PDFNetException {
        return Obj.__Create(SDFDoc.ImportObj(this.impl, obj.impl, bl), this);
    }

    public Obj[] importObjs(Obj[] objArray) throws PDFNetException {
        return this.importObjs(objArray, null);
    }

    public Obj[] importObjs(Obj[] objArray, Obj[] objArray2) throws PDFNetException {
        int n;
        long[] lArray = new long[objArray.length];
        long[] lArray2 = null;
        for (n = 0; n < lArray.length; ++n) {
            lArray[n] = objArray[n].impl;
        }
        if (objArray2 != null) {
            lArray2 = new long[objArray2.length];
            for (n = 0; n < lArray2.length; ++n) {
                lArray2[n] = objArray2[n].impl;
            }
        }
        long[] lArray3 = SDFDoc.ImportObjs(this.impl, lArray, lArray2);
        Obj[] objArray3 = new Obj[lArray3.length];
        for (int i = 0; i < lArray3.length; ++i) {
            objArray3[i] = Obj.__Create(lArray3[i], this);
        }
        return objArray3;
    }

    public long xRefSize() throws PDFNetException {
        return SDFDoc.XRefSize(this.impl);
    }

    public void clearMarks() throws PDFNetException {
        SDFDoc.ClearMarks(this.impl);
    }

    public void save(String string, long l, ProgressMonitor progressMonitor, String string2) throws PDFNetException {
        SDFDoc.Save(this.impl, string, l, progressMonitor, string2);
    }

    public void save(String string, SaveMode saveMode, ProgressMonitor progressMonitor, String string2) throws PDFNetException {
        SDFDoc.Save(this.impl, string, saveMode.getValue(), progressMonitor, string2);
    }

    public byte[] save(long l, ProgressMonitor progressMonitor, String string) throws PDFNetException {
        return SDFDoc.Save(this.impl, l, progressMonitor, string);
    }

    public byte[] save(SaveMode saveMode, ProgressMonitor progressMonitor, String string) throws PDFNetException {
        return SDFDoc.Save(this.impl, saveMode.getValue(), progressMonitor, string);
    }

    public void save(OutputStream outputStream, long l, ProgressMonitor progressMonitor, String string) throws PDFNetException, IOException {
        this.save(outputStream, l, progressMonitor, string, 0x100000);
    }

    public void save(OutputStream outputStream, SaveMode saveMode, ProgressMonitor progressMonitor, String string) throws PDFNetException, IOException {
        this.save(outputStream, saveMode.getValue(), progressMonitor, string, 0x100000);
    }

    public void save(OutputStream outputStream, long l, ProgressMonitor progressMonitor, String string, int n) throws PDFNetException, IOException {
        long l2;
        long[] lArray = SDFDoc.SaveStream(this.impl, l, progressMonitor, string);
        long l3 = lArray[1];
        byte[] byArray = new byte[n];
        long l4 = l3 - (long)n;
        for (l2 = lArray[0]; l2 < l4; l2 += (long)n) {
            SDFDoc.ReadData(byArray, n, l2);
            outputStream.write(byArray);
        }
        int n2 = (int)(l3 - l2);
        if (n2 > 0) {
            SDFDoc.ReadData(byArray, n2, l2);
            outputStream.write(byArray, 0, n2);
        }
    }

    public void save(OutputStream outputStream, SaveMode saveMode, ProgressMonitor progressMonitor, String string, int n) throws PDFNetException, IOException {
        this.save(outputStream, saveMode.getValue(), progressMonitor, string, n);
    }

    public String getHeader() throws PDFNetException {
        return SDFDoc.GetHeader(this.impl);
    }

    public SecurityHandler getSecurityHandler() {
        return SecurityHandler.__Create(SDFDoc.GetSecurityHandler(this.impl), this);
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        securityHandler.ref = this;
        SDFDoc.SetSecurityHandler(this.impl, securityHandler.impl);
        ReachabilityHelper.ensureReachable(securityHandler);
    }

    public void swap(long l, long l2) throws PDFNetException {
        SDFDoc.Swap(this.impl, l, l2);
    }

    public Obj createIndirectName(String string) throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectName(this.impl, string), this);
    }

    public Obj createIndirectArray() throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectArray(this.impl), this);
    }

    public Obj createIndirectBool(boolean bl) throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectBool(this.impl, bl), this);
    }

    public Obj createIndirectDict() throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectDict(this.impl), this);
    }

    public Obj createIndirectNull() throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectNull(this.impl), this);
    }

    public Obj createIndirectNumber(double d) throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectNumber(this.impl, d), this);
    }

    public Obj createIndirectString(byte[] byArray) throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectString(this.impl, byArray), this);
    }

    public Obj createIndirectString(String string) throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectString(this.impl, string), this);
    }

    public Obj createIndirectStream(FilterReader filterReader) throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectStream(this.impl, filterReader.__GetHandle(), 0L), this);
    }

    public Obj createIndirectStream(FilterReader filterReader, Filter filter) throws PDFNetException {
        if (filter != null) {
            filter.__SetRefHandle(this);
        }
        Obj obj = Obj.__Create(SDFDoc.CreateIndirectStream(this.impl, filterReader.__GetHandle(), filter.__GetHandle()), this);
        ReachabilityHelper.ensureReachable(filterReader);
        ReachabilityHelper.ensureReachable(filter);
        return obj;
    }

    public Obj createIndirectStream(byte[] byArray) throws PDFNetException {
        return Obj.__Create(SDFDoc.CreateIndirectStream(this.impl, byArray, 0L), this);
    }

    public Obj createIndirectStream(byte[] byArray, Filter filter) throws PDFNetException {
        if (filter != null) {
            filter.__SetRefHandle(this);
        }
        Obj obj = Obj.__Create(SDFDoc.CreateIndirectStream(this.impl, byArray, filter.__GetHandle()), this);
        ReachabilityHelper.ensureReachable(filter);
        return obj;
    }

    public boolean isLinearized() throws PDFNetException {
        return SDFDoc.IsLinearized(this.impl);
    }

    public Obj getLinearizationDict() throws PDFNetException {
        return Obj.__Create(SDFDoc.GetLinearizationDict(this.impl), this);
    }

    public Obj getHintStream() throws PDFNetException {
        return Obj.__Create(SDFDoc.GetHintStream(this.impl), this);
    }

    public void lock() throws PDFNetException {
        SDFDoc.Lock(this.impl);
    }

    public void unlock() throws PDFNetException {
        SDFDoc.Unlock(this.impl);
    }

    public boolean timedLock(int n) throws PDFNetException {
        return SDFDoc.TryLock(this.impl, n);
    }

    public void lockRead() throws PDFNetException {
        SDFDoc.LockRead(this.impl);
    }

    public void unlockRead() throws PDFNetException {
        SDFDoc.UnlockRead(this.impl);
    }

    public boolean tryLockRead() throws PDFNetException {
        return SDFDoc.TryLockRead(this.impl, 0);
    }

    public boolean timedLockRead(int n) throws PDFNetException {
        return SDFDoc.TryLockRead(this.impl, n);
    }

    public String getFileName() throws PDFNetException {
        return SDFDoc.GetFileName(this.impl);
    }

    SDFDoc(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    public static SDFDoc __Create(long l, Object object) {
        return new SDFDoc(l, object);
    }

    public void __SetRef(Object object) {
        this.ref = object;
    }

    public Object __GetRefHandle() {
        return this.ref;
    }

    @Override
    public long __GetHandle() {
        return this.impl;
    }

    public void removeSecurity() {
        SDFDoc.RemoveSecurity(this.impl);
    }

    static native long SDFDocCreate();

    static native long SDFDocCreate(String var0);

    static native long SDFDocCreate(long var0);

    static native long SDFDocCreate(byte[] var0);

    static native long MemStreamCreateMemFilt(long var0) throws PDFNetException;

    static native void MemStreamWriteData(long var0, byte[] var2, int var3);

    static native long MemStreamCreateDoc(long var0);

    static native void Destroy(long var0);

    static native boolean IsEncrypted(long var0);

    static native boolean InitSecurityHandler(long var0, Object var2);

    static native boolean InitStdSecurityHandler(long var0, String var2);

    static native boolean InitStdSecurityHandlerBuffer(long var0, byte[] var2);

    static native boolean IsModified(long var0);

    static native boolean HasRepairedXRef(long var0);

    static native boolean IsFullSaveRequired(long var0);

    static native boolean CanSaveToPath(long var0, String var2, long var3);

    static native void EnableDiskCaching(long var0, boolean var2);

    static native long GetTrailer(long var0);

    static native long GetObj(long var0, long var2);

    static native long ImportObj(long var0, long var2, boolean var4);

    static native long[] ImportObjs(long var0, long[] var2, long[] var3);

    static native long XRefSize(long var0);

    static native void ClearMarks(long var0);

    static native void Save(long var0, String var2, long var3, ProgressMonitor var5, String var6);

    static native byte[] Save(long var0, long var2, ProgressMonitor var4, String var5);

    static native long[] SaveStream(long var0, long var2, ProgressMonitor var4, String var5);

    static native void ReadData(byte[] var0, int var1, long var2);

    static native String GetHeader(long var0);

    static native long GetSecurityHandler(long var0);

    static native void SetSecurityHandler(long var0, long var2);

    static native void RemoveSecurity(long var0);

    static native void Swap(long var0, long var2, long var4);

    static native long CreateIndirectName(long var0, String var2);

    static native long CreateIndirectArray(long var0);

    static native long CreateIndirectBool(long var0, boolean var2);

    static native long CreateIndirectDict(long var0);

    static native long CreateIndirectNull(long var0);

    static native long CreateIndirectNumber(long var0, double var2);

    static native long CreateIndirectString(long var0, byte[] var2);

    static native long CreateIndirectString(long var0, String var2);

    static native long CreateIndirectStream(long var0, long var2, long var4);

    static native long CreateIndirectStream(long var0, byte[] var2, long var3);

    static native boolean IsLinearized(long var0);

    static native long GetLinearizationDict(long var0);

    static native long GetHintStream(long var0);

    static native void Lock(long var0);

    static native void Unlock(long var0);

    static native boolean TryLock(long var0, int var2);

    static native void LockRead(long var0);

    static native void UnlockRead(long var0);

    static native boolean TryLockRead(long var0, int var2);

    static native String GetFileName(long var0);

    public static enum SaveMode {
        INCREMENTAL(1),
        REMOVE_UNUSED(2),
        HEX_STRINGS(4),
        OMIT_XREF(8),
        LINEARIZED(16),
        COMPATIBILITY(32),
        NO_FLAGS(0);

        private final int mode;

        private SaveMode(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }
}

