//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFBarcodeModule
#define PDFTRON_H_CPPPDFBarcodeModule
#include <C/PDF/TRN_BarcodeModule.h>

#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>
#include <PDF/BarcodeOptions.h>

namespace pdftron { namespace PDF { 


/**
 * The class BarcodeModule.
 * static interface to Apryse SDK's barcode extraction functionality
 */
class BarcodeModule
{
public:
		
	/**
	 * Find out whether the Barcode Extraction Module is available (and
	 * licensed).
	 * 
	 * @return Returns true if barcode extraction can be performed.
	 */
	static bool IsModuleAvailable();
	
	/**
	 * Perform barcode extraction on a PDF. Scan the PDF for barcodes, and
	 * save a JSON array of detected barcodes to the specified file. By
	 * default, this will search for all supported barcode types in all
	 * orientations. The time required to process the document will depend on
	 * the number of barcode types and orientations to search for. Thus, the
	 * default behavior is the slowest. To improve speed, specify a subset of
	 * barcode types and orientations to search for using the options
	 * parameter. Very small barcodes may not be detected. While there is no
	 * hard limit to barcode size, accuracy will begin to decrease as
	 * barcodes get smaller. The smallest barcode that can be detected will
	 * depend on a number of factors, including page size, barcode type, and
	 * (if applicable) image quality.
	 * 
	 * @param src The source document.
	 * @param output_file_path The path to the output file.
	 * @param options Barcode options (optional).
	 */
	static void ExtractBarcodes(PDFDoc& src, const UString& output_file_path, const BarcodeOptions& options = BarcodeOptions());
	
	/**
	 * Perform barcode extraction on a PDF. Scan the PDF for barcodes, and
	 * return a JSON array of detected barcodes as a string. By default, this
	 * will search for all supported barcode types in all orientations. The
	 * time required to process the document will depend on the number of
	 * barcode types and orientations to search for. Thus, the default
	 * behavior is the slowest. To improve speed, specify a subset of barcode
	 * types and orientations to search for using the options parameter. Very
	 * small barcodes may not be detected. While there is no hard limit to
	 * barcode size, accuracy will begin to decrease as barcodes get smaller.
	 * The smallest barcode that can be detected will depend on a number of
	 * factors, including page size, barcode type, and (if applicable) image
	 * quality.
	 * 
	 * @param src The source document.
	 * @param options Barcode options (optional).
	 * @return JSON string representing barcode extraction results.
	 */
	static UString ExtractBarcodesAsString(PDFDoc& src, const BarcodeOptions& options = BarcodeOptions());

};

#include <Impl/BarcodeModule.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFBarcodeModule
