// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFDataExtractionOptions
#define PDFTRON_H_CPPPDFDataExtractionOptions

#include <PDF/OptionsBase.h>

namespace pdftron{ namespace PDF{ 

class DataExtractionOptions : public OptionsBase
{
public:
	DataExtractionOptions();
	~DataExtractionOptions();

	
	/**
	* Gets the value DeepLearningAssist from the options object.
	* Specifies if Deep Learning is used with table recognition in the
	* DocStructure engine. The default is false. When true, table
	* recognition accuracy improves at the cost of increased processing
	* time. This only affects the DocStructure engine.
	* @return The current value for DeepLearningAssist.
	*/
	bool GetDeepLearningAssist();

	/**
	* Sets the value for DeepLearningAssist in the options object.
	* Specifies if Deep Learning is used with table recognition in the
	* DocStructure engine. The default is false. When true, table
	* recognition accuracy improves at the cost of increased processing
	* time. This only affects the DocStructure engine.
	* @param value The new value for DeepLearningAssist.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetDeepLearningAssist(bool value);

	

	/**
	* Gets the value DetectEmptyFields from the options object.
	* Specifies if empty fields should be recognized in the GenericKeyValue
	* engine. The default is true. Users who don't require empty fields
	* could benefit from setting this option to false, thus reducing
	* processing time. This setting only affects the GenericKeyValue engine.
	* @return The current value for DetectEmptyFields.
	*/
	bool GetDetectEmptyFields();

	/**
	* Sets the value for DetectEmptyFields in the options object.
	* Specifies if empty fields should be recognized in the GenericKeyValue
	* engine. The default is true. Users who don't require empty fields
	* could benefit from setting this option to false, thus reducing
	* processing time. This setting only affects the GenericKeyValue engine.
	* @param value The new value for DetectEmptyFields.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetDetectEmptyFields(bool value);

	
	/**
	* Adds the value to the ExclusionZonesForPage array.
	* Optional list of page areas to be excluded from analysis. Zones should
	* be provided as a collection of Rects paired with a page number. The
	* Rects are then applied to the corresponding page. Rects are specified
	* in User Space coordinates. If this is set, the specified areas will
	* not be analyzed. If neither this nor InclusionZonesForPage is set,
	* the entire page will be analyzed. This option only affects the
	* GenericKeyValue, FormKeyValue, and FormField engines.
	* @param value List of page areas to be excluded from analysis.
	* @param page_num The page number (1-indexed) to which the regions are applied.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& AddExclusionZonesForPage(RectCollection& value, int page_num);

	
	/**
	* Gets the value FormExtractionEngine from the options object.
	* Specifies the form extraction engine used in
	* DetectAndAddFormFieldsToPDF, either 'Form' or 'FormKeyValue'. The
	* default is 'Form'.
	* @return The current value for FormExtractionEngine.
	*/
	UString GetFormExtractionEngine();

	/**
	* Sets the value for FormExtractionEngine in the options object.
	* Specifies the form extraction engine used in
	* DetectAndAddFormFieldsToPDF, either 'Form' or 'FormKeyValue'. The
	* default is 'Form'.
	* @param value The new value for FormExtractionEngine.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetFormExtractionEngine(const UString& value);

	

	/**
	* Adds the value to the InclusionZonesForPage array.
	* Optional list of page areas to be included in analysis (to the
	* exclusion of all other areas). Zones should be provided as a
	* collection of Rects paired with a page number. The Rects are then
	* applied to the corresponding page. Rects are specified in User Space
	* coordinates. If this is set, only the areas specified will be
	* analyzed. If neither this nor ExclusionZonesForPage is set, the entire
	* page will be analyzed. This option only affects the GenericKeyValue,
	* FormKeyValue, and FormField engines.
	* @param value List of page areas to be included in analysis.
	* @param page_num The page number (1-indexed) to which the regions are applied.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& AddInclusionZonesForPage(RectCollection& value, int page_num);

	
	/**
	* Gets the value Language from the options object.
	* Specifies the OCR language(s). Use 3-letter ISO 639-2 language codes,
	* separated by spaces. Example: "eng deu spa fra". The default is
	* English.
	* @return The current value for Language.
	*/
	UString GetLanguage();

	/**
	* Sets the value for Language in the options object.
	* Specifies the OCR language(s). Use 3-letter ISO 639-2 language codes,
	* separated by spaces. Example: "eng deu spa fra". The default is
	* English.
	* @param value The new value for Language.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetLanguage(const UString& value);

	
	/**
	* Gets the value MinimumConfidenceThreshold from the options object.
	* Specifies the minimum confidence threshold for a class to be accepted
	* in the DocClassification engine. The default is 0.25. Classes that
	* don't meet the minimum threshold will not be listed in the output
	* JSON. This setting only affects the DocClassification engine.
	* @return The current value for MinimumConfidenceThreshold.
	*/
	double GetMinimumConfidenceThreshold();

	/**
	* Sets the value for MinimumConfidenceThreshold in the options object.
	* Specifies the minimum confidence threshold for a class to be accepted
	* in the DocClassification engine. The default is 0.25. Classes that
	* don't meet the minimum threshold will not be listed in the output
	* JSON. This setting only affects the DocClassification engine.
	* @param value The new value for MinimumConfidenceThreshold.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetMinimumConfidenceThreshold(double value);

	
	/**
	* Gets the value OverlappingFormFieldBehavior from the options object.
	* When a detected form field overlaps with an existing one, keep either
	* the old field (value 'KeepOld'), or the new one (value 'KeepNew',
	* default).
	* @return The current value for OverlappingFormFieldBehavior.
	*/
	UString GetOverlappingFormFieldBehavior();

	/**
	* Sets the value for OverlappingFormFieldBehavior in the options object.
	* When a detected form field overlaps with an existing one, keep either
	* the old field (value 'KeepOld'), or the new one (value 'KeepNew',
	* default).
	* @param value The new value for OverlappingFormFieldBehavior.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetOverlappingFormFieldBehavior(const UString& value);

	
	/**
	* Gets the value PDFPassword from the options object.
	* Specifies the password if the PDF requires one. The default is no
	* password.
	* @return The current value for PDFPassword.
	*/
	UString GetPDFPassword();

	/**
	* Sets the value for PDFPassword in the options object.
	* Specifies the password if the PDF requires one. The default is no
	* password.
	* @param value The new value for PDFPassword.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetPDFPassword(const UString& value);

	
	/**
	* Gets the value Pages from the options object.
	* Specifies a range of pages to be converted, such as "1-5". By default
	* all pages are converted. The first page has the page number of 1.
	* @return The current value for Pages.
	*/
	UString GetPages();

	/**
	* Sets the value for Pages in the options object.
	* Specifies a range of pages to be converted, such as "1-5". By default
	* all pages are converted. The first page has the page number of 1.
	* @param value The new value for Pages.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetPages(const UString& value);

	
	/**
	* Gets the value TextRecoveryNSE from the options object.
	* Specifies whether to use OCR in order to automatically recover text with a non-standard encoding. Default is true.
	* This setting only affects the DocStructure engine.
	* Note: This option should only be used by customers who are already familiar with the Solid Documents SDK from being a customer, or if they have been advised by support.
	* @return The current value for TextRecoveryNSE.
	*/
	bool GetTextRecoveryNSE();

	/**
	* Sets the value TextRecoveryNSE in the options object.
	* Specifies whether to use OCR in order to automatically recover text with a non-standard encoding. Default is true.
	* This setting only affects the DocStructure engine.
	* Note: This option should only be used by customers who are already familiar with the Solid Documents SDK from being a customer, or if they have been advised by support.
	* @param value The new value for TextRecoveryNSE.
	* @return This object, for call chaining.
	*/
	DataExtractionOptions& SetTextRecoveryNSE(bool value);
	
};

}
}

#include "../Impl/DataExtractionOptions.inl"
#endif // PDFTRON_H_CPPPDFDataExtractionOptions
