//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFPrintToPdfModule
#define PDFTRON_H_CPPPDFPrintToPdfModule
#include <C/PDF/TRN_PrintToPdfModule.h>

#include <PDF/PrintToPdfOptions.h>
#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace PDF { 

/**
 * The class PrintToPdfModule.
 * An interface into Apryse SDKs Print To PDF functionality
 */
class PrintToPdfModule
{
public:
		
	/**
	 * Find out whether the PrintToPdf module is available.
	 * 
	 * @return returns true if PrintToPdf can be performed.
	 */
	static bool IsModuleAvailable();
	
	/**
	 * Generate a PDF file by printing a document to the Apryse PDF printer via the Windows print verb.
	 * 
	 * @param pdf_doc -- The destination document.
	 * @param file_to_print -- The source document filename.
	 * @param options -- Print options (optional).
	 */
	static void PrintToPdf(PDFDoc& pdf_doc, const UString& file_to_print, PrintToPdfOptions* options = 0);
};

#include <Impl/PrintToPdfModule.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFPrintToPdfModule
