/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.filters;

import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;

public abstract class CustomFilter
extends Filter
implements AutoCloseable {
    public static final String TAG = "save CustomFilter";
    private byte[] m_read_buf;
    public static final int READ_MODE = 0;
    public static final int WRITE_MODE = 1;
    public static final int APPEND_MODE = 2;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private Object mUserObject;
    protected long callback_data;

    public CustomFilter(int n, Object object) throws PDFNetException {
        super(0L, null);
        if (n < 0 || n > 2) {
            throw new PDFNetException("false", 31L, "CustomFilter.java", "CustomFilter()", "Filter mode is incorrect.");
        }
        this.m_read_buf = null;
        this.mUserObject = object;
        long[] lArray = CustomFilter.CustomFilterCreate(new CustomFilterCallback(), n);
        this.impl = lArray[0];
        this.callback_data = lArray[1];
    }

    protected CustomFilter(long l, Filter filter) {
        super(l, filter);
    }

    public abstract long onRead(byte[] var1, Object var2);

    public abstract long onSeek(long var1, int var3, Object var4);

    public abstract long onTell(Object var1);

    public long onTruncate(long l, Object object) {
        return -1L;
    }

    public abstract long onFlush(Object var1);

    public abstract long onWrite(byte[] var1, Object var2);

    public abstract long onCreateInputIterator(Object var1);

    public abstract void onDestroy(Object var1);

    @Override
    public abstract void close();

    public Object getUserObject() {
        return this.mUserObject;
    }

    @Override
    public String getName() throws PDFNetException {
        return new String("CustomFilter");
    }

    @Override
    public void destroy() throws PDFNetException {
        if (this.attached == null && this.impl != 0L && this.ref == null) {
            CustomFilter.Destroy(this.impl);
            this.impl = 0L;
        }
        if (this.attached == null && this.callback_data != 0L && this.ref == null) {
            CustomFilter.DestroyCallbackData(this.callback_data);
            this.callback_data = 0L;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.destroy();
    }

    private void afterRead(byte[] byArray, long l, long l2) {
        CustomFilter.AfterRead(this.impl, byArray, l, l2);
    }

    static native void Destroy(long var0);

    static native void DestroyCallbackData(long var0);

    static native long[] CustomFilterCreate(CustomFilterCallback var0, int var1);

    static native void AfterRead(long var0, byte[] var2, long var3, long var5);

    static long[] CustomFilterCreate2(Object object, int n) throws PDFNetException {
        return CustomFilter.CustomFilterCreate((CustomFilterCallback)object, n);
    }

    static /* synthetic */ byte[] access$002(CustomFilter customFilter, byte[] byArray) {
        customFilter.m_read_buf = byArray;
        return byArray;
    }

    class CustomFilterCallback {
        CustomFilterCallback() {
        }

        private long Read(long l, long l2, long l3) {
            int n = (int)(l * l2);
            if (CustomFilter.this.m_read_buf == null || CustomFilter.this.m_read_buf.length < n) {
                CustomFilter.access$002(CustomFilter.this, new byte[n]);
            }
            long l4 = CustomFilter.this.onRead(CustomFilter.this.m_read_buf, CustomFilter.this.mUserObject);
            CustomFilter.this.afterRead(CustomFilter.this.m_read_buf, l4, l3);
            return l4;
        }

        private long Seek(long l, int n) {
            long l2 = CustomFilter.this.onSeek(l, n, CustomFilter.this.mUserObject);
            return l2;
        }

        private long Tell() {
            long l = CustomFilter.this.onTell(CustomFilter.this.mUserObject);
            return l;
        }

        private long Truncate(long l) {
            long l2 = CustomFilter.this.onTruncate(l, CustomFilter.this.mUserObject);
            return l2;
        }

        private long Flush() {
            long l = CustomFilter.this.onFlush(CustomFilter.this.mUserObject);
            return l;
        }

        private long Write(byte[] byArray) {
            long l = CustomFilter.this.onWrite(byArray, CustomFilter.this.mUserObject);
            return l;
        }

        private long CreateInputIterator() {
            long l = CustomFilter.this.onCreateInputIterator(CustomFilter.this.mUserObject);
            return l;
        }

        private void Destroy() {
            CustomFilter.this.onDestroy(CustomFilter.this.mUserObject);
        }
    }
}

