/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.filters;

import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.filters.FilterReader;
import com.pdftron.helpers.ReachabilityHelper;

public class FilterWriter
implements AutoCloseable {
    Filter attached;
    long impl;

    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            FilterWriter.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    protected void finalize() throws PDFNetException {
        this.destroy();
    }

    public FilterWriter() throws PDFNetException {
        this.impl = FilterWriter.FilterWriterCreate();
        this.attached = null;
    }

    public FilterWriter(Filter filter) throws PDFNetException {
        this.impl = FilterWriter.FilterWriterCreate(filter.impl);
        this.attached = filter;
    }

    public void writeUChar(byte by) throws PDFNetException {
        FilterWriter.WriteUChar(this.impl, by);
    }

    public void writeInt(int n) throws PDFNetException {
        FilterWriter.WriteInt(this.impl, n);
    }

    public void writeString(String string) throws PDFNetException {
        FilterWriter.WriteString(this.impl, string);
    }

    public void writeFilter(FilterReader filterReader) throws PDFNetException {
        FilterWriter.WriteFilter(this.impl, filterReader.impl);
        ReachabilityHelper.ensureReachable(filterReader);
    }

    public void writeLine(String string) throws PDFNetException {
        FilterWriter.WriteLine(this.impl, string);
    }

    public long writeBuffer(byte[] byArray) throws PDFNetException {
        return FilterWriter.WriteBuffer(this.impl, byArray);
    }

    public void attachFilter(Filter filter) throws PDFNetException {
        FilterWriter.AttachFilter(this.impl, filter.impl);
        this.attached = filter;
    }

    public Filter getAttachedFilter() throws PDFNetException {
        return this.attached;
    }

    public void seek(long l, int n) throws PDFNetException {
        FilterWriter.Seek(this.impl, l, n);
    }

    public long tell() throws PDFNetException {
        return FilterWriter.Tell(this.impl);
    }

    public long count() throws PDFNetException {
        return FilterWriter.Count(this.impl);
    }

    public void flush() throws PDFNetException {
        FilterWriter.Flush(this.impl);
    }

    public void flushAll() throws PDFNetException {
        FilterWriter.FlushAll(this.impl);
    }

    public long __GetHandle() {
        return this.impl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long FilterWriterCreate();

    static native long FilterWriterCreate(long var0);

    static native void WriteUChar(long var0, byte var2);

    static native void WriteInt(long var0, int var2);

    static native void WriteString(long var0, String var2);

    static native void WriteFilter(long var0, long var2);

    static native void WriteLine(long var0, String var2);

    static native long WriteBuffer(long var0, byte[] var2);

    static native void AttachFilter(long var0, long var2);

    static native void Seek(long var0, long var2, int var4);

    static native long Tell(long var0);

    static native long Count(long var0);

    static native void Flush(long var0);

    static native void FlushAll(long var0);
}

