/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.layout;

import com.pdftron.common.PDFNetException;
import com.pdftron.layout.ContentNode;
import com.pdftron.layout.List;
import com.pdftron.layout.Paragraph;
import com.pdftron.layout.Table;
import com.pdftron.pdf.PDFDoc;

public class FlowDocument
implements AutoCloseable {
    private long mImpl = FlowDocument.Create();

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            FlowDocument.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public Paragraph addParagraph() throws PDFNetException {
        return new Paragraph(FlowDocument.AddParagraph(this.mImpl));
    }

    public Paragraph addParagraph(String string) throws PDFNetException {
        Paragraph paragraph = new Paragraph(FlowDocument.AddParagraph(this.mImpl));
        paragraph.addText(string);
        return paragraph;
    }

    public Table addTable() throws PDFNetException {
        return new Table(FlowDocument.AddTable(this.mImpl));
    }

    public List addList() throws PDFNetException {
        return new List(FlowDocument.AddList(this.mImpl));
    }

    public void setDefaultMargins(double d, double d2, double d3, double d4) throws PDFNetException {
        FlowDocument.SetDefaultMargins(this.mImpl, d, d2, d3, d4);
    }

    public void setDefaultPageSize(double d, double d2) throws PDFNetException {
        FlowDocument.SetDefaultPageSize(this.mImpl, d, d2);
    }

    public PDFDoc paginateToPDF() throws PDFNetException {
        return PDFDoc.__Create(FlowDocument.PaginateToPDF(this.mImpl));
    }

    public ContentNode getBody() throws PDFNetException {
        ContentNode contentNode = new ContentNode(FlowDocument.GetBody(this.mImpl));
        return contentNode;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long Create() throws PDFNetException;

    static native void Destroy(long var0) throws PDFNetException;

    static native long AddParagraph(long var0) throws PDFNetException;

    static native long AddTable(long var0) throws PDFNetException;

    static native long AddList(long var0) throws PDFNetException;

    static native void SetDefaultMargins(long var0, double var2, double var4, double var6, double var8) throws PDFNetException;

    static native void SetDefaultPageSize(long var0, double var2, double var4) throws PDFNetException;

    static native long PaginateToPDF(long var0) throws PDFNetException;

    static native long GetBody(long var0) throws PDFNetException;
}

