/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.PDFDoc;
import com.pdftron.pdf.TextSearchResult;
import com.pdftron.pdf.ocg.Context;

public class TextSearch
implements AutoCloseable {
    public static final int e_reg_expression = 1;
    public static final int e_case_sensitive = 2;
    public static final int e_whole_word = 4;
    public static final int e_search_up = 8;
    public static final int e_page_stop = 16;
    public static final int e_highlight = 32;
    public static final int e_ambient_string = 64;
    public static final int e_raw_text_search = 128;
    public static final int e_search_using_zorder = 256;
    Object ctx_ref = null;
    long impl = TextSearch.TextSearchCreate();

    public void destroy() {
        if (this.impl != 0L) {
            TextSearch.Delete(this.impl);
            this.impl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public boolean begin(PDFDoc pDFDoc, String string, int n, int n2, int n3) {
        boolean bl = TextSearch.Begin(this.impl, pDFDoc.__GetHandle(), string, n, n2, n3);
        ReachabilityHelper.ensureReachable(pDFDoc);
        return bl;
    }

    public TextSearchResult run() {
        TextSearchResult textSearchResult = TextSearch.Run(this.impl);
        textSearchResult.highlights.ctx_ref = this;
        return textSearchResult;
    }

    public boolean setPattern(String string) {
        return TextSearch.SetPattern(this.impl, string);
    }

    public int getMode() {
        return TextSearch.GetMode(this.impl);
    }

    public void setMode(int n) {
        TextSearch.SetMode(this.impl, n);
    }

    public int getCurrentPage() {
        return TextSearch.GetCurrentPage(this.impl);
    }

    public void setRightToLeftLanguage(boolean bl) {
        TextSearch.SetRightToLeftLanguage(this.impl, bl);
    }

    public void setAmbientLettersBefore(int n) throws PDFNetException {
        TextSearch.SetAmbientLettersBefore(this.impl, n);
    }

    public void setAmbientLettersAfter(int n) throws PDFNetException {
        TextSearch.SetAmbientLettersAfter(this.impl, n);
    }

    public void setAmbientWordsBefore(int n) throws PDFNetException {
        TextSearch.SetAmbientWordsBefore(this.impl, n);
    }

    public void setAmbientWordsAfter(int n) throws PDFNetException {
        TextSearch.SetAmbientWordsAfter(this.impl, n);
    }

    static native void SetAmbientLettersBefore(long var0, int var2);

    static native void SetAmbientLettersAfter(long var0, int var2);

    static native void SetAmbientWordsBefore(long var0, int var2);

    static native void SetAmbientWordsAfter(long var0, int var2);

    public void setOCGContext(Context context) {
        this.ctx_ref = context;
        if (context == null) {
            TextSearch.SetOCGContext(this.impl, 0L);
        } else {
            TextSearch.SetOCGContext(this.impl, context.__GetHandle());
            ReachabilityHelper.ensureReachable(context);
        }
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long TextSearchCreate();

    static native void Delete(long var0);

    static native boolean Begin(long var0, long var2, String var4, int var5, int var6, int var7);

    static native TextSearchResult Run(long var0);

    static native boolean SetPattern(long var0, String var2);

    static native int GetMode(long var0);

    static native void SetMode(long var0, int var2);

    static native int GetCurrentPage(long var0);

    static native void SetRightToLeftLanguage(long var0, boolean var2);

    static native void SetOCGContext(long var0, long var2);
}

