/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.X509Certificate;
import com.pdftron.fdf.FDFDoc;
import com.pdftron.helpers.ReachabilityHelper;
import java.util.HashMap;

public class VerificationOptions
implements AutoCloseable {
    private long mImpl;

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            VerificationOptions.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public VerificationOptions(long l) {
        this.mImpl = l;
    }

    public VerificationOptions(SecurityLevel securityLevel) throws PDFNetException {
        this.mImpl = VerificationOptions.Create(securityLevel.value);
    }

    public void addTrustedCertificate(byte[] byArray, long l) throws PDFNetException {
        VerificationOptions.AddTrustedCertificateFlags(this.mImpl, byArray, l);
    }

    public void addTrustedCertificate(byte[] byArray) throws PDFNetException {
        VerificationOptions.AddTrustedCertificate(this.mImpl, byArray);
    }

    public void addTrustedCertificate(String string, long l) throws PDFNetException {
        VerificationOptions.AddTrustedCertificateStringFlags(this.mImpl, string, l);
    }

    public void addTrustedCertificate(String string) throws PDFNetException {
        VerificationOptions.AddTrustedCertificateString(this.mImpl, string);
    }

    public void addTrustedCertificates(byte[] byArray) throws PDFNetException {
        VerificationOptions.AddTrustedCertificates(this.mImpl, byArray);
    }

    public void loadTrustList(FDFDoc fDFDoc) throws PDFNetException {
        VerificationOptions.LoadTrustList(this.mImpl, fDFDoc.__GetHandle());
        ReachabilityHelper.ensureReachable(fDFDoc);
    }

    public void enableModificationVerification(boolean bl) throws PDFNetException {
        VerificationOptions.EnableModificationVerification(this.mImpl, bl);
    }

    public void enableDigestVerification(boolean bl) throws PDFNetException {
        VerificationOptions.EnableDigestVerification(this.mImpl, bl);
    }

    public void enableTrustVerification(boolean bl) throws PDFNetException {
        VerificationOptions.EnableTrustVerification(this.mImpl, bl);
    }

    public void setRevocationTimeout(long l) throws PDFNetException {
        VerificationOptions.SetRevocationTimeout(this.mImpl, l);
    }

    public void enableOnlineCRLRevocationChecking(boolean bl) throws PDFNetException {
        VerificationOptions.EnableOnlineCRLRevocationChecking(this.mImpl, bl);
    }

    public void enableOnlineOCSPRevocationChecking(boolean bl) throws PDFNetException {
        VerificationOptions.EnableOnlineOCSPRevocationChecking(this.mImpl, bl);
    }

    public void enableOnlineRevocationChecking(boolean bl) throws PDFNetException {
        VerificationOptions.EnableOnlineRevocationChecking(this.mImpl, bl);
    }

    public long __GetHandle() {
        return this.mImpl;
    }

    public int getTrustedCertificateCount() throws PDFNetException {
        return VerificationOptions.GetTrustedCertificateCount(this.mImpl);
    }

    public X509Certificate getTrustedCertificate(int n) throws PDFNetException {
        return new X509Certificate(VerificationOptions.GetTrustedCertificate(this.mImpl, n));
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long Create(int var0);

    static native void AddTrustedCertificateFlags(long var0, byte[] var2, long var3);

    static native void AddTrustedCertificate(long var0, byte[] var2);

    static native void EnableModificationVerification(long var0, boolean var2);

    static native void EnableDigestVerification(long var0, boolean var2);

    static native void EnableTrustVerification(long var0, boolean var2);

    static native void AddTrustedCertificateStringFlags(long var0, String var2, long var3);

    static native void AddTrustedCertificateString(long var0, String var2);

    static native void SetRevocationTimeout(long var0, long var2);

    static native void EnableOnlineCRLRevocationChecking(long var0, boolean var2);

    static native void EnableOnlineOCSPRevocationChecking(long var0, boolean var2);

    static native void EnableOnlineRevocationChecking(long var0, boolean var2);

    static native void AddTrustedCertificates(long var0, byte[] var2);

    static native void LoadTrustList(long var0, long var2);

    static native int GetTrustedCertificateCount(long var0);

    static native long GetTrustedCertificate(long var0, int var2);

    public static enum CertificateTrustFlag {
        e_signing_trust(1),
        e_certification_trust(2),
        e_dynamic_content(4),
        e_javascript(16),
        e_identity(32),
        e_trust_anchor(64),
        e_default_trust(97),
        e_complete_trust(119);

        public final int value;
        private static HashMap<Integer, CertificateTrustFlag> trust_flags_map;

        private CertificateTrustFlag(int n2) {
            this.value = n2;
        }

        static CertificateTrustFlag valueToEnum(int n) {
            return trust_flags_map.get(n);
        }

        static {
            trust_flags_map = new HashMap();
            for (CertificateTrustFlag certificateTrustFlag : CertificateTrustFlag.values()) {
                trust_flags_map.put(certificateTrustFlag.value, certificateTrustFlag);
            }
        }
    }

    public static enum TimeMode {
        e_signing(0),
        e_timestamp(1),
        e_current(2);

        final int value;
        private static HashMap<Integer, TimeMode> time_modes_map;

        private TimeMode(int n2) {
            this.value = n2;
        }

        static TimeMode valueToEnum(int n) {
            return time_modes_map.get(n);
        }

        static {
            time_modes_map = new HashMap();
            for (TimeMode timeMode : TimeMode.values()) {
                time_modes_map.put(timeMode.value, timeMode);
            }
        }
    }

    public static enum SecurityLevel {
        e_compatibility_and_archiving(0),
        e_maximum(1);

        final int value;
        private static HashMap<Integer, SecurityLevel> security_level_map;

        private SecurityLevel(int n2) {
            this.value = n2;
        }

        static SecurityLevel valueToEnum(int n) {
            return security_level_map.get(n);
        }

        static {
            security_level_map = new HashMap();
            for (SecurityLevel securityLevel : SecurityLevel.values()) {
                security_level_map.put(securityLevel.value, securityLevel);
            }
        }
    }
}

