//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFExternalAnnotManager
#define PDFTRON_H_CPPPDFExternalAnnotManager
#include <C/PDF/TRN_ExternalAnnotManager.h>
#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace PDF { 


/**
 * The class ExternalAnnotManager.
 * A manager class attached to a PDFView that takes care of annotations
 * from xfdf sources
 *
 * ExternalAnnotManager instances are created through the PDFView using PDFView.GetExternalAnnotManager()
 */
class ExternalAnnotManager
{
public:
	enum Mode				// Important: all collaborators need to use the same Mode
	{
		e_user_only,			// each user can only edit the annotations they created
		e_admin_undo_others,	// all the annotations can be edited, can undo yours and other's changes
		e_admin_undo_own		// all the annotations can be edited, can undo only your changes. Incremental save is not supported in this mode
	};
	
	ExternalAnnotManager();
	ExternalAnnotManager(const ExternalAnnotManager& other);
	ExternalAnnotManager(TRN_ExternalAnnotManager impl);
	ExternalAnnotManager& operator= (const ExternalAnnotManager& other);
	~ExternalAnnotManager();
	
	void Destroy();

	//methods:
	
	/**
	 * Merge an xfdf string into the current document. This Xfdf can be in normal Adobe format, or it contain xfdf commands like add, delete, and modify.
	 * 
	 * @param xfdf_content -- xfdf string with content to be added to the document.
	 */
	void MergeXFDF(UString xfdf_content);
	
	/**
	 * Perform the conversion. Will throw an exception on failure.
	 * 
	 * @return a string consisting of the payload that was provided when TakeSnapshot was called. If that payload was in JSON format, then it will have added field "xfdf", containing the xfdf commands representing the changes made by this call (if any).
	 */
	UString Undo();
	
	/**
	 * Retrieve the last XFDF command string produced by the last call to either Undo, Redo, or TakeSnapshot.
	 * 
	 * @return an xfdf command string.
	 */
	UString GetLastXFDF() const;

	/**
	 * Retrieve the last JSON command string produced by the last call to either Undo, Redo, or TakeSnapshot.
	 * 
	 * @return a json command string.
	 */
	UString GetLastJSON() const;
	
	/**
	 * Perform the conversion. Will throw an exception on failure. Does nothing if the conversion is already complete. Use GetConversionStatus() to check if there is remaining content to be converted.
	 * 
	 * @return a string consisting of the payload that was provided when TakeSnapshot was called. If that payload was in JSON format, then it will have added field "xfdf", containing the xfdf commands representing the changes made by this call (if any).
	 */
	UString Redo();
	
	/**
	 * Returns any meta-data associated with the next state in the redo chain.
	 * 
	 * @return a string consisting of the payload that was provided when TakeSnapshot was called.
	 */
	UString GetNextRedoInfo();
	
	/**
	 * Returns any meta-data associated with the next state in the undo chain.
	 * 
	 * @return a string consisting of the payload that was provided when TakeSnapshot was called.
	 */
	UString GetNextUndoInfo();
	
	/**
	 * Take an undo snapshot, returning the xfdf command string representing any change in state since the last snapshot.
	 * 
	 * @param payload -- a string that will be returned when Undo or Redo are called such that the transition marked by this snapshot is reversed..
	 * @return an xfdf string.
	 */
	UString TakeSnapshot(UString payload);

#ifndef SWIGHIDDEN
	TRN_ExternalAnnotManager m_impl;
#endif

private:

#ifndef SWIGHIDDEN
	mutable bool m_owner; 
#endif
};

#include <Impl/ExternalAnnotManager.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFExternalAnnotManager
