// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFPrintToPdfOptions
#define PDFTRON_H_CPPPDFPrintToPdfOptions

#include <PDF/OptionsBase.h>

namespace pdftron{ namespace PDF{ 

class PrintToPdfOptions : public OptionsBase
{
public:
	PrintToPdfOptions();
	~PrintToPdfOptions();

	
	/**
	* Gets the value HorizontalPageMargin from the options object
	* The horizontal margins (left and right) in points. The default is a 1/4 of an inch or 18 points.
	* @return a double, the current value for HorizontalPageMargin.
	*/
	double GetHorizontalPageMargin();

	/**
	* Sets the value for HorizontalPageMargin in the options object
	* The horizontal margins (left and right) in points. The default is a 1/4 of an inch or 18 points.
	* @param value: the new value for HorizontalPageMargin
	* @return this object, for call chaining
	*/
	PrintToPdfOptions& SetHorizontalPageMargin(double value);

	
	/**
	* Gets the value PageHeight from the options object
	* The page height to use in points. If not set (or set to 0), uses letter paper size.
	* @return a double, the current value for PageHeight.
	*/
	double GetPageHeight();

	/**
	* Sets the value for PageHeight in the options object
	* The page height to use in points. If not set (or set to 0), uses letter paper size.
	* @param value: the new value for PageHeight
	* @return this object, for call chaining
	*/
	PrintToPdfOptions& SetPageHeight(double value);

	
	/**
	* Gets the value PageOrientation from the options object
	* Page orientation, "portrait" or "landscape".
	* @return a UString, the current value for PageOrientation.
	*/
	UString GetPageOrientation();

	/**
	* Sets the value for PageOrientation in the options object
	* Page orientation, "portrait" or "landscape".
	* @param value: the new value for PageOrientation
	* @return this object, for call chaining
	*/
	PrintToPdfOptions& SetPageOrientation(const UString& value);

	
	/**
	* Gets the value PageWidth from the options object
	* The page width to use in points. If not set (or set to 0), uses letter paper size.
	* @return a double, the current value for PageWidth.
	*/
	double GetPageWidth();

	/**
	* Sets the value for PageWidth in the options object
	* The page width to use in points. If not set (or set to 0), uses letter paper size.
	* @param value: the new value for PageWidth
	* @return this object, for call chaining
	*/
	PrintToPdfOptions& SetPageWidth(double value);

	
	/**
	* Gets the value VerticalPageMargin from the options object
	* The vertical margins (top and bottom) in points. The default is a 1/4 of an inch or 18 points.
	* @return a double, the current value for VerticalPageMargin.
	*/
	double GetVerticalPageMargin();

	/**
	* Sets the value for VerticalPageMargin in the options object
	* The vertical margins (top and bottom) in points. The default is a 1/4 of an inch or 18 points.
	* @param value: the new value for VerticalPageMargin
	* @return this object, for call chaining
	*/
	PrintToPdfOptions& SetVerticalPageMargin(double value);

	
};

}
}

#include "../Impl/PrintToPdfOptions.inl"
#endif // PDFTRON_H_CPPPDFPrintToPdfOptions
