/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.fdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.fdf.FDFField;
import com.pdftron.fdf.FDFFieldIterator;
import com.pdftron.fdf.XFDFExportOptions;
import com.pdftron.filters.Filter;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.sdf.Obj;
import com.pdftron.sdf.SDFDoc;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FDFDoc
implements AutoCloseable {
    long impl;

    public FDFDoc() throws PDFNetException {
        this.impl = FDFDoc.FDFDocCreate();
    }

    public FDFDoc(SDFDoc sDFDoc) throws PDFNetException {
        if (sDFDoc.__GetRefHandle() != null) {
            throw new PDFNetException("false", 36L, "FDFDoc.java", "FDFDoc(SDFDoc)", "SDFDoc is already owned by another document.");
        }
        this.impl = sDFDoc.__GetHandle();
        sDFDoc.__SetRef(this);
    }

    public FDFDoc(String string) throws PDFNetException {
        this.impl = FDFDoc.FDFDocCreate(string);
    }

    public FDFDoc(Filter filter) throws PDFNetException {
        filter.__SetRefHandle(this);
        this.impl = FDFDoc.FDFDocCreate(filter.__GetHandle());
        ReachabilityHelper.ensureReachable(filter);
    }

    public FDFDoc(byte[] byArray) throws PDFNetException {
        this.impl = FDFDoc.FDFDocCreate(byArray);
    }

    public FDFDoc(InputStream inputStream) throws PDFNetException, IOException {
        this(inputStream, 0x100000);
    }

    public FDFDoc(InputStream inputStream, int n) throws PDFNetException, IOException {
        long l = 0L;
        try {
            int n2;
            l = FDFDoc.MemStreamCreateMemFilt(inputStream.available());
            byte[] byArray = new byte[n];
            while ((n2 = inputStream.read(byArray)) != -1) {
                FDFDoc.MemStreamWriteData(l, byArray, n2);
            }
            this.impl = FDFDoc.MemStreamCreateDoc(l);
        }
        catch (PDFNetException pDFNetException) {
            Filter filter = Filter.__Create(l, null);
            filter.destroy();
            throw pDFNetException;
        }
        catch (IOException iOException) {
            Filter filter = Filter.__Create(l, null);
            filter.destroy();
            throw iOException;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() throws PDFNetException {
        if (this.impl != 0L) {
            FDFDoc.Close(this.impl);
            this.impl = 0L;
        }
    }

    public boolean isModified() throws PDFNetException {
        return FDFDoc.IsModified(this.impl);
    }

    public void save(String string) throws PDFNetException {
        FDFDoc.Save(this.impl, string);
    }

    public byte[] save() throws PDFNetException {
        return FDFDoc.Save(this.impl);
    }

    public void save(OutputStream outputStream) throws PDFNetException, IOException {
        this.save(outputStream, 0x100000);
    }

    public void save(OutputStream outputStream, int n) throws PDFNetException, IOException {
        long l;
        long[] lArray = FDFDoc.SaveStream(this.impl);
        long l2 = lArray[1];
        byte[] byArray = new byte[n];
        long l3 = l2 - (long)n;
        for (l = lArray[0]; l < l3; l += (long)n) {
            FDFDoc.ReadData(byArray, n, l);
            outputStream.write(byArray);
        }
        int n2 = (int)(l2 - l);
        if (n2 > 0) {
            FDFDoc.ReadData(byArray, n2, l);
            outputStream.write(byArray, 0, n2);
        }
    }

    public Obj getTrailer() throws PDFNetException {
        return Obj.__Create(FDFDoc.GetTrailer(this.impl), this);
    }

    public Obj getRoot() throws PDFNetException {
        return Obj.__Create(FDFDoc.GetRoot(this.impl), this);
    }

    public Obj getFDF() throws PDFNetException {
        return Obj.__Create(FDFDoc.GetFDF(this.impl), this);
    }

    public String getPDFFileName() throws PDFNetException {
        return FDFDoc.GetPDFFileName(this.impl);
    }

    public void setPDFFileName(String string) throws PDFNetException {
        FDFDoc.SetPDFFileName(this.impl, string);
    }

    public Obj getID() throws PDFNetException {
        return Obj.__Create(FDFDoc.GetID(this.impl), this);
    }

    public void setID(Obj obj) throws PDFNetException {
        FDFDoc.SetID(this.impl, obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
    }

    public FDFFieldIterator getFieldIterator() throws PDFNetException {
        return new FDFFieldIterator(FDFDoc.GetFieldIteratorBegin(this.impl), this);
    }

    public FDFFieldIterator getFieldIterator(String string) throws PDFNetException {
        return new FDFFieldIterator(FDFDoc.GetFieldIterator(this.impl, string), this);
    }

    public FDFField getField(String string) throws PDFNetException {
        long l = FDFDoc.GetField(this.impl, string);
        if (l != 0L) {
            return new FDFField(l, this);
        }
        return null;
    }

    public FDFField fieldCreate(String string, int n) throws PDFNetException {
        return new FDFField(FDFDoc.FieldCreate(this.impl, string, n, 0L), this);
    }

    public FDFField fieldCreate(String string, int n, Obj obj) throws PDFNetException {
        FDFField fDFField = new FDFField(FDFDoc.FieldCreate(this.impl, string, n, obj.__GetHandle()), this);
        ReachabilityHelper.ensureReachable(obj);
        return fDFField;
    }

    public FDFField fieldCreate(String string, int n, String string2) throws PDFNetException {
        return new FDFField(FDFDoc.FieldCreate(this.impl, string, n, string2), this);
    }

    public SDFDoc getSDFDoc() {
        return SDFDoc.__Create(FDFDoc.GetSDFDoc(this.impl), this);
    }

    public static FDFDoc createFromXFDF(String string) throws PDFNetException {
        if (null == string) {
            throw new PDFNetException("false", 454L, "FDFDoc.java", "createFromXFDF(String)", "Argument may not be null.");
        }
        return new FDFDoc(FDFDoc.CreateFromXFDF(string));
    }

    public void saveAsXFDF(String string) throws PDFNetException {
        FDFDoc.SaveAsXFDF(this.impl, string, 0L);
    }

    public void saveAsXFDF(String string, XFDFExportOptions xFDFExportOptions) throws PDFNetException {
        FDFDoc.SaveAsXFDF(this.impl, string, xFDFExportOptions != null ? xFDFExportOptions.getObjHandle() : 0L);
        ReachabilityHelper.ensureReachable(xFDFExportOptions);
    }

    public String saveAsXFDF() throws PDFNetException {
        return FDFDoc.SaveAsXFDF(this.impl, 0L);
    }

    public String saveAsXFDF(XFDFExportOptions xFDFExportOptions) throws PDFNetException {
        String string = FDFDoc.SaveAsXFDF(this.impl, xFDFExportOptions != null ? xFDFExportOptions.getObjHandle() : 0L);
        ReachabilityHelper.ensureReachable(xFDFExportOptions);
        return string;
    }

    public void mergeAnnots(String string) throws PDFNetException {
        FDFDoc.MergeAnnots(this.impl, string, "");
    }

    public void mergeAnnots(String string, String string2) throws PDFNetException {
        FDFDoc.MergeAnnots(this.impl, string, string2);
    }

    public long __GetHandle() {
        return this.impl;
    }

    public static FDFDoc __Create(long l) {
        return new FDFDoc(l);
    }

    FDFDoc(long l) {
        this.impl = l;
    }

    static native long FDFDocCreate();

    static native long FDFDocCreate(String var0);

    static native long FDFDocCreate(long var0);

    static native long FDFDocCreate(byte[] var0);

    static native long MemStreamCreateMemFilt(long var0) throws PDFNetException;

    static native void MemStreamWriteData(long var0, byte[] var2, int var3);

    static native long MemStreamCreateDoc(long var0);

    static native void Close(long var0);

    static native boolean IsModified(long var0);

    static native void Save(long var0, String var2);

    static native byte[] Save(long var0);

    static native long[] SaveStream(long var0);

    static native void ReadData(byte[] var0, int var1, long var2);

    static native long GetTrailer(long var0);

    static native long GetSDFDoc(long var0);

    static native long GetRoot(long var0);

    static native long GetFDF(long var0);

    static native String GetPDFFileName(long var0);

    static native void SetPDFFileName(long var0, String var2);

    static native long GetID(long var0);

    static native void SetID(long var0, long var2);

    static native long GetFieldIteratorBegin(long var0);

    static native long GetFieldIterator(long var0, String var2);

    static native long GetField(long var0, String var2);

    static native long FieldCreate(long var0, String var2, int var3, long var4);

    static native long FieldCreate(long var0, String var2, int var3, String var4);

    static native long CreateFromXFDF(String var0);

    static native long SaveAsXFDF(long var0, String var2, long var3);

    static native String SaveAsXFDF(long var0, long var2);

    static native long MergeAnnots(long var0, String var2, String var3);
}

