/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.filters;

import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.helpers.ReachabilityHelper;

public class FilterReader
implements AutoCloseable {
    Filter attached;
    long impl;

    public FilterReader() throws PDFNetException {
        this.impl = FilterReader.FilterReaderCreate();
        this.attached = null;
    }

    public FilterReader(Filter filter) throws PDFNetException {
        this.impl = FilterReader.FilterReaderCreate(filter.impl);
        this.attached = filter;
    }

    protected void finalize() throws PDFNetException {
        this.destroy();
    }

    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            FilterReader.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    public int get() throws PDFNetException {
        return FilterReader.Get(this.impl);
    }

    public int peek() throws PDFNetException {
        return FilterReader.Peek(this.impl);
    }

    public long read(byte[] byArray) throws PDFNetException {
        return FilterReader.Read(this.impl, byArray);
    }

    public void attachFilter(Filter filter) throws PDFNetException {
        this.attached = filter;
        FilterReader.AttachFilter(this.impl, filter.impl);
        ReachabilityHelper.ensureReachable(filter);
    }

    public Filter getAttachedFilter() throws PDFNetException {
        return this.attached;
    }

    public void seek(long l, int n) throws PDFNetException {
        FilterReader.Seek(this.impl, l, n);
    }

    public long tell() throws PDFNetException {
        return FilterReader.Tell(this.impl);
    }

    public long count() throws PDFNetException {
        return FilterReader.Count(this.impl);
    }

    public void flush() throws PDFNetException {
        FilterReader.Flush(this.impl);
    }

    public void flushAll() throws PDFNetException {
        FilterReader.FlushAll(this.impl);
    }

    public long __GetHandle() {
        return this.impl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long FilterReaderCreate();

    static native long FilterReaderCreate(long var0);

    static native void Destroy(long var0);

    static native int Get(long var0);

    static native int Peek(long var0);

    static native long Read(long var0, byte[] var2);

    static native void AttachFilter(long var0, long var2);

    static native void Seek(long var0, long var2, int var4);

    static native long Tell(long var0);

    static native long Count(long var0);

    static native void Flush(long var0);

    static native void FlushAll(long var0);
}

