/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.DataExtractionOptions;
import com.pdftron.sdf.Doc;
import java.util.HashMap;

public class DataExtractionModule {
    private DataExtractionModule() {
    }

    public static boolean isModuleAvailable(DataExtractionEngine dataExtractionEngine) throws PDFNetException {
        return DataExtractionModule.IsModuleAvailable(dataExtractionEngine.value);
    }

    public static String extractData(String string, DataExtractionEngine dataExtractionEngine) throws PDFNetException {
        return DataExtractionModule.ExtractDataAsString(string, dataExtractionEngine.value, 0L);
    }

    public static String extractData(String string, DataExtractionEngine dataExtractionEngine, DataExtractionOptions dataExtractionOptions) throws PDFNetException {
        long l = 0L;
        if (dataExtractionOptions != null) {
            l = dataExtractionOptions.getObjHandle();
        }
        String string2 = DataExtractionModule.ExtractDataAsString(string, dataExtractionEngine.value, l);
        ReachabilityHelper.ensureReachable(dataExtractionOptions);
        return string2;
    }

    public static void extractData(String string, String string2, DataExtractionEngine dataExtractionEngine) throws PDFNetException {
        DataExtractionModule.ExtractData(string, string2, dataExtractionEngine.value, 0L);
    }

    public static void extractData(String string, String string2, DataExtractionEngine dataExtractionEngine, DataExtractionOptions dataExtractionOptions) throws PDFNetException {
        long l = 0L;
        if (dataExtractionOptions != null) {
            l = dataExtractionOptions.getObjHandle();
        }
        DataExtractionModule.ExtractData(string, string2, dataExtractionEngine.value, l);
        ReachabilityHelper.ensureReachable(dataExtractionOptions);
    }

    public static void detectAndAddFormFieldsToPDF(Doc doc) throws PDFNetException {
        DataExtractionModule.DetectAndAddFormFieldsToPDF(doc.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void detectAndAddFormFieldsToPDF(Doc doc, DataExtractionOptions dataExtractionOptions) throws PDFNetException {
        long l = 0L;
        if (dataExtractionOptions != null) {
            l = dataExtractionOptions.getObjHandle();
        }
        DataExtractionModule.DetectAndAddFormFieldsToPDF(doc.__GetHandle(), l);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(dataExtractionOptions);
    }

    public static void extractToXLSX(String string, String string2) throws PDFNetException {
        DataExtractionModule.ExtractToXLSX(string, string2, 0L);
    }

    public static void extractToXLSX(String string, String string2, DataExtractionOptions dataExtractionOptions) throws PDFNetException {
        long l = 0L;
        if (dataExtractionOptions != null) {
            l = dataExtractionOptions.getObjHandle();
        }
        DataExtractionModule.ExtractToXLSX(string, string2, l);
        ReachabilityHelper.ensureReachable(dataExtractionOptions);
    }

    public static void extractToXLSX(String string, Filter filter) throws PDFNetException {
        DataExtractionModule.ExtractToXLSXWithFilter(string, filter.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static void extractToXLSX(String string, Filter filter, DataExtractionOptions dataExtractionOptions) throws PDFNetException {
        long l = 0L;
        if (dataExtractionOptions != null) {
            l = dataExtractionOptions.getObjHandle();
        }
        DataExtractionModule.ExtractToXLSXWithFilter(string, filter.__GetHandle(), l);
        ReachabilityHelper.ensureReachable(filter);
        ReachabilityHelper.ensureReachable(dataExtractionOptions);
    }

    static native boolean IsModuleAvailable(int var0);

    static native String ExtractDataAsString(String var0, int var1, long var2);

    static native void ExtractData(String var0, String var1, int var2, long var3);

    static native void DetectAndAddFormFieldsToPDF(long var0, long var2);

    static native void ExtractToXLSX(String var0, String var1, long var2);

    static native void ExtractToXLSXWithFilter(String var0, long var1, long var3);

    public static enum DataExtractionEngine {
        e_tabular(0),
        e_form(1),
        e_doc_structure(2),
        e_form_key_value(3),
        e_generic_key_value(4),
        e_doc_classification(5);

        final int value;
        private static HashMap<Integer, DataExtractionEngine> engine_map;

        private DataExtractionEngine(int n2) {
            this.value = n2;
        }

        static DataExtractionEngine valueToEnum(int n) {
            return engine_map.get(n);
        }

        static {
            engine_map = new HashMap();
            for (DataExtractionEngine dataExtractionEngine : DataExtractionEngine.values()) {
                engine_map.put(dataExtractionEngine.value, dataExtractionEngine);
            }
        }
    }
}

