/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.ByteRange;
import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.AlgorithmIdentifier;
import com.pdftron.crypto.DigestAlgorithm;
import com.pdftron.crypto.ObjectIdentifier;
import com.pdftron.crypto.X509Certificate;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.CMSSignatureOptions;
import com.pdftron.pdf.Date;
import com.pdftron.pdf.DigitalSignatureFieldIterator;
import com.pdftron.pdf.Field;
import com.pdftron.pdf.TimestampingConfiguration;
import com.pdftron.pdf.TimestampingResult;
import com.pdftron.pdf.VerificationOptions;
import com.pdftron.pdf.VerificationResult;
import com.pdftron.pdf.__DelayDelete;
import com.pdftron.sdf.Obj;
import java.util.HashMap;

public class DigitalSignatureField
extends __DelayDelete
implements AutoCloseable {
    private long impl;
    Object ref;

    public DigitalSignatureField(Field field) throws PDFNetException {
        this.impl = DigitalSignatureField.Create(field.__GetHandle());
        this.ref = field.__GetRefHandle();
        this.clearList();
    }

    public boolean hasCryptographicSignature() throws PDFNetException {
        return DigitalSignatureField.HasCryptographicSignature(this.impl);
    }

    public SubFilterType getSubFilter() throws PDFNetException {
        return SubFilterType.valueToEnum(DigitalSignatureField.GetSubFilter(this.impl));
    }

    public String getSignatureName() throws PDFNetException {
        return DigitalSignatureField.GetSignatureName(this.impl);
    }

    public Date getSigningTime() throws PDFNetException {
        return new Date(DigitalSignatureField.GetSigningTime(this.impl));
    }

    public String getLocation() throws PDFNetException {
        return DigitalSignatureField.GetLocation(this.impl);
    }

    public String getReason() throws PDFNetException {
        return DigitalSignatureField.GetReason(this.impl);
    }

    public String getContactInfo() throws PDFNetException {
        return DigitalSignatureField.GetContactInfo(this.impl);
    }

    public byte[] getCert(int n) throws PDFNetException {
        byte[] byArray = DigitalSignatureField.GetCert(this.impl, n);
        return byArray;
    }

    public int getCertCount() throws PDFNetException {
        return DigitalSignatureField.GetCertCount(this.impl);
    }

    public boolean hasVisibleAppearance() throws PDFNetException {
        return DigitalSignatureField.HasVisibleAppearance(this.impl);
    }

    public void setContactInfo(String string) throws PDFNetException {
        DigitalSignatureField.SetContactInfo(this.impl, string);
    }

    public void setLocation(String string) throws PDFNetException {
        DigitalSignatureField.SetLocation(this.impl, string);
    }

    public void setReason(String string) throws PDFNetException {
        DigitalSignatureField.SetReason(this.impl, string);
    }

    public void setDocumentPermissions(DocumentPermissions documentPermissions) throws PDFNetException {
        DigitalSignatureField.SetDocumentPermissions(this.impl, documentPermissions.value);
    }

    public void setFieldPermissions(FieldPermissions fieldPermissions, String[] stringArray) throws PDFNetException {
        DigitalSignatureField.SetFieldPermissions(this.impl, fieldPermissions.ordinal(), stringArray);
    }

    public void setFieldPermissions(FieldPermissions fieldPermissions) throws PDFNetException {
        DigitalSignatureField.SetFieldPermissions(this.impl, fieldPermissions.ordinal());
    }

    public void signOnNextSave(String string, String string2) throws PDFNetException {
        DigitalSignatureField.SignOnNextSave(this.impl, string, string2);
    }

    public void signOnNextSave(byte[] byArray, String string) throws PDFNetException {
        DigitalSignatureField.SignOnNextSave(this.impl, byArray, string);
    }

    public void signOnNextSaveWithCustomHandler(long l) throws PDFNetException {
        DigitalSignatureField.SignOnNextSaveWithCustomHandler(this.impl, l);
    }

    public void certifyOnNextSave(String string, String string2) throws PDFNetException {
        DigitalSignatureField.CertifyOnNextSave(this.impl, string, string2);
    }

    public void certifyOnNextSave(byte[] byArray, String string) throws PDFNetException {
        DigitalSignatureField.CertifyOnNextSave(this.impl, byArray, string);
    }

    public void certifyOnNextSaveWithCustomHandler(long l) throws PDFNetException {
        DigitalSignatureField.CertifyOnNextSaveWithCustomHandler(this.impl, l);
    }

    public Obj getSDFObj() throws PDFNetException {
        return Obj.__Create(DigitalSignatureField.GetSDFObj(this.impl), this.ref);
    }

    public boolean isLockedByDigitalSignature() throws PDFNetException {
        return DigitalSignatureField.IsLockedByDigitalSignature(this.impl);
    }

    public String[] getLockedFields() throws PDFNetException {
        String[] stringArray = DigitalSignatureField.GetLockedFields(this.impl);
        return stringArray;
    }

    public DocumentPermissions getDocumentPermissions() throws PDFNetException {
        return DocumentPermissions.valueToEnum(DigitalSignatureField.GetDocumentPermissions(this.impl));
    }

    public void clearSignature() throws PDFNetException {
        DigitalSignatureField.ClearSignature(this.impl);
    }

    public VerificationResult verify(VerificationOptions verificationOptions) throws PDFNetException {
        VerificationResult verificationResult = new VerificationResult(DigitalSignatureField.Verify(this.impl, verificationOptions.__GetHandle()), this.__GetRefHandle());
        ReachabilityHelper.ensureReachable(verificationOptions);
        return verificationResult;
    }

    public boolean isCertification() throws PDFNetException {
        return DigitalSignatureField.IsCertification(this.impl);
    }

    public X509Certificate getSignerCertFromCMS() throws PDFNetException {
        return new X509Certificate(DigitalSignatureField.GetSignerCertFromCMS(this.impl));
    }

    public ByteRange[] getByteRanges() throws PDFNetException {
        ByteRange[] byteRangeArray = DigitalSignatureField.GetByteRanges(this.impl);
        return byteRangeArray;
    }

    public X509Certificate[][] getCertPathsFromCMS() throws PDFNetException {
        int n = DigitalSignatureField.GetCertPathsFromCMSGetSize(this.impl);
        X509Certificate[][] x509CertificateArray = new X509Certificate[n][];
        for (int i = 0; i < DigitalSignatureField.GetCertPathsFromCMSGetSize(this.impl); ++i) {
            long[] lArray = DigitalSignatureField.GetCertPathsFromCMS(this.impl, i);
            x509CertificateArray[i] = new X509Certificate[lArray.length];
            for (int j = 0; j < lArray.length; ++j) {
                x509CertificateArray[i][j] = new X509Certificate(lArray[j]);
            }
        }
        return x509CertificateArray;
    }

    public boolean enableLTVOfflineVerification(VerificationResult verificationResult) throws PDFNetException {
        boolean bl = DigitalSignatureField.EnableLTVOfflineVerification(this.impl, verificationResult.__GetHandle());
        ReachabilityHelper.ensureReachable(verificationResult);
        return bl;
    }

    public void timestampOnNextSave(TimestampingConfiguration timestampingConfiguration, VerificationOptions verificationOptions) throws PDFNetException {
        DigitalSignatureField.TimestampOnNextSave(this.impl, timestampingConfiguration.__GetHandle(), verificationOptions.__GetHandle());
        ReachabilityHelper.ensureReachable(timestampingConfiguration);
        ReachabilityHelper.ensureReachable(verificationOptions);
    }

    public TimestampingResult generateContentsWithEmbeddedTimestamp(TimestampingConfiguration timestampingConfiguration, VerificationOptions verificationOptions) throws PDFNetException {
        TimestampingResult timestampingResult = new TimestampingResult(DigitalSignatureField.GenerateContentsWithEmbeddedTimestamp(this.impl, timestampingConfiguration.__GetHandle(), verificationOptions.__GetHandle()));
        ReachabilityHelper.ensureReachable(timestampingConfiguration);
        ReachabilityHelper.ensureReachable(verificationOptions);
        return timestampingResult;
    }

    public void useSubFilter(SubFilterType subFilterType, boolean bl) throws PDFNetException {
        DigitalSignatureField.UseSubFilter(this.impl, subFilterType.value, bl);
    }

    public void useSubFilter(SubFilterType subFilterType) throws PDFNetException {
        DigitalSignatureField.UseSubFilter(this.impl, subFilterType.value, true);
    }

    public byte[] calculateDigest() throws PDFNetException {
        byte[] byArray = DigitalSignatureField.CalculateDigest(this.impl, DigestAlgorithm.e_sha256.value);
        return byArray;
    }

    public byte[] calculateDigest(DigestAlgorithm digestAlgorithm) throws PDFNetException {
        byte[] byArray = DigitalSignatureField.CalculateDigest(this.impl, digestAlgorithm.value);
        return byArray;
    }

    public void setPreferredDigestAlgorithm(DigestAlgorithm digestAlgorithm, boolean bl) throws PDFNetException {
        DigitalSignatureField.SetPreferredDigestAlgorithm(this.impl, digestAlgorithm.value, bl);
    }

    public void setPreferredDigestAlgorithm(DigestAlgorithm digestAlgorithm) throws PDFNetException {
        DigitalSignatureField.SetPreferredDigestAlgorithm(this.impl, digestAlgorithm.value, true);
    }

    public void createSigDictForCustomCertification(String string, SubFilterType subFilterType, int n) throws PDFNetException {
        DigitalSignatureField.CreateSigDictForCustomCertification(this.impl, string, subFilterType.value, n);
    }

    public void createSigDictForCustomSigning(String string, SubFilterType subFilterType, int n) throws PDFNetException {
        DigitalSignatureField.CreateSigDictForCustomSigning(this.impl, string, subFilterType.value, n);
    }

    public void setSigDictTimeOfSigning(Date date) throws PDFNetException {
        DigitalSignatureField.SetSigDictTimeOfSigning(this.impl, date.impl);
        ReachabilityHelper.ensureReachable(date);
    }

    public static byte[] signDigest(byte[] byArray, String string, String string2, boolean bl, DigestAlgorithm digestAlgorithm) throws PDFNetException {
        return DigitalSignatureField.SignDigestPath(byArray, string, string2, bl, digestAlgorithm.value);
    }

    public static byte[] signDigest(byte[] byArray, byte[] byArray2, String string, boolean bl, DigestAlgorithm digestAlgorithm) throws PDFNetException {
        return DigitalSignatureField.SignDigestBuffer(byArray, byArray2, string, bl, digestAlgorithm.value);
    }

    public static byte[] generateESSSigningCertPAdESAttribute(X509Certificate x509Certificate, DigestAlgorithm digestAlgorithm) throws PDFNetException {
        byte[] byArray = DigitalSignatureField.GenerateESSSigningCertPAdESAttribute(x509Certificate.__GetHandle(), digestAlgorithm.value);
        ReachabilityHelper.ensureReachable(x509Certificate);
        return byArray;
    }

    public static byte[] generateCMSSignedAttributes(byte[] byArray, byte[] byArray2) throws PDFNetException {
        return DigitalSignatureField.GenerateCMSSignedAttributes(byArray, byArray2);
    }

    public static byte[] generateCMSSignedAttributes(byte[] byArray) throws PDFNetException {
        return DigitalSignatureField.GenerateCMSSignedAttributes(byArray, new byte[0]);
    }

    public static byte[] generateCMSSignature(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray, ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2, byte[] byArray, byte[] byArray2) throws PDFNetException {
        long[] lArray = new long[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            lArray[i] = x509CertificateArray[i].__GetHandle();
        }
        byte[] byArray3 = DigitalSignatureField.GenerateCMSSignature(x509Certificate.__GetHandle(), lArray, objectIdentifier.__GetHandle(), objectIdentifier2.__GetHandle(), byArray, byArray2);
        ReachabilityHelper.ensureReachable(x509Certificate);
        ReachabilityHelper.ensureReachable(objectIdentifier);
        ReachabilityHelper.ensureReachable(objectIdentifier2);
        ReachabilityHelper.ensureReachable(x509CertificateArray);
        return byArray3;
    }

    public static byte[] generateCMSSignature(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2) throws PDFNetException {
        long[] lArray = new long[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            lArray[i] = x509CertificateArray[i].__GetHandle();
        }
        byte[] byArray3 = DigitalSignatureField.GenerateCMSSignatureWithAlgoId(x509Certificate.__GetHandle(), lArray, algorithmIdentifier.__GetHandle(), algorithmIdentifier2.__GetHandle(), byArray, byArray2, 0L);
        ReachabilityHelper.ensureReachable(x509Certificate);
        ReachabilityHelper.ensureReachable(algorithmIdentifier);
        ReachabilityHelper.ensureReachable(algorithmIdentifier2);
        ReachabilityHelper.ensureReachable(x509CertificateArray);
        return byArray3;
    }

    public static byte[] generateCMSSignature(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2, CMSSignatureOptions cMSSignatureOptions) throws PDFNetException {
        long[] lArray = new long[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            lArray[i] = x509CertificateArray[i].__GetHandle();
        }
        byte[] byArray3 = DigitalSignatureField.GenerateCMSSignatureWithAlgoId(x509Certificate.__GetHandle(), lArray, algorithmIdentifier.__GetHandle(), algorithmIdentifier2.__GetHandle(), byArray, byArray2, cMSSignatureOptions.__GetHandle());
        ReachabilityHelper.ensureReachable(x509Certificate);
        ReachabilityHelper.ensureReachable(algorithmIdentifier);
        ReachabilityHelper.ensureReachable(algorithmIdentifier2);
        ReachabilityHelper.ensureReachable(x509CertificateArray);
        ReachabilityHelper.ensureReachable(cMSSignatureOptions);
        return byArray3;
    }

    public static boolean setDigSigLogFilename(String string) throws PDFNetException {
        return DigitalSignatureField.SetDigSigLogFilename(string);
    }

    public long __GetHandle() {
        return this.impl;
    }

    DigitalSignatureField(long l, Object object) throws PDFNetException {
        this.impl = l;
        this.ref = object;
        this.clearList();
    }

    public static DigitalSignatureField __Create(long l, Object object) throws PDFNetException {
        if (l == 0L) {
            return null;
        }
        return new DigitalSignatureField(l, object);
    }

    @Override
    public void destroy() throws PDFNetException {
        if (this.impl != 0L && !(this.ref instanceof DigitalSignatureFieldIterator)) {
            DigitalSignatureField.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.destroy();
    }

    public Object __GetRefHandle() {
        return this.ref;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long Create(long var0);

    static native boolean HasCryptographicSignature(long var0);

    static native int GetSubFilter(long var0);

    static native String GetSignatureName(long var0);

    static native long GetSigningTime(long var0);

    static native String GetLocation(long var0);

    static native String GetReason(long var0);

    static native String GetContactInfo(long var0);

    static native byte[] GetCert(long var0, int var2);

    static native int GetCertCount(long var0);

    static native boolean HasVisibleAppearance(long var0);

    static native void SetContactInfo(long var0, String var2);

    static native void SetLocation(long var0, String var2);

    static native void SetReason(long var0, String var2);

    static native void SetDocumentPermissions(long var0, int var2);

    static native void SetFieldPermissions(long var0, int var2, String[] var3);

    static native void SetFieldPermissions(long var0, int var2);

    static native void SignOnNextSave(long var0, String var2, String var3);

    static native void SignOnNextSave(long var0, byte[] var2, String var3);

    static native void SignOnNextSaveWithCustomHandler(long var0, long var2);

    static native void CertifyOnNextSave(long var0, String var2, String var3);

    static native void CertifyOnNextSave(long var0, byte[] var2, String var3);

    static native void CertifyOnNextSaveWithCustomHandler(long var0, long var2);

    static native long GetSDFObj(long var0);

    static native boolean IsLockedByDigitalSignature(long var0);

    static native String[] GetLockedFields(long var0);

    static native int GetDocumentPermissions(long var0);

    static native void ClearSignature(long var0);

    static native long Verify(long var0, long var2);

    static native boolean IsCertification(long var0);

    static native long GetSignerCertFromCMS(long var0);

    static native ByteRange[] GetByteRanges(long var0);

    static native long[] GetCertPathsFromCMS(long var0, int var2);

    static native int GetCertPathsFromCMSGetSize(long var0);

    static native boolean EnableLTVOfflineVerification(long var0, long var2);

    static native void TimestampOnNextSave(long var0, long var2, long var4);

    static native long GenerateContentsWithEmbeddedTimestamp(long var0, long var2, long var4);

    static native void UseSubFilter(long var0, int var2, boolean var3);

    static native byte[] CalculateDigest(long var0, int var2);

    static native void SetPreferredDigestAlgorithm(long var0, int var2, boolean var3);

    static native void CreateSigDictForCustomCertification(long var0, String var2, int var3, int var4);

    static native void CreateSigDictForCustomSigning(long var0, String var2, int var3, int var4);

    static native void SetSigDictTimeOfSigning(long var0, long var2);

    static native byte[] SignDigestPath(byte[] var0, String var1, String var2, boolean var3, int var4);

    static native byte[] SignDigestBuffer(byte[] var0, byte[] var1, String var2, boolean var3, int var4);

    static native byte[] GenerateESSSigningCertPAdESAttribute(long var0, int var2);

    static native byte[] GenerateCMSSignedAttributes(byte[] var0, byte[] var1);

    static native byte[] GenerateCMSSignature(long var0, long[] var2, long var3, long var5, byte[] var7, byte[] var8);

    static native byte[] GenerateCMSSignatureWithAlgoId(long var0, long[] var2, long var3, long var5, byte[] var7, byte[] var8, long var9);

    static native boolean SetDigSigLogFilename(String var0);

    public static enum FieldPermissions {
        e_lock_all,
        e_include,
        e_exclude;

    }

    public static enum DocumentPermissions {
        e_no_changes_allowed(1),
        e_formfilling_signing_allowed(2),
        e_annotating_formfilling_signing_allowed(3),
        e_unrestricted(4);

        final int value;
        private static HashMap<Integer, DocumentPermissions> doc_perms_map;

        private DocumentPermissions(int n2) {
            this.value = n2;
        }

        static DocumentPermissions valueToEnum(int n) {
            return doc_perms_map.get(n);
        }

        static {
            doc_perms_map = new HashMap();
            for (DocumentPermissions documentPermissions : DocumentPermissions.values()) {
                doc_perms_map.put(documentPermissions.value, documentPermissions);
            }
        }
    }

    public static enum SubFilterType {
        e_adbe_x509_rsa_sha1(0),
        e_adbe_pkcs7_detached(1),
        e_adbe_pkcs7_sha1(2),
        e_ETSI_CAdES_detached(3),
        e_ETSI_RFC3161(4),
        e_unknown(5),
        e_absent(6);

        final int value;
        private static HashMap<Integer, SubFilterType> subfiltertype_map;

        private SubFilterType(int n2) {
            this.value = n2;
        }

        static SubFilterType valueToEnum(int n) {
            return subfiltertype_map.get(n);
        }

        static {
            subfiltertype_map = new HashMap();
            for (SubFilterType subFilterType : SubFilterType.values()) {
                subfiltertype_map.put(subFilterType.value, subFilterType);
            }
        }
    }
}

