/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.CharData;
import com.pdftron.pdf.Element;
import com.pdftron.pdf.GSChangesIterator;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.__DelayDelete;
import com.pdftron.pdf.ocg.Context;
import com.pdftron.sdf.Obj;

public class ElementReader
extends __DelayDelete
implements AutoCloseable {
    Object ref;
    Object ocgctx_ref = null;

    public ElementReader() throws PDFNetException {
        this.impl = ElementReader.ElementReaderCreate();
        this.ref = null;
        this.clearList();
    }

    @Override
    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            ElementReader.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    public void begin(Page page) throws PDFNetException {
        ElementReader.Begin1(this.impl, page.impl);
        this.ref = page.ref;
        this.ocgctx_ref = null;
    }

    public void begin(Page page, Context context) throws PDFNetException {
        ElementReader.Begin2(this.impl, page.impl, context.__GetHandle());
        this.ref = page.ref;
        this.ocgctx_ref = context;
    }

    public void begin(Obj obj) throws PDFNetException {
        ElementReader.BeginStm1(this.impl, obj.__GetHandle());
        this.ref = obj.__GetRefHandle();
        this.ocgctx_ref = null;
    }

    public void begin(Obj obj, Obj obj2) throws PDFNetException {
        ElementReader.BeginStm2(this.impl, obj.__GetHandle(), obj2.__GetHandle());
        this.ref = obj.__GetRefHandle();
        this.ocgctx_ref = null;
        ReachabilityHelper.ensureReachable(obj2);
    }

    public void begin(Obj obj, Obj obj2, Context context) throws PDFNetException {
        ElementReader.BeginStm3(this.impl, obj.__GetHandle(), obj2.__GetHandle(), context.__GetHandle());
        this.ref = obj.__GetRefHandle();
        this.ocgctx_ref = context;
        ReachabilityHelper.ensureReachable(obj2);
    }

    public Element next() throws PDFNetException {
        long l = ElementReader.Next(this.impl);
        if (l != 0L) {
            return new Element(l, this, this.ref);
        }
        return null;
    }

    public Element current() throws PDFNetException {
        long l = ElementReader.Current(this.impl);
        if (l != 0L) {
            return new Element(l, this, this.ref);
        }
        return null;
    }

    public void formBegin() throws PDFNetException {
        ElementReader.FormBegin(this.impl);
    }

    public void patternBegin(boolean bl, boolean bl2) throws PDFNetException {
        ElementReader.PatternBegin(this.impl, bl, bl2);
    }

    public void patternBegin(boolean bl) throws PDFNetException {
        ElementReader.PatternBegin(this.impl, bl, false);
    }

    public void type3FontBegin(CharData charData, Obj obj) throws PDFNetException {
        if (obj != null) {
            ElementReader.Type3FontBegin(this.impl, charData.impl, obj.__GetHandle());
            ReachabilityHelper.ensureReachable(obj);
        } else {
            ElementReader.Type3FontBegin(this.impl, charData.impl, 0L);
        }
        ReachabilityHelper.ensureReachable(charData);
    }

    public void type3FontBegin(CharData charData) throws PDFNetException {
        ElementReader.Type3FontBegin(this.impl, charData.impl, 0L);
        ReachabilityHelper.ensureReachable(charData);
    }

    public boolean end() throws PDFNetException {
        return ElementReader.End(this.impl);
    }

    public GSChangesIterator getChangesIterator() throws PDFNetException {
        return new GSChangesIterator(ElementReader.GetChangesIterator(this.impl), this.ref);
    }

    public boolean isChanged(int n) throws PDFNetException {
        return ElementReader.IsChanged(this.impl, n);
    }

    public void clearChangeList() throws PDFNetException {
        ElementReader.ClearChangeList(this.impl);
    }

    public Obj getFont(String string) throws PDFNetException {
        return Obj.__Create(ElementReader.GetFont(this.impl, string), this.ref);
    }

    public Obj getXObject(String string) {
        return Obj.__Create(ElementReader.GetXObject(this.impl, string), this.ref);
    }

    public Obj getShading(String string) {
        return Obj.__Create(ElementReader.GetShading(this.impl, string), this.ref);
    }

    public Obj getColorSpace(String string) {
        return Obj.__Create(ElementReader.GetColorSpace(this.impl, string), this.ref);
    }

    public Obj getPattern(String string) {
        return Obj.__Create(ElementReader.GetPattern(this.impl, string), this.ref);
    }

    public Obj getExtGState(String string) {
        return Obj.__Create(ElementReader.GetExtGState(this.impl, string), this.ref);
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long ElementReaderCreate();

    static native void Destroy(long var0);

    static native void Begin1(long var0, long var2);

    static native void Begin2(long var0, long var2, long var4);

    static native void BeginStm1(long var0, long var2);

    static native void BeginStm2(long var0, long var2, long var4);

    static native void BeginStm3(long var0, long var2, long var4, long var6);

    static native long Next(long var0);

    static native long Current(long var0);

    static native void FormBegin(long var0);

    static native void PatternBegin(long var0, boolean var2, boolean var3);

    static native void Type3FontBegin(long var0, long var2, long var4);

    static native boolean End(long var0);

    static native long GetChangesIterator(long var0);

    static native boolean IsChanged(long var0, int var2);

    static native void ClearChangeList(long var0);

    static native long GetFont(long var0, String var2);

    static native long GetXObject(long var0, String var2);

    static native long GetShading(long var0, String var2);

    static native long GetColorSpace(long var0, String var2);

    static native long GetPattern(long var0, String var2);

    static native long GetExtGState(long var0, String var2);
}

