/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.Matrix2D;
import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.FontCharCodeIterator;
import com.pdftron.pdf.PathData;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.ShapedText;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;
import java.io.InputStream;

public class Font {
    public static final int e_times_roman = 0;
    public static final int e_times_bold = 1;
    public static final int e_times_italic = 2;
    public static final int e_times_bold_italic = 3;
    public static final int e_helvetica = 4;
    public static final int e_helvetica_bold = 5;
    public static final int e_helvetica_oblique = 6;
    public static final int e_helvetica_bold_oblique = 7;
    public static final int e_courier = 8;
    public static final int e_courier_bold = 9;
    public static final int e_courier_oblique = 10;
    public static final int e_courier_bold_oblique = 11;
    public static final int e_symbol = 12;
    public static final int e_zapf_dingbats = 13;
    public static final int e_null = 14;
    public static final int e_IdentityH = 0;
    public static final int e_Indices = 1;
    public static final int e_Type1 = 0;
    public static final int e_TrueType = 1;
    public static final int e_MMType1 = 2;
    public static final int e_Type3 = 3;
    public static final int e_Type0 = 4;
    public static final int e_CIDType0 = 5;
    public static final int e_CIDType2 = 6;
    long impl;
    Object ref;

    public Font() {
        this.impl = 0L;
        this.ref = null;
    }

    public Font(Obj obj) {
        this.impl = obj.__GetHandle();
        this.ref = obj.__GetRefHandle();
    }

    public static Font create(Doc doc, int n) throws PDFNetException {
        return Font.__Create(Font.Create(doc.__GetHandle(), n, false), doc);
    }

    public static Font create(Doc doc, int n, boolean bl) throws PDFNetException {
        return Font.__Create(Font.Create(doc.__GetHandle(), n, bl), doc);
    }

    public static Font create(Doc doc, Font font, String string) throws PDFNetException {
        Font font2 = Font.__Create(Font.Create(doc.__GetHandle(), font.impl, string), doc);
        ReachabilityHelper.ensureReachable(font);
        return font2;
    }

    public static Font create(Doc doc, String string, String string2) throws PDFNetException {
        return Font.__Create(Font.Create(doc.__GetHandle(), string, string2), doc);
    }

    public static Font createTrueTypeFont(Doc doc, String string) throws PDFNetException {
        return Font.__Create(Font.CreateTrueTypeFont(doc.__GetHandle(), string, true, true), doc);
    }

    public static Font createTrueTypeFont(Doc doc, InputStream inputStream) throws PDFNetException {
        return Font.__Create(Font.CreateTrueTypeFontFromStream(doc.__GetHandle(), inputStream, true, true), doc);
    }

    public static Font createTrueTypeFont(Doc doc, String string, boolean bl) throws PDFNetException {
        return Font.__Create(Font.CreateTrueTypeFont(doc.__GetHandle(), string, bl, true), doc);
    }

    public static Font createTrueTypeFont(Doc doc, InputStream inputStream, boolean bl) throws PDFNetException {
        return Font.__Create(Font.CreateTrueTypeFontFromStream(doc.__GetHandle(), inputStream, bl, true), doc);
    }

    public static Font createTrueTypeFont(Doc doc, String string, boolean bl, boolean bl2) throws PDFNetException {
        return Font.__Create(Font.CreateTrueTypeFont(doc.__GetHandle(), string, bl, bl2), doc);
    }

    public static Font createTrueTypeFont(Doc doc, InputStream inputStream, boolean bl, boolean bl2) throws PDFNetException {
        return Font.__Create(Font.CreateTrueTypeFontFromStream(doc.__GetHandle(), inputStream, bl, bl2), doc);
    }

    public static Font createCIDTrueTypeFont(Doc doc, String string) throws PDFNetException {
        return Font.__Create(Font.CreateCIDTrueTypeFont(doc.__GetHandle(), string, true, true, 0, 0L), doc);
    }

    public static Font createCIDTrueTypeFont(Doc doc, InputStream inputStream) throws PDFNetException {
        return Font.__Create(Font.CreateCIDTrueTypeFontFromStream(doc.__GetHandle(), inputStream, true, true, 0, 0L), doc);
    }

    public static Font createCIDTrueTypeFont(Doc doc, String string, boolean bl, boolean bl2) throws PDFNetException {
        return Font.__Create(Font.CreateCIDTrueTypeFont(doc.__GetHandle(), string, bl, bl2, 0, 0L), doc);
    }

    public static Font createCIDTrueTypeFont(Doc doc, InputStream inputStream, boolean bl, boolean bl2) throws PDFNetException {
        return Font.__Create(Font.CreateCIDTrueTypeFontFromStream(doc.__GetHandle(), inputStream, bl, bl2, 0, 0L), doc);
    }

    public static Font createCIDTrueTypeFont(Doc doc, String string, boolean bl, boolean bl2, int n) throws PDFNetException {
        return Font.__Create(Font.CreateCIDTrueTypeFont(doc.__GetHandle(), string, bl, bl2, n, 0L), doc);
    }

    public static Font createCIDTrueTypeFont(Doc doc, InputStream inputStream, boolean bl, boolean bl2, int n) throws PDFNetException {
        return Font.__Create(Font.CreateCIDTrueTypeFontFromStream(doc.__GetHandle(), inputStream, bl, bl2, n, 0L), doc);
    }

    public static Font createCIDTrueTypeFont(Doc doc, String string, boolean bl, boolean bl2, int n, long l) throws PDFNetException {
        return Font.__Create(Font.CreateCIDTrueTypeFont(doc.__GetHandle(), string, bl, bl2, n, l), doc);
    }

    public static Font createCIDTrueTypeFont(Doc doc, InputStream inputStream, boolean bl, boolean bl2, int n, long l) throws PDFNetException {
        return Font.__Create(Font.CreateCIDTrueTypeFontFromStream(doc.__GetHandle(), inputStream, bl, bl2, n, l), doc);
    }

    public static Font createType1Font(Doc doc, String string) throws PDFNetException {
        return Font.__Create(Font.CreateType1Font(doc.__GetHandle(), string, true), doc);
    }

    public static Font createType1Font(Doc doc, String string, boolean bl) throws PDFNetException {
        return Font.__Create(Font.CreateType1Font(doc.__GetHandle(), string, bl), doc);
    }

    public int getType() throws PDFNetException {
        return Font.GetType(this.impl);
    }

    public boolean isSimple() throws PDFNetException {
        return Font.IsSimple(this.impl);
    }

    public static int getType(Obj obj) throws PDFNetException {
        int n = Font.GetTypeStatic(obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
        return n;
    }

    public Obj GetSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    public Obj GetDescriptor() throws PDFNetException {
        return Obj.__Create(Font.GetDescriptor(this.impl), this.ref);
    }

    public String getName() throws PDFNetException {
        return Font.GetName(this.impl);
    }

    public String getFamilyName() throws PDFNetException {
        return Font.GetFamilyName(this.impl);
    }

    public boolean isFixedWidth() throws PDFNetException {
        return Font.IsFixedWidth(this.impl);
    }

    public boolean isSerif() throws PDFNetException {
        return Font.IsSerif(this.impl);
    }

    public boolean isSymbolic() throws PDFNetException {
        return Font.IsSymbolic(this.impl);
    }

    public boolean isItalic() throws PDFNetException {
        return Font.IsItalic(this.impl);
    }

    public boolean isAllCap() throws PDFNetException {
        return Font.IsAllCap(this.impl);
    }

    public boolean isForceBold() throws PDFNetException {
        return Font.IsForceBold(this.impl);
    }

    public boolean isHorizontalMode() throws PDFNetException {
        return Font.IsHorizontalMode(this.impl);
    }

    public double getWidth(long l) throws PDFNetException {
        return Font.GetWidth(this.impl, l);
    }

    public double getMaxWidth() throws PDFNetException {
        return Font.GetMaxWidth(this.impl);
    }

    public double getMissingWidth() throws PDFNetException {
        return Font.GetMissingWidth(this.impl);
    }

    public FontCharCodeIterator getCharCodeIterator() throws PDFNetException {
        return new FontCharCodeIterator(Font.GetCharCodeIterator(this.impl), this.ref);
    }

    public PathData getGlyphPath(long l, boolean bl) {
        return Font.GetGlyphPath(this.impl, l, bl, 0L);
    }

    public PathData getGlyphPath(long l, boolean bl, Matrix2D matrix2D) {
        PathData pathData = Font.GetGlyphPath(this.impl, l, bl, matrix2D.__GetHandle());
        ReachabilityHelper.ensureReachable(matrix2D);
        return pathData;
    }

    public ShapedText getShapedText(String string) {
        return new ShapedText(Font.GetShapedText(this.impl, string));
    }

    public char[] mapToUnicode(long l) throws PDFNetException {
        char[] cArray = Font.MapToUnicode(this.impl, l);
        return cArray;
    }

    public String[] getEncoding() throws PDFNetException {
        String[] stringArray = Font.GetEncoding(this.impl);
        return stringArray;
    }

    public boolean isEmbedded() throws PDFNetException {
        return Font.IsEmbedded(this.impl);
    }

    public String getEmbeddedFontName() throws PDFNetException {
        return Font.GetEmbeddedFontName(this.impl);
    }

    public Obj getEmbeddedFont() throws PDFNetException {
        return Obj.__Create(Font.GetEmbeddedFont(this.impl), this.ref);
    }

    public int getEmbeddedFontBufSize() throws PDFNetException {
        return Font.GetEmbeddedFontBufSize(this.impl);
    }

    public short getUnitsPerEm() throws PDFNetException {
        return Font.GetUnitsPerEm(this.impl);
    }

    public Rect getBBox() throws PDFNetException {
        return new Rect(Font.GetBBox(this.impl));
    }

    public double getAscent() throws PDFNetException {
        return Font.GetAscent(this.impl);
    }

    public double getDescent() throws PDFNetException {
        return Font.GetDescent(this.impl);
    }

    public int getStandardType1FontType() throws PDFNetException {
        return Font.GetStandardType1FontType(this.impl);
    }

    public boolean isCFF() throws PDFNetException {
        return Font.IsCFF(this.impl);
    }

    public Matrix2D getType3FontMatrix() throws PDFNetException {
        return Matrix2D.__Create(Font.GetType3FontMatrix(this.impl));
    }

    public Obj getType3GlyphStream(long l) {
        return Obj.__Create(Font.GetType3GlyphStream(this.impl, l), this.ref);
    }

    double[] getVerticalAdvance(long l) throws PDFNetException {
        double[] dArray = Font.GetVerticalAdvance(this.impl, l);
        return dArray;
    }

    Font getDescendant() throws PDFNetException {
        return Font.__Create(Font.GetDescendant(this.impl), this.ref);
    }

    int mapToCID(long l) throws PDFNetException {
        return Font.MapToCID(this.impl, l);
    }

    private Font(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    public static Font __Create(long l, Object object) {
        if (l == 0L) {
            return null;
        }
        return new Font(l, object);
    }

    public long __GetHandle() {
        return this.impl;
    }

    public Object __GetRefHandle() {
        return this.ref;
    }

    static native long Create(long var0, int var2, boolean var3);

    static native long Create(long var0, long var2, String var4);

    static native long Create(long var0, String var2, String var3);

    static native long CreateTrueTypeFont(long var0, String var2, boolean var3, boolean var4);

    static native long CreateTrueTypeFontFromStream(long var0, InputStream var2, boolean var3, boolean var4);

    static native long CreateCIDTrueTypeFont(long var0, String var2, boolean var3, boolean var4, int var5, long var6);

    static native long CreateCIDTrueTypeFontFromStream(long var0, InputStream var2, boolean var3, boolean var4, int var5, long var6);

    static native long CreateType1Font(long var0, String var2, boolean var3);

    static native int GetType(long var0);

    static native boolean IsSimple(long var0);

    static native int GetTypeStatic(long var0);

    static native long GetDescriptor(long var0);

    static native String GetName(long var0);

    static native String GetFamilyName(long var0);

    static native boolean IsFixedWidth(long var0);

    static native boolean IsSerif(long var0);

    static native boolean IsSymbolic(long var0);

    static native boolean IsItalic(long var0);

    static native boolean IsAllCap(long var0);

    static native boolean IsForceBold(long var0);

    static native boolean IsHorizontalMode(long var0);

    static native double GetWidth(long var0, long var2);

    static native double GetMaxWidth(long var0);

    static native double GetMissingWidth(long var0);

    static native long GetCharCodeIterator(long var0);

    static native PathData GetGlyphPath(long var0, long var2, boolean var4, long var5);

    static native long GetShapedText(long var0, String var2);

    static native char[] MapToUnicode(long var0, long var2);

    static native String[] GetEncoding(long var0);

    static native boolean IsEmbedded(long var0);

    static native String GetEmbeddedFontName(long var0);

    static native long GetEmbeddedFont(long var0);

    static native int GetEmbeddedFontBufSize(long var0);

    static native short GetUnitsPerEm(long var0);

    static native long GetBBox(long var0);

    static native double GetAscent(long var0);

    static native double GetDescent(long var0);

    static native int GetStandardType1FontType(long var0);

    static native boolean IsCFF(long var0);

    static native long GetType3FontMatrix(long var0);

    static native long GetType3GlyphStream(long var0, long var2);

    static native double[] GetVerticalAdvance(long var0, long var2);

    static native long GetDescendant(long var0);

    static native int MapToCID(long var0, long var2);
}

