/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

final class JarResourceExtractor {
    private static final Logger LOGGER = Logger.getLogger(JarResourceExtractor.class.getName());

    JarResourceExtractor() {
    }

    public static Path extractJarResourcesByClassName(String string) {
        if (string == null) {
            throw new NullPointerException("markerClassName must not be null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("markerClassName must not be empty");
        }
        try {
            Class<?> clazz = Class.forName(string);
            Package package_ = clazz.getPackage();
            if (package_ == null || package_.getName().isEmpty()) {
                LOGGER.warning("Cannot extract resources: marker class " + string + " is not in a named package.");
                return null;
            }
            String[] stringArray = package_.getName().split("\\.");
            if (stringArray.length == 0) {
                LOGGER.warning("Cannot extract resources: marker class " + string + " has a malformed package name.");
                return null;
            }
            String string2 = stringArray[stringArray.length - 1] + "_";
            Path path = JarResourceExtractor.resolveJarPathFromClass(clazz);
            if (path == null) {
                return null;
            }
            try {
                Path path2 = JarResourceExtractor.createTempDirWithPrefix(string2);
                JarResourceExtractor.extractJarResources(path, path2);
                JarResourceExtractor.registerRecursiveDeleteOnExit(path2);
                LOGGER.fine("Successfully extracted resources from JAR: " + path + " to " + path2);
                return path2;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Failed to extract resources from JAR", iOException);
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.FINE, "Marker class " + string + " not found", classNotFoundException);
            return null;
        }
    }

    public static Path resolveJarPathFromClass(Class<?> clazz) {
        URL uRL;
        if (clazz == null) {
            throw new NullPointerException("markerClass must not be null");
        }
        String string = clazz.getName().replace('.', '/') + ".class";
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL2 = uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            LOGGER.fine("Resource not found for class: " + clazz.getName());
            return null;
        }
        if (!"jar".equalsIgnoreCase(uRL.getProtocol())) {
            LOGGER.fine("Class not loaded from a JAR (protocol=" + uRL.getProtocol() + "): " + uRL);
            return null;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (!(uRLConnection instanceof JarURLConnection)) {
                LOGGER.fine("Unexpected connection type for JAR resource: " + uRLConnection.getClass());
                return null;
            }
            JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
            Path path = Paths.get(jarURLConnection.getJarFileURL().toURI());
            LOGGER.fine("Resolved JAR file path for class " + clazz.getName() + ": " + path);
            return path;
        }
        catch (IOException | SecurityException | URISyntaxException exception) {
            LOGGER.log(Level.WARNING, "Failed to resolve JAR file for class: " + clazz.getName(), exception);
            return null;
        }
    }

    public static Path createTempDirWithPrefix(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("prefix must not be empty");
        }
        String string2 = System.getProperty("com.pdftron.systemloadtmpdir");
        Path path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        if (string2 != null && !string2.isEmpty()) {
            path = Paths.get(string2, new String[0]);
        }
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            } else {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    throw new IOException("Base path is not a directory: " + path);
                }
                if (!Files.isWritable(path)) {
                    throw new IOException("Base directory is not writable: " + path);
                }
            }
            Path path2 = Files.createTempDirectory(path, string, new FileAttribute[0]);
            LOGGER.fine("Temporary directory created: " + path2);
            return path2;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Failed to create temporary directory: " + path, iOException);
            throw iOException;
        }
    }

    public static void extractJarResources(Path path, Path path2) throws IOException {
        if (path == null) {
            throw new NullPointerException("jarPath must not be null");
        }
        if (path2 == null) {
            throw new NullPointerException("destinationDir must not be null");
        }
        if (!(Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar"))) {
            throw new IllegalArgumentException("Invalid JAR file: " + path);
        }
        LOGGER.fine("Extracting resources from JAR: " + path + " to directory: " + path2);
        Files.createDirectories(path2, new FileAttribute[0]);
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName().replace('\\', '/');
                if (jarEntry.isDirectory() || string.toUpperCase(Locale.ROOT).startsWith("META-INF/")) continue;
                Path path3 = path2.resolve(string).normalize();
                if (!path3.normalize().startsWith(path2)) {
                    LOGGER.warning("Zip-slip attempt detected: " + string);
                    throw new IOException("Entry is outside the target dir: " + string);
                }
                LOGGER.finest("Extracting entry: " + string + " to " + path3);
                Path path4 = path3.getParent();
                if (path4 != null) {
                    Files.createDirectories(path4, new FileAttribute[0]);
                }
                try {
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    Throwable throwable = null;
                    try {
                        Files.copy(inputStream, path3, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException | SecurityException exception) {
                    LOGGER.log(Level.WARNING, "Failed to extract entry: " + string, exception);
                    throw exception;
                }
            }
            LOGGER.fine("Extraction completed for JAR: " + path);
        }
    }

    private static void registerRecursiveDeleteOnExit(Path path) throws IOException {
        File[] fileArray;
        File file = path.toFile();
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                JarResourceExtractor.registerRecursiveDeleteOnExit(fileArray[i].toPath());
            }
        }
        file.deleteOnExit();
    }
}

