/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

class NativeLoader {
    private static final String MAC_PDFNETC_PATH = "/libs/osx-x64/libPDFNetC.dylib";
    private static final String WINDOWS_PDFNETC_PATH = "/libs/win-x64/PDFNetC.dll";
    private static final String AARCH_PDFNETC_PATH = "/libs/linux-aarch64/libPDFNetC.so";
    private static final String ALPINE_RELEASE_FILE_PATH = "/etc/alpine-release";
    private static final String ALPINE_PDFNETC_PATH = "/libs/linux-aarch64/libPDFNetC.so";
    private static final String LINUX_PDFNETC_PATH = "/libs/linux-x64/libPDFNetC.so";
    private static final int MIN_LIB_FILE_NAME_LENGTH = 3;
    private static final String PDFTRON_TEMP_DIR_PROPERTY_KEY = "com.pdftron.systemloadtmpdir";
    private static final String JAVA_TEMP_DIR_PROPERTY_KEY = "java.io.tmpdir";
    private static final String NATIVE_LIB_DIRECTORY_NAME = "NativeLib";
    private static final String HASH_FILE_SUFFIX = ".sha256";
    private static final String COPY_FILE_SUFFIX = ".copy";
    private static final String LOCK_FILE_SUFFIX = ".lock";

    private NativeLoader() {
    }

    public static boolean loadPDFNetCFromJar() {
        try {
            String string = NativeLoader.getPDFNetCPathByOS();
            NativeLoader.loadLibFromJar(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getPDFNetCPathByOS() throws PDFNetException {
        String string = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (string.indexOf("mac") >= 0 || string.indexOf("darwin") >= 0) {
            return MAC_PDFNETC_PATH;
        }
        if (string.indexOf("win") >= 0) {
            return WINDOWS_PDFNETC_PATH;
        }
        if (string.indexOf("nux") >= 0 || string.indexOf("nix") >= 0 || string.indexOf("aix") >= 0) {
            if (System.getProperty("os.arch").toLowerCase(Locale.ENGLISH).equals("aarch64")) {
                return "/libs/linux-aarch64/libPDFNetC.so";
            }
            File file = new File(ALPINE_RELEASE_FILE_PATH);
            if (file.exists()) {
                return "/libs/linux-aarch64/libPDFNetC.so";
            }
            return LINUX_PDFNETC_PATH;
        }
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        throw new PDFNetException("Unsupported operating system detected", stackTraceElement.getLineNumber(), stackTraceElement.getFileName(), stackTraceElement.getMethodName(), "OS is not Windows/Linux/macOS x64: " + string);
    }

    public static void loadLibFromJar(String string) throws IOException {
        String string2 = NativeLoader.getLibFileName(string);
        File file = NativeLoader.getTempDir();
        File file2 = NativeLoader.getNativeLibDirectory(file);
        File file3 = NativeLoader.getOrCreateLibFile(file2, string2, string);
        file3.setExecutable(true, false);
        NativeLoader.loadLibFile(file3);
    }

    private static String getLibFileName(String string) {
        String string2;
        if (string == null || !string.startsWith("/")) {
            throw new IllegalArgumentException("Library file path is not absolute (starts with '/'): " + (string == null ? "" : string));
        }
        String[] stringArray = string.split("/");
        String string3 = string2 = stringArray.length >= 1 ? stringArray[stringArray.length - 1] : null;
        if (string2 == null || string2.length() < 3) {
            throw new IllegalArgumentException("Library file name must be at least 3 characters, library file name: " + string2);
        }
        return string2;
    }

    private static File getTempDir() throws IOException {
        String string = System.getProperty(PDFTRON_TEMP_DIR_PROPERTY_KEY);
        if (string == null || string.isEmpty()) {
            return new File(System.getProperty(JAVA_TEMP_DIR_PROPERTY_KEY));
        }
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("Unable to get PDFTron temporary directory as it is a file: " + string);
            }
        } else if (!file.mkdirs()) {
            throw new IOException("Unable to create PDFTron temporary directory: " + string);
        }
        return file;
    }

    private static File getNativeLibDirectory(File file) throws IOException {
        File file2 = new File(file, NATIVE_LIB_DIRECTORY_NAME);
        if (file2.exists()) {
            return file2;
        }
        if (!file2.mkdirs()) {
            throw new IOException("Unable to create native lib directory: " + file2.getAbsolutePath());
        }
        return file2;
    }

    /*
     * Exception decompiling
     */
    private static File getOrCreateLibFile(File var0, String var1_1, String var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void copyLibFileFromJar(String string, File file) throws IOException {
        try (InputStream inputStream = NativeLoader.class.getResourceAsStream(string);){
            if (inputStream == null) {
                throw new FileNotFoundException("Unable to find library file \"" + string + "\" from within JAR");
            }
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static String calculateFileHash(File file) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Object object = Files.newInputStream(file.toPath(), new OpenOption[0]);
            Serializable serializable = null;
            try (DigestInputStream digestInputStream = new DigestInputStream((InputStream)object, messageDigest);){
                byte[] byArray = new byte[8192];
                while (digestInputStream.read(byArray) != -1) {
                }
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (serializable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            object = messageDigest.digest();
            serializable = new StringBuilder(2 * ((Object)object).length);
            for (Object object2 : object) {
                String string = Integer.toHexString(0xFF & object2);
                if (string.length() == 1) {
                    ((StringBuilder)serializable).append('0');
                }
                ((StringBuilder)serializable).append(string);
            }
            return ((StringBuilder)serializable).toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("SHA-256 algorithm not available", noSuchAlgorithmException);
        }
    }

    private static void loadLibFile(File file) {
        try {
            System.load(file.getAbsolutePath());
        }
        finally {
            if (NativeLoader.isPosixCompliant()) {
                file.delete();
            }
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

