/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.OCROptions;
import com.pdftron.pdf.PDFDoc;

public class OCRModule {
    private OCRModule() {
    }

    public static boolean isModuleAvailable() throws PDFNetException {
        return OCRModule.IsModuleAvailable();
    }

    public static boolean isIRISModuleAvailable() throws PDFNetException {
        return OCRModule.IsIRISModuleAvailable();
    }

    public static void imageToPDF(PDFDoc pDFDoc, String string, OCROptions oCROptions) throws PDFNetException {
        OCRModule.ImageToPDF(pDFDoc == null ? 0L : pDFDoc.__GetHandle(), string, oCROptions == null ? 0L : oCROptions.getObjHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(oCROptions);
    }

    public static void processPDF(PDFDoc pDFDoc, OCROptions oCROptions) throws PDFNetException {
        OCRModule.ProcessPDF(pDFDoc == null ? 0L : pDFDoc.__GetHandle(), oCROptions == null ? 0L : oCROptions.getObjHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(oCROptions);
    }

    public static String getOCRJsonFromImage(PDFDoc pDFDoc, String string, OCROptions oCROptions) throws PDFNetException {
        String string2 = OCRModule.GetOCRJsonFromImage(pDFDoc == null ? 0L : pDFDoc.__GetHandle(), string, oCROptions == null ? 0L : oCROptions.getObjHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(oCROptions);
        return string2;
    }

    public static String getOCRJsonFromPDF(PDFDoc pDFDoc, OCROptions oCROptions) throws PDFNetException {
        String string = OCRModule.GetOCRJsonFromPDF(pDFDoc == null ? 0L : pDFDoc.__GetHandle(), oCROptions == null ? 0L : oCROptions.getObjHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(oCROptions);
        return string;
    }

    public static void applyOCRJsonToPDF(PDFDoc pDFDoc, String string) throws PDFNetException {
        OCRModule.ApplyOCRJsonToPDF(pDFDoc == null ? 0L : pDFDoc.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    public static String getOCRXmlFromImage(PDFDoc pDFDoc, String string, OCROptions oCROptions) throws PDFNetException {
        String string2 = OCRModule.GetOCRXmlFromImage(pDFDoc == null ? 0L : pDFDoc.__GetHandle(), string, oCROptions == null ? 0L : oCROptions.getObjHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(oCROptions);
        return string2;
    }

    public static String getOCRXmlFromPDF(PDFDoc pDFDoc, OCROptions oCROptions) throws PDFNetException {
        String string = OCRModule.GetOCRXmlFromPDF(pDFDoc == null ? 0L : pDFDoc.__GetHandle(), oCROptions == null ? 0L : oCROptions.getObjHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(oCROptions);
        return string;
    }

    public static void applyOCRXmlToPDF(PDFDoc pDFDoc, String string) throws PDFNetException {
        OCRModule.ApplyOCRXmlToPDF(pDFDoc == null ? 0L : pDFDoc.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    static native boolean IsModuleAvailable();

    static native boolean IsIRISModuleAvailable();

    static native void ImageToPDF(long var0, String var2, long var3);

    static native void ProcessPDF(long var0, long var2);

    static native String GetOCRJsonFromImage(long var0, String var2, long var3);

    static native String GetOCRJsonFromPDF(long var0, long var2);

    static native void ApplyOCRJsonToPDF(long var0, String var2);

    static native String GetOCRXmlFromImage(long var0, String var2, long var3);

    static native String GetOCRXmlFromPDF(long var0, long var2);

    static native void ApplyOCRXmlToPDF(long var0, String var2);
}

