/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.OptionsBase;
import com.pdftron.pdf.RectCollection;
import com.pdftron.sdf.Obj;

public class OCROptions
extends OptionsBase {
    public OCROptions() throws PDFNetException {
    }

    public OCROptions(String string) throws PDFNetException {
        super(string);
    }

    @Override
    long getObjHandle() throws PDFNetException {
        return this.mDict.__GetHandle();
    }

    public boolean getAutoRotate() throws PDFNetException {
        Obj obj = this.mDict.findObj("AutoRotate");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public OCROptions setAutoRotate(boolean bl) throws PDFNetException {
        this.putBool("AutoRotate", bl);
        return this;
    }

    public int getDPI() throws PDFNetException {
        Obj obj = this.mDict.findObj("DPI");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return 0;
    }

    public OCROptions addDPI(int n) throws PDFNetException {
        this.putNumber("DPI", n);
        return this;
    }

    public boolean getIgnoreExistingText() throws PDFNetException {
        Obj obj = this.mDict.findObj("IncludeExistingText");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return true;
    }

    public OCROptions setIgnoreExistingText(boolean bl) throws PDFNetException {
        this.putBool("IncludeExistingText", bl);
        return this;
    }

    public boolean getIncludeExistingText() throws PDFNetException {
        Obj obj = this.mDict.findObj("IncludeExistingText");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return true;
    }

    public OCROptions setIncludeExistingText(boolean bl) throws PDFNetException {
        this.putBool("IncludeExistingText", bl);
        return this;
    }

    public OCROptions addIgnoreZonesForPage(RectCollection rectCollection, int n) throws PDFNetException {
        this.insertRectCollection("IgnoreZones", rectCollection, n - 1);
        return this;
    }

    public OCROptions addLang(String string) throws PDFNetException {
        this.pushBackText("Langs", string);
        return this;
    }

    public String getOCREngine() throws PDFNetException {
        Obj obj = this.mDict.findObj("OCREngine");
        if (obj != null && !obj.isNull()) {
            return obj.getAsPDFText();
        }
        return "";
    }

    public OCROptions setOCREngine(String string) throws PDFNetException {
        this.putText("OCREngine", string);
        return this;
    }

    public OCROptions addTextZonesForPage(RectCollection rectCollection, int n) throws PDFNetException {
        this.insertRectCollection("TextZones", rectCollection, n - 1);
        return this;
    }

    public boolean getUsePDFPageCoords() throws PDFNetException {
        Obj obj = this.mDict.findObj("UsePDFPageCoords");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public OCROptions setUsePDFPageCoords(boolean bl) throws PDFNetException {
        this.putBool("UsePDFPageCoords", bl);
        return this;
    }
}

