/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.sdf.Obj;
import java.awt.geom.Rectangle2D;

public class Rect
implements AutoCloseable {
    long impl;

    public Rect() throws PDFNetException {
        this.impl = Rect.RectCreate(0.0, 0.0, 0.0, 0.0);
    }

    public Rect(Obj obj) throws PDFNetException {
        this.impl = Rect.RectCreate(obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
    }

    public Rect(double d, double d2, double d3, double d4) throws PDFNetException {
        this.impl = Rect.RectCreate(d, d2, d3, d4);
    }

    public Rect(Rectangle2D.Double double_) throws PDFNetException {
        this.impl = Rect.RectCreate(double_.x, double_.y, double_.x + double_.width, double_.y + double_.height);
    }

    Rect(long l) {
        this.impl = l;
    }

    public static Rect __Create(long l) {
        if (l == 0L) {
            return null;
        }
        return new Rect(l);
    }

    public long __GetHandle() {
        return this.impl;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            boolean bl = Rect.Equals(this.impl, ((Rect)object).impl);
            ReachabilityHelper.ensureReachable(object);
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return Rect.HashCode(this.impl);
    }

    public void attach(Obj obj) throws PDFNetException {
        Rect.Attach(this.impl, obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
    }

    public boolean update() throws PDFNetException {
        return Rect.Update(this.impl, 0L);
    }

    public boolean update(Obj obj) throws PDFNetException {
        boolean bl = Rect.Update(this.impl, obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
        return bl;
    }

    public double[] get() throws PDFNetException {
        return Rect.Get(this.impl);
    }

    public void set(double d, double d2, double d3, double d4) throws PDFNetException {
        Rect.Set(this.impl, d, d2, d3, d4);
    }

    public void set(Rectangle2D.Double double_) throws PDFNetException {
        Rect.Set(this.impl, double_.x, double_.y, double_.x + double_.width, double_.y + double_.height);
    }

    public double getWidth() throws PDFNetException {
        return Rect.Width(this.impl);
    }

    public double getHeight() throws PDFNetException {
        return Rect.Height(this.impl);
    }

    public boolean contains(double d, double d2) throws PDFNetException {
        return Rect.Contains(this.impl, d, d2);
    }

    public boolean intersectRect(Rect rect, Rect rect2) throws PDFNetException {
        boolean bl = Rect.IntersectRect(this.impl, rect.impl, rect2.impl);
        ReachabilityHelper.ensureReachable(rect);
        ReachabilityHelper.ensureReachable(rect2);
        return bl;
    }

    public void normalize() throws PDFNetException {
        Rect.Normalize(this.impl);
    }

    public void inflate(double d) {
        Rect.Inflate(this.impl, d);
    }

    public void inflate(double d, double d2) {
        Rect.Inflate(this.impl, d, d2);
    }

    public void destroy() {
        if (this.impl != 0L) {
            Rect.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    public Rectangle2D.Double getRectangle() throws PDFNetException {
        double[] dArray = Rect.Get(this.impl);
        return new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
    }

    public double getX1() throws PDFNetException {
        return Rect.GetX1(this.impl);
    }

    public double getY1() throws PDFNetException {
        return Rect.GetY1(this.impl);
    }

    public double getX2() throws PDFNetException {
        return Rect.GetX2(this.impl);
    }

    public double getY2() throws PDFNetException {
        return Rect.GetY2(this.impl);
    }

    public void setX1(double d) throws PDFNetException {
        Rect.SetX1(this.impl, d);
    }

    public void setY1(double d) throws PDFNetException {
        Rect.SetY1(this.impl, d);
    }

    public void setX2(double d) throws PDFNetException {
        Rect.SetX2(this.impl, d);
    }

    public void setY2(double d) throws PDFNetException {
        Rect.SetY2(this.impl, d);
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long RectCreate(long var0);

    static native long RectCreate(double var0, double var2, double var4, double var6);

    static native boolean Equals(long var0, long var2);

    static native int HashCode(long var0);

    static native void Attach(long var0, long var2);

    static native boolean Update(long var0, long var2);

    static native double[] Get(long var0);

    static native void Set(long var0, double var2, double var4, double var6, double var8);

    static native double Width(long var0);

    static native double Height(long var0);

    static native boolean Contains(long var0, double var2, double var4);

    static native boolean IntersectRect(long var0, long var2, long var4);

    static native void Normalize(long var0);

    static native void Inflate(long var0, double var2);

    static native void Inflate(long var0, double var2, double var4);

    static native void Destroy(long var0);

    static native double GetX1(long var0);

    static native double GetY1(long var0);

    static native double GetX2(long var0);

    static native double GetY2(long var0);

    static native void SetX1(long var0, double var2);

    static native void SetY1(long var0, double var2);

    static native void SetX2(long var0, double var2);

    static native void SetY2(long var0, double var2);
}

