/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.ColorPt;
import com.pdftron.pdf.Font;
import com.pdftron.pdf.Rect;
import com.pdftron.sdf.Doc;

public class Redactor {
    public static void redact(Doc doc, Redaction[] redactionArray, Appearance appearance, boolean bl, boolean bl2) throws PDFNetException {
        long[] lArray = new long[redactionArray.length];
        for (int i = 0; i < redactionArray.length; ++i) {
            lArray[i] = redactionArray[i].impl;
        }
        long l = 0L;
        if (appearance.font != null) {
            l = appearance.font.impl;
        }
        long l2 = 0L;
        if (appearance.positiveOverlayColor != null) {
            l2 = appearance.positiveOverlayColor.impl;
        }
        long l3 = 0L;
        if (appearance.negativeOverlayColor != null) {
            l3 = appearance.negativeOverlayColor.impl;
        }
        long l4 = 0L;
        if (appearance.textColor != null) {
            l4 = appearance.textColor.impl;
        }
        long l5 = 0L;
        if (appearance.redactedContentColor != null) {
            l5 = appearance.redactedContentColor.impl;
        }
        Redactor.Redact(doc.__GetHandle(), lArray, appearance.redactionOverlay, l2, l3, appearance.border, appearance.useOverlayText, l, appearance.minFontSize, appearance.maxFontSize, l4, appearance.horizTextAlignment, appearance.vertTextAlignment, appearance.enableTextWrapping, appearance.showRedactedContentRegions, l5, bl, bl2);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(appearance);
        ReachabilityHelper.ensureReachable(redactionArray);
    }

    static native long RedactionCreate(int var0, long var1, boolean var3, String var4);

    static native void RedactionDestroy(long var0);

    static native void Redact(long var0, long[] var2, boolean var3, long var4, long var6, boolean var8, boolean var9, long var10, double var12, double var14, long var16, int var18, int var19, boolean var20, boolean var21, long var22, boolean var24, boolean var25);

    public static class Appearance {
        public boolean redactionOverlay = true;
        public ColorPt positiveOverlayColor = new ColorPt(1.0, 1.0, 1.0);
        public ColorPt negativeOverlayColor = new ColorPt(1.0, 1.0, 1.0);
        public boolean border = true;
        public boolean useOverlayText = true;
        public Font font;
        public double minFontSize = 2.0;
        public double maxFontSize = 24.0;
        public ColorPt textColor = new ColorPt(0.0, 0.0, 0.0);
        public int horizTextAlignment = -1;
        public int vertTextAlignment = 1;
        public boolean enableTextWrapping = false;
        public boolean showRedactedContentRegions = false;
        public ColorPt redactedContentColor = new ColorPt(0.3, 0.3, 0.3);
    }

    public static class Redaction
    implements AutoCloseable {
        long impl;

        public Redaction(int n, Rect rect, boolean bl, String string) throws PDFNetException {
            this.impl = Redactor.RedactionCreate(n, rect.impl, bl, string);
            ReachabilityHelper.ensureReachable(rect);
        }

        protected void finalize() throws Throwable {
            this.destroy();
        }

        public void destroy() {
            if (this.impl != 0L) {
                Redactor.RedactionDestroy(this.impl);
                this.impl = 0L;
            }
        }

        @Override
        public void close() throws PDFNetException {
            this.destroy();
        }
    }
}

