/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.X509Certificate;
import com.pdftron.pdf.EmbeddedTimestampVerificationResult;
import com.pdftron.pdf.VerificationOptions;

public class TrustVerificationResult
implements AutoCloseable {
    private long mImpl;

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            TrustVerificationResult.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public TrustVerificationResult(long l) {
        this.mImpl = l;
    }

    public boolean wasSuccessful() throws PDFNetException {
        return TrustVerificationResult.WasSuccessful(this.mImpl);
    }

    public String getResultString() throws PDFNetException {
        return TrustVerificationResult.GetResultString(this.mImpl);
    }

    public long getTimeOfTrustVerification() throws PDFNetException {
        return TrustVerificationResult.GetTimeOfTrustVerification(this.mImpl);
    }

    public VerificationOptions.TimeMode getTimeOfTrustVerificationEnum() throws PDFNetException {
        return VerificationOptions.TimeMode.valueToEnum(TrustVerificationResult.GetTimeOfTrustVerificationEnum(this.mImpl));
    }

    public boolean hasEmbeddedTimestampVerificationResult() throws PDFNetException {
        return TrustVerificationResult.HasEmbeddedTimestampVerificationResult(this.mImpl);
    }

    public EmbeddedTimestampVerificationResult getEmbeddedTimestampVerificationResult() throws PDFNetException {
        return new EmbeddedTimestampVerificationResult(TrustVerificationResult.GetEmbeddedTimestampVerificationResult(this.mImpl));
    }

    public X509Certificate[] getCertPath() throws PDFNetException {
        long[] lArray = TrustVerificationResult.GetCertPath(this.mImpl);
        X509Certificate[] x509CertificateArray = new X509Certificate[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            x509CertificateArray[i] = new X509Certificate(lArray[i]);
        }
        return x509CertificateArray;
    }

    public long __GetHandle() {
        return this.mImpl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native boolean WasSuccessful(long var0);

    static native String GetResultString(long var0);

    static native long GetTimeOfTrustVerification(long var0);

    static native int GetTimeOfTrustVerificationEnum(long var0);

    static native boolean HasEmbeddedTimestampVerificationResult(long var0);

    static native long GetEmbeddedTimestampVerificationResult(long var0);

    static native long[] GetCertPath(long var0);
}

