/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf.annots;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Field;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.annots.RadioButtonWidget;
import com.pdftron.sdf.Doc;

public class RadioButtonGroup
implements AutoCloseable {
    long impl;
    Object ref;

    public RadioButtonGroup(Field field) {
        this.impl = RadioButtonGroup.CreateFromField(field.__GetHandle());
        this.ref = field.__GetRefHandle();
    }

    public static RadioButtonGroup create(Doc doc, String string) throws PDFNetException {
        return new RadioButtonGroup(RadioButtonGroup.Create(doc.__GetHandle(), string), doc);
    }

    public static RadioButtonGroup create(Doc doc) throws PDFNetException {
        return RadioButtonGroup.create(doc, "");
    }

    public RadioButtonGroup() {
        this.impl = 0L;
        this.ref = null;
    }

    public RadioButtonWidget add(Rect rect, String string) throws PDFNetException {
        RadioButtonWidget radioButtonWidget = new RadioButtonWidget(RadioButtonGroup.Add(this.impl, rect.__GetHandle(), string), this.ref);
        ReachabilityHelper.ensureReachable(rect);
        return radioButtonWidget;
    }

    public RadioButtonWidget add(Rect rect) throws PDFNetException {
        return this.add(rect, "");
    }

    public int getNumButtons() throws PDFNetException {
        return RadioButtonGroup.GetNumButtons(this.impl);
    }

    public RadioButtonWidget getButton(int n) throws PDFNetException {
        return new RadioButtonWidget(RadioButtonGroup.GetButton(this.impl, n), this.ref);
    }

    public Field getField() throws PDFNetException {
        return Field.__Create(RadioButtonGroup.GetField(this.impl), this.ref);
    }

    public void addGroupButtonsToPage(Page page) throws PDFNetException {
        RadioButtonGroup.AddGroupButtonsToPage(this.impl, page.__GetHandle());
        ReachabilityHelper.ensureReachable(page);
    }

    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            RadioButtonGroup.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    RadioButtonGroup(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long CreateFromField(long var0);

    static native long Create(long var0, String var2);

    static native long Add(long var0, long var2, String var4);

    static native int GetNumButtons(long var0);

    static native long GetButton(long var0, int var2);

    static native long GetField(long var0);

    static native void AddGroupButtonsToPage(long var0, long var2);

    static native void Destroy(long var0);
}

